/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal.util;

import io.kadai.common.internal.logging.LoggingAspect;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ComparableVersion
implements Comparable<ComparableVersion> {
    private static final int MAX_INT_ITEM_LENGTH = 9;
    private static final int MAX_LONG_ITEM_LENGTH = 18;
    private String value;
    private String canonical;
    private ListItem items;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    private ComparableVersion(String version) {
        this.parseVersion(version);
    }

    public static ComparableVersion of(String version) {
        ComparableVersion comparableVersion;
        ComparableVersion comparableVersion2;
        String string = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ComparableVersion comparableVersion3 = comparableVersion2 = (comparableVersion = new ComparableVersion(version));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)comparableVersion2);
        return comparableVersion;
    }

    private static Item parseItem(boolean isDigit, String buf) {
        Item item;
        StringItem stringItem;
        boolean bl = isDigit;
        String string = buf;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)Conversions.booleanObject((boolean)bl), (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        StringItem stringItem2 = stringItem = isDigit ? ((buf = ComparableVersion.stripLeadingZeroes(buf)).length() <= 9 ? (item = new IntItem(buf)) : (buf.length() <= 18 ? (item = new LongItem(buf)) : (item = new BigIntegerItem(buf)))) : (item = new StringItem(buf, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringItem);
        return item;
    }

    private static String stripLeadingZeroes(String buf) {
        String string;
        String string2;
        String string3;
        JoinPoint joinPoint;
        block4: {
            String string4 = buf;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string4);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (buf == null || buf.isEmpty()) {
                string2 = string3 = "0";
            } else {
                int i = 0;
                while (i < buf.length()) {
                    char c = buf.charAt(i);
                    if (c != '0') {
                        string2 = string3 = buf.substring(i);
                        break block4;
                    }
                    ++i;
                }
                string2 = string3 = buf;
            }
        }
        String string5 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string3;
    }

    public final void parseVersion(String version) {
        String string = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.value = version;
        this.items = new ListItem();
        version = version.toLowerCase(Locale.ENGLISH);
        ListItem list = this.items;
        ArrayDeque<ListItem> stack = new ArrayDeque<ListItem>();
        stack.push(list);
        boolean isDigit = false;
        int startIndex = 0;
        int i = 0;
        while (i < version.length()) {
            char c = version.charAt(i);
            if (c == '.') {
                if (i == startIndex) {
                    list.add(IntItem.ZERO);
                } else {
                    list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
            } else if (c == '-') {
                if (i == startIndex) {
                    list.add(IntItem.ZERO);
                } else {
                    list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
            } else if (Character.isDigit(c)) {
                if (!isDigit && i > startIndex) {
                    list.add(new StringItem(version.substring(startIndex, i), true));
                    startIndex = i;
                    ListItem listItem = list;
                    list = new ListItem();
                    listItem.add(list);
                    stack.push(list);
                }
                isDigit = true;
            } else {
                if (isDigit && i > startIndex) {
                    list.add(ComparableVersion.parseItem(true, version.substring(startIndex, i)));
                    startIndex = i;
                    ListItem listItem = list;
                    list = new ListItem();
                    listItem.add(list);
                    stack.push(list);
                }
                isDigit = false;
            }
            ++i;
        }
        if (version.length() > startIndex) {
            list.add(ComparableVersion.parseItem(isDigit, version.substring(startIndex)));
        }
        while (!stack.isEmpty()) {
            list = (ListItem)stack.pop();
            list.normalize();
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    @Override
    public int compareTo(ComparableVersion o) {
        int n;
        int n2;
        ComparableVersion comparableVersion = o;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)comparableVersion);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.items.compareTo(o.items));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public String getCanonical() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.canonical == null) {
            this.canonical = this.items.toString();
        }
        String string3 = string2 = (string = this.canonical);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ComparableVersion) {
            ComparableVersion comparableVersion = (ComparableVersion)o;
            if (this.items.equals(comparableVersion.items)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.value;
    }

    static {
        ComparableVersion.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ComparableVersion.java", ComparableVersion.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "of", "io.kadai.common.internal.util.ComparableVersion", "java.lang.String", "version", "", "io.kadai.common.internal.util.ComparableVersion"), 100);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "parseItem", "io.kadai.common.internal.util.ComparableVersion", "boolean:java.lang.String", "isDigit:buf", "", "io.kadai.common.internal.util.ComparableVersion$Item"), 104);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "stripLeadingZeroes", "io.kadai.common.internal.util.ComparableVersion", "java.lang.String", "buf", "", "java.lang.String"), 119);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "parseVersion", "io.kadai.common.internal.util.ComparableVersion", "java.lang.String", "version", "", "void"), 132);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compareTo", "io.kadai.common.internal.util.ComparableVersion", "io.kadai.common.internal.util.ComparableVersion", "o", "", "int"), 202);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCanonical", "io.kadai.common.internal.util.ComparableVersion", "", "", "", "java.lang.String"), 206);
    }

    private static class BigIntegerItem
    implements Item {
        private final BigInteger value;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private BigIntegerItem(String str) {
            this.value = new BigInteger(str);
        }

        @Override
        public int getType() {
            int n;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int n2 = 0;
            int n3 = n = 0;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n2;
        }

        @Override
        public boolean isNull() {
            boolean bl;
            boolean bl2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            boolean bl3 = bl2 = (bl = BigInteger.ZERO.equals(this.value));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
            return bl;
        }

        @Override
        public int compareTo(Item item) {
            int n;
            int n2;
            int n3;
            Item item2 = item;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)item2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (item == null) {
                n2 = n3 = BigInteger.ZERO.equals(this.value) ? 0 : 1;
            } else {
                int n4;
                switch (item.getType()) {
                    case 3: 
                    case 4: {
                        n4 = 1;
                        break;
                    }
                    case 0: {
                        n4 = this.value.compareTo(((BigIntegerItem)item).value);
                        break;
                    }
                    case 1: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n4 = 1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("invalid item: " + item.getClass());
                    }
                }
                n2 = n3 = n4;
            }
            int n5 = n = n2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n3;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigIntegerItem that = (BigIntegerItem)o;
            return this.value.equals(that.value);
        }

        public String toString() {
            return this.value.toString();
        }

        static {
            BigIntegerItem.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ComparableVersion.java", BigIntegerItem.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "io.kadai.common.internal.util.ComparableVersion$BigIntegerItem", "", "", "", "int"), 389);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isNull", "io.kadai.common.internal.util.ComparableVersion$BigIntegerItem", "", "", "", "boolean"), 394);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compareTo", "io.kadai.common.internal.util.ComparableVersion$BigIntegerItem", "io.kadai.common.internal.util.ComparableVersion$Item", "item", "", "int"), 399);
        }
    }

    private static class IntItem
    implements Item {
        public static final IntItem ZERO;
        private final int value;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            IntItem.ajc$preClinit();
            ZERO = new IntItem();
        }

        private IntItem() {
            this.value = 0;
        }

        private IntItem(String str) {
            this.value = Integer.parseInt(str);
        }

        @Override
        public int getType() {
            int n;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int n2 = 3;
            int n3 = n = 3;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n2;
        }

        @Override
        public boolean isNull() {
            boolean bl;
            boolean bl2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            boolean bl3 = bl2 = this.value == 0 ? (bl = true) : (bl = false);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
            return bl;
        }

        @Override
        public int compareTo(Item item) {
            int n;
            int n2;
            int n3;
            Item item2 = item;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)item2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (item == null) {
                n2 = n3 = this.value == 0 ? 0 : 1;
            } else {
                int n4;
                switch (item.getType()) {
                    case 3: {
                        int itemValue = ((IntItem)item).value;
                        n4 = Integer.compare(this.value, itemValue);
                        break;
                    }
                    case 0: 
                    case 4: {
                        n4 = -1;
                        break;
                    }
                    case 1: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n4 = 1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("invalid item: " + item.getClass());
                    }
                }
                n2 = n3 = n4;
            }
            int n5 = n = n2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n3;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntItem intItem = (IntItem)o;
            return this.value == intItem.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ComparableVersion.java", IntItem.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "io.kadai.common.internal.util.ComparableVersion$IntItem", "", "", "", "int"), 257);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isNull", "io.kadai.common.internal.util.ComparableVersion$IntItem", "", "", "", "boolean"), 262);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compareTo", "io.kadai.common.internal.util.ComparableVersion$IntItem", "io.kadai.common.internal.util.ComparableVersion$Item", "item", "", "int"), 267);
        }
    }

    private static interface Item {
        public static final int INT_ITEM = 3;
        public static final int LONG_ITEM = 4;
        public static final int BIGINTEGER_ITEM = 0;
        public static final int STRING_ITEM = 1;
        public static final int LIST_ITEM = 2;

        public int compareTo(Item var1);

        public int getType();

        public boolean isNull();
    }

    private static class ListItem
    extends ArrayList<Item>
    implements Item {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

        private ListItem() {
        }

        @Override
        public int getType() {
            int n;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int n2 = 2;
            int n3 = n = 2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n2;
        }

        @Override
        public boolean isNull() {
            boolean bl;
            boolean bl2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            boolean bl3 = bl2 = this.size() == 0 ? (bl = true) : (bl = false);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
            return bl;
        }

        @Override
        public int compareTo(Item item) {
            int n;
            int n2;
            int n3;
            Item item2 = item;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)item2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (item == null) {
                if (this.size() == 0) {
                    n2 = n3 = 0;
                } else {
                    Item first = (Item)this.get(0);
                    n2 = n3 = first.compareTo(null);
                }
            } else {
                block0 : switch (item.getType()) {
                    case 0: 
                    case 3: 
                    case 4: {
                        n2 = n3 = -1;
                        break;
                    }
                    case 1: {
                        n2 = n3 = 1;
                        break;
                    }
                    case 2: {
                        Iterator left = this.iterator();
                        Iterator right = ((ListItem)item).iterator();
                        while (left.hasNext() || right.hasNext()) {
                            Item r;
                            Item l = left.hasNext() ? (Item)left.next() : null;
                            Item item3 = r = right.hasNext() ? (Item)right.next() : null;
                            int result = l == null ? (r == null ? 0 : -1 * r.compareTo(null)) : l.compareTo(r);
                            if (result == 0) continue;
                            n2 = n3 = result;
                            break block0;
                        }
                        n2 = n3 = 0;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("invalid item: " + item.getClass());
                    }
                }
            }
            int n4 = n = n2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n3;
        }

        void normalize() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int i = this.size() - 1;
            while (i >= 0) {
                Item lastItem = (Item)this.get(i);
                if (lastItem.isNull()) {
                    this.remove(i);
                } else if (!(lastItem instanceof ListItem)) break;
                --i;
            }
            Object var4_4 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            for (Item item : this) {
                if (buffer.length() > 0) {
                    buffer.append(item instanceof ListItem ? (char)'-' : '.');
                }
                buffer.append(item);
            }
            return buffer.toString();
        }

        static {
            ListItem.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ComparableVersion.java", ListItem.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "io.kadai.common.internal.util.ComparableVersion$ListItem", "", "", "", "int"), 560);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isNull", "io.kadai.common.internal.util.ComparableVersion$ListItem", "", "", "", "boolean"), 565);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compareTo", "io.kadai.common.internal.util.ComparableVersion$ListItem", "io.kadai.common.internal.util.ComparableVersion$Item", "item", "", "int"), 570);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "normalize", "io.kadai.common.internal.util.ComparableVersion$ListItem", "", "", "", "void"), 613);
        }
    }

    private static class LongItem
    implements Item {
        private final long value;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private LongItem(String str) {
            this.value = Long.parseLong(str);
        }

        @Override
        public int getType() {
            int n;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int n2 = 4;
            int n3 = n = 4;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n2;
        }

        @Override
        public boolean isNull() {
            boolean bl;
            boolean bl2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            boolean bl3 = bl2 = this.value == 0L ? (bl = true) : (bl = false);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
            return bl;
        }

        @Override
        public int compareTo(Item item) {
            int n;
            int n2;
            int n3;
            Item item2 = item;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)item2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (item == null) {
                n2 = n3 = this.value == 0L ? 0 : 1;
            } else {
                switch (item.getType()) {
                    case 3: {
                        n2 = n3 = 1;
                        break;
                    }
                    case 4: {
                        long itemValue = ((LongItem)item).value;
                        n2 = n3 = Long.compare(this.value, itemValue);
                        break;
                    }
                    case 0: {
                        n2 = n3 = -1;
                        break;
                    }
                    case 1: {
                        n2 = n3 = 1;
                        break;
                    }
                    case 2: {
                        n2 = n3 = 1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("invalid item: " + item.getClass());
                    }
                }
            }
            int n4 = n = n2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n3;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongItem longItem = (LongItem)o;
            return this.value == longItem.value;
        }

        public String toString() {
            return Long.toString(this.value);
        }

        static {
            LongItem.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ComparableVersion.java", LongItem.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "io.kadai.common.internal.util.ComparableVersion$LongItem", "", "", "", "int"), 320);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isNull", "io.kadai.common.internal.util.ComparableVersion$LongItem", "", "", "", "boolean"), 325);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compareTo", "io.kadai.common.internal.util.ComparableVersion$LongItem", "io.kadai.common.internal.util.ComparableVersion$Item", "item", "", "int"), 330);
        }
    }

    private static class StringItem
    implements Item {
        private static final List<String> QUALIFIERS;
        private static final Properties ALIASES;
        private static final String RELEASE_VERSION_INDEX;
        private final String value;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

        static {
            StringItem.ajc$preClinit();
            QUALIFIERS = Arrays.asList("alpha", "beta", "milestone", "rc", "snapshot", "", "sp");
            ALIASES = new Properties();
            RELEASE_VERSION_INDEX = String.valueOf(QUALIFIERS.indexOf(""));
            ALIASES.put("ga", "");
            ALIASES.put("final", "");
            ALIASES.put("release", "");
            ALIASES.put("cr", "rc");
        }

        private StringItem(String value, boolean followedByDigit) {
            if (followedByDigit && value.length() == 1) {
                switch (value.charAt(0)) {
                    case 'a': {
                        value = "alpha";
                        break;
                    }
                    case 'b': {
                        value = "beta";
                        break;
                    }
                    case 'm': {
                        value = "milestone";
                    }
                }
            }
            this.value = ALIASES.getProperty(value, value);
        }

        public static String comparableQualifier(String qualifier) {
            String string;
            String string2 = qualifier;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int i = QUALIFIERS.indexOf(qualifier);
            String string3 = i == -1 ? String.valueOf(QUALIFIERS.size()) + "-" + qualifier : String.valueOf(i);
            String string4 = string = string3;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
            return string3;
        }

        @Override
        public int getType() {
            int n;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int n2 = 1;
            int n3 = n = 1;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n2;
        }

        @Override
        public boolean isNull() {
            boolean bl;
            boolean bl2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            boolean bl3 = bl2 = StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX) == 0 ? (bl = true) : (bl = false);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
            return bl;
        }

        @Override
        public int compareTo(Item item) {
            int n;
            int n2;
            int n3;
            Item item2 = item;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)item2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (item == null) {
                n2 = n3 = StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX);
            } else {
                int n4;
                switch (item.getType()) {
                    case 0: 
                    case 3: 
                    case 4: {
                        n4 = -1;
                        break;
                    }
                    case 1: {
                        n4 = StringItem.comparableQualifier(this.value).compareTo(StringItem.comparableQualifier(((StringItem)item).value));
                        break;
                    }
                    case 2: {
                        n4 = -1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("invalid item: " + item.getClass());
                    }
                }
                n2 = n3 = n4;
            }
            int n5 = n = n2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n));
            return n3;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringItem that = (StringItem)o;
            return this.value.equals(that.value);
        }

        public String toString() {
            return this.value;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ComparableVersion.java", StringItem.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "comparableQualifier", "io.kadai.common.internal.util.ComparableVersion$StringItem", "java.lang.String", "qualifier", "", "java.lang.String"), 494);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "io.kadai.common.internal.util.ComparableVersion$StringItem", "", "", "", "int"), 501);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isNull", "io.kadai.common.internal.util.ComparableVersion$StringItem", "", "", "", "boolean"), 506);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compareTo", "io.kadai.common.internal.util.ComparableVersion$StringItem", "io.kadai.common.internal.util.ComparableVersion$Item", "item", "", "int"), 511);
        }
    }
}

