/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal.util;

import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.util.CheckedFunction;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ReflectionUtil {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        ReflectionUtil.ajc$preClinit();
        PRIMITIVES_TO_WRAPPERS = new HashMap();
        PRIMITIVES_TO_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES_TO_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVES_TO_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVES_TO_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVES_TO_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVES_TO_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVES_TO_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVES_TO_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVES_TO_WRAPPERS.put(Void.TYPE, Void.class);
    }

    private ReflectionUtil() {
        throw new IllegalStateException("utility class");
    }

    public static List<Field> retrieveAllFields(Class<?> currentClass) {
        List<Field> list;
        List<Field> list2;
        Class<?> clazz = currentClass;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, clazz);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<Field> fields = new ArrayList<Field>();
        while (currentClass.getSuperclass() != null) {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
            currentClass = currentClass.getSuperclass();
        }
        List<Field> list3 = list2 = (list = fields.stream().filter(Predicate.not(Field::isSynthetic)).toList());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public static Class<?> getRawClass(Type type) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Type type2 = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)type2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz2 = clazz3 = ReflectionUtil.getRawClass(parameterizedType.getRawType());
        } else {
            clazz2 = clazz3 = (Class<?>)type;
        }
        Class<?> clazz4 = clazz = clazz2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, clazz);
        return clazz3;
    }

    public static <T> Class<T> wrap(Class<T> c) {
        Class<T> clazz;
        Class<T> clazz2 = c;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, clazz2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Class<T> clazz3 = c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
        Class<T> clazz4 = clazz = clazz3;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, clazz);
        return clazz3;
    }

    public static Object getEnclosingInstance(Object instance) {
        Object var3_3;
        Object var4_4;
        Object object = instance;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)object);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Object v0 = var4_4 = (var3_3 = Arrays.stream(instance.getClass().getDeclaredFields()).filter(Field::isSynthetic).filter(f -> f.getName().startsWith("this")).findFirst().map(CheckedFunction.wrap((T field) -> {
            field.setAccessible(true);
            return field.get(instance);
        })).orElse(null));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
        return var3_3;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ReflectionUtil.java", ReflectionUtil.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "retrieveAllFields", "io.kadai.common.internal.util.ReflectionUtil", "java.lang.Class", "currentClass", "", "java.util.List"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getRawClass", "io.kadai.common.internal.util.ReflectionUtil", "java.lang.reflect.Type", "type", "", "java.lang.Class"), 61);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "wrap", "io.kadai.common.internal.util.ReflectionUtil", "java.lang.Class", "c", "", "java.lang.Class"), 70);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getEnclosingInstance", "io.kadai.common.internal.util.ReflectionUtil", "java.lang.Object", "instance", "", "java.lang.Object"), 74);
    }
}

