/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal.workingtime;

import io.kadai.common.api.CustomHoliday;
import io.kadai.common.internal.logging.LoggingAspect;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.LongStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class HolidaySchedule {
    private static final long OFFSET_EASTER_SUNDAY = 0L;
    private static final long OFFSET_GOOD_FRIDAY = -2L;
    private static final long OFFSET_EASTER_MONDAY = 1L;
    private static final long OFFSET_ASCENSION_DAY = 39L;
    private static final long OFFSET_WHIT_MONDAY = 50L;
    private static final long OFFSET_CORPUS_CHRISTI = 60L;
    private static final Set<CustomHoliday> GERMAN_HOLIDAYS;
    private final boolean germanHolidaysEnabled;
    private final boolean corpusChristiEnabled;
    private final Set<CustomHoliday> customHolidays;
    private final EasterCalculator easterCalculator;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        HolidaySchedule.ajc$preClinit();
        GERMAN_HOLIDAYS = new HashSet<CustomHoliday>(Arrays.asList(CustomHoliday.of(1, 1), CustomHoliday.of(1, 5), CustomHoliday.of(3, 10), CustomHoliday.of(25, 12), CustomHoliday.of(26, 12)));
    }

    public HolidaySchedule(boolean germanHolidaysEnabled, boolean corpusChristiEnabled) {
        this(germanHolidaysEnabled, corpusChristiEnabled, Collections.emptySet());
    }

    public HolidaySchedule(boolean germanHolidaysEnabled, boolean corpusChristiEnabled, Collection<CustomHoliday> customHolidays) {
        this.germanHolidaysEnabled = germanHolidaysEnabled;
        this.corpusChristiEnabled = corpusChristiEnabled;
        this.customHolidays = new HashSet<CustomHoliday>(customHolidays);
        this.easterCalculator = new EasterCalculator();
    }

    public boolean isHoliday(LocalDate date) {
        boolean bl;
        boolean bl2;
        LocalDate localDate = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)localDate);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = this.germanHolidaysEnabled && this.isGermanHoliday(date) ? (bl = true) : (bl = this.customHolidays.contains(CustomHoliday.of(date.getDayOfMonth(), date.getMonthValue())));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isGermanHoliday(LocalDate date) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        LocalDate localDate = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)localDate);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (GERMAN_HOLIDAYS.contains(CustomHoliday.of(date.getDayOfMonth(), date.getMonthValue()))) {
            bl2 = bl3 = true;
        } else {
            long diffFromEasterSunday = ChronoUnit.DAYS.between(this.easterCalculator.getEasterSunday(date.getYear()), date);
            LongStream.Builder builder = LongStream.builder().add(0L).add(-2L).add(1L).add(39L).add(50L);
            if (this.corpusChristiEnabled) {
                builder.add(60L);
            }
            bl2 = bl3 = builder.build().anyMatch(c -> c == diffFromEasterSunday);
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    public String toString() {
        return "WorkingDaysToDaysConverter [germanHolidaysEnabled=" + this.germanHolidaysEnabled + ", corpusChristiEnabled=" + this.corpusChristiEnabled + ", customHolidays=" + this.customHolidays + ", easterCalculator=" + this.easterCalculator + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HolidaySchedule.java", HolidaySchedule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isHoliday", "io.kadai.common.internal.workingtime.HolidaySchedule", "java.time.LocalDate", "date", "", "boolean"), 83);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanHoliday", "io.kadai.common.internal.workingtime.HolidaySchedule", "java.time.LocalDate", "date", "", "boolean"), 91);
    }

    static class EasterCalculator {
        LocalDate cachedEasterDay;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        EasterCalculator() {
        }

        LocalDate getEasterSunday(int year) {
            LocalDate localDate;
            LocalDate localDate2;
            LocalDate localDate3;
            int n = year;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (this.cachedEasterDay != null && this.cachedEasterDay.getYear() == year) {
                localDate2 = localDate3 = this.cachedEasterDay;
            } else {
                int a = year % 19;
                int b = year / 100;
                int c = year % 100;
                int d = b / 4;
                int e = b % 4;
                int f = (b + 8) / 25;
                int g = (b - f + 1) / 3;
                int h = (19 * a + b - d - g + 15) % 30;
                int i = c / 4;
                int k = c % 4;
                int l = (32 + 2 * e + 2 * i - h - k) % 7;
                int m = (a + 11 * h + 22 * l) / 451;
                int n2 = h + l - 7 * m + 114;
                int month = n2 / 31;
                int day = n2 % 31 + 1;
                localDate2 = localDate3 = (this.cachedEasterDay = LocalDate.of(year, month, day));
            }
            LocalDate localDate4 = localDate = localDate2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)localDate);
            return localDate3;
        }

        static {
            EasterCalculator.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("HolidaySchedule.java", EasterCalculator.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getEasterSunday", "io.kadai.common.internal.workingtime.HolidaySchedule$EasterCalculator", "int", "year", "", "java.time.LocalDate"), 138);
        }
    }
}

