/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal.workingtime;

import io.kadai.common.api.WorkingTimeCalculator;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.workingtime.HolidaySchedule;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.stream.LongStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class WorkingDayCalculatorImpl
implements WorkingTimeCalculator {
    private final ZoneId zoneId;
    private final HolidaySchedule holidaySchedule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public WorkingDayCalculatorImpl(HolidaySchedule holidaySchedule, ZoneId zoneId) {
        this.holidaySchedule = holidaySchedule;
        this.zoneId = zoneId;
    }

    @Override
    public Instant subtractWorkingTime(Instant workStart, Duration workingTime) throws InvalidArgumentException {
        Instant instant;
        Instant instant2;
        Instant instant3 = workStart;
        Duration duration = workingTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)instant3, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long days = this.convertWorkingDaysToDays(workStart, -workingTime.toDays(), ZeroDirection.SUB_DAYS);
        Instant instant4 = instant2 = (instant = workStart.plus(Duration.ofDays(days)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    @Override
    public Instant addWorkingTime(Instant workStart, Duration workingTime) throws InvalidArgumentException {
        Instant instant;
        Instant instant2;
        Instant instant3 = workStart;
        Duration duration = workingTime;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)instant3, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long days = this.convertWorkingDaysToDays(workStart, workingTime.toDays(), ZeroDirection.ADD_DAYS);
        Instant instant4 = instant2 = (instant = workStart.plus(Duration.ofDays(days)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    @Override
    public Duration workingTimeBetween(Instant first, Instant second) throws InvalidArgumentException {
        Duration duration;
        Duration duration2;
        Instant instant = first;
        Instant instant2 = second;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)instant, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long days = Duration.between(first, second).abs().toDays();
        Instant firstInstant = first.isBefore(second) ? first : second;
        long workingDaysBetween = LongStream.range(1L, days).mapToObj(day -> this.isWorkingDay(firstInstant.plus(day, ChronoUnit.DAYS))).filter(t -> t).count();
        Duration duration3 = duration2 = (duration = Duration.ofDays(workingDaysBetween));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    @Override
    public boolean isWorkingDay(Instant instant) {
        boolean bl;
        boolean bl2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = !this.isWeekend(instant) && !this.isHoliday(instant) ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    @Override
    public boolean isWeekend(Instant instant) {
        boolean bl;
        boolean bl2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DayOfWeek dayOfWeek = this.toDayOfWeek(instant);
        boolean bl3 = bl2 = dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY ? (bl = false) : (bl = true);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    @Override
    public boolean isHoliday(Instant instant) {
        boolean bl;
        boolean bl2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.holidaySchedule.isHoliday(this.toLocalDate(instant)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    @Override
    public boolean isGermanHoliday(Instant instant) {
        boolean bl;
        boolean bl2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.holidaySchedule.isGermanHoliday(this.toLocalDate(instant)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private long convertWorkingDaysToDays(Instant startTime, long numberOfDays, ZeroDirection zeroDirection) {
        long l;
        long l2;
        Instant instant = startTime;
        long l3 = numberOfDays;
        ZeroDirection zeroDirection2 = zeroDirection;
        Object[] objectArray = new Object[]{instant, Conversions.longObject((long)l3), zeroDirection2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (startTime == null) {
            throw new SystemException("Internal Error: convertWorkingDaysToDays was called with a null startTime");
        }
        int direction = this.calculateDirection(numberOfDays, zeroDirection);
        long limit = Math.abs(numberOfDays);
        long l4 = l2 = (l = LongStream.iterate(0L, i -> i + (long)direction).filter(day -> this.isWorkingDay(startTime.plus(day, ChronoUnit.DAYS))).skip(limit).findFirst().orElse(0L));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l2));
        return l;
    }

    private int calculateDirection(long numberOfDays, ZeroDirection zeroDirection) {
        int n;
        int n2;
        long l = numberOfDays;
        ZeroDirection zeroDirection2 = zeroDirection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)((Object)zeroDirection2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = numberOfDays == 0L ? (n = zeroDirection.getDirection()) : (n = numberOfDays >= 0L ? 1 : -1);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private LocalDate toLocalDate(Instant instant) {
        LocalDate localDate;
        LocalDate localDate2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LocalDate localDate3 = localDate2 = (localDate = LocalDate.ofInstant(instant, this.zoneId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)localDate2);
        return localDate;
    }

    private DayOfWeek toDayOfWeek(Instant instant) {
        DayOfWeek dayOfWeek;
        DayOfWeek dayOfWeek2;
        Instant instant2 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DayOfWeek dayOfWeek3 = dayOfWeek2 = (dayOfWeek = this.toLocalDate(instant).getDayOfWeek());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dayOfWeek2);
        return dayOfWeek;
    }

    static {
        WorkingDayCalculatorImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkingDayCalculatorImpl.java", WorkingDayCalculatorImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "subtractWorkingTime", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant:java.time.Duration", "workStart:workingTime", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.time.Instant"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addWorkingTime", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant:java.time.Duration", "workStart:workingTime", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.time.Instant"), 50);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toDayOfWeek", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant", "instant", "", "java.time.DayOfWeek"), 118);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workingTimeBetween", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant:java.time.Instant", "first:second", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.time.Duration"), 57);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWorkingDay", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant", "instant", "", "boolean"), 71);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWeekend", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant", "instant", "", "boolean"), 76);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isHoliday", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant", "instant", "", "boolean"), 82);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanHoliday", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant", "instant", "", "boolean"), 87);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertWorkingDaysToDays", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant:long:io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl$ZeroDirection", "startTime:numberOfDays:zeroDirection", "", "long"), 91);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateDirection", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "long:io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl$ZeroDirection", "numberOfDays:zeroDirection", "", "int"), 106);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toLocalDate", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl", "java.time.Instant", "instant", "", "java.time.LocalDate"), 114);
    }

    private static final class ZeroDirection
    extends Enum<ZeroDirection> {
        public static final /* enum */ ZeroDirection SUB_DAYS;
        public static final /* enum */ ZeroDirection ADD_DAYS;
        private final int direction;
        private static final /* synthetic */ ZeroDirection[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            ZeroDirection.ajc$preClinit();
            SUB_DAYS = new ZeroDirection(-1);
            ADD_DAYS = new ZeroDirection(1);
            ENUM$VALUES = new ZeroDirection[]{SUB_DAYS, ADD_DAYS};
        }

        private ZeroDirection(int direction) {
            this.direction = direction;
        }

        public int getDirection() {
            int n;
            int n2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int n3 = n2 = (n = this.direction);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
            return n;
        }

        public static ZeroDirection[] values() {
            ZeroDirection[] zeroDirectionArray;
            ZeroDirection[] zeroDirectionArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ZeroDirection[] zeroDirectionArray3 = ENUM$VALUES;
            int n = zeroDirectionArray3.length;
            ZeroDirection[] zeroDirectionArray4 = new ZeroDirection[n];
            System.arraycopy(ENUM$VALUES, 0, zeroDirectionArray4, 0, n);
            ZeroDirection[] zeroDirectionArray5 = zeroDirectionArray2 = (zeroDirectionArray = zeroDirectionArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zeroDirectionArray2);
            return zeroDirectionArray;
        }

        public static ZeroDirection valueOf(String arg0) {
            ZeroDirection zeroDirection;
            ZeroDirection zeroDirection2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ZeroDirection zeroDirection3 = zeroDirection2 = (zeroDirection = Enum.valueOf(ZeroDirection.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zeroDirection2);
            return zeroDirection;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkingDayCalculatorImpl.java", ZeroDirection.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDirection", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl$ZeroDirection", "", "", "", "int"), 132);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl$ZeroDirection", "", "", "", "[Lio.kadai.common.internal.workingtime.WorkingDayCalculatorImpl$ZeroDirection;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl$ZeroDirection", "java.lang.String", "arg0", "", "io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl$ZeroDirection"), 1);
        }
    }
}

