/*
 * Decompiled with CFR 0.152.
 */
package io.kadai;

import io.kadai.common.api.CustomHoliday;
import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.LocalTimeInterval;
import io.kadai.common.api.SharedConstants;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.configuration.KadaiProperty;
import io.kadai.common.internal.configuration.parser.PropertyParser;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.util.FileLoaderUtil;
import io.kadai.common.internal.util.Pair;
import io.kadai.common.internal.util.ReflectionUtil;
import io.kadai.workbasket.api.WorkbasketPermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KadaiConfiguration {
    private final DataSource dataSource;
    private final boolean useManagedTransactions;
    private final String schemaName;
    private final boolean securityEnabled;
    private final List<String> domains;
    private final boolean enforceServiceLevel;
    private final Map<KadaiRole, Set<String>> roleMap;
    private final List<String> classificationTypes;
    private final Map<String, List<String>> classificationCategoriesByType;
    private final boolean useWorkingTimeCalculation;
    private final Map<DayOfWeek, Set<LocalTimeInterval>> workingTimeSchedule;
    private final ZoneId workingTimeScheduleTimeZone;
    private final Set<CustomHoliday> customHolidays;
    private final boolean germanPublicHolidaysEnabled;
    private final boolean germanPublicHolidaysCorpusChristiEnabled;
    private final boolean deleteHistoryEventsOnTaskDeletionEnabled;
    private final String logHistoryLoggerName;
    private final boolean jobSchedulerEnabled;
    private final long jobSchedulerInitialStartDelay;
    private final long jobSchedulerPeriod;
    private final TimeUnit jobSchedulerPeriodTimeUnit;
    private final int maxNumberOfJobRetries;
    private final int jobBatchSize;
    private final Instant jobFirstRun;
    private final Duration jobRunEvery;
    private final Duration jobLockExpirationPeriod;
    private final boolean taskCleanupJobEnabled;
    private final Duration taskCleanupJobMinimumAge;
    private final boolean taskCleanupJobAllCompletedSameParentBusiness;
    private final Duration taskCleanupJobLockExpirationPeriod;
    private final boolean workbasketCleanupJobEnabled;
    private final Duration workbasketCleanupJobLockExpirationPeriod;
    private final boolean simpleHistoryCleanupJobEnabled;
    private final int simpleHistoryCleanupJobBatchSize;
    private final Duration simpleHistoryCleanupJobMinimumAge;
    private final boolean simpleHistoryCleanupJobAllCompletedSameParentBusiness;
    private final Duration simpleHistoryCleanupJobLockExpirationPeriod;
    private final boolean taskUpdatePriorityJobEnabled;
    private final int taskUpdatePriorityJobBatchSize;
    private final Instant taskUpdatePriorityJobFirstRun;
    private final Duration taskUpdatePriorityJobRunEvery;
    private final Duration taskUpdatePriorityJobLockExpirationPeriod;
    private final boolean userInfoRefreshJobEnabled;
    private final Instant userRefreshJobFirstRun;
    private final Duration userRefreshJobRunEvery;
    private final Duration userRefreshJobLockExpirationPeriod;
    private final Set<String> customJobs;
    private final boolean addAdditionalUserInfo;
    private final Set<WorkbasketPermission> minimalPermissionsToAssignDomains;
    private final boolean useSpecificDb2Taskquery;
    private final Map<String, String> properties;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;

    private KadaiConfiguration(Builder builder) {
        this.dataSource = builder.dataSource;
        this.useManagedTransactions = builder.useManagedTransactions;
        this.schemaName = builder.schemaName;
        this.securityEnabled = builder.securityEnabled;
        this.domains = Collections.unmodifiableList(builder.domains);
        this.enforceServiceLevel = builder.enforceServiceLevel;
        this.roleMap = builder.roleMap.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Collections.unmodifiableSet((Set)e.getValue())));
        this.classificationTypes = Collections.unmodifiableList(builder.classificationTypes);
        this.classificationCategoriesByType = Collections.unmodifiableMap(builder.classificationCategoriesByType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableList((List)e.getValue()), (oldValue, newValue) -> oldValue, LinkedHashMap::new)));
        this.useWorkingTimeCalculation = builder.useWorkingTimeCalculation;
        this.workingTimeSchedule = builder.workingTimeSchedule.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Collections.unmodifiableSet((Set)e.getValue())));
        this.workingTimeScheduleTimeZone = builder.workingTimeScheduleTimeZone;
        this.customHolidays = Collections.unmodifiableSet(builder.customHolidays);
        this.germanPublicHolidaysEnabled = builder.germanPublicHolidaysEnabled;
        this.germanPublicHolidaysCorpusChristiEnabled = builder.germanPublicHolidaysCorpusChristiEnabled;
        this.deleteHistoryEventsOnTaskDeletionEnabled = builder.deleteHistoryEventsOnTaskDeletionEnabled;
        this.logHistoryLoggerName = builder.logHistoryLoggerName;
        this.jobSchedulerEnabled = builder.jobSchedulerEnabled;
        this.jobSchedulerInitialStartDelay = builder.jobSchedulerInitialStartDelay;
        this.jobSchedulerPeriod = builder.jobSchedulerPeriod;
        this.jobSchedulerPeriodTimeUnit = builder.jobSchedulerPeriodTimeUnit;
        this.maxNumberOfJobRetries = builder.maxNumberOfJobRetries;
        this.jobBatchSize = builder.jobBatchSize;
        this.jobFirstRun = builder.jobFirstRun;
        this.jobRunEvery = builder.jobRunEvery;
        this.jobLockExpirationPeriod = builder.jobLockExpirationPeriod;
        this.taskCleanupJobEnabled = builder.taskCleanupJobEnabled;
        this.taskCleanupJobMinimumAge = builder.taskCleanupJobMinimumAge;
        this.taskCleanupJobAllCompletedSameParentBusiness = builder.taskCleanupJobAllCompletedSameParentBusiness;
        this.taskCleanupJobLockExpirationPeriod = builder.taskCleanupJobLockExpirationPeriod;
        this.workbasketCleanupJobEnabled = builder.workbasketCleanupJobEnabled;
        this.workbasketCleanupJobLockExpirationPeriod = builder.workbasketCleanupJobLockExpirationPeriod;
        this.simpleHistoryCleanupJobEnabled = builder.simpleHistoryCleanupJobEnabled;
        this.simpleHistoryCleanupJobBatchSize = builder.simpleHistoryCleanupJobBatchSize;
        this.simpleHistoryCleanupJobMinimumAge = builder.simpleHistoryCleanupJobMinimumAge;
        this.simpleHistoryCleanupJobAllCompletedSameParentBusiness = builder.simpleHistoryCleanupJobAllCompletedSameParentBusiness;
        this.simpleHistoryCleanupJobLockExpirationPeriod = builder.simpleHistoryCleanupJobLockExpirationPeriod;
        this.taskUpdatePriorityJobEnabled = builder.taskUpdatePriorityJobEnabled;
        this.taskUpdatePriorityJobBatchSize = builder.taskUpdatePriorityJobBatchSize;
        this.taskUpdatePriorityJobFirstRun = builder.taskUpdatePriorityJobFirstRun;
        this.taskUpdatePriorityJobRunEvery = builder.taskUpdatePriorityJobRunEvery;
        this.taskUpdatePriorityJobLockExpirationPeriod = builder.taskUpdatePriorityJobLockExpirationPeriod;
        this.userInfoRefreshJobEnabled = builder.userInfoRefreshJobEnabled;
        this.userRefreshJobFirstRun = builder.userRefreshJobFirstRun;
        this.userRefreshJobRunEvery = builder.userRefreshJobRunEvery;
        this.userRefreshJobLockExpirationPeriod = builder.userRefreshJobLockExpirationPeriod;
        this.customJobs = Collections.unmodifiableSet(builder.customJobs);
        this.addAdditionalUserInfo = builder.addAdditionalUserInfo;
        this.minimalPermissionsToAssignDomains = Collections.unmodifiableSet(builder.minimalPermissionsToAssignDomains);
        this.useSpecificDb2Taskquery = builder.useSpecificDb2Taskquery;
        this.properties = Map.copyOf(builder.properties);
    }

    public static boolean shouldUseLowerCaseForAccessIds() {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = true;
        boolean bl3 = bl = true;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    public List<String> getAllClassificationCategories() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationCategoriesByType.values().stream().flatMap(Collection::stream).toList());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public List<String> getClassificationCategoriesByType(String type) {
        List<String> list;
        List<String> list2;
        String string = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationCategoriesByType.getOrDefault(type, Collections.emptyList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public Map<String, List<String>> getClassificationCategoriesByType() {
        Map<String, List<String>> map;
        Map<String, List<String>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, List<String>> map3 = map2 = (map = this.classificationCategoriesByType);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public DataSource getDataSource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DataSource dataSource3 = dataSource2 = (dataSource = this.dataSource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public boolean isUseManagedTransactions() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.useManagedTransactions);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public String getSchemaName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.schemaName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public boolean isSecurityEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.securityEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public List<String> getDomains() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.domains);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public boolean isEnforceServiceLevel() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.enforceServiceLevel);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Map<KadaiRole, Set<String>> getRoleMap() {
        Map<KadaiRole, Set<String>> map;
        Map<KadaiRole, Set<String>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<KadaiRole, Set<String>> map3 = map2 = (map = this.roleMap);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public List<String> getClassificationTypes() {
        List<String> list;
        List<String> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = this.classificationTypes);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public boolean isUseWorkingTimeCalculation() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.useWorkingTimeCalculation);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Map<DayOfWeek, Set<LocalTimeInterval>> getWorkingTimeSchedule() {
        Map<DayOfWeek, Set<LocalTimeInterval>> map;
        Map<DayOfWeek, Set<LocalTimeInterval>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<DayOfWeek, Set<LocalTimeInterval>> map3 = map2 = (map = this.workingTimeSchedule);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public ZoneId getWorkingTimeScheduleTimeZone() {
        ZoneId zoneId;
        ZoneId zoneId2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ZoneId zoneId3 = zoneId2 = (zoneId = this.workingTimeScheduleTimeZone);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zoneId2);
        return zoneId;
    }

    public Set<CustomHoliday> getCustomHolidays() {
        Set<CustomHoliday> set;
        Set<CustomHoliday> set2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<CustomHoliday> set3 = set2 = (set = this.customHolidays);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    public boolean isGermanPublicHolidaysEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.germanPublicHolidaysEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isGermanPublicHolidaysCorpusChristiEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.germanPublicHolidaysCorpusChristiEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isDeleteHistoryEventsOnTaskDeletionEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.deleteHistoryEventsOnTaskDeletionEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public String getLogHistoryLoggerName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.logHistoryLoggerName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public boolean isJobSchedulerEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.jobSchedulerEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public long getJobSchedulerInitialStartDelay() {
        long l;
        long l2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long l3 = l2 = (l = this.jobSchedulerInitialStartDelay);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l2));
        return l;
    }

    public long getJobSchedulerPeriod() {
        long l;
        long l2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long l3 = l2 = (l = this.jobSchedulerPeriod);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l2));
        return l;
    }

    public TimeUnit getJobSchedulerPeriodTimeUnit() {
        TimeUnit timeUnit;
        TimeUnit timeUnit2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimeUnit timeUnit3 = timeUnit2 = (timeUnit = this.jobSchedulerPeriodTimeUnit);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timeUnit2);
        return timeUnit;
    }

    public int getMaxNumberOfJobRetries() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.maxNumberOfJobRetries);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public int getJobBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.jobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public Instant getJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.jobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Duration getJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.jobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public Duration getJobLockExpirationPeriod() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.jobLockExpirationPeriod);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isTaskCleanupJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.taskCleanupJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Duration getTaskCleanupJobMinimumAge() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.taskCleanupJobMinimumAge);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isTaskCleanupJobAllCompletedSameParentBusiness() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.taskCleanupJobAllCompletedSameParentBusiness);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Duration getTaskCleanupJobLockExpirationPeriod() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.taskCleanupJobLockExpirationPeriod);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isWorkbasketCleanupJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.workbasketCleanupJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Duration getWorkbasketCleanupJobLockExpirationPeriod() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.workbasketCleanupJobLockExpirationPeriod);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isSimpleHistoryCleanupJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.simpleHistoryCleanupJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public int getSimpleHistoryCleanupJobBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.simpleHistoryCleanupJobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public Duration getSimpleHistoryCleanupJobMinimumAge() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.simpleHistoryCleanupJobMinimumAge);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isSimpleHistoryCleanupJobAllCompletedSameParentBusiness() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.simpleHistoryCleanupJobAllCompletedSameParentBusiness);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Duration getSimpleHistoryCleanupJobLockExpirationPeriod() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.simpleHistoryCleanupJobLockExpirationPeriod);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isTaskUpdatePriorityJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.taskUpdatePriorityJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public int getTaskUpdatePriorityJobBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.taskUpdatePriorityJobBatchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public Instant getTaskUpdatePriorityJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.taskUpdatePriorityJobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Duration getTaskUpdatePriorityJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.taskUpdatePriorityJobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public Duration getTaskUpdatePriorityJobLockExpirationPeriod() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.taskUpdatePriorityJobLockExpirationPeriod);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public boolean isUserInfoRefreshJobEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.userInfoRefreshJobEnabled);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Instant getUserRefreshJobFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.userRefreshJobFirstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Duration getUserRefreshJobRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.userRefreshJobRunEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public Duration getUserRefreshJobLockExpirationPeriod() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.userRefreshJobLockExpirationPeriod);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    public Set<String> getCustomJobs() {
        Set<String> set;
        Set<String> set2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<String> set3 = set2 = (set = this.customJobs);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    public boolean isAddAdditionalUserInfo() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.addAdditionalUserInfo);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Set<WorkbasketPermission> getMinimalPermissionsToAssignDomains() {
        Set<WorkbasketPermission> set;
        Set<WorkbasketPermission> set2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<WorkbasketPermission> set3 = set2 = (set = this.minimalPermissionsToAssignDomains);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    public boolean isUseSpecificDb2Taskquery() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.useSpecificDb2Taskquery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Map<String, String> getProperties() {
        Map<String, String> map;
        Map<String, String> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, String> map3 = map2 = (map = this.properties);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataSource, this.useManagedTransactions, this.schemaName, this.securityEnabled, this.domains, this.enforceServiceLevel, this.roleMap, this.classificationTypes, this.classificationCategoriesByType, this.useWorkingTimeCalculation, this.workingTimeSchedule, this.workingTimeScheduleTimeZone, this.customHolidays, this.germanPublicHolidaysEnabled, this.germanPublicHolidaysCorpusChristiEnabled, this.deleteHistoryEventsOnTaskDeletionEnabled, this.logHistoryLoggerName, this.jobSchedulerEnabled, this.jobSchedulerInitialStartDelay, this.jobSchedulerPeriod, this.jobSchedulerPeriodTimeUnit, this.maxNumberOfJobRetries, this.jobBatchSize, this.jobFirstRun, this.jobRunEvery, this.jobLockExpirationPeriod, this.taskCleanupJobEnabled, this.taskCleanupJobMinimumAge, this.taskCleanupJobAllCompletedSameParentBusiness, this.taskCleanupJobLockExpirationPeriod, this.workbasketCleanupJobEnabled, this.workbasketCleanupJobLockExpirationPeriod, this.simpleHistoryCleanupJobEnabled, this.simpleHistoryCleanupJobBatchSize, this.simpleHistoryCleanupJobMinimumAge, this.simpleHistoryCleanupJobAllCompletedSameParentBusiness, this.simpleHistoryCleanupJobLockExpirationPeriod, this.taskUpdatePriorityJobEnabled, this.taskUpdatePriorityJobBatchSize, this.taskUpdatePriorityJobFirstRun, this.taskUpdatePriorityJobRunEvery, this.taskUpdatePriorityJobLockExpirationPeriod, this.userInfoRefreshJobEnabled, this.userRefreshJobFirstRun, this.userRefreshJobRunEvery, this.userRefreshJobLockExpirationPeriod, this.customJobs, this.addAdditionalUserInfo, this.minimalPermissionsToAssignDomains, this.useSpecificDb2Taskquery, this.properties});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KadaiConfiguration)) {
            return false;
        }
        KadaiConfiguration other = (KadaiConfiguration)obj;
        return this.useManagedTransactions == other.useManagedTransactions && this.securityEnabled == other.securityEnabled && this.enforceServiceLevel == other.enforceServiceLevel && this.useWorkingTimeCalculation == other.useWorkingTimeCalculation && this.germanPublicHolidaysEnabled == other.germanPublicHolidaysEnabled && this.germanPublicHolidaysCorpusChristiEnabled == other.germanPublicHolidaysCorpusChristiEnabled && this.deleteHistoryEventsOnTaskDeletionEnabled == other.deleteHistoryEventsOnTaskDeletionEnabled && this.jobSchedulerEnabled == other.jobSchedulerEnabled && this.jobSchedulerInitialStartDelay == other.jobSchedulerInitialStartDelay && this.jobSchedulerPeriod == other.jobSchedulerPeriod && this.maxNumberOfJobRetries == other.maxNumberOfJobRetries && this.jobBatchSize == other.jobBatchSize && this.taskCleanupJobEnabled == other.taskCleanupJobEnabled && this.taskCleanupJobAllCompletedSameParentBusiness == other.taskCleanupJobAllCompletedSameParentBusiness && this.workbasketCleanupJobEnabled == other.workbasketCleanupJobEnabled && this.simpleHistoryCleanupJobEnabled == other.simpleHistoryCleanupJobEnabled && this.simpleHistoryCleanupJobBatchSize == other.simpleHistoryCleanupJobBatchSize && this.simpleHistoryCleanupJobAllCompletedSameParentBusiness == other.simpleHistoryCleanupJobAllCompletedSameParentBusiness && this.taskUpdatePriorityJobEnabled == other.taskUpdatePriorityJobEnabled && this.taskUpdatePriorityJobBatchSize == other.taskUpdatePriorityJobBatchSize && this.userInfoRefreshJobEnabled == other.userInfoRefreshJobEnabled && this.addAdditionalUserInfo == other.addAdditionalUserInfo && this.useSpecificDb2Taskquery == other.useSpecificDb2Taskquery && Objects.equals(this.dataSource, other.dataSource) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.domains, other.domains) && Objects.equals(this.roleMap, other.roleMap) && Objects.equals(this.classificationTypes, other.classificationTypes) && Objects.equals(this.classificationCategoriesByType, other.classificationCategoriesByType) && Objects.equals(this.workingTimeSchedule, other.workingTimeSchedule) && Objects.equals(this.workingTimeScheduleTimeZone, other.workingTimeScheduleTimeZone) && Objects.equals(this.customHolidays, other.customHolidays) && Objects.equals(this.logHistoryLoggerName, other.logHistoryLoggerName) && this.jobSchedulerPeriodTimeUnit == other.jobSchedulerPeriodTimeUnit && Objects.equals(this.jobFirstRun, other.jobFirstRun) && Objects.equals(this.jobRunEvery, other.jobRunEvery) && Objects.equals(this.jobLockExpirationPeriod, other.jobLockExpirationPeriod) && Objects.equals(this.taskCleanupJobMinimumAge, other.taskCleanupJobMinimumAge) && Objects.equals(this.taskCleanupJobLockExpirationPeriod, other.taskCleanupJobLockExpirationPeriod) && Objects.equals(this.workbasketCleanupJobLockExpirationPeriod, other.workbasketCleanupJobLockExpirationPeriod) && Objects.equals(this.simpleHistoryCleanupJobMinimumAge, other.simpleHistoryCleanupJobMinimumAge) && Objects.equals(this.simpleHistoryCleanupJobLockExpirationPeriod, other.simpleHistoryCleanupJobLockExpirationPeriod) && Objects.equals(this.taskUpdatePriorityJobFirstRun, other.taskUpdatePriorityJobFirstRun) && Objects.equals(this.taskUpdatePriorityJobRunEvery, other.taskUpdatePriorityJobRunEvery) && Objects.equals(this.taskUpdatePriorityJobLockExpirationPeriod, other.taskUpdatePriorityJobLockExpirationPeriod) && Objects.equals(this.userRefreshJobFirstRun, other.userRefreshJobFirstRun) && Objects.equals(this.userRefreshJobRunEvery, other.userRefreshJobRunEvery) && Objects.equals(this.userRefreshJobLockExpirationPeriod, other.userRefreshJobLockExpirationPeriod) && Objects.equals(this.customJobs, other.customJobs) && Objects.equals(this.minimalPermissionsToAssignDomains, other.minimalPermissionsToAssignDomains) && Objects.equals(this.properties, other.properties);
    }

    public String toString() {
        return "KadaiConfiguration{dataSource=" + this.dataSource + ", useManagedTransactions=" + this.useManagedTransactions + ", schemaName='" + this.schemaName + '\'' + ", securityEnabled=" + this.securityEnabled + ", domains=" + this.domains + ", enforceServiceLevel=" + this.enforceServiceLevel + ", roleMap=" + this.roleMap + ", classificationTypes=" + this.classificationTypes + ", classificationCategoriesByType=" + this.classificationCategoriesByType + ", useWorkingTimeCalculation=" + this.useWorkingTimeCalculation + ", workingTimeSchedule=" + this.workingTimeSchedule + ", workingTimeScheduleTimeZone=" + this.workingTimeScheduleTimeZone + ", customHolidays=" + this.customHolidays + ", germanPublicHolidaysEnabled=" + this.germanPublicHolidaysEnabled + ", germanPublicHolidaysCorpusChristiEnabled=" + this.germanPublicHolidaysCorpusChristiEnabled + ", deleteHistoryEventsOnTaskDeletionEnabled=" + this.deleteHistoryEventsOnTaskDeletionEnabled + ", logHistoryLoggerName='" + this.logHistoryLoggerName + '\'' + ", jobSchedulerEnabled=" + this.jobSchedulerEnabled + ", jobSchedulerInitialStartDelay=" + this.jobSchedulerInitialStartDelay + ", jobSchedulerPeriod=" + this.jobSchedulerPeriod + ", jobSchedulerPeriodTimeUnit=" + (Object)((Object)this.jobSchedulerPeriodTimeUnit) + ", maxNumberOfJobRetries=" + this.maxNumberOfJobRetries + ", jobBatchSize=" + this.jobBatchSize + ", jobFirstRun=" + this.jobFirstRun + ", jobRunEvery=" + this.jobRunEvery + ", jobLockExpirationPeriod=" + this.jobLockExpirationPeriod + ", taskCleanupJobEnabled=" + this.taskCleanupJobEnabled + ", taskCleanupJobMinimumAge=" + this.taskCleanupJobMinimumAge + ", taskCleanupJobAllCompletedSameParentBusiness=" + this.taskCleanupJobAllCompletedSameParentBusiness + ", taskCleanupJobLockExpirationPeriod=" + this.taskCleanupJobLockExpirationPeriod + ", workbasketCleanupJobEnabled=" + this.workbasketCleanupJobEnabled + ", workbasketCleanupJobLockExpirationPeriod=" + this.workbasketCleanupJobLockExpirationPeriod + ", simpleHistoryCleanupJobEnabled=" + this.simpleHistoryCleanupJobEnabled + ", simpleHistoryCleanupJobBatchSize=" + this.simpleHistoryCleanupJobBatchSize + ", simpleHistoryCleanupJobMinimumAge=" + this.simpleHistoryCleanupJobMinimumAge + ", simpleHistoryCleanupJobAllCompletedSameParentBusiness=" + this.simpleHistoryCleanupJobAllCompletedSameParentBusiness + ", simpleHistoryCleanupJobLockExpirationPeriod=" + this.simpleHistoryCleanupJobLockExpirationPeriod + ", taskUpdatePriorityJobEnabled=" + this.taskUpdatePriorityJobEnabled + ", taskUpdatePriorityJobBatchSize=" + this.taskUpdatePriorityJobBatchSize + ", taskUpdatePriorityJobFirstRun=" + this.taskUpdatePriorityJobFirstRun + ", taskUpdatePriorityJobRunEvery=" + this.taskUpdatePriorityJobRunEvery + ", taskUpdatePriorityJobLockExpirationPeriod=" + this.taskUpdatePriorityJobLockExpirationPeriod + ", userInfoRefreshJobEnabled=" + this.userInfoRefreshJobEnabled + ", userRefreshJobFirstRun=" + this.userRefreshJobFirstRun + ", userRefreshJobRunEvery=" + this.userRefreshJobRunEvery + ", userRefreshJobLockExpirationPeriod=" + this.userRefreshJobLockExpirationPeriod + ", customJobs=" + this.customJobs + ", addAdditionalUserInfo=" + this.addAdditionalUserInfo + ", minimalPermissionsToAssignDomains=" + this.minimalPermissionsToAssignDomains + ", useSpecificDb2Taskquery=" + this.useSpecificDb2Taskquery + ", properties=" + this.properties + '}';
    }

    /* synthetic */ KadaiConfiguration(Builder builder, KadaiConfiguration kadaiConfiguration) {
        this(builder);
    }

    static {
        KadaiConfiguration.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("KadaiConfiguration.java", KadaiConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "shouldUseLowerCaseForAccessIds", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 253);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllClassificationCategories", "io.kadai.KadaiConfiguration", "", "", "", "java.util.List"), 257);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRoleMap", "io.kadai.KadaiConfiguration", "", "", "", "java.util.Map"), 297);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationTypes", "io.kadai.KadaiConfiguration", "", "", "", "java.util.List"), 301);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isUseWorkingTimeCalculation", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 305);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkingTimeSchedule", "io.kadai.KadaiConfiguration", "", "", "", "java.util.Map"), 309);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkingTimeScheduleTimeZone", "io.kadai.KadaiConfiguration", "", "", "", "java.time.ZoneId"), 313);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustomHolidays", "io.kadai.KadaiConfiguration", "", "", "", "java.util.Set"), 317);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanPublicHolidaysEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 321);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanPublicHolidaysCorpusChristiEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 325);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDeleteHistoryEventsOnTaskDeletionEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 329);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLogHistoryLoggerName", "io.kadai.KadaiConfiguration", "", "", "", "java.lang.String"), 333);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoriesByType", "io.kadai.KadaiConfiguration", "java.lang.String", "type", "", "java.util.List"), 263);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isJobSchedulerEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 337);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobSchedulerInitialStartDelay", "io.kadai.KadaiConfiguration", "", "", "", "long"), 341);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobSchedulerPeriod", "io.kadai.KadaiConfiguration", "", "", "", "long"), 345);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobSchedulerPeriodTimeUnit", "io.kadai.KadaiConfiguration", "", "", "", "java.util.concurrent.TimeUnit"), 349);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxNumberOfJobRetries", "io.kadai.KadaiConfiguration", "", "", "", "int"), 353);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobBatchSize", "io.kadai.KadaiConfiguration", "", "", "", "int"), 357);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobFirstRun", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Instant"), 361);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobRunEvery", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 365);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobLockExpirationPeriod", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 369);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTaskCleanupJobEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 373);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoriesByType", "io.kadai.KadaiConfiguration", "", "", "", "java.util.Map"), 267);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskCleanupJobMinimumAge", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 377);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTaskCleanupJobAllCompletedSameParentBusiness", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 381);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskCleanupJobLockExpirationPeriod", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 385);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWorkbasketCleanupJobEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 389);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketCleanupJobLockExpirationPeriod", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 393);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSimpleHistoryCleanupJobEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 397);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSimpleHistoryCleanupJobBatchSize", "io.kadai.KadaiConfiguration", "", "", "", "int"), 401);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSimpleHistoryCleanupJobMinimumAge", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 405);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSimpleHistoryCleanupJobAllCompletedSameParentBusiness", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 409);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSimpleHistoryCleanupJobLockExpirationPeriod", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 413);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataSource", "io.kadai.KadaiConfiguration", "", "", "", "javax.sql.DataSource"), 273);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTaskUpdatePriorityJobEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 417);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskUpdatePriorityJobBatchSize", "io.kadai.KadaiConfiguration", "", "", "", "int"), 421);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskUpdatePriorityJobFirstRun", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Instant"), 425);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskUpdatePriorityJobRunEvery", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 429);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskUpdatePriorityJobLockExpirationPeriod", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 433);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isUserInfoRefreshJobEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 437);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserRefreshJobFirstRun", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Instant"), 441);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserRefreshJobRunEvery", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 445);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserRefreshJobLockExpirationPeriod", "io.kadai.KadaiConfiguration", "", "", "", "java.time.Duration"), 449);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustomJobs", "io.kadai.KadaiConfiguration", "", "", "", "java.util.Set"), 453);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isUseManagedTransactions", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 277);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAddAdditionalUserInfo", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 457);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMinimalPermissionsToAssignDomains", "io.kadai.KadaiConfiguration", "", "", "", "java.util.Set"), 461);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isUseSpecificDb2Taskquery", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 465);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProperties", "io.kadai.KadaiConfiguration", "", "", "", "java.util.Map"), 476);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaName", "io.kadai.KadaiConfiguration", "", "", "", "java.lang.String"), 281);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSecurityEnabled", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 285);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomains", "io.kadai.KadaiConfiguration", "", "", "", "java.util.List"), 289);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isEnforceServiceLevel", "io.kadai.KadaiConfiguration", "", "", "", "boolean"), 293);
    }

    public static class Builder {
        private static final Logger LOGGER;
        private static final String DEFAULT_KADAI_PROPERTIES = "/kadai.properties";
        private static final String DEFAULT_KADAI_PROPERTY_SEPARATOR = "|";
        private final DataSource dataSource;
        private final boolean useManagedTransactions;
        private final String schemaName;
        private final boolean securityEnabled;
        @KadaiProperty(value="kadai.domains")
        private List<String> domains = new ArrayList<String>();
        @KadaiProperty(value="kadai.servicelevel.validation.enforce")
        private boolean enforceServiceLevel = true;
        @KadaiProperty(value="kadai.roles")
        private Map<KadaiRole, Set<String>> roleMap = new EnumMap<KadaiRole, Set<String>>(KadaiRole.class);
        @KadaiProperty(value="kadai.classification.types")
        private List<String> classificationTypes = new ArrayList<String>();
        @KadaiProperty(value="kadai.classification.categories")
        private Map<String, List<String>> classificationCategoriesByType = new HashMap<String, List<String>>();
        @KadaiProperty(value="kadai.workingTime.useWorkingTimeCalculation")
        private boolean useWorkingTimeCalculation = true;
        @KadaiProperty(value="kadai.workingTime.schedule")
        private Map<DayOfWeek, Set<LocalTimeInterval>> workingTimeSchedule = Builder.initDefaultWorkingTimeSchedule();
        @KadaiProperty(value="kadai.workingTime.timezone")
        private ZoneId workingTimeScheduleTimeZone = ZoneId.of("Europe/Berlin");
        @KadaiProperty(value="kadai.workingTime.holidays.custom")
        private Set<CustomHoliday> customHolidays = new HashSet<CustomHoliday>();
        @KadaiProperty(value="kadai.workingTime.holidays.german.enabled")
        private boolean germanPublicHolidaysEnabled = true;
        @KadaiProperty(value="kadai.workingTime.holidays.german.corpus-christi.enabled")
        private boolean germanPublicHolidaysCorpusChristiEnabled = false;
        @KadaiProperty(value="kadai.history.simple.deleteOnTaskDeletion.enabled")
        private boolean deleteHistoryEventsOnTaskDeletionEnabled = false;
        @KadaiProperty(value="kadai.history.logger.name")
        private String logHistoryLoggerName = null;
        @KadaiProperty(value="kadai.jobs.scheduler.enabled")
        private boolean jobSchedulerEnabled = true;
        @KadaiProperty(value="kadai.jobs.scheduler.initialStartDelay")
        private long jobSchedulerInitialStartDelay = 0L;
        @KadaiProperty(value="kadai.jobs.scheduler.period")
        private long jobSchedulerPeriod = 5L;
        @KadaiProperty(value="kadai.jobs.scheduler.periodTimeUnit")
        private TimeUnit jobSchedulerPeriodTimeUnit = TimeUnit.MINUTES;
        @KadaiProperty(value="kadai.jobs.maxRetries")
        private int maxNumberOfJobRetries = 3;
        @KadaiProperty(value="kadai.jobs.batchSize")
        private int jobBatchSize = 100;
        @KadaiProperty(value="kadai.jobs.firstRunAt")
        private Instant jobFirstRun = Instant.parse("2023-01-01T00:00:00Z");
        @KadaiProperty(value="kadai.jobs.runEvery")
        private Duration jobRunEvery = Duration.ofDays(1L);
        @KadaiProperty(value="kadai.jobs.lockExpirationPeriod")
        private Duration jobLockExpirationPeriod = Duration.ofMinutes(30L);
        @KadaiProperty(value="kadai.jobs.cleanup.task.enable")
        private boolean taskCleanupJobEnabled = true;
        @KadaiProperty(value="kadai.jobs.cleanup.task.minimumAge")
        private Duration taskCleanupJobMinimumAge = Duration.ofDays(14L);
        @KadaiProperty(value="kadai.jobs.cleanup.task.allCompletedSameParentBusiness")
        private boolean taskCleanupJobAllCompletedSameParentBusiness = true;
        @KadaiProperty(value="kadai.jobs.cleanup.task.lockExpirationPeriod")
        private Duration taskCleanupJobLockExpirationPeriod = Duration.ofMinutes(30L);
        @KadaiProperty(value="kadai.jobs.cleanup.workbasket.enable")
        private boolean workbasketCleanupJobEnabled = true;
        @KadaiProperty(value="kadai.jobs.cleanup.workbasket.lockExpirationPeriod")
        private Duration workbasketCleanupJobLockExpirationPeriod = Duration.ofMinutes(30L);
        @KadaiProperty(value="kadai.jobs.cleanup.history.simple.enable")
        private boolean simpleHistoryCleanupJobEnabled = false;
        @KadaiProperty(value="kadai.jobs.cleanup.history.simple.batchSize")
        private int simpleHistoryCleanupJobBatchSize = 100;
        @KadaiProperty(value="kadai.jobs.cleanup.history.simple.minimumAge")
        private Duration simpleHistoryCleanupJobMinimumAge = Duration.ofDays(14L);
        @KadaiProperty(value="kadai.jobs.cleanup.history.simple.allCompletedSameParentBusiness")
        private boolean simpleHistoryCleanupJobAllCompletedSameParentBusiness = true;
        @KadaiProperty(value="kadai.jobs.cleanup.history.simple.lockExpirationPeriod")
        private Duration simpleHistoryCleanupJobLockExpirationPeriod = Duration.ofMinutes(30L);
        @KadaiProperty(value="kadai.jobs.priority.task.enable")
        private boolean taskUpdatePriorityJobEnabled = false;
        @KadaiProperty(value="kadai.jobs.priority.task.batchSize")
        private int taskUpdatePriorityJobBatchSize = 100;
        @KadaiProperty(value="kadai.jobs.priority.task.firstRunAt")
        private Instant taskUpdatePriorityJobFirstRun = Instant.parse("2023-01-01T00:00:00Z");
        @KadaiProperty(value="kadai.jobs.priority.task.runEvery")
        private Duration taskUpdatePriorityJobRunEvery = Duration.ofDays(1L);
        @KadaiProperty(value="kadai.jobs.priority.task.lockExpirationPeriod")
        private Duration taskUpdatePriorityJobLockExpirationPeriod = Duration.ofMinutes(30L);
        @KadaiProperty(value="kadai.jobs.refresh.user.enable")
        private boolean userInfoRefreshJobEnabled = false;
        @KadaiProperty(value="kadai.jobs.refresh.user.firstRunAt")
        private Instant userRefreshJobFirstRun = Instant.parse("2023-01-01T23:00:00Z");
        @KadaiProperty(value="kadai.jobs.refresh.user.runEvery")
        private Duration userRefreshJobRunEvery = Duration.ofDays(1L);
        @KadaiProperty(value="kadai.jobs.refresh.user.lockExpirationPeriod")
        private Duration userRefreshJobLockExpirationPeriod = Duration.ofMinutes(30L);
        @KadaiProperty(value="kadai.jobs.customJobs")
        private Set<String> customJobs = new HashSet<String>();
        @KadaiProperty(value="kadai.user.addAdditionalUserInfo")
        private boolean addAdditionalUserInfo = false;
        @KadaiProperty(value="kadai.user.minimalPermissionsToAssignDomains")
        private Set<WorkbasketPermission> minimalPermissionsToAssignDomains = new HashSet<WorkbasketPermission>();
        @KadaiProperty(value="kadai.feature.useSpecificDb2Taskquery")
        private boolean useSpecificDb2Taskquery = true;
        private Map<String, String> properties = Collections.emptyMap();
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;

        static {
            Builder.ajc$preClinit();
            LOGGER = LoggerFactory.getLogger(Builder.class);
        }

        public Builder(DataSource dataSource, boolean useManagedTransactions, String schemaName) {
            this(dataSource, useManagedTransactions, schemaName, true);
        }

        public Builder(DataSource dataSource, boolean useManagedTransactions, String schemaName, boolean securityEnabled) {
            this.useManagedTransactions = useManagedTransactions;
            this.securityEnabled = securityEnabled;
            this.dataSource = Objects.requireNonNull(dataSource);
            this.schemaName = this.initSchemaName(schemaName);
        }

        public Builder(KadaiConfiguration conf) {
            this(conf, conf.dataSource, conf.useManagedTransactions, conf.schemaName, conf.securityEnabled);
        }

        public Builder(KadaiConfiguration conf, DataSource dataSource) {
            this(conf, dataSource, conf.useManagedTransactions, conf.schemaName, conf.securityEnabled);
        }

        public Builder(KadaiConfiguration conf, DataSource dataSource, boolean useManagedTransactions) {
            this(conf, dataSource, useManagedTransactions, conf.schemaName, conf.securityEnabled);
        }

        public Builder(KadaiConfiguration conf, DataSource dataSource, boolean useManagedTransactions, String schemaName) {
            this(conf, dataSource, useManagedTransactions, schemaName, conf.securityEnabled);
        }

        public Builder(KadaiConfiguration conf, DataSource dataSource, boolean useManagedTransactions, String schemaName, boolean securityEnabled) {
            this.dataSource = dataSource;
            this.useManagedTransactions = useManagedTransactions;
            this.schemaName = this.initSchemaName(schemaName);
            this.securityEnabled = securityEnabled;
            this.domains = conf.domains;
            this.enforceServiceLevel = conf.enforceServiceLevel;
            this.roleMap = conf.roleMap;
            this.classificationTypes = conf.classificationTypes;
            this.classificationCategoriesByType = conf.classificationCategoriesByType;
            this.useWorkingTimeCalculation = conf.useWorkingTimeCalculation;
            this.workingTimeSchedule = conf.workingTimeSchedule;
            this.workingTimeScheduleTimeZone = conf.workingTimeScheduleTimeZone;
            this.customHolidays = conf.customHolidays;
            this.germanPublicHolidaysEnabled = conf.germanPublicHolidaysEnabled;
            this.germanPublicHolidaysCorpusChristiEnabled = conf.germanPublicHolidaysCorpusChristiEnabled;
            this.deleteHistoryEventsOnTaskDeletionEnabled = conf.deleteHistoryEventsOnTaskDeletionEnabled;
            this.logHistoryLoggerName = conf.logHistoryLoggerName;
            this.jobSchedulerEnabled = conf.jobSchedulerEnabled;
            this.jobSchedulerInitialStartDelay = conf.jobSchedulerInitialStartDelay;
            this.jobSchedulerPeriod = conf.jobSchedulerPeriod;
            this.jobSchedulerPeriodTimeUnit = conf.jobSchedulerPeriodTimeUnit;
            this.maxNumberOfJobRetries = conf.maxNumberOfJobRetries;
            this.jobBatchSize = conf.jobBatchSize;
            this.jobFirstRun = conf.jobFirstRun;
            this.jobRunEvery = conf.jobRunEvery;
            this.jobLockExpirationPeriod = conf.jobLockExpirationPeriod;
            this.taskCleanupJobEnabled = conf.taskCleanupJobEnabled;
            this.taskCleanupJobMinimumAge = conf.taskCleanupJobMinimumAge;
            this.taskCleanupJobAllCompletedSameParentBusiness = conf.taskCleanupJobAllCompletedSameParentBusiness;
            this.taskCleanupJobLockExpirationPeriod = conf.taskCleanupJobLockExpirationPeriod;
            this.workbasketCleanupJobEnabled = conf.workbasketCleanupJobEnabled;
            this.workbasketCleanupJobLockExpirationPeriod = conf.workbasketCleanupJobLockExpirationPeriod;
            this.simpleHistoryCleanupJobEnabled = conf.simpleHistoryCleanupJobEnabled;
            this.simpleHistoryCleanupJobBatchSize = conf.simpleHistoryCleanupJobBatchSize;
            this.simpleHistoryCleanupJobMinimumAge = conf.simpleHistoryCleanupJobMinimumAge;
            this.simpleHistoryCleanupJobAllCompletedSameParentBusiness = conf.simpleHistoryCleanupJobAllCompletedSameParentBusiness;
            this.simpleHistoryCleanupJobLockExpirationPeriod = conf.simpleHistoryCleanupJobLockExpirationPeriod;
            this.taskUpdatePriorityJobEnabled = conf.taskUpdatePriorityJobEnabled;
            this.taskUpdatePriorityJobBatchSize = conf.taskUpdatePriorityJobBatchSize;
            this.taskUpdatePriorityJobFirstRun = conf.taskUpdatePriorityJobFirstRun;
            this.taskUpdatePriorityJobRunEvery = conf.taskUpdatePriorityJobRunEvery;
            this.taskUpdatePriorityJobLockExpirationPeriod = conf.taskUpdatePriorityJobLockExpirationPeriod;
            this.userInfoRefreshJobEnabled = conf.userInfoRefreshJobEnabled;
            this.userRefreshJobFirstRun = conf.userRefreshJobFirstRun;
            this.userRefreshJobRunEvery = conf.userRefreshJobRunEvery;
            this.userRefreshJobLockExpirationPeriod = conf.userRefreshJobLockExpirationPeriod;
            this.customJobs = conf.customJobs;
            this.addAdditionalUserInfo = conf.addAdditionalUserInfo;
            this.minimalPermissionsToAssignDomains = conf.minimalPermissionsToAssignDomains;
            this.useSpecificDb2Taskquery = conf.useSpecificDb2Taskquery;
            this.properties = conf.properties;
        }

        private static Map<DayOfWeek, Set<LocalTimeInterval>> initDefaultWorkingTimeSchedule() {
            EnumMap<DayOfWeek, Set<LocalTimeInterval>> enumMap;
            EnumMap<DayOfWeek, Set<LocalTimeInterval>> enumMap2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            EnumMap<DayOfWeek, Set<LocalTimeInterval>> workingTime = new EnumMap<DayOfWeek, Set<LocalTimeInterval>>(DayOfWeek.class);
            Set<LocalTimeInterval> standardWorkingSlots = Set.of(new LocalTimeInterval(LocalTime.MIN, LocalTime.MAX));
            workingTime.put(DayOfWeek.MONDAY, standardWorkingSlots);
            workingTime.put(DayOfWeek.TUESDAY, standardWorkingSlots);
            workingTime.put(DayOfWeek.WEDNESDAY, standardWorkingSlots);
            workingTime.put(DayOfWeek.THURSDAY, standardWorkingSlots);
            workingTime.put(DayOfWeek.FRIDAY, standardWorkingSlots);
            EnumMap<DayOfWeek, Set<LocalTimeInterval>> enumMap3 = enumMap2 = (enumMap = workingTime);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, enumMap2);
            return enumMap;
        }

        public Builder initKadaiProperties() {
            Builder builder;
            Builder builder2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Builder builder3 = builder2 = (builder = this.initKadaiProperties(DEFAULT_KADAI_PROPERTIES, DEFAULT_KADAI_PROPERTY_SEPARATOR));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder initKadaiProperties(String propertiesFile) {
            Builder builder;
            Builder builder2;
            String string = propertiesFile;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Builder builder3 = builder2 = (builder = this.initKadaiProperties(propertiesFile, DEFAULT_KADAI_PROPERTY_SEPARATOR));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder initKadaiProperties(String propertiesFile, String separator) {
            Builder builder;
            Builder builder2;
            String string = propertiesFile;
            String string2 = separator;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (propertiesFile == null || propertiesFile.isEmpty() || propertiesFile.isBlank()) {
                throw new SystemException("property file can't be null or empty");
            }
            if (separator == null || separator.isEmpty() || separator.isBlank()) {
                throw new SystemException("separator file can't be null or empty");
            }
            LOGGER.debug("Reading kadai configuration from {} with separator {}", (Object)propertiesFile, (Object)separator);
            this.properties = this.loadProperties(propertiesFile);
            this.configureAnnotatedFields(separator, this.properties);
            this.addMasterDomain();
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder domains(List<String> domains) {
            Builder builder;
            Builder builder2;
            List<String> list = domains;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.domains = domains;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder enforceServiceLevel(boolean enforceServiceLevel) {
            Builder builder;
            Builder builder2;
            boolean bl = enforceServiceLevel;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.enforceServiceLevel = enforceServiceLevel;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder roleMap(Map<KadaiRole, Set<String>> roleMap) {
            Builder builder;
            Builder builder2;
            Map<KadaiRole, Set<String>> map = roleMap;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, map);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.roleMap = roleMap;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder classificationTypes(List<String> classificationTypes) {
            Builder builder;
            Builder builder2;
            List<String> list = classificationTypes;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.classificationTypes = classificationTypes;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder classificationCategoriesByType(Map<String, List<String>> classificationCategoriesByType) {
            Builder builder;
            Builder builder2;
            Map<String, List<String>> map = classificationCategoriesByType;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, map);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.classificationCategoriesByType = classificationCategoriesByType;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder useWorkingTimeCalculation(boolean useWorkingTimeCalculation) {
            Builder builder;
            Builder builder2;
            boolean bl = useWorkingTimeCalculation;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.useWorkingTimeCalculation = useWorkingTimeCalculation;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder workingTimeSchedule(Map<DayOfWeek, Set<LocalTimeInterval>> workingTimeSchedule) {
            Builder builder;
            Builder builder2;
            Map<DayOfWeek, Set<LocalTimeInterval>> map = workingTimeSchedule;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, map);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.workingTimeSchedule = workingTimeSchedule;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder workingTimeScheduleTimeZone(ZoneId workingTimeScheduleTimeZone) {
            Builder builder;
            Builder builder2;
            ZoneId zoneId = workingTimeScheduleTimeZone;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)zoneId);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.workingTimeScheduleTimeZone = workingTimeScheduleTimeZone;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder customHolidays(Set<CustomHoliday> customHolidays) {
            Builder builder;
            Builder builder2;
            Set<CustomHoliday> set = customHolidays;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, set);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.customHolidays = customHolidays;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder germanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = germanPublicHolidaysEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.germanPublicHolidaysEnabled = germanPublicHolidaysEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder germanPublicHolidaysCorpusChristiEnabled(boolean germanPublicHolidaysCorpusChristiEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = germanPublicHolidaysCorpusChristiEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.germanPublicHolidaysCorpusChristiEnabled = germanPublicHolidaysCorpusChristiEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder deleteHistoryEventsOnTaskDeletionEnabled(boolean deleteHistoryEventsOnTaskDeletionEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = deleteHistoryEventsOnTaskDeletionEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.deleteHistoryEventsOnTaskDeletionEnabled = deleteHistoryEventsOnTaskDeletionEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder logHistoryLoggerName(String loggerName) {
            Builder builder;
            Builder builder2;
            String string = loggerName;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.logHistoryLoggerName = loggerName;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobSchedulerEnabled(boolean jobSchedulerEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = jobSchedulerEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobSchedulerEnabled = jobSchedulerEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobSchedulerInitialStartDelay(long jobSchedulerInitialStartDelay) {
            Builder builder;
            Builder builder2;
            long l = jobSchedulerInitialStartDelay;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobSchedulerInitialStartDelay = jobSchedulerInitialStartDelay;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobSchedulerPeriod(long jobSchedulerPeriod) {
            Builder builder;
            Builder builder2;
            long l = jobSchedulerPeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobSchedulerPeriod = jobSchedulerPeriod;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobSchedulerPeriodTimeUnit(TimeUnit jobSchedulerPeriodTimeUnit) {
            Builder builder;
            Builder builder2;
            TimeUnit timeUnit = jobSchedulerPeriodTimeUnit;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)((Object)timeUnit));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobSchedulerPeriodTimeUnit = jobSchedulerPeriodTimeUnit;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder maxNumberOfJobRetries(int maxNumberOfJobRetries) {
            Builder builder;
            Builder builder2;
            int n = maxNumberOfJobRetries;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.maxNumberOfJobRetries = maxNumberOfJobRetries;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobBatchSize(int jobBatchSize) {
            Builder builder;
            Builder builder2;
            int n = jobBatchSize;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobBatchSize = jobBatchSize;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobFirstRun(Instant jobFirstRun) {
            Builder builder;
            Builder builder2;
            Instant instant = jobFirstRun;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)instant);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobFirstRun = jobFirstRun;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobRunEvery(Duration jobRunEvery) {
            Builder builder;
            Builder builder2;
            Duration duration = jobRunEvery;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobRunEvery = jobRunEvery;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskCleanupJobEnabled(boolean taskCleanupJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = taskCleanupJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskCleanupJobEnabled = taskCleanupJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder jobLockExpirationPeriod(Duration jobLockExpirationPeriod) {
            Builder builder;
            Builder builder2;
            Duration duration = jobLockExpirationPeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.jobLockExpirationPeriod = jobLockExpirationPeriod;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskCleanupJobMinimumAge(Duration taskCleanupJobMinimumAge) {
            Builder builder;
            Builder builder2;
            Duration duration = taskCleanupJobMinimumAge;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskCleanupJobMinimumAge = taskCleanupJobMinimumAge;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskCleanupJobAllCompletedSameParentBusiness(boolean taskCleanupJobAllCompletedSameParentBusiness) {
            Builder builder;
            Builder builder2;
            boolean bl = taskCleanupJobAllCompletedSameParentBusiness;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskCleanupJobAllCompletedSameParentBusiness = taskCleanupJobAllCompletedSameParentBusiness;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskCleanupJobLockExpirationPeriod(Duration taskCleanupJobLockExpirationPeriod) {
            Builder builder;
            Builder builder2;
            Duration duration = taskCleanupJobLockExpirationPeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskCleanupJobLockExpirationPeriod = taskCleanupJobLockExpirationPeriod;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder workbasketCleanupJobEnabled(boolean workbasketCleanupJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = workbasketCleanupJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.workbasketCleanupJobEnabled = workbasketCleanupJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder workbasketCleanupJobLockExpirationPeriod(Duration workbasketCleanupJobLockExpirationPeriod) {
            Builder builder;
            Builder builder2;
            Duration duration = workbasketCleanupJobLockExpirationPeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.workbasketCleanupJobLockExpirationPeriod = workbasketCleanupJobLockExpirationPeriod;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder simpleHistoryCleanupJobEnabled(boolean simpleHistoryCleanupJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = simpleHistoryCleanupJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.simpleHistoryCleanupJobEnabled = simpleHistoryCleanupJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder simpleHistoryCleanupJobBatchSize(int simpleHistoryCleanupJobBatchSize) {
            Builder builder;
            Builder builder2;
            int n = simpleHistoryCleanupJobBatchSize;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.simpleHistoryCleanupJobBatchSize = simpleHistoryCleanupJobBatchSize;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder simpleHistoryCleanupJobMinimumAge(Duration simpleHistoryCleanupJobMinimumAge) {
            Builder builder;
            Builder builder2;
            Duration duration = simpleHistoryCleanupJobMinimumAge;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.simpleHistoryCleanupJobMinimumAge = simpleHistoryCleanupJobMinimumAge;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder simpleHistoryCleanupJobAllCompletedSameParentBusiness(boolean simpleHistoryCleanupJobAllCompletedSameParentBusiness) {
            Builder builder;
            Builder builder2;
            boolean bl = simpleHistoryCleanupJobAllCompletedSameParentBusiness;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.simpleHistoryCleanupJobAllCompletedSameParentBusiness = simpleHistoryCleanupJobAllCompletedSameParentBusiness;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder simpleHistoryCleanupJobLockExpirationPeriod(Duration simpleHistoryCleanupJobLockExpirationPeriod) {
            Builder builder;
            Builder builder2;
            Duration duration = simpleHistoryCleanupJobLockExpirationPeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.simpleHistoryCleanupJobLockExpirationPeriod = simpleHistoryCleanupJobLockExpirationPeriod;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskUpdatePriorityJobEnabled(boolean taskUpdatePriorityJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = taskUpdatePriorityJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskUpdatePriorityJobEnabled = taskUpdatePriorityJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskUpdatePriorityJobBatchSize(int priorityJobBatchSize) {
            Builder builder;
            Builder builder2;
            int n = priorityJobBatchSize;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskUpdatePriorityJobBatchSize = priorityJobBatchSize;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskUpdatePriorityJobFirstRun(Instant taskUpdatePriorityJobFirstRun) {
            Builder builder;
            Builder builder2;
            Instant instant = taskUpdatePriorityJobFirstRun;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)instant);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskUpdatePriorityJobFirstRun = taskUpdatePriorityJobFirstRun;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskUpdatePriorityJobRunEvery(Duration taskUpdatePriorityJobRunEvery) {
            Builder builder;
            Builder builder2;
            Duration duration = taskUpdatePriorityJobRunEvery;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskUpdatePriorityJobRunEvery = taskUpdatePriorityJobRunEvery;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder taskUpdatePriorityJobLockExpirationPeriod(Duration taskUpdatePriorityJobLockExpirationPeriod) {
            Builder builder;
            Builder builder2;
            Duration duration = taskUpdatePriorityJobLockExpirationPeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskUpdatePriorityJobLockExpirationPeriod = taskUpdatePriorityJobLockExpirationPeriod;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder userInfoRefreshJobEnabled(boolean userInfoRefreshJobEnabled) {
            Builder builder;
            Builder builder2;
            boolean bl = userInfoRefreshJobEnabled;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.userInfoRefreshJobEnabled = userInfoRefreshJobEnabled;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder userRefreshJobFirstRun(Instant userRefreshJobFirstRun) {
            Builder builder;
            Builder builder2;
            Instant instant = userRefreshJobFirstRun;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)instant);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.userRefreshJobFirstRun = userRefreshJobFirstRun;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder userRefreshJobRunEvery(Duration userRefreshJobRunEvery) {
            Builder builder;
            Builder builder2;
            Duration duration = userRefreshJobRunEvery;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.userRefreshJobRunEvery = userRefreshJobRunEvery;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder userRefreshJobLockExpirationPeriod(Duration userRefreshJobLockExpirationPeriod) {
            Builder builder;
            Builder builder2;
            Duration duration = userRefreshJobLockExpirationPeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)duration);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.userRefreshJobLockExpirationPeriod = userRefreshJobLockExpirationPeriod;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder customJobs(Set<String> customJobs) {
            Builder builder;
            Builder builder2;
            Set<String> set = customJobs;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, set);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.customJobs = customJobs;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder addAdditionalUserInfo(boolean addAdditionalUserInfo) {
            Builder builder;
            Builder builder2;
            boolean bl = addAdditionalUserInfo;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.addAdditionalUserInfo = addAdditionalUserInfo;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder minimalPermissionsToAssignDomains(Set<WorkbasketPermission> minimalPermissionsToAssignDomains) {
            Builder builder;
            Builder builder2;
            Set<WorkbasketPermission> set = minimalPermissionsToAssignDomains;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, set);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.minimalPermissionsToAssignDomains = minimalPermissionsToAssignDomains;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public Builder useSpecificDb2Taskquery(boolean useSpecificDb2Taskquery) {
            Builder builder;
            Builder builder2;
            boolean bl = useSpecificDb2Taskquery;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.useSpecificDb2Taskquery = useSpecificDb2Taskquery;
            Builder builder3 = builder2 = (builder = this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
            return builder;
        }

        public KadaiConfiguration build() {
            KadaiConfiguration kadaiConfiguration;
            KadaiConfiguration kadaiConfiguration2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.adjustConfiguration();
            this.validateConfiguration();
            KadaiConfiguration kadaiConfiguration3 = kadaiConfiguration2 = (kadaiConfiguration = new KadaiConfiguration(this, null));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)kadaiConfiguration2);
            return kadaiConfiguration;
        }

        private void addMasterDomain() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (!this.domains.contains(SharedConstants.MASTER_DOMAIN)) {
                this.domains.add(SharedConstants.MASTER_DOMAIN);
            }
            Object var2_2 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
        }

        private void configureAnnotatedFields(String separator, Map<String, String> props) {
            String string = separator;
            Map<String, String> map = props;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object)string, map);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List fields = ReflectionUtil.retrieveAllFields(this.getClass());
            for (Field field : fields) {
                Optional.ofNullable(field.getAnnotation(KadaiProperty.class)).flatMap(kadaiProperty -> PropertyParser.getPropertyParser(field.getType()).parse(props, separator, field, kadaiProperty)).ifPresent(value -> this.setFieldValue(field, value));
            }
            Object var9_9 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
        }

        private void setFieldValue(Field field, Object value) {
            Field field2 = field;
            Object object = value;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, (Object)field2, (Object)object);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                field.set(this, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new SystemException(String.format("Property value '%s' is invalid for field '%s'", value, field.getName()), (Throwable)e);
            }
            Object var7_7 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
        }

        private void adjustConfiguration() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.domains = this.domains.stream().map(String::toUpperCase).toList();
            this.classificationTypes = this.classificationTypes.stream().map(String::toUpperCase).toList();
            this.classificationCategoriesByType = this.classificationCategoriesByType.entrySet().stream().map(e -> Map.entry(((String)e.getKey()).toUpperCase(), ((List)e.getValue()).stream().map(String::toUpperCase).toList())).sorted(Comparator.comparingInt(e -> this.classificationTypes.indexOf(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            this.roleMap = Arrays.stream(KadaiRole.values()).map(role -> Pair.of((Object)role, this.roleMap.getOrDefault(role, Set.of()))).map(pair -> {
                if (KadaiConfiguration.shouldUseLowerCaseForAccessIds()) {
                    return Pair.of((Object)((KadaiRole)pair.getLeft()), ((Set)pair.getRight()).stream().map(String::toLowerCase).collect(Collectors.toSet()));
                }
                return pair;
            }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
            Object var2_2 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
        }

        private void validateConfiguration() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (this.jobBatchSize <= 0) {
                throw new InvalidArgumentException("Parameter jobBatchSize (kadai.jobs.batchSize) must be a positive integer");
            }
            if (this.maxNumberOfJobRetries <= 0) {
                throw new InvalidArgumentException("Parameter maxNumberOfJobRetries (kadai.jobs.maxRetries) must be a positive integer");
            }
            if (this.jobRunEvery == null || this.jobRunEvery.isNegative() || this.jobRunEvery.isZero()) {
                throw new InvalidArgumentException("Parameter jobRunEvery (kadai.jobs.runEvery) must be a positive duration");
            }
            if (this.simpleHistoryCleanupJobMinimumAge == null || this.simpleHistoryCleanupJobMinimumAge.isNegative()) {
                throw new InvalidArgumentException("Parameter simpleHistoryCleanupJobMinimumAge (kadai.jobs.cleanup.history.simple.minimumAge) must not be negative");
            }
            if (this.taskCleanupJobMinimumAge == null || this.taskCleanupJobMinimumAge.isNegative()) {
                throw new InvalidArgumentException("Parameter taskCleanupJobMinimumAge (kadai.jobs.cleanup.task.minimumAge) must not be negative");
            }
            if (this.taskUpdatePriorityJobBatchSize <= 0) {
                throw new InvalidArgumentException("Parameter taskUpdatePriorityJobBatchSize (kadai.jobs.priority.task.batchSize) must be a positive integer");
            }
            if (this.taskUpdatePriorityJobRunEvery == null || this.taskUpdatePriorityJobRunEvery.isNegative() || this.taskUpdatePriorityJobRunEvery.isZero()) {
                throw new InvalidArgumentException("Parameter taskUpdatePriorityJobRunEvery (kadai.jobs.priority.task.runEvery) must be a positive duration");
            }
            if (this.userRefreshJobRunEvery == null || this.userRefreshJobRunEvery.isNegative() || this.userRefreshJobRunEvery.isZero()) {
                throw new InvalidArgumentException("Parameter userRefreshJobRunEvery (kadai.jobs.refresh.user.runEvery) must be a positive duration");
            }
            if (this.jobSchedulerInitialStartDelay < 0L) {
                throw new InvalidArgumentException("Parameter jobSchedulerInitialStartDelay (kadai.jobs.scheduler.initialStartDelay) must be a natural integer");
            }
            if (this.jobSchedulerPeriod <= 0L) {
                throw new InvalidArgumentException("Parameter jobSchedulerPeriod (kadai.jobs.scheduler.period) must be a positive integer");
            }
            if (!new HashSet<String>(this.classificationTypes).containsAll(this.classificationCategoriesByType.keySet())) {
                throw new InvalidArgumentException("Parameter classificationCategoriesByType (kadai.classification.categories.<KEY>) is configured incorrectly. Please check whether all specified Classification Types exist. Additionally, check whether the correct separator is used in the property kadai.classification.types .");
            }
            if (!this.classificationCategoriesByType.keySet().containsAll(this.classificationTypes)) {
                throw new InvalidArgumentException(String.format("Some Classification Categories for parameter classificationTypes (kadai.classification.types) are missing. configured: %s detected: %s", this.classificationTypes, this.classificationCategoriesByType.keySet()));
            }
            Object var2_2 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
        }

        /*
         * Exception decompiling
         */
        private String initSchemaName(String schemaName) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Map<String, String> loadProperties(String propertiesFile) {
            Map<String, String> map;
            Map<String, String> map2;
            String string = propertiesFile;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Properties props = new Properties();
            try {
                Throwable throwable = null;
                Object var4_8 = null;
                try (InputStream stream = FileLoaderUtil.openFileFromClasspathOrSystem((String)propertiesFile, KadaiConfiguration.class);){
                    props.load(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e2) {
                throw new SystemException(String.format("Could not process properties file '%s'", propertiesFile), (Throwable)e2);
            }
            Map<String, String> map3 = map2 = (map = props.entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> e.getKey().toString(), e -> e.getValue().toString())));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
            return map;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("KadaiConfiguration.java", Builder.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "initDefaultWorkingTimeSchedule", "io.kadai.KadaiConfiguration$Builder", "", "", "", "java.util.Map"), 1020);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initKadaiProperties", "io.kadai.KadaiConfiguration$Builder", "", "", "", "io.kadai.KadaiConfiguration$Builder"), 1040);
            ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workingTimeSchedule", "io.kadai.KadaiConfiguration$Builder", "java.util.Map", "workingTimeSchedule", "", "io.kadai.KadaiConfiguration$Builder"), 1131);
            ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workingTimeScheduleTimeZone", "io.kadai.KadaiConfiguration$Builder", "java.time.ZoneId", "workingTimeScheduleTimeZone", "", "io.kadai.KadaiConfiguration$Builder"), 1136);
            ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "customHolidays", "io.kadai.KadaiConfiguration$Builder", "java.util.Set", "customHolidays", "", "io.kadai.KadaiConfiguration$Builder"), 1141);
            ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "germanPublicHolidaysEnabled", "io.kadai.KadaiConfiguration$Builder", "boolean", "germanPublicHolidaysEnabled", "", "io.kadai.KadaiConfiguration$Builder"), 1146);
            ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "germanPublicHolidaysCorpusChristiEnabled", "io.kadai.KadaiConfiguration$Builder", "boolean", "germanPublicHolidaysCorpusChristiEnabled", "", "io.kadai.KadaiConfiguration$Builder"), 1155);
            ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteHistoryEventsOnTaskDeletionEnabled", "io.kadai.KadaiConfiguration$Builder", "boolean", "deleteHistoryEventsOnTaskDeletionEnabled", "", "io.kadai.KadaiConfiguration$Builder"), 1161);
            ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logHistoryLoggerName", "io.kadai.KadaiConfiguration$Builder", "java.lang.String", "loggerName", "", "io.kadai.KadaiConfiguration$Builder"), 1171);
            ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobSchedulerEnabled", "io.kadai.KadaiConfiguration$Builder", "boolean", "jobSchedulerEnabled", "", "io.kadai.KadaiConfiguration$Builder"), 1176);
            ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobSchedulerInitialStartDelay", "io.kadai.KadaiConfiguration$Builder", "long", "jobSchedulerInitialStartDelay", "", "io.kadai.KadaiConfiguration$Builder"), 1181);
            ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobSchedulerPeriod", "io.kadai.KadaiConfiguration$Builder", "long", "jobSchedulerPeriod", "", "io.kadai.KadaiConfiguration$Builder"), 1186);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initKadaiProperties", "io.kadai.KadaiConfiguration$Builder", "java.lang.String", "propertiesFile", "", "io.kadai.KadaiConfiguration$Builder"), 1051);
            ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobSchedulerPeriodTimeUnit", "io.kadai.KadaiConfiguration$Builder", "java.util.concurrent.TimeUnit", "jobSchedulerPeriodTimeUnit", "", "io.kadai.KadaiConfiguration$Builder"), 1191);
            ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "maxNumberOfJobRetries", "io.kadai.KadaiConfiguration$Builder", "int", "maxNumberOfJobRetries", "", "io.kadai.KadaiConfiguration$Builder"), 1196);
            ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobBatchSize", "io.kadai.KadaiConfiguration$Builder", "int", "jobBatchSize", "", "io.kadai.KadaiConfiguration$Builder"), 1201);
            ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobFirstRun", "io.kadai.KadaiConfiguration$Builder", "java.time.Instant", "jobFirstRun", "", "io.kadai.KadaiConfiguration$Builder"), 1206);
            ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobRunEvery", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "jobRunEvery", "", "io.kadai.KadaiConfiguration$Builder"), 1211);
            ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskCleanupJobEnabled", "io.kadai.KadaiConfiguration$Builder", "boolean", "taskCleanupJobEnabled", "", "io.kadai.KadaiConfiguration$Builder"), 1216);
            ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jobLockExpirationPeriod", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "jobLockExpirationPeriod", "", "io.kadai.KadaiConfiguration$Builder"), 1221);
            ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskCleanupJobMinimumAge", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "taskCleanupJobMinimumAge", "", "io.kadai.KadaiConfiguration$Builder"), 1226);
            ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskCleanupJobAllCompletedSameParentBusiness", "io.kadai.KadaiConfiguration$Builder", "boolean", "taskCleanupJobAllCompletedSameParentBusiness", "", "io.kadai.KadaiConfiguration$Builder"), 1231);
            ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskCleanupJobLockExpirationPeriod", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "taskCleanupJobLockExpirationPeriod", "", "io.kadai.KadaiConfiguration$Builder"), 1238);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initKadaiProperties", "io.kadai.KadaiConfiguration$Builder", "java.lang.String:java.lang.String", "propertiesFile:separator", "", "io.kadai.KadaiConfiguration$Builder"), 1072);
            ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workbasketCleanupJobEnabled", "io.kadai.KadaiConfiguration$Builder", "boolean", "workbasketCleanupJobEnabled", "", "io.kadai.KadaiConfiguration$Builder"), 1243);
            ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workbasketCleanupJobLockExpirationPeriod", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "workbasketCleanupJobLockExpirationPeriod", "", "io.kadai.KadaiConfiguration$Builder"), 1248);
            ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simpleHistoryCleanupJobEnabled", "io.kadai.KadaiConfiguration$Builder", "boolean", "simpleHistoryCleanupJobEnabled", "", "io.kadai.KadaiConfiguration$Builder"), 1254);
            ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simpleHistoryCleanupJobBatchSize", "io.kadai.KadaiConfiguration$Builder", "int", "simpleHistoryCleanupJobBatchSize", "", "io.kadai.KadaiConfiguration$Builder"), 1259);
            ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simpleHistoryCleanupJobMinimumAge", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "simpleHistoryCleanupJobMinimumAge", "", "io.kadai.KadaiConfiguration$Builder"), 1264);
            ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simpleHistoryCleanupJobAllCompletedSameParentBusiness", "io.kadai.KadaiConfiguration$Builder", "boolean", "simpleHistoryCleanupJobAllCompletedSameParentBusiness", "", "io.kadai.KadaiConfiguration$Builder"), 1269);
            ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "simpleHistoryCleanupJobLockExpirationPeriod", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "simpleHistoryCleanupJobLockExpirationPeriod", "", "io.kadai.KadaiConfiguration$Builder"), 1276);
            ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskUpdatePriorityJobEnabled", "io.kadai.KadaiConfiguration$Builder", "boolean", "taskUpdatePriorityJobEnabled", "", "io.kadai.KadaiConfiguration$Builder"), 1283);
            ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskUpdatePriorityJobBatchSize", "io.kadai.KadaiConfiguration$Builder", "int", "priorityJobBatchSize", "", "io.kadai.KadaiConfiguration$Builder"), 1288);
            ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskUpdatePriorityJobFirstRun", "io.kadai.KadaiConfiguration$Builder", "java.time.Instant", "taskUpdatePriorityJobFirstRun", "", "io.kadai.KadaiConfiguration$Builder"), 1293);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "domains", "io.kadai.KadaiConfiguration$Builder", "java.util.List", "domains", "", "io.kadai.KadaiConfiguration$Builder"), 1088);
            ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskUpdatePriorityJobRunEvery", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "taskUpdatePriorityJobRunEvery", "", "io.kadai.KadaiConfiguration$Builder"), 1298);
            ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "taskUpdatePriorityJobLockExpirationPeriod", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "taskUpdatePriorityJobLockExpirationPeriod", "", "io.kadai.KadaiConfiguration$Builder"), 1303);
            ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "userInfoRefreshJobEnabled", "io.kadai.KadaiConfiguration$Builder", "boolean", "userInfoRefreshJobEnabled", "", "io.kadai.KadaiConfiguration$Builder"), 1309);
            ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "userRefreshJobFirstRun", "io.kadai.KadaiConfiguration$Builder", "java.time.Instant", "userRefreshJobFirstRun", "", "io.kadai.KadaiConfiguration$Builder"), 1314);
            ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "userRefreshJobRunEvery", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "userRefreshJobRunEvery", "", "io.kadai.KadaiConfiguration$Builder"), 1319);
            ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "userRefreshJobLockExpirationPeriod", "io.kadai.KadaiConfiguration$Builder", "java.time.Duration", "userRefreshJobLockExpirationPeriod", "", "io.kadai.KadaiConfiguration$Builder"), 1324);
            ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "customJobs", "io.kadai.KadaiConfiguration$Builder", "java.util.Set", "customJobs", "", "io.kadai.KadaiConfiguration$Builder"), 1333);
            ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addAdditionalUserInfo", "io.kadai.KadaiConfiguration$Builder", "boolean", "addAdditionalUserInfo", "", "io.kadai.KadaiConfiguration$Builder"), 1338);
            ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "minimalPermissionsToAssignDomains", "io.kadai.KadaiConfiguration$Builder", "java.util.Set", "minimalPermissionsToAssignDomains", "", "io.kadai.KadaiConfiguration$Builder"), 1343);
            ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "useSpecificDb2Taskquery", "io.kadai.KadaiConfiguration$Builder", "boolean", "useSpecificDb2Taskquery", "", "io.kadai.KadaiConfiguration$Builder"), 1351);
            ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enforceServiceLevel", "io.kadai.KadaiConfiguration$Builder", "boolean", "enforceServiceLevel", "", "io.kadai.KadaiConfiguration$Builder"), 1097);
            ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "build", "io.kadai.KadaiConfiguration$Builder", "", "", "", "io.kadai.KadaiConfiguration"), 1358);
            ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addMasterDomain", "io.kadai.KadaiConfiguration$Builder", "", "", "", "void"), 1364);
            ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "configureAnnotatedFields", "io.kadai.KadaiConfiguration$Builder", "java.lang.String:java.util.Map", "separator:props", "", "void"), 1373);
            ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setFieldValue", "io.kadai.KadaiConfiguration$Builder", "java.lang.reflect.Field:java.lang.Object", "field:value", "", "void"), 1385);
            ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "adjustConfiguration", "io.kadai.KadaiConfiguration$Builder", "", "", "", "void"), 1395);
            ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateConfiguration", "io.kadai.KadaiConfiguration$Builder", "", "", "", "void"), 1429);
            ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initSchemaName", "io.kadai.KadaiConfiguration$Builder", "java.lang.String", "schemaName", "", "java.lang.String"), 1503);
            ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadProperties", "io.kadai.KadaiConfiguration$Builder", "java.lang.String", "propertiesFile", "", "java.util.Map"), 1521);
            ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "roleMap", "io.kadai.KadaiConfiguration$Builder", "java.util.Map", "roleMap", "", "io.kadai.KadaiConfiguration$Builder"), 1106);
            ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationTypes", "io.kadai.KadaiConfiguration$Builder", "java.util.List", "classificationTypes", "", "io.kadai.KadaiConfiguration$Builder"), 1111);
            ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationCategoriesByType", "io.kadai.KadaiConfiguration$Builder", "java.util.Map", "classificationCategoriesByType", "", "io.kadai.KadaiConfiguration$Builder"), 1120);
            ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "useWorkingTimeCalculation", "io.kadai.KadaiConfiguration$Builder", "boolean", "useWorkingTimeCalculation", "", "io.kadai.KadaiConfiguration$Builder"), 1126);
        }
    }
}

