/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.classification.internal.jobs;

import io.kadai.common.api.KadaiEngine;
import io.kadai.common.api.ScheduledJob;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.jobs.AbstractKadaiJob;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.transaction.KadaiTransactionProvider;
import io.kadai.common.internal.util.CollectionUtil;
import io.kadai.task.internal.TaskServiceImpl;
import io.kadai.task.internal.jobs.TaskRefreshJob;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationChangedJob
extends AbstractKadaiJob {
    public static final String CLASSIFICATION_ID = "classificationId";
    public static final String PRIORITY_CHANGED = "priorityChanged";
    public static final String SERVICE_LEVEL_CHANGED = "serviceLevelChanged";
    private static final Logger LOGGER;
    private static final String TASK_IDS = "taskIds";
    private final String classificationId;
    private final boolean priorityChanged;
    private final boolean serviceLevelChanged;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        ClassificationChangedJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ClassificationChangedJob.class);
    }

    public ClassificationChangedJob(KadaiEngine engine, KadaiTransactionProvider txProvider, ScheduledJob job) {
        super(engine, txProvider, job, false);
        Map<String, String> args = job.getArguments();
        this.classificationId = args.get(CLASSIFICATION_ID);
        this.priorityChanged = Boolean.parseBoolean(args.get(PRIORITY_CHANGED));
        this.serviceLevelChanged = Boolean.parseBoolean(args.get(SERVICE_LEVEL_CHANGED));
    }

    @Override
    public void execute() throws KadaiException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LOGGER.info("Running ClassificationChangedJob for classification ({})", (Object)this.classificationId);
        try {
            TaskServiceImpl taskService = (TaskServiceImpl)this.kadaiEngineImpl.getTaskService();
            List<String> affectedTaskIds = taskService.findTasksIdsAffectedByClassificationChange(this.classificationId);
            if (!affectedTaskIds.isEmpty()) {
                this.scheduleTaskRefreshJobs(affectedTaskIds);
            }
            LOGGER.info("ClassificationChangedJob ended successfully.");
        }
        catch (Exception e) {
            throw new SystemException("Error while processing ClassificationChangedJob.", (Throwable)e);
        }
        Object var4_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_5);
    }

    @Override
    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = ClassificationChangedJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private void scheduleTaskRefreshJobs(List<String> affectedTaskIds) {
        List<String> list = affectedTaskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int batchSize = this.kadaiEngineImpl.getConfiguration().getJobBatchSize();
        Collection affectedTaskBatches = CollectionUtil.partitionBasedOnSize(affectedTaskIds, (int)batchSize);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating {} TaskRefreshJobs out of {} affected tasks with a maximum number of {} tasks each. ", new Object[]{affectedTaskBatches.size(), affectedTaskIds.size(), batchSize});
        }
        for (List taskIdBatch : affectedTaskBatches) {
            HashMap<String, String> args = new HashMap<String, String>();
            if (taskIdBatch.isEmpty()) continue;
            String taskIds = String.join((CharSequence)",", affectedTaskIds);
            args.put(TASK_IDS, taskIds);
            args.put(PRIORITY_CHANGED, Boolean.toString(this.priorityChanged));
            args.put(SERVICE_LEVEL_CHANGED, Boolean.toString(this.serviceLevelChanged));
            ScheduledJob job = new ScheduledJob();
            job.setType(TaskRefreshJob.class.getName());
            job.setArguments(args);
            this.kadaiEngineImpl.getJobService().createJob(job);
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    public String toString() {
        return "ClassificationChangedJob [classificationId=" + this.classificationId + ", priorityChanged=" + this.priorityChanged + ", serviceLevelChanged=" + this.serviceLevelChanged + ", firstRun=" + this.firstRun + ", runEvery=" + this.runEvery + ", kadaiEngineImpl=" + this.kadaiEngineImpl + ", txProvider=" + this.txProvider + ", scheduledJob=" + this.scheduledJob + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationChangedJob.java", ClassificationChangedJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "io.kadai.classification.internal.jobs.ClassificationChangedJob", "", "", "io.kadai.common.api.exceptions.KadaiException", "void"), 62);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "io.kadai.classification.internal.jobs.ClassificationChangedJob", "", "", "", "java.lang.String"), 78);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "scheduleTaskRefreshJobs", "io.kadai.classification.internal.jobs.ClassificationChangedJob", "java.util.List", "affectedTaskIds", "", "void"), 82);
    }
}

