/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal;

import io.kadai.KadaiConfiguration;
import io.kadai.common.api.JobService;
import io.kadai.common.api.ScheduledJob;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.JobMapper;
import io.kadai.common.internal.logging.LoggingAspect;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobServiceImpl
implements JobService {
    public static final int JOB_DEFAULT_PRIORITY = 50;
    private static final Logger LOGGER;
    private final JobMapper jobMapper;
    private final InternalKadaiEngine kadaiEngineImpl;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        JobServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JobServiceImpl.class);
    }

    public JobServiceImpl(InternalKadaiEngine kadaiEngine, JobMapper jobMapper) {
        this.kadaiEngineImpl = kadaiEngine;
        this.jobMapper = jobMapper;
    }

    @Override
    public ScheduledJob createJob(ScheduledJob job) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)scheduledJob3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.initializeDefaultJobProperties(job);
        Integer id = this.kadaiEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.insertJob(job));
        job.setJobId(id);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created job {}", (Object)job);
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = job);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    public void deleteJobs(String jobType) {
        String string = jobType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.deleteMultiple(jobType));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted jobs of type: {}", (Object)jobType);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public ScheduledJob lockJob(ScheduledJob job, String owner) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        String string = owner;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)scheduledJob3, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        job.setLockedBy(owner);
        Class<?> jobClass = null;
        try {
            jobClass = Thread.currentThread().getContextClassLoader().loadClass(job.getType());
            job.setLockExpires(Instant.now().plus((Duration)jobClass.getMethod("getLockExpirationPeriod", KadaiConfiguration.class).invoke(null, this.kadaiEngineImpl.getEngine().getConfiguration())));
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            throw new SystemException(String.format("Job '%s' does not have a method matching ('getLockExpirationPeriod', %s", jobClass, KadaiConfiguration.class));
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new SystemException(String.format("Caught Exception while invoking method 'getLockExpirationPeriod' by reflection", new Object[0]));
        }
        job.setRetryCount(job.getRetryCount() - 1);
        this.kadaiEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.update(job));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Job {} locked. Remaining retries: {}", (Object)job.getJobId(), (Object)job.getRetryCount());
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = job);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    public List<ScheduledJob> findJobsToRun() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List availableJobs = this.kadaiEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.findJobsToRun(Instant.now()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found available jobs: {}", (Object)availableJobs);
        }
        List list3 = list2 = (list = availableJobs);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public void deleteJob(ScheduledJob job) {
        ScheduledJob scheduledJob = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)scheduledJob);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngineImpl.executeInDatabaseConnection(() -> this.jobMapper.delete(job));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted job: {}", (Object)job);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void initializeDefaultJobProperties(ScheduledJob job) {
        ScheduledJob scheduledJob = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)scheduledJob);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant now = Instant.now();
        job.setCreated(now);
        job.setState(ScheduledJob.State.READY);
        job.setPriority(50);
        if (job.getDue() == null) {
            job.setDue(now);
        }
        job.setRetryCount(this.kadaiEngineImpl.getEngine().getConfiguration().getMaxNumberOfJobRetries());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Job after initialization: {}", (Object)job);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobServiceImpl.java", JobServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createJob", "io.kadai.common.internal.JobServiceImpl", "io.kadai.common.api.ScheduledJob", "job", "", "io.kadai.common.api.ScheduledJob"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJobs", "io.kadai.common.internal.JobServiceImpl", "java.lang.String", "jobType", "", "void"), 57);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lockJob", "io.kadai.common.internal.JobServiceImpl", "io.kadai.common.api.ScheduledJob:java.lang.String", "job:owner", "", "io.kadai.common.api.ScheduledJob"), 64);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findJobsToRun", "io.kadai.common.internal.JobServiceImpl", "", "", "", "java.util.List"), 95);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteJob", "io.kadai.common.internal.JobServiceImpl", "io.kadai.common.api.ScheduledJob", "job", "", "void"), 104);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeDefaultJobProperties", "io.kadai.common.internal.JobServiceImpl", "io.kadai.common.api.ScheduledJob", "job", "", "void"), 111);
    }
}

