/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal;

import io.kadai.KadaiConfiguration;
import io.kadai.classification.api.ClassificationService;
import io.kadai.classification.internal.ClassificationMapper;
import io.kadai.classification.internal.ClassificationQueryMapper;
import io.kadai.classification.internal.ClassificationServiceImpl;
import io.kadai.common.api.ConfigurationService;
import io.kadai.common.api.JobService;
import io.kadai.common.api.KadaiEngine;
import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.WorkingTimeCalculator;
import io.kadai.common.api.exceptions.AutocommitFailedException;
import io.kadai.common.api.exceptions.ConnectionNotSetException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.api.security.CurrentUserContext;
import io.kadai.common.api.security.UserPrincipal;
import io.kadai.common.internal.ConfigurationMapper;
import io.kadai.common.internal.ConfigurationServiceImpl;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.JobMapper;
import io.kadai.common.internal.JobServiceImpl;
import io.kadai.common.internal.configuration.DB;
import io.kadai.common.internal.configuration.DbSchemaCreator;
import io.kadai.common.internal.jobs.JobScheduler;
import io.kadai.common.internal.jobs.RealClock;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.persistence.InstantTypeHandler;
import io.kadai.common.internal.persistence.MapTypeHandler;
import io.kadai.common.internal.security.CurrentUserContextImpl;
import io.kadai.common.internal.workingtime.HolidaySchedule;
import io.kadai.common.internal.workingtime.WorkingDayCalculatorImpl;
import io.kadai.common.internal.workingtime.WorkingTimeCalculatorImpl;
import io.kadai.monitor.api.MonitorService;
import io.kadai.monitor.internal.MonitorMapper;
import io.kadai.monitor.internal.MonitorServiceImpl;
import io.kadai.spi.history.internal.HistoryEventManager;
import io.kadai.spi.priority.internal.PriorityServiceManager;
import io.kadai.spi.routing.internal.TaskRoutingManager;
import io.kadai.spi.task.internal.AfterRequestChangesManager;
import io.kadai.spi.task.internal.AfterRequestReviewManager;
import io.kadai.spi.task.internal.BeforeRequestChangesManager;
import io.kadai.spi.task.internal.BeforeRequestReviewManager;
import io.kadai.spi.task.internal.CreateTaskPreprocessorManager;
import io.kadai.spi.task.internal.ReviewRequiredManager;
import io.kadai.spi.task.internal.TaskEndstatePreprocessorManager;
import io.kadai.task.api.TaskService;
import io.kadai.task.internal.AttachmentMapper;
import io.kadai.task.internal.ObjectReferenceMapper;
import io.kadai.task.internal.TaskCommentMapper;
import io.kadai.task.internal.TaskCommentQueryMapper;
import io.kadai.task.internal.TaskMapper;
import io.kadai.task.internal.TaskQueryMapper;
import io.kadai.task.internal.TaskServiceImpl;
import io.kadai.user.api.UserService;
import io.kadai.user.internal.UserMapper;
import io.kadai.user.internal.UserServiceImpl;
import io.kadai.workbasket.api.WorkbasketService;
import io.kadai.workbasket.internal.DistributionTargetMapper;
import io.kadai.workbasket.internal.WorkbasketAccessMapper;
import io.kadai.workbasket.internal.WorkbasketMapper;
import io.kadai.workbasket.internal.WorkbasketQueryMapper;
import io.kadai.workbasket.internal.WorkbasketServiceImpl;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KadaiEngineImpl
implements KadaiEngine {
    private static final Logger LOGGER;
    private static final SessionStack SESSION_STACK;
    protected final KadaiConfiguration kadaiConfiguration;
    private final TaskRoutingManager taskRoutingManager;
    private final CreateTaskPreprocessorManager createTaskPreprocessorManager;
    private final PriorityServiceManager priorityServiceManager;
    private final ReviewRequiredManager reviewRequiredManager;
    private final BeforeRequestReviewManager beforeRequestReviewManager;
    private final AfterRequestReviewManager afterRequestReviewManager;
    private final BeforeRequestChangesManager beforeRequestChangesManager;
    private final AfterRequestChangesManager afterRequestChangesManager;
    private final TaskEndstatePreprocessorManager taskEndstatePreprocessorManager;
    private final InternalKadaiEngineImpl internalKadaiEngineImpl;
    private final WorkingTimeCalculator workingTimeCalculator;
    private final HistoryEventManager historyEventManager;
    private final CurrentUserContext currentUserContext;
    private final JobScheduler jobScheduler;
    protected KadaiEngine.ConnectionManagementMode mode;
    protected TransactionFactory transactionFactory;
    protected SqlSessionManager sessionManager;
    protected Connection connection;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;

    static {
        KadaiEngineImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(KadaiEngineImpl.class);
        SESSION_STACK = new SessionStack();
    }

    protected KadaiEngineImpl(KadaiConfiguration kadaiConfiguration, KadaiEngine.ConnectionManagementMode connectionManagementMode, TransactionFactory transactionFactory) throws SQLException {
        LOGGER.info("initializing KADAI with this configuration: {} and this mode: {}", (Object)kadaiConfiguration, (Object)connectionManagementMode);
        this.mode = connectionManagementMode == KadaiEngine.ConnectionManagementMode.EXPLICIT ? KadaiEngine.ConnectionManagementMode.AUTOCOMMIT : connectionManagementMode;
        this.kadaiConfiguration = kadaiConfiguration;
        this.internalKadaiEngineImpl = new InternalKadaiEngineImpl();
        HolidaySchedule holidaySchedule = new HolidaySchedule(kadaiConfiguration.isGermanPublicHolidaysEnabled(), kadaiConfiguration.isGermanPublicHolidaysCorpusChristiEnabled(), kadaiConfiguration.getCustomHolidays());
        this.workingTimeCalculator = kadaiConfiguration.isUseWorkingTimeCalculation() ? new WorkingTimeCalculatorImpl(holidaySchedule, kadaiConfiguration.getWorkingTimeSchedule(), kadaiConfiguration.getWorkingTimeScheduleTimeZone()) : new WorkingDayCalculatorImpl(holidaySchedule, kadaiConfiguration.getWorkingTimeScheduleTimeZone());
        this.currentUserContext = new CurrentUserContextImpl(KadaiConfiguration.shouldUseLowerCaseForAccessIds());
        if (transactionFactory == null) {
            this.createTransactionFactory(kadaiConfiguration.isUseManagedTransactions());
        } else {
            this.transactionFactory = transactionFactory;
        }
        this.sessionManager = this.createSqlSessionManager();
        this.initializeDbSchema(kadaiConfiguration);
        if (this.kadaiConfiguration.isJobSchedulerEnabled()) {
            KadaiConfiguration configuration = new KadaiConfiguration.Builder(this.kadaiConfiguration).jobSchedulerEnabled(false).build();
            KadaiEngine kadaiEngine = KadaiEngine.buildKadaiEngine(configuration, KadaiEngine.ConnectionManagementMode.EXPLICIT, transactionFactory);
            RealClock clock = new RealClock(this.kadaiConfiguration.getJobSchedulerInitialStartDelay(), this.kadaiConfiguration.getJobSchedulerPeriod(), this.kadaiConfiguration.getJobSchedulerPeriodTimeUnit());
            this.jobScheduler = new JobScheduler(kadaiEngine, clock);
            this.jobScheduler.start();
        } else {
            this.jobScheduler = null;
        }
        this.createTaskPreprocessorManager = new CreateTaskPreprocessorManager();
        this.priorityServiceManager = new PriorityServiceManager(this);
        this.historyEventManager = new HistoryEventManager(this);
        this.taskRoutingManager = new TaskRoutingManager(this);
        this.reviewRequiredManager = new ReviewRequiredManager(this);
        this.beforeRequestReviewManager = new BeforeRequestReviewManager(this);
        this.afterRequestReviewManager = new AfterRequestReviewManager(this);
        this.beforeRequestChangesManager = new BeforeRequestChangesManager(this);
        this.afterRequestChangesManager = new AfterRequestChangesManager(this);
        this.taskEndstatePreprocessorManager = new TaskEndstatePreprocessorManager();
        this.mode = connectionManagementMode;
    }

    public static KadaiEngine createKadaiEngine(KadaiConfiguration kadaiConfiguration, KadaiEngine.ConnectionManagementMode connectionManagementMode, TransactionFactory transactionFactory) throws SQLException {
        KadaiEngineImpl kadaiEngineImpl;
        KadaiEngineImpl kadaiEngineImpl2;
        KadaiConfiguration kadaiConfiguration2 = kadaiConfiguration;
        KadaiEngine.ConnectionManagementMode connectionManagementMode2 = connectionManagementMode;
        TransactionFactory transactionFactory2 = transactionFactory;
        Object[] objectArray = new Object[]{kadaiConfiguration2, connectionManagementMode2, transactionFactory2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        KadaiEngineImpl kadaiEngineImpl3 = kadaiEngineImpl2 = (kadaiEngineImpl = new KadaiEngineImpl(kadaiConfiguration, connectionManagementMode, transactionFactory));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)kadaiEngineImpl2);
        return kadaiEngineImpl;
    }

    @Override
    public ConfigurationService getConfigurationService() {
        ConfigurationServiceImpl configurationServiceImpl;
        ConfigurationServiceImpl configurationServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ConfigurationServiceImpl configurationServiceImpl3 = configurationServiceImpl2 = (configurationServiceImpl = new ConfigurationServiceImpl(this.internalKadaiEngineImpl, (ConfigurationMapper)this.sessionManager.getMapper(ConfigurationMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)configurationServiceImpl2);
        return configurationServiceImpl;
    }

    @Override
    public TaskService getTaskService() {
        TaskServiceImpl taskServiceImpl;
        TaskServiceImpl taskServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskServiceImpl taskServiceImpl3 = taskServiceImpl2 = (taskServiceImpl = new TaskServiceImpl(this.internalKadaiEngineImpl, (TaskMapper)this.sessionManager.getMapper(TaskMapper.class), (TaskCommentMapper)this.sessionManager.getMapper(TaskCommentMapper.class), (AttachmentMapper)this.sessionManager.getMapper(AttachmentMapper.class), (ObjectReferenceMapper)this.sessionManager.getMapper(ObjectReferenceMapper.class), (UserMapper)this.sessionManager.getMapper(UserMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskServiceImpl2);
        return taskServiceImpl;
    }

    @Override
    public MonitorService getMonitorService() {
        MonitorServiceImpl monitorServiceImpl;
        MonitorServiceImpl monitorServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        MonitorServiceImpl monitorServiceImpl3 = monitorServiceImpl2 = (monitorServiceImpl = new MonitorServiceImpl(this.internalKadaiEngineImpl, (MonitorMapper)this.sessionManager.getMapper(MonitorMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)monitorServiceImpl2);
        return monitorServiceImpl;
    }

    @Override
    public WorkbasketService getWorkbasketService() {
        WorkbasketServiceImpl workbasketServiceImpl;
        WorkbasketServiceImpl workbasketServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketServiceImpl workbasketServiceImpl3 = workbasketServiceImpl2 = (workbasketServiceImpl = new WorkbasketServiceImpl(this.internalKadaiEngineImpl, this.historyEventManager, (WorkbasketMapper)this.sessionManager.getMapper(WorkbasketMapper.class), (DistributionTargetMapper)this.sessionManager.getMapper(DistributionTargetMapper.class), (WorkbasketAccessMapper)this.sessionManager.getMapper(WorkbasketAccessMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketServiceImpl2);
        return workbasketServiceImpl;
    }

    @Override
    public ClassificationService getClassificationService() {
        ClassificationServiceImpl classificationServiceImpl;
        ClassificationServiceImpl classificationServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationServiceImpl classificationServiceImpl3 = classificationServiceImpl2 = (classificationServiceImpl = new ClassificationServiceImpl(this.internalKadaiEngineImpl, this.priorityServiceManager, (ClassificationMapper)this.sessionManager.getMapper(ClassificationMapper.class), (TaskMapper)this.sessionManager.getMapper(TaskMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationServiceImpl2);
        return classificationServiceImpl;
    }

    public Connection getConnection() {
        Connection connection;
        Connection connection2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Connection connection3 = connection2 = (connection = this.connection);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)connection2);
        return connection;
    }

    @Override
    public void setConnection(Connection connection) throws SQLException {
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)connection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (connection != null) {
            this.connection = connection;
            connection.setAutoCommit(false);
            connection.setSchema(this.kadaiConfiguration.getSchemaName());
            this.mode = KadaiEngine.ConnectionManagementMode.EXPLICIT;
            if (this.transactionFactory.getClass().getSimpleName().equals("SpringManagedTransactionFactory")) {
                this.sessionManager.startManagedSession();
            } else {
                this.sessionManager.startManagedSession(connection);
            }
        } else if (this.connection != null) {
            this.closeConnection();
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public PriorityServiceManager getPriorityServiceManager() {
        PriorityServiceManager priorityServiceManager;
        PriorityServiceManager priorityServiceManager2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PriorityServiceManager priorityServiceManager3 = priorityServiceManager2 = (priorityServiceManager = this.priorityServiceManager);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)priorityServiceManager2);
        return priorityServiceManager;
    }

    @Override
    public JobService getJobService() {
        JobServiceImpl jobServiceImpl;
        JobServiceImpl jobServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobServiceImpl jobServiceImpl3 = jobServiceImpl2 = (jobServiceImpl = new JobServiceImpl(this.internalKadaiEngineImpl, (JobMapper)this.sessionManager.getMapper(JobMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)jobServiceImpl2);
        return jobServiceImpl;
    }

    @Override
    public UserService getUserService() {
        UserServiceImpl userServiceImpl;
        UserServiceImpl userServiceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        UserServiceImpl userServiceImpl3 = userServiceImpl2 = (userServiceImpl = new UserServiceImpl(this.internalKadaiEngineImpl, (UserMapper)this.sessionManager.getMapper(UserMapper.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)userServiceImpl2);
        return userServiceImpl;
    }

    public JobScheduler getJobScheduler() {
        JobScheduler jobScheduler;
        JobScheduler jobScheduler2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JobScheduler jobScheduler3 = jobScheduler2 = (jobScheduler = this.jobScheduler);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)jobScheduler2);
        return jobScheduler;
    }

    @Override
    public KadaiConfiguration getConfiguration() {
        KadaiConfiguration kadaiConfiguration;
        KadaiConfiguration kadaiConfiguration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        KadaiConfiguration kadaiConfiguration3 = kadaiConfiguration2 = (kadaiConfiguration = this.kadaiConfiguration);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)kadaiConfiguration2);
        return kadaiConfiguration;
    }

    @Override
    public WorkingTimeCalculator getWorkingTimeCalculator() {
        WorkingTimeCalculator workingTimeCalculator;
        WorkingTimeCalculator workingTimeCalculator2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkingTimeCalculator workingTimeCalculator3 = workingTimeCalculator2 = (workingTimeCalculator = this.workingTimeCalculator);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workingTimeCalculator2);
        return workingTimeCalculator;
    }

    @Override
    public boolean isHistoryEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.historyEventManager.isEnabled());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    @Override
    public KadaiEngine.ConnectionManagementMode getConnectionManagementMode() {
        KadaiEngine.ConnectionManagementMode connectionManagementMode;
        KadaiEngine.ConnectionManagementMode connectionManagementMode2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        KadaiEngine.ConnectionManagementMode connectionManagementMode3 = connectionManagementMode2 = (connectionManagementMode = this.mode);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)connectionManagementMode2);
        return connectionManagementMode;
    }

    @Override
    public void setConnectionManagementMode(KadaiEngine.ConnectionManagementMode mode) {
        KadaiEngine.ConnectionManagementMode connectionManagementMode = mode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)((Object)connectionManagementMode));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.mode == KadaiEngine.ConnectionManagementMode.EXPLICIT && this.connection != null && mode != KadaiEngine.ConnectionManagementMode.EXPLICIT) {
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.connection = null;
        }
        this.mode = mode;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public void closeConnection() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.mode == KadaiEngine.ConnectionManagementMode.EXPLICIT) {
            this.connection = null;
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.mode = KadaiEngine.ConnectionManagementMode.PARTICIPATE;
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    @Override
    public boolean isUserInRole(KadaiRole ... roles) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        JoinPoint joinPoint;
        block4: {
            KadaiRole[] kadaiRoleArray = roles;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)kadaiRoleArray);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (!this.getConfiguration().isSecurityEnabled()) {
                bl2 = bl3 = true;
            } else {
                List accessIds = this.currentUserContext.getAccessIds();
                HashSet rolesMembers = new HashSet();
                KadaiRole[] kadaiRoleArray2 = roles;
                int n = roles.length;
                int n2 = 0;
                while (n2 < n) {
                    KadaiRole role = kadaiRoleArray2[n2];
                    rolesMembers.addAll(this.getConfiguration().getRoleMap().get(role));
                    ++n2;
                }
                for (String accessId : accessIds) {
                    if (!rolesMembers.contains(accessId)) continue;
                    bl2 = bl3 = true;
                    break block4;
                }
                bl2 = bl3 = false;
            }
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    @Override
    public void checkRoleMembership(KadaiRole ... roles) throws NotAuthorizedException {
        KadaiRole[] kadaiRoleArray = roles;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)kadaiRoleArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.isUserInRole(roles)) {
            if (LOGGER.isDebugEnabled()) {
                String rolesAsString = Arrays.toString(roles);
                LOGGER.debug("Throwing NotAuthorizedException because accessIds {} are not member of roles {}", (Object)this.currentUserContext.getAccessIds(), (Object)rolesAsString);
            }
            throw new NotAuthorizedException(this.currentUserContext.getUserid(), roles);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    @Override
    public <T> T runAsAdmin(Supplier<T> supplier) {
        T t;
        Object object;
        Object object2;
        Supplier<T> supplier2 = supplier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, supplier2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.isUserInRole(KadaiRole.ADMIN)) {
            object = object2 = supplier.get();
        } else {
            String adminName = (String)this.getConfiguration().getRoleMap().get(KadaiRole.ADMIN).stream().findFirst().orElseThrow(() -> new SystemException("There is no admin configured"));
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new UserPrincipal(adminName));
            object = object2 = Subject.doAs(subject, supplier::get);
        }
        T t2 = t = object;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, t);
        return object2;
    }

    @Override
    public CurrentUserContext getCurrentUserContext() {
        CurrentUserContext currentUserContext;
        CurrentUserContext currentUserContext2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        CurrentUserContext currentUserContext3 = currentUserContext2 = (currentUserContext = this.currentUserContext);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)currentUserContext2);
        return currentUserContext;
    }

    @Override
    public void clearSqlSessionCache() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.sessionManager.clearCache();
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    protected SqlSessionManager createSqlSessionManager() {
        SqlSessionManager sqlSessionManager;
        SqlSessionManager sqlSessionManager2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Environment environment = new Environment("default", this.transactionFactory, this.kadaiConfiguration.getDataSource());
        Configuration configuration = new Configuration(environment);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection con = this.kadaiConfiguration.getDataSource().getConnection();){
                DB db = DB.getDB((Connection)con);
                configuration.setDatabaseId(db.dbProductId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new SystemException("Method createSqlSessionManager() could not open a connection to the database. No databaseId has been set.", e.getCause());
        }
        configuration.getTypeHandlerRegistry().register((TypeHandler)new MapTypeHandler());
        configuration.getTypeHandlerRegistry().register(Instant.class, (TypeHandler)new InstantTypeHandler());
        configuration.getTypeHandlerRegistry().register(JdbcType.TIMESTAMP, (TypeHandler)new InstantTypeHandler());
        configuration.addMapper(TaskMapper.class);
        configuration.addMapper(MonitorMapper.class);
        configuration.addMapper(WorkbasketMapper.class);
        configuration.addMapper(DistributionTargetMapper.class);
        configuration.addMapper(ClassificationMapper.class);
        configuration.addMapper(WorkbasketAccessMapper.class);
        configuration.addMapper(ObjectReferenceMapper.class);
        configuration.addMapper(WorkbasketQueryMapper.class);
        configuration.addMapper(TaskQueryMapper.class);
        configuration.addMapper(TaskCommentMapper.class);
        configuration.addMapper(TaskCommentQueryMapper.class);
        configuration.addMapper(ClassificationQueryMapper.class);
        configuration.addMapper(AttachmentMapper.class);
        configuration.addMapper(JobMapper.class);
        configuration.addMapper(UserMapper.class);
        configuration.addMapper(ConfigurationMapper.class);
        SqlSessionFactory localSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        SqlSessionManager sqlSessionManager3 = sqlSessionManager2 = (sqlSessionManager = SqlSessionManager.newInstance((SqlSessionFactory)localSessionFactory));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)sqlSessionManager2);
        return sqlSessionManager;
    }

    private void initializeDbSchema(KadaiConfiguration kadaiConfiguration) throws SQLException {
        KadaiConfiguration kadaiConfiguration2 = kadaiConfiguration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)kadaiConfiguration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DbSchemaCreator dbSchemaCreator = new DbSchemaCreator(kadaiConfiguration.getDataSource(), kadaiConfiguration.getSchemaName());
        boolean schemaCreated = dbSchemaCreator.run();
        if (!schemaCreated && !dbSchemaCreator.isValidSchemaVersion("9.0.0")) {
            throw new SystemException("The Database Schema Version doesn't match the expected minimal version 9.0.0");
        }
        ((ConfigurationServiceImpl)this.getConfigurationService()).checkSecureAccess(kadaiConfiguration.isSecurityEnabled());
        ((ConfigurationServiceImpl)this.getConfigurationService()).setupDefaultCustomAttributes();
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void createTransactionFactory(boolean useManagedTransactions) {
        boolean bl = useManagedTransactions;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.transactionFactory = useManagedTransactions ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("KadaiEngineImpl.java", KadaiEngineImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createKadaiEngine", "io.kadai.common.internal.KadaiEngineImpl", "io.kadai.KadaiConfiguration:io.kadai.common.api.KadaiEngine$ConnectionManagementMode:org.apache.ibatis.transaction.TransactionFactory", "kadaiConfiguration:connectionManagementMode:transactionFactory", "java.sql.SQLException", "io.kadai.common.api.KadaiEngine"), 212);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigurationService", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.common.api.ConfigurationService"), 221);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserService", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.user.api.UserService"), 298);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobScheduler", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.common.internal.jobs.JobScheduler"), 302);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfiguration", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.KadaiConfiguration"), 307);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkingTimeCalculator", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.common.api.WorkingTimeCalculator"), 312);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isHistoryEnabled", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "boolean"), 317);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnectionManagementMode", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.common.api.KadaiEngine$ConnectionManagementMode"), 322);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConnectionManagementMode", "io.kadai.common.internal.KadaiEngineImpl", "io.kadai.common.api.KadaiEngine$ConnectionManagementMode", "mode", "", "void"), 327);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeConnection", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "void"), 338);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "isUserInRole", "io.kadai.common.internal.KadaiEngineImpl", "[Lio.kadai.common.api.KadaiRole;", "roles", "", "boolean"), 349);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "checkRoleMembership", "io.kadai.common.internal.KadaiEngineImpl", "[Lio.kadai.common.api.KadaiRole;", "roles", "io.kadai.common.api.exceptions.NotAuthorizedException", "void"), 369);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskService", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.task.api.TaskService"), 227);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runAsAdmin", "io.kadai.common.internal.KadaiEngineImpl", "java.util.function.Supplier", "supplier", "", "java.lang.Object"), 382);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCurrentUserContext", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.common.api.security.CurrentUserContext"), 399);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearSqlSessionCache", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "void"), 404);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createSqlSessionManager", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "org.apache.ibatis.session.SqlSessionManager"), 415);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeDbSchema", "io.kadai.common.internal.KadaiEngineImpl", "io.kadai.KadaiConfiguration", "kadaiConfiguration", "java.sql.SQLException", "void"), 459);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTransactionFactory", "io.kadai.common.internal.KadaiEngineImpl", "boolean", "useManagedTransactions", "", "void"), 479);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMonitorService", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.monitor.api.MonitorService"), 238);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketService", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.workbasket.api.WorkbasketService"), 244);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationService", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.classification.api.ClassificationService"), 254);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnection", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "java.sql.Connection"), 262);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConnection", "io.kadai.common.internal.KadaiEngineImpl", "java.sql.Connection", "connection", "java.sql.SQLException", "void"), 267);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityServiceManager", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.spi.priority.internal.PriorityServiceManager"), 288);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJobService", "io.kadai.common.internal.KadaiEngineImpl", "", "", "", "io.kadai.common.api.JobService"), 293);
    }

    private class InternalKadaiEngineImpl
    implements InternalKadaiEngine {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;

        private InternalKadaiEngineImpl() {
        }

        @Override
        public void openConnection() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.initSqlSession();
            try {
                KadaiEngineImpl.this.sessionManager.getConnection().setSchema(KadaiEngineImpl.this.kadaiConfiguration.getSchemaName());
            }
            catch (SQLException e) {
                throw new SystemException("Method openConnection() could not open a connection to the database. No schema has been created.", e.getCause());
            }
            if (KadaiEngineImpl.this.mode != KadaiEngine.ConnectionManagementMode.EXPLICIT) {
                SESSION_STACK.pushSessionToStack(KadaiEngineImpl.this.sessionManager);
            }
            Object var3_3 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
        }

        @Override
        public void returnConnection() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (KadaiEngineImpl.this.mode != KadaiEngine.ConnectionManagementMode.EXPLICIT) {
                SESSION_STACK.popSessionFromStack();
                if (SESSION_STACK.getSessionStack().isEmpty() && KadaiEngineImpl.this.sessionManager != null && KadaiEngineImpl.this.sessionManager.isManagedSessionStarted()) {
                    if (KadaiEngineImpl.this.mode == KadaiEngine.ConnectionManagementMode.AUTOCOMMIT) {
                        try {
                            KadaiEngineImpl.this.sessionManager.commit();
                        }
                        catch (Exception e) {
                            throw new AutocommitFailedException(e.getCause());
                        }
                    }
                    KadaiEngineImpl.this.sessionManager.close();
                }
            }
            Object var3_3 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
        }

        @Override
        public <T> T executeInDatabaseConnection(Supplier<T> supplier) {
            T t;
            T t2;
            Supplier<T> supplier2 = supplier;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, supplier2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                this.openConnection();
                T t3 = supplier.get();
                t2 = t3;
            }
            finally {
                this.returnConnection();
            }
            T t4 = t = t2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, t);
            return t2;
        }

        @Override
        public void initSqlSession() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (KadaiEngineImpl.this.mode == KadaiEngine.ConnectionManagementMode.EXPLICIT && KadaiEngineImpl.this.connection == null) {
                throw new ConnectionNotSetException();
            }
            if (KadaiEngineImpl.this.mode != KadaiEngine.ConnectionManagementMode.EXPLICIT && !KadaiEngineImpl.this.sessionManager.isManagedSessionStarted()) {
                KadaiEngineImpl.this.sessionManager.startManagedSession();
            }
            Object var2_2 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
        }

        @Override
        public boolean domainExists(String domain) {
            boolean bl;
            boolean bl2;
            String string = domain;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            boolean bl3 = bl2 = (bl = KadaiEngineImpl.this.getConfiguration().getDomains().contains(domain));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
            return bl;
        }

        @Override
        public SqlSession getSqlSession() {
            SqlSessionManager sqlSessionManager;
            SqlSessionManager sqlSessionManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            SqlSessionManager sqlSessionManager3 = sqlSessionManager2 = (sqlSessionManager = KadaiEngineImpl.this.sessionManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)sqlSessionManager2);
            return sqlSessionManager;
        }

        @Override
        public KadaiEngine getEngine() {
            KadaiEngineImpl kadaiEngineImpl;
            KadaiEngineImpl kadaiEngineImpl2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            KadaiEngineImpl kadaiEngineImpl3 = kadaiEngineImpl2 = (kadaiEngineImpl = KadaiEngineImpl.this);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)kadaiEngineImpl2);
            return kadaiEngineImpl;
        }

        @Override
        public HistoryEventManager getHistoryEventManager() {
            HistoryEventManager historyEventManager;
            HistoryEventManager historyEventManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            HistoryEventManager historyEventManager3 = historyEventManager2 = (historyEventManager = KadaiEngineImpl.this.historyEventManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)historyEventManager2);
            return historyEventManager;
        }

        @Override
        public TaskRoutingManager getTaskRoutingManager() {
            TaskRoutingManager taskRoutingManager;
            TaskRoutingManager taskRoutingManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskRoutingManager taskRoutingManager3 = taskRoutingManager2 = (taskRoutingManager = KadaiEngineImpl.this.taskRoutingManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskRoutingManager2);
            return taskRoutingManager;
        }

        @Override
        public CreateTaskPreprocessorManager getCreateTaskPreprocessorManager() {
            CreateTaskPreprocessorManager createTaskPreprocessorManager;
            CreateTaskPreprocessorManager createTaskPreprocessorManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            CreateTaskPreprocessorManager createTaskPreprocessorManager3 = createTaskPreprocessorManager2 = (createTaskPreprocessorManager = KadaiEngineImpl.this.createTaskPreprocessorManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)createTaskPreprocessorManager2);
            return createTaskPreprocessorManager;
        }

        @Override
        public PriorityServiceManager getPriorityServiceManager() {
            PriorityServiceManager priorityServiceManager;
            PriorityServiceManager priorityServiceManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            PriorityServiceManager priorityServiceManager3 = priorityServiceManager2 = (priorityServiceManager = KadaiEngineImpl.this.priorityServiceManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)priorityServiceManager2);
            return priorityServiceManager;
        }

        @Override
        public ReviewRequiredManager getReviewRequiredManager() {
            ReviewRequiredManager reviewRequiredManager;
            ReviewRequiredManager reviewRequiredManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ReviewRequiredManager reviewRequiredManager3 = reviewRequiredManager2 = (reviewRequiredManager = KadaiEngineImpl.this.reviewRequiredManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reviewRequiredManager2);
            return reviewRequiredManager;
        }

        @Override
        public BeforeRequestReviewManager getBeforeRequestReviewManager() {
            BeforeRequestReviewManager beforeRequestReviewManager;
            BeforeRequestReviewManager beforeRequestReviewManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            BeforeRequestReviewManager beforeRequestReviewManager3 = beforeRequestReviewManager2 = (beforeRequestReviewManager = KadaiEngineImpl.this.beforeRequestReviewManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)beforeRequestReviewManager2);
            return beforeRequestReviewManager;
        }

        @Override
        public AfterRequestReviewManager getAfterRequestReviewManager() {
            AfterRequestReviewManager afterRequestReviewManager;
            AfterRequestReviewManager afterRequestReviewManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            AfterRequestReviewManager afterRequestReviewManager3 = afterRequestReviewManager2 = (afterRequestReviewManager = KadaiEngineImpl.this.afterRequestReviewManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)afterRequestReviewManager2);
            return afterRequestReviewManager;
        }

        @Override
        public BeforeRequestChangesManager getBeforeRequestChangesManager() {
            BeforeRequestChangesManager beforeRequestChangesManager;
            BeforeRequestChangesManager beforeRequestChangesManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            BeforeRequestChangesManager beforeRequestChangesManager3 = beforeRequestChangesManager2 = (beforeRequestChangesManager = KadaiEngineImpl.this.beforeRequestChangesManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)beforeRequestChangesManager2);
            return beforeRequestChangesManager;
        }

        @Override
        public AfterRequestChangesManager getAfterRequestChangesManager() {
            AfterRequestChangesManager afterRequestChangesManager;
            AfterRequestChangesManager afterRequestChangesManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            AfterRequestChangesManager afterRequestChangesManager3 = afterRequestChangesManager2 = (afterRequestChangesManager = KadaiEngineImpl.this.afterRequestChangesManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)afterRequestChangesManager2);
            return afterRequestChangesManager;
        }

        @Override
        public TaskEndstatePreprocessorManager getTaskEndstatePreprocessorManager() {
            TaskEndstatePreprocessorManager taskEndstatePreprocessorManager;
            TaskEndstatePreprocessorManager taskEndstatePreprocessorManager2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskEndstatePreprocessorManager taskEndstatePreprocessorManager3 = taskEndstatePreprocessorManager2 = (taskEndstatePreprocessorManager = KadaiEngineImpl.this.taskEndstatePreprocessorManager);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskEndstatePreprocessorManager2);
            return taskEndstatePreprocessorManager;
        }

        static {
            InternalKadaiEngineImpl.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("KadaiEngineImpl.java", InternalKadaiEngineImpl.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openConnection", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "void"), 533);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "returnConnection", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "void"), 549);
            ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityServiceManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.priority.internal.PriorityServiceManager"), 618);
            ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReviewRequiredManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.task.internal.ReviewRequiredManager"), 623);
            ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBeforeRequestReviewManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.task.internal.BeforeRequestReviewManager"), 628);
            ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAfterRequestReviewManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.task.internal.AfterRequestReviewManager"), 633);
            ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBeforeRequestChangesManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.task.internal.BeforeRequestChangesManager"), 638);
            ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAfterRequestChangesManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.task.internal.AfterRequestChangesManager"), 643);
            ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskEndstatePreprocessorManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.task.internal.TaskEndstatePreprocessorManager"), 648);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeInDatabaseConnection", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "java.util.function.Supplier", "supplier", "", "java.lang.Object"), 568);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initSqlSession", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "void"), 579);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "domainExists", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "java.lang.String", "domain", "", "boolean"), 588);
            ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSqlSession", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "org.apache.ibatis.session.SqlSession"), 593);
            ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEngine", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.common.api.KadaiEngine"), 598);
            ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHistoryEventManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.history.internal.HistoryEventManager"), 603);
            ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskRoutingManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.routing.internal.TaskRoutingManager"), 608);
            ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreateTaskPreprocessorManager", "io.kadai.common.internal.KadaiEngineImpl$InternalKadaiEngineImpl", "", "", "", "io.kadai.spi.task.internal.CreateTaskPreprocessorManager"), 613);
        }
    }

    private static class SessionStack {
        private final ThreadLocal<Deque<SqlSessionManager>> sessionStack = new ThreadLocal();
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private SessionStack() {
        }

        private Deque<SqlSessionManager> getSessionStack() {
            Deque<SqlSessionManager> deque;
            Deque<SqlSessionManager> deque2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Deque<SqlSessionManager> stack = this.sessionStack.get();
            if (stack == null) {
                stack = new ArrayDeque<SqlSessionManager>();
                this.sessionStack.set(stack);
            }
            Deque<SqlSessionManager> deque3 = deque2 = (deque = stack);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, deque2);
            return deque;
        }

        private void pushSessionToStack(SqlSessionManager session) {
            SqlSessionManager sqlSessionManager = session;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)sqlSessionManager);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.getSessionStack().push(session);
            Object var4_4 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
        }

        private void popSessionFromStack() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Deque<SqlSessionManager> stack = this.getSessionStack();
            if (!stack.isEmpty()) {
                stack.pop();
            }
            Object var3_3 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
        }

        static {
            SessionStack.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("KadaiEngineImpl.java", SessionStack.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSessionStack", "io.kadai.common.internal.KadaiEngineImpl$SessionStack", "", "", "", "java.util.Deque"), 508);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "pushSessionToStack", "io.kadai.common.internal.KadaiEngineImpl$SessionStack", "org.apache.ibatis.session.SqlSessionManager", "session", "", "void"), 517);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "popSessionFromStack", "io.kadai.common.internal.KadaiEngineImpl$SessionStack", "", "", "", "void"), 521);
        }
    }
}

