/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal.jobs;

import io.kadai.KadaiConfiguration;
import io.kadai.common.api.KadaiEngine;
import io.kadai.common.api.ScheduledJob;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.JobServiceImpl;
import io.kadai.common.internal.KadaiEngineImpl;
import io.kadai.common.internal.jobs.KadaiJob;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.transaction.KadaiTransactionProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractKadaiJob
implements KadaiJob {
    protected final KadaiEngineImpl kadaiEngineImpl;
    protected final KadaiTransactionProvider txProvider;
    protected final ScheduledJob scheduledJob;
    private final boolean async;
    protected Instant firstRun;
    protected Duration runEvery;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    protected AbstractKadaiJob(KadaiEngine kadaiEngine, KadaiTransactionProvider txProvider, ScheduledJob job, boolean async) {
        this.kadaiEngineImpl = (KadaiEngineImpl)kadaiEngine;
        this.txProvider = txProvider;
        this.scheduledJob = job;
        this.async = async;
        this.firstRun = this.kadaiEngineImpl.getConfiguration().getJobFirstRun();
        this.runEvery = this.kadaiEngineImpl.getConfiguration().getJobRunEvery();
    }

    public static KadaiJob createFromScheduledJob(KadaiEngine engine, KadaiTransactionProvider txProvider, ScheduledJob job) {
        AbstractKadaiJob abstractKadaiJob;
        AbstractKadaiJob abstractKadaiJob2;
        Class<?> jobClass;
        KadaiEngine kadaiEngine = engine;
        KadaiTransactionProvider kadaiTransactionProvider = txProvider;
        ScheduledJob scheduledJob = job;
        Object[] objectArray = new Object[]{kadaiEngine, kadaiTransactionProvider, scheduledJob};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            jobClass = Thread.currentThread().getContextClassLoader().loadClass(job.getType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SystemException(String.format("Can't load class '%s'", job.getType()));
        }
        AbstractKadaiJob abstractKadaiJob3 = abstractKadaiJob2 = (abstractKadaiJob = AbstractKadaiJob.initKadaiJob(engine, jobClass, txProvider, job));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)abstractKadaiJob2);
        return abstractKadaiJob;
    }

    public static void initializeSchedule(KadaiEngine kadaiEngine, Class<?> jobClass) {
        KadaiEngine kadaiEngine2 = kadaiEngine;
        Class<?> clazz = jobClass;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)kadaiEngine2, clazz);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        AbstractKadaiJob job = AbstractKadaiJob.initKadaiJob(kadaiEngine, jobClass, null, null);
        if (!job.async) {
            throw new SystemException(String.format("Job '%s' is not an async job. Please declare it as async", jobClass));
        }
        JobServiceImpl jobService = (JobServiceImpl)kadaiEngine.getJobService();
        jobService.deleteJobs(job.getType());
        job.scheduleNextJob();
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    public static Duration getLockExpirationPeriod(KadaiConfiguration kadaiConfiguration) {
        Duration duration;
        Duration duration2;
        KadaiConfiguration kadaiConfiguration2 = kadaiConfiguration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)kadaiConfiguration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = kadaiConfiguration.getJobLockExpirationPeriod());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    private static AbstractKadaiJob initKadaiJob(KadaiEngine kadaiEngine, Class<?> jobClass, KadaiTransactionProvider txProvider, ScheduledJob scheduledJob) {
        AbstractKadaiJob abstractKadaiJob;
        AbstractKadaiJob abstractKadaiJob2;
        AbstractKadaiJob job;
        Constructor<?> constructor;
        KadaiEngine kadaiEngine2 = kadaiEngine;
        Class<?> clazz = jobClass;
        KadaiTransactionProvider kadaiTransactionProvider = txProvider;
        ScheduledJob scheduledJob2 = scheduledJob;
        Object[] objectArray = new Object[]{kadaiEngine2, clazz, kadaiTransactionProvider, scheduledJob2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!AbstractKadaiJob.class.isAssignableFrom(jobClass)) {
            throw new SystemException(String.format("Job '%s' is not a subclass of '%s'", jobClass, AbstractKadaiJob.class));
        }
        try {
            constructor = jobClass.getConstructor(KadaiEngine.class, KadaiTransactionProvider.class, ScheduledJob.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SystemException(String.format("Job '%s' does not have a constructor matching (%s, %s, %s)", jobClass, KadaiEngine.class, KadaiTransactionProvider.class, ScheduledJob.class));
        }
        try {
            job = (AbstractKadaiJob)constructor.newInstance(kadaiEngine, txProvider, scheduledJob);
        }
        catch (InvocationTargetException e) {
            throw new SystemException(String.format("Required Constructor(%s, %s, %s) of job '%s' could not be invoked", KadaiEngine.class, KadaiTransactionProvider.class, ScheduledJob.class, jobClass), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SystemException(String.format("Required Constructor(%s, %s, %s) of job '%s' could not be initialized", KadaiEngine.class, KadaiTransactionProvider.class, ScheduledJob.class, jobClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SystemException(String.format("Required Constructor(%s, %s, %s) of job '%s' is not public", KadaiEngine.class, KadaiTransactionProvider.class, ScheduledJob.class, jobClass), (Throwable)e);
        }
        AbstractKadaiJob abstractKadaiJob3 = abstractKadaiJob2 = (abstractKadaiJob = job);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)abstractKadaiJob2);
        return abstractKadaiJob;
    }

    @Override
    public final void run() throws KadaiException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.execute();
        if (this.async) {
            this.scheduleNextJob();
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    public boolean isAsync() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.async);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public Instant getFirstRun() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.firstRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Duration getRunEvery() {
        Duration duration;
        Duration duration2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = this.runEvery);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    protected abstract String getType();

    protected abstract void execute() throws KadaiException;

    protected Instant getNextDueForJob() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant nextRun = this.firstRun;
        if (this.scheduledJob != null && this.scheduledJob.getDue() != null) {
            nextRun = this.scheduledJob.getDue();
        }
        while (nextRun.isBefore(Instant.now())) {
            nextRun = nextRun.plus(this.runEvery);
        }
        Instant instant3 = instant2 = (instant = nextRun);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    protected void scheduleNextJob() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ScheduledJob job = new ScheduledJob();
        job.setType(this.getType());
        job.setDue(this.getNextDueForJob());
        this.kadaiEngineImpl.getJobService().createJob(job);
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    static {
        AbstractKadaiJob.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractKadaiJob.java", AbstractKadaiJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createFromScheduledJob", "io.kadai.common.internal.jobs.AbstractKadaiJob", "io.kadai.common.api.KadaiEngine:io.kadai.common.internal.transaction.KadaiTransactionProvider:io.kadai.common.api.ScheduledJob", "engine:txProvider:job", "", "io.kadai.common.internal.jobs.KadaiJob"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initializeSchedule", "io.kadai.common.internal.jobs.AbstractKadaiJob", "io.kadai.common.api.KadaiEngine:java.lang.Class", "kadaiEngine:jobClass", "", "void"), 78);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getLockExpirationPeriod", "io.kadai.common.internal.jobs.AbstractKadaiJob", "io.kadai.KadaiConfiguration", "kadaiConfiguration", "", "java.time.Duration"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "initKadaiJob", "io.kadai.common.internal.jobs.AbstractKadaiJob", "io.kadai.common.api.KadaiEngine:java.lang.Class:io.kadai.common.internal.transaction.KadaiTransactionProvider:io.kadai.common.api.ScheduledJob", "kadaiEngine:jobClass:txProvider:scheduledJob", "", "io.kadai.common.internal.jobs.AbstractKadaiJob"), 93);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "run", "io.kadai.common.internal.jobs.AbstractKadaiJob", "", "", "io.kadai.common.api.exceptions.KadaiException", "void"), 139);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAsync", "io.kadai.common.internal.jobs.AbstractKadaiJob", "", "", "", "boolean"), 146);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirstRun", "io.kadai.common.internal.jobs.AbstractKadaiJob", "", "", "", "java.time.Instant"), 150);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRunEvery", "io.kadai.common.internal.jobs.AbstractKadaiJob", "", "", "", "java.time.Duration"), 154);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getNextDueForJob", "io.kadai.common.internal.jobs.AbstractKadaiJob", "", "", "", "java.time.Instant"), 162);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "scheduleNextJob", "io.kadai.common.internal.jobs.AbstractKadaiJob", "", "", "", "void"), 175);
    }
}

