/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal.jobs;

import io.kadai.common.api.KadaiEngine;
import io.kadai.common.api.ScheduledJob;
import io.kadai.common.internal.JobServiceImpl;
import io.kadai.common.internal.jobs.AbstractKadaiJob;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.transaction.KadaiTransactionProvider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunner {
    private static final Logger LOGGER;
    private final KadaiEngine kadaiEngine;
    private final JobServiceImpl jobService;
    private KadaiTransactionProvider txProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        JobRunner.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JobRunner.class);
    }

    public JobRunner(KadaiEngine kadaiEngine) {
        this.kadaiEngine = kadaiEngine;
        this.jobService = (JobServiceImpl)kadaiEngine.getJobService();
    }

    public void registerTransactionProvider(KadaiTransactionProvider txProvider) {
        KadaiTransactionProvider kadaiTransactionProvider = txProvider;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)kadaiTransactionProvider);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.txProvider = txProvider;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public void runJobs() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.findAndLockJobsToRun().forEach(this::runJobTransactionally);
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private List<ScheduledJob> findAndLockJobsToRun() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list3 = list2 = (list = (List)KadaiTransactionProvider.executeInTransactionIfPossible((KadaiTransactionProvider)this.txProvider, () -> this.jobService.findJobsToRun().stream().map(this::lockJob).toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private void runJobTransactionally(ScheduledJob scheduledJob) {
        ScheduledJob scheduledJob2 = scheduledJob;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)scheduledJob2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        KadaiTransactionProvider.executeInTransactionIfPossible((KadaiTransactionProvider)this.txProvider, () -> {
            boolean successful = this.kadaiEngine.runAsAdmin(() -> this.runScheduledJob(scheduledJob));
            if (successful) {
                this.jobService.deleteJob(scheduledJob);
            }
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private boolean runScheduledJob(ScheduledJob scheduledJob) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        ScheduledJob scheduledJob2 = scheduledJob;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)scheduledJob2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            AbstractKadaiJob.createFromScheduledJob(this.kadaiEngine, this.txProvider, scheduledJob).run();
            bl2 = bl3 = true;
        }
        catch (Exception e) {
            LOGGER.error("Error running job: {} ", (Object)scheduledJob.getType(), (Object)e);
            bl2 = bl3 = false;
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    private ScheduledJob lockJob(ScheduledJob job) {
        ScheduledJob scheduledJob;
        ScheduledJob scheduledJob2;
        ScheduledJob scheduledJob3 = job;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)scheduledJob3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String hostAddress = this.getHostAddress();
        String owner = String.valueOf(hostAddress) + " - " + Thread.currentThread().getName();
        job.setLockedBy(owner);
        ScheduledJob lockedJob = this.jobService.lockJob(job, owner);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Locked job: {}", (Object)lockedJob);
        }
        ScheduledJob scheduledJob4 = scheduledJob2 = (scheduledJob = lockedJob);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scheduledJob2);
        return scheduledJob;
    }

    private String getHostAddress() {
        String string;
        String string2;
        String hostAddress;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            hostAddress = "UNKNOWN_ADDRESS";
        }
        String string3 = string2 = (string = hostAddress);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobRunner.java", JobRunner.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerTransactionProvider", "io.kadai.common.internal.jobs.JobRunner", "io.kadai.common.internal.transaction.KadaiTransactionProvider", "txProvider", "", "void"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "runJobs", "io.kadai.common.internal.jobs.JobRunner", "", "", "", "void"), 48);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findAndLockJobsToRun", "io.kadai.common.internal.jobs.JobRunner", "", "", "", "java.util.List"), 52);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runJobTransactionally", "io.kadai.common.internal.jobs.JobRunner", "io.kadai.common.api.ScheduledJob", "scheduledJob", "", "void"), 57);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runScheduledJob", "io.kadai.common.internal.jobs.JobRunner", "io.kadai.common.api.ScheduledJob", "scheduledJob", "", "boolean"), 68);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "lockJob", "io.kadai.common.internal.jobs.JobRunner", "io.kadai.common.api.ScheduledJob", "job", "", "io.kadai.common.api.ScheduledJob"), 78);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getHostAddress", "io.kadai.common.internal.jobs.JobRunner", "", "", "", "java.lang.String"), 89);
    }
}

