/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.common.internal.jobs;

import io.kadai.common.api.KadaiEngine;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.jobs.AbstractKadaiJob;
import io.kadai.common.internal.jobs.Clock;
import io.kadai.common.internal.jobs.JobRunner;
import io.kadai.common.internal.jobs.PlainJavaTransactionProvider;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.task.internal.jobs.TaskCleanupJob;
import io.kadai.task.internal.jobs.TaskUpdatePriorityJob;
import io.kadai.workbasket.internal.jobs.WorkbasketCleanupJob;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobScheduler {
    private static final Logger LOGGER;
    private final KadaiEngine kadaiEngine;
    private final Clock clock;
    private final PlainJavaTransactionProvider plainJavaTransactionProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        JobScheduler.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JobScheduler.class);
    }

    public JobScheduler(KadaiEngine kadaiEngine, Clock clock) {
        this.kadaiEngine = kadaiEngine;
        this.clock = clock;
        this.plainJavaTransactionProvider = new PlainJavaTransactionProvider(kadaiEngine, kadaiEngine.getConfiguration().getDataSource());
        this.plainJavaTransactionProvider.executeInTransaction(() -> {
            if (kadaiEngine.getConfiguration().isTaskCleanupJobEnabled()) {
                AbstractKadaiJob.initializeSchedule(kadaiEngine, TaskCleanupJob.class);
                LOGGER.info("Job '{}' enabled", (Object)TaskCleanupJob.class.getName());
            }
            if (kadaiEngine.getConfiguration().isTaskUpdatePriorityJobEnabled()) {
                AbstractKadaiJob.initializeSchedule(kadaiEngine, TaskUpdatePriorityJob.class);
                LOGGER.info("Job '{}' enabled", (Object)TaskUpdatePriorityJob.class.getName());
            }
            if (kadaiEngine.getConfiguration().isWorkbasketCleanupJobEnabled()) {
                AbstractKadaiJob.initializeSchedule(kadaiEngine, WorkbasketCleanupJob.class);
                LOGGER.info("Job '{}' enabled", (Object)WorkbasketCleanupJob.class.getName());
            }
            if (kadaiEngine.getConfiguration().isUserInfoRefreshJobEnabled()) {
                this.initJobByClassName("io.kadai.user.jobs.UserInfoRefreshJob");
            }
            if (kadaiEngine.getConfiguration().isSimpleHistoryCleanupJobEnabled()) {
                this.initJobByClassName("io.kadai.simplehistory.impl.jobs.HistoryCleanupJob");
            }
            kadaiEngine.getConfiguration().getCustomJobs().forEach(this::initJobByClassName);
            return "Initialized Jobs successfully";
        });
        this.clock.register(this::runAsyncJobsAsAdmin);
    }

    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.clock.start();
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    public void stop() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.clock.stop();
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private void initJobByClassName(String className) throws SystemException {
        String string = className;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Class<?> jobClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            AbstractKadaiJob.initializeSchedule(this.kadaiEngine, jobClass);
            LOGGER.info("Job '{}' enabled", (Object)className);
        }
        catch (ClassNotFoundException e) {
            throw new SystemException(String.format("Could not find class '%s'", className), (Throwable)e);
        }
        Object var5_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_6);
    }

    private void runAsyncJobsAsAdmin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.runAsAdmin(() -> {
            JobRunner runner = new JobRunner(this.kadaiEngine);
            runner.registerTransactionProvider(this.plainJavaTransactionProvider);
            LOGGER.info("Running Jobs");
            runner.runJobs();
            return "Successful";
        });
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JobScheduler.java", JobScheduler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "io.kadai.common.internal.jobs.JobScheduler", "", "", "", "void"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "io.kadai.common.internal.jobs.JobScheduler", "", "", "", "void"), 81);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initJobByClassName", "io.kadai.common.internal.jobs.JobScheduler", "java.lang.String", "className", "io.kadai.common.api.exceptions.SystemException", "void"), 85);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "runAsyncJobsAsAdmin", "io.kadai.common.internal.jobs.JobScheduler", "", "", "", "void"), 95);
    }
}

