/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.monitor.api.reports;

import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.monitor.api.reports.header.ColumnHeader;
import io.kadai.monitor.api.reports.item.QueryItem;
import io.kadai.monitor.api.reports.item.QueryItemPreprocessor;
import io.kadai.monitor.api.reports.row.Row;
import io.kadai.monitor.api.reports.row.SingleRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class Report<I extends QueryItem, H extends ColumnHeader<? super I>> {
    private final Map<String, Row<I>> reportRows = new LinkedHashMap<String, Row<I>>();
    private final Row<I> sumRow;
    private final String[] rowDesc;
    protected List<H> columnHeaders;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    protected Report(List<H> columnHeaders, String[] rowDesc) {
        this.rowDesc = rowDesc;
        this.columnHeaders = new ArrayList<H>(columnHeaders);
        this.sumRow = this.createRow("Total");
    }

    public final Map<String, Row<I>> getRows() {
        Map<String, Row<I>> map;
        Map<String, Row<I>> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, Row<I>> map3 = map2 = (map = this.reportRows);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public final Row<I> getSumRow() {
        Row<I> row;
        Row<I> row2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Row<I> row3 = row2 = (row = this.sumRow);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, row2);
        return row;
    }

    public final List<H> getColumnHeaders() {
        List<H> list;
        List<H> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<H> list3 = list2 = (list = this.columnHeaders);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public final String[] getRowDesc() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.rowDesc);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public Row<I> getRow(String key) {
        Row<I> row;
        Row<I> row2;
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Row<I> row3 = row2 = (row = this.reportRows.get(key));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, row2);
        return row;
    }

    public final Set<String> rowTitles() {
        Set<String> set;
        Set<String> set2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<String> set3 = set2 = (set = this.reportRows.keySet());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    public final int rowSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.reportRows.size());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public final void addItem(I item) {
        I i = item;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, i);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Row row = null;
        if (this.columnHeaders.isEmpty()) {
            row = this.reportRows.computeIfAbsent(item.getKey(), this::createRow);
            row.updateTotalValue(item);
            this.sumRow.updateTotalValue(item);
        } else {
            int i2 = 0;
            while (i2 < this.columnHeaders.size()) {
                if (((ColumnHeader)this.columnHeaders.get(i2)).fits(item)) {
                    if (row == null) {
                        row = this.reportRows.computeIfAbsent(item.getKey(), this::createRow);
                    }
                    row.addItem(item, i2);
                    this.sumRow.addItem(item, i2);
                }
                ++i2;
            }
        }
        Object var7_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_6);
    }

    public final void addItem(I item, QueryItemPreprocessor<I> preprocessor) {
        I i = item;
        QueryItemPreprocessor<I> queryItemPreprocessor = preprocessor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, i, queryItemPreprocessor);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.addItem(preprocessor.apply(item));
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    public final void addItems(List<? extends I> items, QueryItemPreprocessor<I> preprocessor) {
        List<I> list = items;
        QueryItemPreprocessor<I> queryItemPreprocessor = preprocessor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, list, queryItemPreprocessor);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        items.stream().map(preprocessor::apply).forEach(this::addItem);
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    public final void addItems(List<I> items) {
        List<I> list = items;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        items.forEach(this::addItem);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public final void augmentDisplayNames(Map<String, String> displayMap) {
        Map<String, String> map = displayMap;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.reportRows.values().forEach(row -> row.setDisplayName(displayMap));
        this.sumRow.setDisplayName(displayMap);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public final Row<I> createRow(String key) {
        Row<I> row;
        Row<I> row2;
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Row<I> row3 = row2 = (row = this.createRow(key, this.columnHeaders.size()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, row2);
        return row;
    }

    protected Row<I> createRow(String key, int columnSize) {
        SingleRow singleRow;
        SingleRow singleRow2;
        String string = key;
        int n = columnSize;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        SingleRow singleRow3 = singleRow2 = (singleRow = new SingleRow(key, columnSize));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, singleRow2);
        return singleRow;
    }

    public String toString() {
        return "Report [reportRows=" + this.reportRows + ", sumRow=" + this.sumRow + ", rowDesc=" + Arrays.toString(this.rowDesc) + ", columnHeaders=" + this.columnHeaders + "]";
    }

    static {
        Report.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Report.java", Report.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getRows", "io.kadai.monitor.api.reports.Report", "", "", "", "java.util.Map"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getSumRow", "io.kadai.monitor.api.reports.Report", "", "", "", "io.kadai.monitor.api.reports.row.Row"), 63);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addItems", "io.kadai.monitor.api.reports.Report", "java.util.List", "items", "", "void"), 114);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "augmentDisplayNames", "io.kadai.monitor.api.reports.Report", "java.util.Map", "displayMap", "", "void"), 118);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "createRow", "io.kadai.monitor.api.reports.Report", "java.lang.String", "key", "", "io.kadai.monitor.api.reports.row.Row"), 123);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createRow", "io.kadai.monitor.api.reports.Report", "java.lang.String:int", "key:columnSize", "", "io.kadai.monitor.api.reports.row.Row"), 127);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getColumnHeaders", "io.kadai.monitor.api.reports.Report", "", "", "", "java.util.List"), 67);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getRowDesc", "io.kadai.monitor.api.reports.Report", "", "", "", "[Ljava.lang.String;"), 71);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRow", "io.kadai.monitor.api.reports.Report", "java.lang.String", "key", "", "io.kadai.monitor.api.reports.row.Row"), 75);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "rowTitles", "io.kadai.monitor.api.reports.Report", "", "", "", "java.util.Set"), 79);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "rowSize", "io.kadai.monitor.api.reports.Report", "", "", "", "int"), 83);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addItem", "io.kadai.monitor.api.reports.Report", "io.kadai.monitor.api.reports.item.QueryItem", "item", "", "void"), 87);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addItem", "io.kadai.monitor.api.reports.Report", "io.kadai.monitor.api.reports.item.QueryItem:io.kadai.monitor.api.reports.item.QueryItemPreprocessor", "item:preprocessor", "", "void"), 106);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "addItems", "io.kadai.monitor.api.reports.Report", "java.util.List:io.kadai.monitor.api.reports.item.QueryItemPreprocessor", "items:preprocessor", "", "void"), 110);
    }

    public static interface Builder<I extends QueryItem, H extends ColumnHeader<? super I>> {
        public Report<I, H> buildReport() throws InvalidArgumentException, NotAuthorizedException;
    }
}

