/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.monitor.internal.reports;

import io.kadai.classification.api.ClassificationService;
import io.kadai.classification.api.models.ClassificationSummary;
import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.monitor.api.TaskTimestamp;
import io.kadai.monitor.api.reports.ClassificationReport;
import io.kadai.monitor.api.reports.header.TimeIntervalColumnHeader;
import io.kadai.monitor.api.reports.item.DetailedMonitorQueryItem;
import io.kadai.monitor.api.reports.item.MonitorQueryItem;
import io.kadai.monitor.api.reports.row.Row;
import io.kadai.monitor.internal.MonitorMapper;
import io.kadai.monitor.internal.preprocessor.DaysToWorkingDaysReportPreProcessor;
import io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ClassificationReportBuilderImpl
extends TimeIntervalReportBuilderImpl<ClassificationReport.Builder, MonitorQueryItem, TimeIntervalColumnHeader>
implements ClassificationReport.Builder {
    private final ClassificationService classificationService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public ClassificationReportBuilderImpl(InternalKadaiEngine kadaiEngine, MonitorMapper monitorMapper) {
        super(kadaiEngine, monitorMapper);
        this.classificationService = kadaiEngine.getEngine().getClassificationService();
    }

    @Override
    public ClassificationReport buildReport() throws InvalidArgumentException, NotAuthorizedException {
        ClassificationReport classificationReport;
        ClassificationReport classificationReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationReport classificationReport3 = classificationReport2 = (classificationReport = this.buildReport(TaskTimestamp.DUE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationReport2);
        return classificationReport;
    }

    @Override
    public ClassificationReport buildReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        ClassificationReport classificationReport;
        ClassificationReport classificationReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.MONITOR, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            ClassificationReport report = new ClassificationReport(this.columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.monitorMapper.getTaskCountOfClassifications(Instant.now(), timestamp, this);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.workingTimeCalculator, this.inWorkingDays));
            Map<String, String> displayMap = this.classificationService.createClassificationQuery().keyIn(report.getRows().isEmpty() ? null : report.getRows().keySet().toArray(new String[0])).domainIn(this.domains).list().stream().collect(Collectors.toMap(ClassificationSummary::getKey, ClassificationSummary::getName, (a, b) -> a));
            report.augmentDisplayNames(displayMap);
            ClassificationReport classificationReport3 = report;
            classificationReport2 = classificationReport3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        ClassificationReport classificationReport4 = classificationReport = classificationReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationReport);
        return classificationReport2;
    }

    @Override
    public ClassificationReport.DetailedClassificationReport buildDetailedReport() throws InvalidArgumentException, NotAuthorizedException {
        ClassificationReport.DetailedClassificationReport detailedClassificationReport;
        ClassificationReport.DetailedClassificationReport detailedClassificationReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationReport.DetailedClassificationReport detailedClassificationReport3 = detailedClassificationReport2 = (detailedClassificationReport = this.buildDetailedReport(TaskTimestamp.DUE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)detailedClassificationReport2);
        return detailedClassificationReport;
    }

    @Override
    public ClassificationReport.DetailedClassificationReport buildDetailedReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        ClassificationReport.DetailedClassificationReport detailedClassificationReport;
        ClassificationReport.DetailedClassificationReport detailedClassificationReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.MONITOR, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            ClassificationReport.DetailedClassificationReport report = new ClassificationReport.DetailedClassificationReport(this.columnHeaders);
            List<DetailedMonitorQueryItem> detailedMonitorQueryItems = this.monitorMapper.getTaskCountOfDetailedClassifications(Instant.now(), timestamp, this);
            report.addItems(detailedMonitorQueryItems, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.workingTimeCalculator, this.inWorkingDays));
            Stream<String> attachmentKeys = report.getRows().keySet().stream().map(report::getRow).flatMap(row -> row.getFoldableRows().values().stream()).map(Row::getKey);
            String[] keys = (String[])Stream.concat(attachmentKeys, report.getRows().keySet().stream()).toArray(String[]::new);
            Map<String, String> displayMap = this.classificationService.createClassificationQuery().keyIn(keys.length == 0 ? null : keys).domainIn(this.domains).list().stream().collect(Collectors.toMap(ClassificationSummary::getKey, ClassificationSummary::getName, (a, b) -> a));
            report.augmentDisplayNames(displayMap);
            ClassificationReport.DetailedClassificationReport detailedClassificationReport3 = report;
            detailedClassificationReport2 = detailedClassificationReport3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        ClassificationReport.DetailedClassificationReport detailedClassificationReport4 = detailedClassificationReport = detailedClassificationReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)detailedClassificationReport);
        return detailedClassificationReport2;
    }

    @Override
    protected ClassificationReport.Builder _this() {
        ClassificationReportBuilderImpl classificationReportBuilderImpl;
        ClassificationReportBuilderImpl classificationReportBuilderImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationReportBuilderImpl classificationReportBuilderImpl3 = classificationReportBuilderImpl2 = (classificationReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationReportBuilderImpl2);
        return classificationReportBuilderImpl;
    }

    @Override
    protected String determineGroupedBy() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "CLASSIFICATION_KEY";
        String string3 = string = "CLASSIFICATION_KEY";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    static {
        ClassificationReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationReportBuilderImpl.java", ClassificationReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "io.kadai.monitor.internal.reports.ClassificationReportBuilderImpl", "", "", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.monitor.api.reports.ClassificationReport"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "io.kadai.monitor.internal.reports.ClassificationReportBuilderImpl", "io.kadai.monitor.api.TaskTimestamp", "timestamp", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.monitor.api.reports.ClassificationReport"), 63);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildDetailedReport", "io.kadai.monitor.internal.reports.ClassificationReportBuilderImpl", "", "", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.monitor.api.reports.ClassificationReport$DetailedClassificationReport"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildDetailedReport", "io.kadai.monitor.internal.reports.ClassificationReportBuilderImpl", "io.kadai.monitor.api.TaskTimestamp", "timestamp", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.monitor.api.reports.ClassificationReport$DetailedClassificationReport"), 102);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "_this", "io.kadai.monitor.internal.reports.ClassificationReportBuilderImpl", "", "", "", "io.kadai.monitor.api.reports.ClassificationReport$Builder"), 140);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "determineGroupedBy", "io.kadai.monitor.internal.reports.ClassificationReportBuilderImpl", "", "", "", "java.lang.String"), 145);
    }
}

