/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.monitor.internal.reports;

import io.kadai.common.api.BaseQuery;
import io.kadai.common.api.IntInterval;
import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.WorkingTimeCalculator;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.monitor.api.CombinedClassificationFilter;
import io.kadai.monitor.api.SelectedItem;
import io.kadai.monitor.api.TaskTimestamp;
import io.kadai.monitor.api.reports.ClassificationReport;
import io.kadai.monitor.api.reports.TimeIntervalReportBuilder;
import io.kadai.monitor.api.reports.header.TimeIntervalColumnHeader;
import io.kadai.monitor.api.reports.item.AgeQueryItem;
import io.kadai.monitor.internal.MonitorMapper;
import io.kadai.monitor.internal.preprocessor.WorkingDaysToDaysReportConverter;
import io.kadai.task.api.TaskCustomField;
import io.kadai.task.api.TaskCustomIntField;
import io.kadai.task.api.TaskState;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

abstract class TimeIntervalReportBuilderImpl<B extends TimeIntervalReportBuilder<B, I, H>, I extends AgeQueryItem, H extends TimeIntervalColumnHeader>
implements TimeIntervalReportBuilder<B, I, H> {
    protected InternalKadaiEngine kadaiEngine;
    protected MonitorMapper monitorMapper;
    protected List<H> columnHeaders;
    protected boolean inWorkingDays;
    protected String[] workbasketIds;
    protected TaskState[] states;
    protected String[] classificationCategories;
    protected String[] domains;
    protected String[] classificationIds;
    protected String[] excludedClassificationIds;
    protected WorkingTimeCalculator workingTimeCalculator;
    private String[] custom1In;
    private String[] custom1NotIn;
    private String[] custom1Like;
    private String[] custom2In;
    private String[] custom2NotIn;
    private String[] custom2Like;
    private String[] custom3In;
    private String[] custom3NotIn;
    private String[] custom3Like;
    private String[] custom4In;
    private String[] custom4NotIn;
    private String[] custom4Like;
    private String[] custom5In;
    private String[] custom5NotIn;
    private String[] custom5Like;
    private String[] custom6In;
    private String[] custom6NotIn;
    private String[] custom6Like;
    private String[] custom7In;
    private String[] custom7NotIn;
    private String[] custom7Like;
    private String[] custom8In;
    private String[] custom8NotIn;
    private String[] custom8Like;
    private String[] custom9In;
    private String[] custom9NotIn;
    private String[] custom9Like;
    private String[] custom10In;
    private String[] custom10NotIn;
    private String[] custom10Like;
    private String[] custom11In;
    private String[] custom11NotIn;
    private String[] custom11Like;
    private String[] custom12In;
    private String[] custom12NotIn;
    private String[] custom12Like;
    private String[] custom13In;
    private String[] custom13NotIn;
    private String[] custom13Like;
    private String[] custom14In;
    private String[] custom14NotIn;
    private String[] custom14Like;
    private String[] custom15In;
    private String[] custom15NotIn;
    private String[] custom15Like;
    private String[] custom16In;
    private String[] custom16NotIn;
    private String[] custom16Like;
    private Integer[] customInt1In;
    private Integer[] customInt1NotIn;
    private Integer[] customInt2In;
    private Integer[] customInt2NotIn;
    private Integer[] customInt3In;
    private Integer[] customInt3NotIn;
    private Integer[] customInt4In;
    private Integer[] customInt4NotIn;
    private Integer[] customInt5In;
    private Integer[] customInt5NotIn;
    private Integer[] customInt6In;
    private Integer[] customInt6NotIn;
    private Integer[] customInt7In;
    private Integer[] customInt7NotIn;
    private Integer[] customInt8In;
    private Integer[] customInt8NotIn;
    private IntInterval[] customInt1Within;
    private IntInterval[] customInt1NotWithin;
    private IntInterval[] customInt2Within;
    private IntInterval[] customInt2NotWithin;
    private IntInterval[] customInt3Within;
    private IntInterval[] customInt3NotWithin;
    private IntInterval[] customInt4Within;
    private IntInterval[] customInt4NotWithin;
    private IntInterval[] customInt5Within;
    private IntInterval[] customInt5NotWithin;
    private IntInterval[] customInt6Within;
    private IntInterval[] customInt6NotWithin;
    private IntInterval[] customInt7Within;
    private IntInterval[] customInt7NotWithin;
    private IntInterval[] customInt8Within;
    private IntInterval[] customInt8NotWithin;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;

    TimeIntervalReportBuilderImpl(InternalKadaiEngine kadaiEngine, MonitorMapper monitorMapper) {
        this.kadaiEngine = kadaiEngine;
        this.monitorMapper = monitorMapper;
        this.columnHeaders = Collections.emptyList();
        this.workingTimeCalculator = kadaiEngine.getEngine().getWorkingTimeCalculator();
    }

    @Override
    public B withColumnHeaders(List<H> columnHeaders) {
        B b;
        B b2;
        List<H> list = columnHeaders;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.columnHeaders = columnHeaders;
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B inWorkingDays() {
        B b;
        B b2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.inWorkingDays = true;
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B workbasketIdIn(List<String> workbasketIds) {
        B b;
        B b2;
        List<String> list = workbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (workbasketIds != null) {
            this.workbasketIds = workbasketIds.toArray(new String[0]);
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B stateIn(List<TaskState> states) {
        B b;
        B b2;
        List<TaskState> list = states;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (states != null) {
            this.states = states.toArray(new TaskState[0]);
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B classificationCategoryIn(List<String> classificationCategories) {
        B b;
        B b2;
        List<String> list = classificationCategories;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (classificationCategories != null) {
            this.classificationCategories = classificationCategories.toArray(new String[0]);
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B classificationIdIn(List<String> classificationIds) {
        B b;
        B b2;
        List<String> list = classificationIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (classificationIds != null) {
            this.classificationIds = classificationIds.toArray(new String[0]);
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B excludedClassificationIdIn(List<String> excludedClassificationIds) {
        B b;
        B b2;
        List<String> list = excludedClassificationIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (excludedClassificationIds != null) {
            this.excludedClassificationIds = excludedClassificationIds.toArray(new String[0]);
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B domainIn(List<String> domains) {
        B b;
        B b2;
        List<String> list = domains;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (domains != null) {
            this.domains = domains.toArray(new String[0]);
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customAttributeIn(TaskCustomField customField, String ... strings) throws InvalidArgumentException {
        B b;
        B b2;
        TaskCustomField taskCustomField = customField;
        String[] stringArray = strings;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)((Object)taskCustomField), (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (customField) {
            case CUSTOM_1: {
                this.custom1In = strings;
                break;
            }
            case CUSTOM_2: {
                this.custom2In = strings;
                break;
            }
            case CUSTOM_3: {
                this.custom3In = strings;
                break;
            }
            case CUSTOM_4: {
                this.custom4In = strings;
                break;
            }
            case CUSTOM_5: {
                this.custom5In = strings;
                break;
            }
            case CUSTOM_6: {
                this.custom6In = strings;
                break;
            }
            case CUSTOM_7: {
                this.custom7In = strings;
                break;
            }
            case CUSTOM_8: {
                this.custom8In = strings;
                break;
            }
            case CUSTOM_9: {
                this.custom9In = strings;
                break;
            }
            case CUSTOM_10: {
                this.custom10In = strings;
                break;
            }
            case CUSTOM_11: {
                this.custom11In = strings;
                break;
            }
            case CUSTOM_12: {
                this.custom12In = strings;
                break;
            }
            case CUSTOM_13: {
                this.custom13In = strings;
                break;
            }
            case CUSTOM_14: {
                this.custom14In = strings;
                break;
            }
            case CUSTOM_15: {
                this.custom15In = strings;
                break;
            }
            case CUSTOM_16: {
                this.custom16In = strings;
                break;
            }
            default: {
                throw new SystemException("Unknown custom attribute '" + (Object)((Object)customField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customAttributeNotIn(TaskCustomField customField, String ... strings) throws InvalidArgumentException {
        B b;
        B b2;
        TaskCustomField taskCustomField = customField;
        String[] stringArray = strings;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)((Object)taskCustomField), (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (customField) {
            case CUSTOM_1: {
                this.custom1NotIn = strings;
                break;
            }
            case CUSTOM_2: {
                this.custom2NotIn = strings;
                break;
            }
            case CUSTOM_3: {
                this.custom3NotIn = strings;
                break;
            }
            case CUSTOM_4: {
                this.custom4NotIn = strings;
                break;
            }
            case CUSTOM_5: {
                this.custom5NotIn = strings;
                break;
            }
            case CUSTOM_6: {
                this.custom6NotIn = strings;
                break;
            }
            case CUSTOM_7: {
                this.custom7NotIn = strings;
                break;
            }
            case CUSTOM_8: {
                this.custom8NotIn = strings;
                break;
            }
            case CUSTOM_9: {
                this.custom9NotIn = strings;
                break;
            }
            case CUSTOM_10: {
                this.custom10NotIn = strings;
                break;
            }
            case CUSTOM_11: {
                this.custom11NotIn = strings;
                break;
            }
            case CUSTOM_12: {
                this.custom12NotIn = strings;
                break;
            }
            case CUSTOM_13: {
                this.custom13NotIn = strings;
                break;
            }
            case CUSTOM_14: {
                this.custom14NotIn = strings;
                break;
            }
            case CUSTOM_15: {
                this.custom15NotIn = strings;
                break;
            }
            case CUSTOM_16: {
                this.custom16NotIn = strings;
                break;
            }
            default: {
                throw new SystemException("Unknown custom attribute '" + (Object)((Object)customField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customIntAttributeIn(TaskCustomIntField customIntField, Integer ... values) throws InvalidArgumentException {
        B b;
        B b2;
        TaskCustomIntField taskCustomIntField = customIntField;
        Integer[] integerArray = values;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)((Object)taskCustomIntField), (Object)integerArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (values.length == 0) {
            throw new InvalidArgumentException("At least one Integer has to be provided as a search parameter");
        }
        switch (customIntField) {
            case CUSTOM_INT_1: {
                this.customInt1In = values;
                break;
            }
            case CUSTOM_INT_2: {
                this.customInt2In = values;
                break;
            }
            case CUSTOM_INT_3: {
                this.customInt3In = values;
                break;
            }
            case CUSTOM_INT_4: {
                this.customInt4In = values;
                break;
            }
            case CUSTOM_INT_5: {
                this.customInt5In = values;
                break;
            }
            case CUSTOM_INT_6: {
                this.customInt6In = values;
                break;
            }
            case CUSTOM_INT_7: {
                this.customInt7In = values;
                break;
            }
            case CUSTOM_INT_8: {
                this.customInt8In = values;
                break;
            }
            default: {
                throw new SystemException("Unknown custom int attribute '" + (Object)((Object)customIntField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customIntAttributeNotIn(TaskCustomIntField customIntField, Integer ... values) throws InvalidArgumentException {
        B b;
        B b2;
        TaskCustomIntField taskCustomIntField = customIntField;
        Integer[] integerArray = values;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)((Object)taskCustomIntField), (Object)integerArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (values.length == 0) {
            throw new InvalidArgumentException("At least one Integer has to be provided as a search parameter");
        }
        switch (customIntField) {
            case CUSTOM_INT_1: {
                this.customInt1NotIn = values;
                break;
            }
            case CUSTOM_INT_2: {
                this.customInt2NotIn = values;
                break;
            }
            case CUSTOM_INT_3: {
                this.customInt3NotIn = values;
                break;
            }
            case CUSTOM_INT_4: {
                this.customInt4NotIn = values;
                break;
            }
            case CUSTOM_INT_5: {
                this.customInt5NotIn = values;
                break;
            }
            case CUSTOM_INT_6: {
                this.customInt6NotIn = values;
                break;
            }
            case CUSTOM_INT_7: {
                this.customInt7NotIn = values;
                break;
            }
            case CUSTOM_INT_8: {
                this.customInt8NotIn = values;
                break;
            }
            default: {
                throw new SystemException("Unknown custom int attribute '" + (Object)((Object)customIntField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customIntAttributeWithin(TaskCustomIntField customIntField, IntInterval ... values) throws IllegalArgumentException {
        B b;
        B b2;
        TaskCustomIntField taskCustomIntField = customIntField;
        IntInterval[] intIntervalArray = values;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)((Object)taskCustomIntField), (Object)intIntervalArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        IntInterval[] intIntervalArray2 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IntInterval i = intIntervalArray2[n2];
            if (!i.isValid()) {
                throw new IllegalArgumentException("IntInterval " + i + " is invalid.");
            }
            ++n2;
        }
        switch (customIntField) {
            case CUSTOM_INT_1: {
                this.customInt1Within = values;
                break;
            }
            case CUSTOM_INT_2: {
                this.customInt2Within = values;
                break;
            }
            case CUSTOM_INT_3: {
                this.customInt3Within = values;
                break;
            }
            case CUSTOM_INT_4: {
                this.customInt4Within = values;
                break;
            }
            case CUSTOM_INT_5: {
                this.customInt5Within = values;
                break;
            }
            case CUSTOM_INT_6: {
                this.customInt6Within = values;
                break;
            }
            case CUSTOM_INT_7: {
                this.customInt7Within = values;
                break;
            }
            case CUSTOM_INT_8: {
                this.customInt8Within = values;
                break;
            }
            default: {
                throw new SystemException("Unknown custom int attribute '" + (Object)((Object)customIntField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customIntAttributeNotWithin(TaskCustomIntField customIntField, IntInterval ... values) throws IllegalArgumentException {
        B b;
        B b2;
        TaskCustomIntField taskCustomIntField = customIntField;
        IntInterval[] intIntervalArray = values;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)((Object)taskCustomIntField), (Object)intIntervalArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        IntInterval[] intIntervalArray2 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IntInterval i = intIntervalArray2[n2];
            if (!i.isValid()) {
                throw new IllegalArgumentException("IntInterval " + i + " is invalid.");
            }
            ++n2;
        }
        switch (customIntField) {
            case CUSTOM_INT_1: {
                this.customInt1NotWithin = values;
                break;
            }
            case CUSTOM_INT_2: {
                this.customInt2NotWithin = values;
                break;
            }
            case CUSTOM_INT_3: {
                this.customInt3NotWithin = values;
                break;
            }
            case CUSTOM_INT_4: {
                this.customInt4NotWithin = values;
                break;
            }
            case CUSTOM_INT_5: {
                this.customInt5NotWithin = values;
                break;
            }
            case CUSTOM_INT_6: {
                this.customInt6NotWithin = values;
                break;
            }
            case CUSTOM_INT_7: {
                this.customInt7NotWithin = values;
                break;
            }
            case CUSTOM_INT_8: {
                this.customInt8NotWithin = values;
                break;
            }
            default: {
                throw new SystemException("Unknown custom int attribute '" + (Object)((Object)customIntField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public B customAttributeLike(TaskCustomField customField, String ... strings) throws InvalidArgumentException {
        B b;
        B b2;
        TaskCustomField taskCustomField = customField;
        String[] stringArray = strings;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)((Object)taskCustomField), (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (customField) {
            case CUSTOM_1: {
                this.custom1Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_2: {
                this.custom2Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_3: {
                this.custom3Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_4: {
                this.custom4Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_5: {
                this.custom5Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_6: {
                this.custom6Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_7: {
                this.custom7Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_8: {
                this.custom8Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_9: {
                this.custom9Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_10: {
                this.custom10Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_11: {
                this.custom11Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_12: {
                this.custom12Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_13: {
                this.custom13Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_14: {
                this.custom14Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_15: {
                this.custom15Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            case CUSTOM_16: {
                this.custom16Like = BaseQuery.toLowerCopy((String[])strings);
                break;
            }
            default: {
                throw new SystemException("Unknown custom field '" + (Object)((Object)customField) + "'");
            }
        }
        B b3 = b2 = (b = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, b2);
        return b;
    }

    @Override
    public List<String> listTaskIdsForSelectedItems(List<SelectedItem> selectedItems, TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        List<String> list;
        List<String> list2;
        List<SelectedItem> list3 = selectedItems;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, list3, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.MONITOR);
        try {
            this.kadaiEngine.openConnection();
            if (this.columnHeaders == null) {
                throw new InvalidArgumentException("ColumnHeader must not be null.");
            }
            if (selectedItems == null || selectedItems.isEmpty()) {
                throw new InvalidArgumentException("SelectedItems must not be null or empty.");
            }
            boolean joinWithAttachments = this.subKeyIsSet(selectedItems);
            if (!(this instanceof ClassificationReport.Builder) && joinWithAttachments) {
                throw new InvalidArgumentException("SubKeys are supported for ClassificationReport only.");
            }
            List<CombinedClassificationFilter> combinedClassificationFilter = this.getCombinedClassificationFilter();
            joinWithAttachments |= combinedClassificationFilter != null;
            if (this.inWorkingDays) {
                selectedItems = this.convertWorkingDaysToDays(selectedItems, this.columnHeaders);
            }
            List<String> list4 = this.monitorMapper.getTaskIdsForSelectedItems(Instant.now(), this, combinedClassificationFilter, this.determineGroupedBy(), timestamp, selectedItems, joinWithAttachments);
            list2 = list4;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        List<String> list5 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list2;
    }

    @Override
    public List<String> listCustomAttributeValuesForCustomAttributeName(TaskCustomField taskCustomField) throws NotAuthorizedException {
        List<String> list;
        List<String> list2;
        TaskCustomField taskCustomField2 = taskCustomField;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)((Object)taskCustomField2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.MONITOR);
        try {
            this.kadaiEngine.openConnection();
            List<String> list3 = this.monitorMapper.getCustomAttributeValuesForReport(this, this.getCombinedClassificationFilter(), taskCustomField);
            list2 = list3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        List<String> list4 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list2;
    }

    protected abstract B _this();

    protected abstract String determineGroupedBy();

    protected List<CombinedClassificationFilter> getCombinedClassificationFilter() {
        List<CombinedClassificationFilter> list;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<CombinedClassificationFilter> list2 = null;
        List<CombinedClassificationFilter> list3 = list = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list2;
    }

    private List<SelectedItem> convertWorkingDaysToDays(List<SelectedItem> selectedItems, List<H> columnHeaders) throws InvalidArgumentException {
        List<SelectedItem> list;
        List<SelectedItem> list2;
        List<SelectedItem> list3 = selectedItems;
        List<H> list4 = columnHeaders;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, list3, list4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkingDaysToDaysReportConverter instance = WorkingDaysToDaysReportConverter.initialize(columnHeaders, this.workingTimeCalculator);
        List<SelectedItem> list5 = list2 = (list = selectedItems.stream().map(s -> new SelectedItem(s.getKey(), s.getSubKey(), Collections.min(instance.convertWorkingDaysToDays(s.getLowerAgeLimit())), Collections.max(instance.convertWorkingDaysToDays(s.getUpperAgeLimit())))).toList());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private boolean subKeyIsSet(List<SelectedItem> selectedItems) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        JoinPoint joinPoint;
        block1: {
            List<SelectedItem> list = selectedItems;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            for (SelectedItem selectedItem : selectedItems) {
                if (selectedItem.getSubKey() == null || selectedItem.getSubKey().isEmpty()) continue;
                bl2 = bl3 = true;
                break block1;
            }
            bl2 = bl3 = false;
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    static {
        TimeIntervalReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TimeIntervalReportBuilderImpl.java", TimeIntervalReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withColumnHeaders", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "columnHeaders", "", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 160);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "inWorkingDays", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "", "", "", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 166);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customIntAttributeIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "io.kadai.task.api.TaskCustomIntField:[Ljava.lang.Integer;", "customIntField:values", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 346);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customIntAttributeNotIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "io.kadai.task.api.TaskCustomIntField:[Ljava.lang.Integer;", "customIntField:values", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 385);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customIntAttributeWithin", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "io.kadai.task.api.TaskCustomIntField:[Lio.kadai.common.api.IntInterval;", "customIntField:values", "java.lang.IllegalArgumentException", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 424);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customIntAttributeNotWithin", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "io.kadai.task.api.TaskCustomIntField:[Lio.kadai.common.api.IntInterval;", "customIntField:values", "java.lang.IllegalArgumentException", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 463);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customAttributeLike", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "io.kadai.task.api.TaskCustomField:[Ljava.lang.String;", "customField:strings", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 502);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listTaskIdsForSelectedItems", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List:io.kadai.monitor.api.TaskTimestamp", "selectedItems:timestamp", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "java.util.List"), 566);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listCustomAttributeValuesForCustomAttributeName", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "io.kadai.task.api.TaskCustomField", "taskCustomField", "io.kadai.common.api.exceptions.NotAuthorizedException", "java.util.List"), 603);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getCombinedClassificationFilter", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "", "", "", "java.util.List"), 620);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertWorkingDaysToDays", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List:java.util.List", "selectedItems:columnHeaders", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.util.List"), 627);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "subKeyIsSet", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "selectedItems", "", "boolean"), 642);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workbasketIdIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "workbasketIds", "", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 172);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stateIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "states", "", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 180);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationCategoryIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "classificationCategories", "", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 188);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classificationIdIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "classificationIds", "", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 196);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "excludedClassificationIdIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "excludedClassificationIds", "", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 204);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "domainIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "java.util.List", "domains", "", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 212);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customAttributeIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "io.kadai.task.api.TaskCustomField:[Ljava.lang.String;", "customField:strings", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 220);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "customAttributeNotIn", "io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl", "io.kadai.task.api.TaskCustomField:[Ljava.lang.String;", "customField:strings", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.monitor.api.reports.TimeIntervalReportBuilder"), 283);
    }
}

