/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.spi.priority.internal;

import io.kadai.common.api.KadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.util.CheckedFunction;
import io.kadai.common.internal.util.LogSanitizer;
import io.kadai.common.internal.util.SpiLoader;
import io.kadai.spi.priority.api.PriorityServiceProvider;
import io.kadai.task.api.models.TaskSummary;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityServiceManager {
    private static final Logger LOGGER;
    private final List<PriorityServiceProvider> priorityServiceProviders = SpiLoader.load(PriorityServiceProvider.class);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        PriorityServiceManager.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(PriorityServiceManager.class);
    }

    public PriorityServiceManager(KadaiEngine kadaiEngine) {
        for (PriorityServiceProvider priorityProvider : this.priorityServiceProviders) {
            priorityProvider.initialize(kadaiEngine);
            LOGGER.info("Registered PriorityServiceProvider: {}", (Object)priorityProvider.getClass().getName());
        }
        if (this.priorityServiceProviders.isEmpty()) {
            LOGGER.info("No PriorityServiceProvider found. Running without PriorityServiceProvider.");
        }
    }

    public boolean isEnabled() {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = !this.priorityServiceProviders.isEmpty();
        boolean bl3 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    public OptionalInt calculatePriorityOfTask(TaskSummary task) {
        OptionalInt optionalInt;
        OptionalInt optionalInt2;
        OptionalInt optionalInt3;
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (task.isManualPriorityActive()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skip using PriorityServiceProviders because the Task is prioritised manually: {}", (Object)task);
            }
            optionalInt2 = optionalInt3 = OptionalInt.empty();
        } else {
            Set priorities;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending Task to PriorityServiceProviders: {}", (Object)task);
            }
            if ((priorities = this.priorityServiceProviders.stream().map(CheckedFunction.wrap(provider -> provider.calculatePriority(task))).filter(OptionalInt::isPresent).collect(Collectors.toSet())).size() == 1) {
                optionalInt2 = optionalInt3 = (OptionalInt)priorities.iterator().next();
            } else {
                if (!priorities.isEmpty() && LOGGER.isErrorEnabled()) {
                    LOGGER.error("The PriorityServiceProviders determined more than one priority for Task {}.", (Object)LogSanitizer.stripLineBreakingChars((Object)task));
                }
                optionalInt2 = optionalInt3 = OptionalInt.empty();
            }
        }
        OptionalInt optionalInt4 = optionalInt = optionalInt2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optionalInt);
        return optionalInt3;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PriorityServiceManager.java", PriorityServiceManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isEnabled", "io.kadai.spi.priority.internal.PriorityServiceManager", "", "", "", "boolean"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "calculatePriorityOfTask", "io.kadai.spi.priority.internal.PriorityServiceManager", "io.kadai.task.api.models.TaskSummary", "task", "", "java.util.OptionalInt"), 55);
    }
}

