/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.api;

import io.kadai.classification.api.exceptions.ClassificationNotFoundException;
import io.kadai.common.api.BulkOperationResults;
import io.kadai.common.api.exceptions.ConcurrencyException;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.task.api.CallbackState;
import io.kadai.task.api.TaskCommentQuery;
import io.kadai.task.api.TaskCustomField;
import io.kadai.task.api.TaskQuery;
import io.kadai.task.api.exceptions.AttachmentPersistenceException;
import io.kadai.task.api.exceptions.InvalidCallbackStateException;
import io.kadai.task.api.exceptions.InvalidOwnerException;
import io.kadai.task.api.exceptions.InvalidTaskStateException;
import io.kadai.task.api.exceptions.NotAuthorizedOnTaskCommentException;
import io.kadai.task.api.exceptions.ObjectReferencePersistenceException;
import io.kadai.task.api.exceptions.TaskAlreadyExistException;
import io.kadai.task.api.exceptions.TaskCommentNotFoundException;
import io.kadai.task.api.exceptions.TaskNotFoundException;
import io.kadai.task.api.models.Attachment;
import io.kadai.task.api.models.ObjectReference;
import io.kadai.task.api.models.Task;
import io.kadai.task.api.models.TaskComment;
import io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public interface TaskService {
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    public static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public Task newTask();

    public Task newTask(String var1);

    public Task newTask(String var1, String var2);

    public Task createTask(Task var1) throws WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidArgumentException, AttachmentPersistenceException, ObjectReferencePersistenceException, NotAuthorizedOnWorkbasketException;

    public Task getTask(String var1) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException;

    public Task claim(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task forceClaim(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Optional<Task> selectAndClaim(TaskQuery var1) throws InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task cancelClaim(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task cancelClaim(String var1, boolean var2) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task forceCancelClaim(String var1, boolean var2) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task forceCancelClaim(String var1) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task requestReview(String var1) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task forceRequestReview(String var1) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task requestChanges(String var1) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task forceRequestChanges(String var1) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException;

    public Task completeTask(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task forceCompleteTask(String var1) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public BulkOperationResults<String, KadaiException> completeTasks(List<String> var1) throws InvalidArgumentException;

    public BulkOperationResults<String, KadaiException> forceCompleteTasks(List<String> var1) throws InvalidArgumentException;

    public Task cancelTask(String var1) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public Task terminateTask(String var1) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    default public Task transfer(String taskId, String destinationWorkbasketId) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.transfer(taskId, destinationWorkbasketId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    public Task transfer(String var1, String var2, boolean var3) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    default public Task transfer(String taskId, String workbasketKey, String domain) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = workbasketKey;
        String string3 = domain;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.transfer(taskId, workbasketKey, domain, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    public Task transfer(String var1, String var2, String var3, boolean var4) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    default public Task transferWithOwner(String taskId, String destinationWorkbasketId, String owner) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        String string3 = owner;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.transferWithOwner(taskId, destinationWorkbasketId, owner, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    public Task transferWithOwner(String var1, String var2, String var3, boolean var4) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    default public Task transferWithOwner(String taskId, String workbasketKey, String domain, String owner) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = workbasketKey;
        String string3 = domain;
        String string4 = owner;
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.transferWithOwner(taskId, workbasketKey, domain, owner, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    public Task transferWithOwner(String var1, String var2, String var3, String var4, boolean var5) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    default public BulkOperationResults<String, KadaiException> transferTasks(String destinationWorkbasketId, List<String> taskIds) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        String string = destinationWorkbasketId;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferTasks(destinationWorkbasketId, taskIds, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    public BulkOperationResults<String, KadaiException> transferTasks(String var1, List<String> var2, boolean var3) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    default public BulkOperationResults<String, KadaiException> transferTasks(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        String string = destinationWorkbasketKey;
        String string2 = destinationWorkbasketDomain;
        List<String> list = taskIds;
        Object[] objectArray = new Object[]{string, string2, list};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferTasks(destinationWorkbasketKey, destinationWorkbasketDomain, taskIds, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    public BulkOperationResults<String, KadaiException> transferTasks(String var1, String var2, List<String> var3, boolean var4) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    default public BulkOperationResults<String, KadaiException> transferTasksWithOwner(String destinationWorkbasketId, List<String> taskIds, String owner) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        String string = destinationWorkbasketId;
        List<String> list = taskIds;
        String string2 = owner;
        Object[] objectArray = new Object[]{string, list, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferTasksWithOwner(destinationWorkbasketId, taskIds, owner, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    public BulkOperationResults<String, KadaiException> transferTasksWithOwner(String var1, List<String> var2, String var3, boolean var4) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    default public BulkOperationResults<String, KadaiException> transferTasksWithOwner(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds, String owner) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        String string = destinationWorkbasketKey;
        String string2 = destinationWorkbasketDomain;
        List<String> list = taskIds;
        String string3 = owner;
        Object[] objectArray = new Object[]{string, string2, list, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferTasksWithOwner(destinationWorkbasketKey, destinationWorkbasketDomain, taskIds, owner, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    public BulkOperationResults<String, KadaiException> transferTasksWithOwner(String var1, String var2, List<String> var3, String var4, boolean var5) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    public Task updateTask(Task var1) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, ClassificationNotFoundException, AttachmentPersistenceException, ObjectReferencePersistenceException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException;

    public List<String> updateTasks(ObjectReference var1, Map<TaskCustomField, String> var2) throws InvalidArgumentException;

    public List<String> updateTasks(List<String> var1, Map<TaskCustomField, String> var2) throws InvalidArgumentException;

    public Task setTaskRead(String var1, boolean var2) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException;

    public BulkOperationResults<String, KadaiException> setCallbackStateForTasks(List<String> var1, CallbackState var2);

    public BulkOperationResults<String, KadaiException> setOwnerOfTasks(String var1, List<String> var2);

    public BulkOperationResults<String, KadaiException> setPlannedPropertyOfTasks(Instant var1, List<String> var2);

    public void deleteTask(String var1) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException;

    public void forceDeleteTask(String var1) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException;

    public BulkOperationResults<String, KadaiException> deleteTasks(List<String> var1) throws InvalidArgumentException, NotAuthorizedException;

    public TaskComment newTaskComment(String var1);

    public TaskComment createTaskComment(TaskComment var1) throws TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException;

    public TaskComment getTaskComment(String var1) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException;

    public List<TaskComment> getTaskComments(String var1) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException;

    public TaskComment updateTaskComment(TaskComment var1) throws ConcurrencyException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException;

    public void deleteTaskComment(String var1) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException;

    public Attachment newAttachment();

    public ObjectReference newObjectReference();

    public ObjectReference newObjectReference(String var1, String var2, String var3, String var4, String var5);

    public TaskQuery createTaskQuery();

    public TaskCommentQuery createTaskCommentQuery();

    static {
        Factory factory = new Factory("TaskService.java", TaskService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "io.kadai.task.api.TaskService", "java.lang.String:java.lang.String", "taskId:destinationWorkbasketId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 502);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "io.kadai.task.api.TaskService", "java.lang.String:java.lang.String:java.lang.String", "taskId:workbasketKey:domain", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 551);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferWithOwner", "io.kadai.task.api.TaskService", "java.lang.String:java.lang.String:java.lang.String", "taskId:destinationWorkbasketId:owner", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 602);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferWithOwner", "io.kadai.task.api.TaskService", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "taskId:workbasketKey:domain:owner", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 656);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "io.kadai.task.api.TaskService", "java.lang.String:java.util.List", "destinationWorkbasketId:taskIds", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 707);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "io.kadai.task.api.TaskService", "java.lang.String:java.lang.String:java.util.List", "destinationWorkbasketKey:destinationWorkbasketDomain:taskIds", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 752);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasksWithOwner", "io.kadai.task.api.TaskService", "java.lang.String:java.util.List:java.lang.String", "destinationWorkbasketId:taskIds:owner", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 802);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasksWithOwner", "io.kadai.task.api.TaskService", "java.lang.String:java.lang.String:java.util.List:java.lang.String", "destinationWorkbasketKey:destinationWorkbasketDomain:taskIds:owner", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 851);
    }
}

