/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.internal;

import io.kadai.common.api.BaseQuery;
import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.TimeInterval;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.task.api.TaskCommentQuery;
import io.kadai.task.api.TaskCommentQueryColumnName;
import io.kadai.task.api.exceptions.TaskNotFoundException;
import io.kadai.task.api.models.TaskComment;
import io.kadai.task.internal.TaskServiceImpl;
import io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import io.kadai.workbasket.api.exceptions.NotAuthorizedToQueryWorkbasketException;
import io.kadai.workbasket.internal.WorkbasketQueryImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCommentQueryImpl
implements TaskCommentQuery {
    private static final Logger LOGGER;
    private static final String LINK_TO_MAPPER = "io.kadai.task.internal.TaskCommentQueryMapper.queryTaskComments";
    private static final String LINK_TO_VALUE_MAPPER = "io.kadai.task.internal.TaskCommentQueryMapper.queryTaskCommentColumnValues";
    private static final String LINK_TO_COUNTER = "io.kadai.task.internal.TaskCommentQueryMapper.countQueryTaskComments";
    private final InternalKadaiEngine kadaiEngine;
    private final TaskServiceImpl taskService;
    private final List<String> orderBy;
    private final List<String> orderColumns;
    private TaskCommentQueryColumnName queryColumnName;
    private String[] idIn;
    private String[] idNotIn;
    private String[] idLike;
    private String[] idNotLike;
    private String[] taskIdIn;
    private String[] creatorIn;
    private String[] creatorNotIn;
    private String[] creatorLike;
    private String[] creatorNotLike;
    private String[] textFieldLike;
    private String[] textFieldNotLike;
    private TimeInterval[] modifiedIn;
    private TimeInterval[] modifiedNotIn;
    private TimeInterval[] createdIn;
    private TimeInterval[] createdNotIn;
    private String[] accessIdIn;
    private boolean joinWithUserInfo;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;

    static {
        TaskCommentQueryImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskCommentQueryImpl.class);
    }

    TaskCommentQueryImpl(InternalKadaiEngine kadaiEngine) {
        this.kadaiEngine = kadaiEngine;
        this.taskService = (TaskServiceImpl)kadaiEngine.getEngine().getTaskService();
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
        this.joinWithUserInfo = kadaiEngine.getEngine().getConfiguration().isAddAdditionalUserInfo();
    }

    @Override
    public TaskCommentQuery idIn(String ... taskCommentIds) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = taskCommentIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.idIn = taskCommentIds;
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery idNotIn(String ... taskCommentIds) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = taskCommentIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.idNotIn = taskCommentIds;
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery idLike(String ... taskCommentIds) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = taskCommentIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.idLike = BaseQuery.toLowerCopy((String[])taskCommentIds);
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery idNotLike(String ... taskCommentIds) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = taskCommentIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.idNotLike = BaseQuery.toLowerCopy((String[])taskCommentIds);
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery taskIdIn(String ... taskIds) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskIdIn = taskIds;
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery textFieldLike(String ... texts) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = texts;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.textFieldLike = BaseQuery.toLowerCopy((String[])texts);
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery textFieldNotLike(String ... texts) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = texts;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.textFieldNotLike = BaseQuery.toLowerCopy((String[])texts);
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery creatorIn(String ... creators) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = creators;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.creatorIn = creators;
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery creatorNotIn(String ... creators) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = creators;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.creatorNotIn = creators;
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery creatorLike(String ... creators) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = creators;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.creatorLike = BaseQuery.toLowerCopy((String[])creators);
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery creatorNotLike(String ... creators) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String[] stringArray = creators;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.creatorNotLike = BaseQuery.toLowerCopy((String[])creators);
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery createdWithin(TimeInterval ... intervals) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        TimeInterval[] timeIntervalArray = intervals;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)timeIntervalArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validateAllIntervals(intervals);
        this.createdIn = intervals;
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery createdNotWithin(TimeInterval ... intervals) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        TimeInterval[] timeIntervalArray = intervals;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)timeIntervalArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.createdNotIn = intervals;
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery modifiedWithin(TimeInterval ... intervals) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        TimeInterval[] timeIntervalArray = intervals;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)timeIntervalArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validateAllIntervals(intervals);
        this.modifiedIn = intervals;
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public TaskCommentQuery modifiedNotWithin(TimeInterval ... intervals) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        TimeInterval[] timeIntervalArray = intervals;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)timeIntervalArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.modifiedNotIn = intervals;
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    public List<TaskComment> list() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.checkTaskPermission();
        this.setupAccessIds();
        List list3 = list2 = (list = this.kadaiEngine.executeInDatabaseConnection(() -> this.kadaiEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public List<TaskComment> list(int offset, int limit) {
        List list;
        List list2;
        int n = offset;
        int n2 = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.checkTaskPermission();
        this.setupAccessIds();
        RowBounds rowBounds = new RowBounds(offset, limit);
        List list3 = list2 = (list = this.kadaiEngine.executeInDatabaseConnection(() -> this.kadaiEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public List<String> listValues(TaskCommentQueryColumnName columnName, BaseQuery.SortDirection sortDirection) {
        List list;
        List list2;
        TaskCommentQueryColumnName taskCommentQueryColumnName = columnName;
        BaseQuery.SortDirection sortDirection2 = sortDirection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)((Object)taskCommentQueryColumnName), (Object)sortDirection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.checkTaskPermission();
        this.setupAccessIds();
        this.queryColumnName = columnName;
        if (columnName == TaskCommentQueryColumnName.CREATOR_FULL_NAME) {
            this.joinWithUserInfo = true;
        }
        List list3 = list2 = (list = this.kadaiEngine.executeInDatabaseConnection(() -> this.kadaiEngine.getSqlSession().selectList(LINK_TO_VALUE_MAPPER, (Object)this)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public TaskComment single() {
        TaskComment taskComment;
        TaskComment taskComment2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.checkTaskPermission();
        this.setupAccessIds();
        TaskComment taskComment3 = taskComment2 = (taskComment = this.kadaiEngine.executeInDatabaseConnection(() -> (TaskComment)this.kadaiEngine.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment2);
        return taskComment;
    }

    public long count() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.checkTaskPermission();
        this.setupAccessIds();
        Long rowCount = this.kadaiEngine.executeInDatabaseConnection(() -> (Long)this.kadaiEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this));
        long l2 = rowCount == null ? 0L : rowCount;
        long l3 = l = l2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l));
        return l2;
    }

    public TaskCommentQueryColumnName getQueryColumnName() {
        TaskCommentQueryColumnName taskCommentQueryColumnName;
        TaskCommentQueryColumnName taskCommentQueryColumnName2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCommentQueryColumnName taskCommentQueryColumnName3 = taskCommentQueryColumnName2 = (taskCommentQueryColumnName = this.queryColumnName);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryColumnName2);
        return taskCommentQueryColumnName;
    }

    public String[] getIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.idIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getIdNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.idNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getIdLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.idLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getIdNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.idNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getTaskIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.taskIdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCreatorIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.creatorIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCreatorNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.creatorNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCreatorLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.creatorLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCreatorNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.creatorNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getTextFieldLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.textFieldLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getTextFieldNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.textFieldNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public TimeInterval[] getModifiedIn() {
        TimeInterval[] timeIntervalArray;
        TimeInterval[] timeIntervalArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimeInterval[] timeIntervalArray3 = timeIntervalArray2 = (timeIntervalArray = this.modifiedIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timeIntervalArray2);
        return timeIntervalArray;
    }

    public TimeInterval[] getModifiedNotIn() {
        TimeInterval[] timeIntervalArray;
        TimeInterval[] timeIntervalArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimeInterval[] timeIntervalArray3 = timeIntervalArray2 = (timeIntervalArray = this.modifiedNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timeIntervalArray2);
        return timeIntervalArray;
    }

    public TimeInterval[] getCreatedIn() {
        TimeInterval[] timeIntervalArray;
        TimeInterval[] timeIntervalArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimeInterval[] timeIntervalArray3 = timeIntervalArray2 = (timeIntervalArray = this.createdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timeIntervalArray2);
        return timeIntervalArray;
    }

    public TimeInterval[] getCreatedNotIn() {
        TimeInterval[] timeIntervalArray;
        TimeInterval[] timeIntervalArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimeInterval[] timeIntervalArray3 = timeIntervalArray2 = (timeIntervalArray = this.createdNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timeIntervalArray2);
        return timeIntervalArray;
    }

    public String[] getAccessIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.accessIdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public boolean isIncludeLongName() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = this.joinWithUserInfo);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void setIncludeLongName(boolean joinWithUserInfo) {
        boolean bl = joinWithUserInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.joinWithUserInfo = joinWithUserInfo;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public TaskCommentQuery orderByCreated(BaseQuery.SortDirection sortDirection) {
        TaskCommentQuery taskCommentQuery;
        TaskCommentQuery taskCommentQuery2;
        BaseQuery.SortDirection sortDirection2 = sortDirection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)sortDirection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCommentQuery taskCommentQuery3 = taskCommentQuery2 = (taskCommentQuery = this.addOrderCriteria("CREATED", sortDirection));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQuery2);
        return taskCommentQuery;
    }

    @Override
    public TaskCommentQuery orderByModified(BaseQuery.SortDirection sortDirection) {
        TaskCommentQuery taskCommentQuery;
        TaskCommentQuery taskCommentQuery2;
        BaseQuery.SortDirection sortDirection2 = sortDirection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)sortDirection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCommentQuery taskCommentQuery3 = taskCommentQuery2 = (taskCommentQuery = this.addOrderCriteria("MODIFIED", sortDirection));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQuery2);
        return taskCommentQuery;
    }

    private void checkTaskPermission() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.taskIdIn != null) {
            if (this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN, KadaiRole.TASK_ADMIN)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Skipping permissions check since user is in role ADMIN or TASK_ADMIN.");
                }
            } else {
                Arrays.stream(this.taskIdIn).forEach(taskId -> {
                    try {
                        this.taskService.getTask((String)taskId);
                    }
                    catch (NotAuthorizedOnWorkbasketException e) {
                        throw new NotAuthorizedToQueryWorkbasketException(e.getMessage(), e.getErrorCode(), (Throwable)((Object)e));
                    }
                    catch (TaskNotFoundException e) {
                        LOGGER.warn(String.format("The Task with the ID ' %s ' does not exist.", taskId), (Throwable)((Object)e));
                    }
                });
            }
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private TaskCommentQuery addOrderCriteria(String columnName, BaseQuery.SortDirection sortDirection) {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        String string = columnName;
        BaseQuery.SortDirection sortDirection2 = sortDirection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)string, (Object)sortDirection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String orderByDirection = " " + (sortDirection == null ? BaseQuery.SortDirection.ASCENDING : sortDirection);
        this.orderBy.add(String.valueOf(columnName) + orderByDirection);
        this.orderColumns.add(columnName);
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    private void setupAccessIds() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN, KadaiRole.TASK_ADMIN)) {
            this.accessIdIn = null;
        } else if (this.accessIdIn == null) {
            String[] accessIds = new String[]{};
            List ucAccessIds = this.kadaiEngine.getEngine().getCurrentUserContext().getAccessIds();
            if (!ucAccessIds.isEmpty()) {
                accessIds = new String[ucAccessIds.size()];
                accessIds = ucAccessIds.toArray(accessIds);
            }
            this.accessIdIn = accessIds;
            WorkbasketQueryImpl.lowercaseAccessIds(this.accessIdIn);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void validateAllIntervals(TimeInterval[] intervals) {
        TimeInterval[] timeIntervalArray = intervals;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)timeIntervalArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimeInterval[] timeIntervalArray2 = intervals;
        int n = intervals.length;
        int n2 = 0;
        while (n2 < n) {
            TimeInterval ti = timeIntervalArray2[n2];
            if (!ti.isValid()) {
                throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
            }
            ++n2;
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    public String toString() {
        return "TaskCommentQueryImpl [kadaiEngine=" + this.kadaiEngine + ", taskService=" + this.taskService + ", queryColumnName=" + (Object)((Object)this.queryColumnName) + ", idIn=" + Arrays.toString(this.idIn) + ", idNotIn=" + Arrays.toString(this.idNotIn) + ", idLike=" + Arrays.toString(this.idLike) + ", idNotLike=" + Arrays.toString(this.idNotLike) + ", taskIdIn=" + Arrays.toString(this.taskIdIn) + ", creatorIn=" + Arrays.toString(this.creatorIn) + ", creatorNotIn=" + Arrays.toString(this.creatorNotIn) + ", creatorLike=" + Arrays.toString(this.creatorLike) + ", creatorNotLike=" + Arrays.toString(this.creatorNotLike) + ", textFieldLike=" + Arrays.toString(this.textFieldLike) + ", textFieldNotLike=" + Arrays.toString(this.textFieldNotLike) + ", modifiedIn=" + Arrays.toString(this.modifiedIn) + ", modifiedNotIn=" + Arrays.toString(this.modifiedNotIn) + ", createdIn=" + Arrays.toString(this.createdIn) + ", createdNotIn=" + Arrays.toString(this.createdNotIn) + ", accessIdIn=" + Arrays.toString(this.accessIdIn) + ", joinWithUserInfo=" + this.joinWithUserInfo + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCommentQueryImpl.java", TaskCommentQueryImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "idIn", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "taskCommentIds", "", "io.kadai.task.api.TaskCommentQuery"), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "idNotIn", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "taskCommentIds", "", "io.kadai.task.api.TaskCommentQuery"), 93);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "creatorNotLike", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "creators", "", "io.kadai.task.api.TaskCommentQuery"), 147);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "createdWithin", "io.kadai.task.internal.TaskCommentQueryImpl", "[Lio.kadai.common.api.TimeInterval;", "intervals", "", "io.kadai.task.api.TaskCommentQuery"), 153);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "createdNotWithin", "io.kadai.task.internal.TaskCommentQueryImpl", "[Lio.kadai.common.api.TimeInterval;", "intervals", "", "io.kadai.task.api.TaskCommentQuery"), 160);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "modifiedWithin", "io.kadai.task.internal.TaskCommentQueryImpl", "[Lio.kadai.common.api.TimeInterval;", "intervals", "", "io.kadai.task.api.TaskCommentQuery"), 166);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "modifiedNotWithin", "io.kadai.task.internal.TaskCommentQueryImpl", "[Lio.kadai.common.api.TimeInterval;", "intervals", "", "io.kadai.task.api.TaskCommentQuery"), 173);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "java.util.List"), 179);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "io.kadai.task.internal.TaskCommentQueryImpl", "int:int", "offset:limit", "", "java.util.List"), 187);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listValues", "io.kadai.task.internal.TaskCommentQueryImpl", "io.kadai.task.api.TaskCommentQueryColumnName:io.kadai.common.api.BaseQuery$SortDirection", "columnName:sortDirection", "", "java.util.List"), 196);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "single", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "io.kadai.task.api.models.TaskComment"), 211);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "count", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "long"), 219);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "idLike", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "taskCommentIds", "", "io.kadai.task.api.TaskCommentQuery"), 99);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getQueryColumnName", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "io.kadai.task.api.TaskCommentQueryColumnName"), 228);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 232);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdNotIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 236);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdLike", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 240);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdNotLike", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 244);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskIdIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 248);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatorIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 252);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatorNotIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 256);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatorLike", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 260);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatorNotLike", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 264);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "idNotLike", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "taskCommentIds", "", "io.kadai.task.api.TaskCommentQuery"), 105);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTextFieldLike", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 268);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTextFieldNotLike", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 272);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getModifiedIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Lio.kadai.common.api.TimeInterval;"), 276);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getModifiedNotIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Lio.kadai.common.api.TimeInterval;"), 280);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatedIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Lio.kadai.common.api.TimeInterval;"), 284);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatedNotIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Lio.kadai.common.api.TimeInterval;"), 288);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccessIdIn", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "[Ljava.lang.String;"), 292);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isIncludeLongName", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "boolean"), 296);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setIncludeLongName", "io.kadai.task.internal.TaskCommentQueryImpl", "boolean", "joinWithUserInfo", "", "void"), 300);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "orderByCreated", "io.kadai.task.internal.TaskCommentQueryImpl", "io.kadai.common.api.BaseQuery$SortDirection", "sortDirection", "", "io.kadai.task.api.TaskCommentQuery"), 305);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "taskIdIn", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "taskIds", "", "io.kadai.task.api.TaskCommentQuery"), 111);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "orderByModified", "io.kadai.task.internal.TaskCommentQueryImpl", "io.kadai.common.api.BaseQuery$SortDirection", "sortDirection", "", "io.kadai.task.api.TaskCommentQuery"), 310);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkTaskPermission", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "void"), 314);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addOrderCriteria", "io.kadai.task.internal.TaskCommentQueryImpl", "java.lang.String:io.kadai.common.api.BaseQuery$SortDirection", "columnName:sortDirection", "", "io.kadai.task.api.TaskCommentQuery"), 340);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setupAccessIds", "io.kadai.task.internal.TaskCommentQueryImpl", "", "", "", "void"), 348);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateAllIntervals", "io.kadai.task.internal.TaskCommentQueryImpl", "[Lio.kadai.common.api.TimeInterval;", "intervals", "", "void"), 363);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "textFieldLike", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "texts", "", "io.kadai.task.api.TaskCommentQuery"), 117);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "textFieldNotLike", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "texts", "", "io.kadai.task.api.TaskCommentQuery"), 123);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "creatorIn", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "creators", "", "io.kadai.task.api.TaskCommentQuery"), 129);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "creatorNotIn", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "creators", "", "io.kadai.task.api.TaskCommentQuery"), 135);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "creatorLike", "io.kadai.task.internal.TaskCommentQueryImpl", "[Ljava.lang.String;", "creators", "", "io.kadai.task.api.TaskCommentQuery"), 141);
    }
}

