/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.internal;

import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.exceptions.ConcurrencyException;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.util.IdGenerator;
import io.kadai.task.api.exceptions.NotAuthorizedOnTaskCommentException;
import io.kadai.task.api.exceptions.TaskCommentNotFoundException;
import io.kadai.task.api.exceptions.TaskNotFoundException;
import io.kadai.task.api.models.TaskComment;
import io.kadai.task.internal.TaskCommentMapper;
import io.kadai.task.internal.TaskMapper;
import io.kadai.task.internal.TaskServiceImpl;
import io.kadai.task.internal.models.TaskCommentImpl;
import io.kadai.user.internal.UserMapper;
import io.kadai.user.internal.models.UserImpl;
import io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import java.time.Instant;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskCommentServiceImpl {
    private static final Logger LOGGER;
    private final InternalKadaiEngine kadaiEngine;
    private final TaskServiceImpl taskService;
    private final TaskCommentMapper taskCommentMapper;
    private final TaskMapper taskMapper;
    private final UserMapper userMapper;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        TaskCommentServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskCommentServiceImpl.class);
    }

    TaskCommentServiceImpl(InternalKadaiEngine kadaiEngine, TaskCommentMapper taskCommentMapper, UserMapper userMapper, TaskMapper taskMapper, TaskServiceImpl taskService) {
        this.kadaiEngine = kadaiEngine;
        this.taskService = taskService;
        this.taskCommentMapper = taskCommentMapper;
        this.userMapper = userMapper;
        this.taskMapper = taskMapper;
    }

    TaskComment newTaskComment(String taskId) {
        TaskCommentImpl taskCommentImpl;
        TaskCommentImpl taskCommentImpl2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCommentImpl taskComment = new TaskCommentImpl();
        taskComment.setTaskId(taskId);
        TaskCommentImpl taskCommentImpl3 = taskCommentImpl2 = (taskCommentImpl = taskComment);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentImpl2);
        return taskCommentImpl;
    }

    TaskComment updateTaskComment(TaskComment taskCommentToUpdate) throws ConcurrencyException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException {
        TaskCommentImpl taskCommentImpl;
        TaskCommentImpl taskCommentImpl2;
        TaskCommentImpl taskCommentImplToUpdate;
        JoinPoint joinPoint;
        block5: {
            TaskComment taskComment = taskCommentToUpdate;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskComment);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
            taskCommentImplToUpdate = (TaskCommentImpl)taskCommentToUpdate;
            try {
                this.kadaiEngine.openConnection();
                TaskComment originalTaskComment = this.getTaskComment(taskCommentImplToUpdate.getId());
                if (originalTaskComment.getCreator().equals(userId) && taskCommentImplToUpdate.getCreator().equals(originalTaskComment.getCreator()) || this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN) || this.kadaiEngine.getEngine().isUserInRole(KadaiRole.TASK_ADMIN)) {
                    this.checkModifiedHasNotChanged(originalTaskComment, taskCommentImplToUpdate);
                    taskCommentImplToUpdate.setModified(Instant.now());
                    this.taskCommentMapper.update(taskCommentImplToUpdate);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Method updateTaskComment() updated taskComment '{}' for user '{}'.", (Object)taskCommentImplToUpdate.getId(), (Object)userId);
                    }
                    break block5;
                }
                throw new NotAuthorizedOnTaskCommentException(userId, taskCommentImplToUpdate.getId());
            }
            finally {
                this.kadaiEngine.returnConnection();
            }
        }
        TaskCommentImpl taskCommentImpl3 = taskCommentImpl2 = (taskCommentImpl = taskCommentImplToUpdate);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentImpl2);
        return taskCommentImpl;
    }

    TaskComment createTaskComment(TaskComment taskCommentToCreate) throws TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        TaskCommentImpl taskCommentImpl;
        TaskCommentImpl taskCommentImpl2;
        TaskComment taskComment = taskCommentToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)taskComment);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCommentImpl taskCommentImplToCreate = (TaskCommentImpl)taskCommentToCreate;
        try {
            this.kadaiEngine.openConnection();
            this.taskService.getTask(taskCommentImplToCreate.getTaskId());
            this.validateNoneExistingTaskCommentId(taskCommentImplToCreate.getId());
            this.initDefaultTaskCommentValues(taskCommentImplToCreate);
            this.taskCommentMapper.insert(taskCommentImplToCreate);
            this.taskMapper.incrementNumberOfComments(taskCommentImplToCreate.getTaskId(), Instant.now());
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskCommentImpl taskCommentImpl3 = taskCommentImpl2 = (taskCommentImpl = taskCommentImplToCreate);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentImpl2);
        return taskCommentImpl;
    }

    void deleteTaskComment(String taskCommentId) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException {
        JoinPoint joinPoint;
        block5: {
            String string = taskCommentId;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
            try {
                this.kadaiEngine.openConnection();
                TaskComment taskCommentToDelete = this.getTaskComment(taskCommentId);
                if (taskCommentToDelete.getCreator().equals(userId) || this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN) || this.kadaiEngine.getEngine().isUserInRole(KadaiRole.TASK_ADMIN)) {
                    this.taskCommentMapper.delete(taskCommentId);
                    this.taskMapper.decrementNumberOfComments(taskCommentToDelete.getTaskId(), Instant.now());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("taskComment {} deleted", (Object)taskCommentToDelete.getId());
                    }
                    break block5;
                }
                throw new NotAuthorizedOnTaskCommentException(userId, taskCommentToDelete.getId());
            }
            finally {
                this.kadaiEngine.returnConnection();
            }
        }
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    List<TaskComment> getTaskComments(String taskId) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException {
        List list;
        List list2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.kadaiEngine.openConnection();
            this.taskService.getTask(taskId);
            List taskComments = this.taskService.createTaskCommentQuery().taskIdIn(taskId).list();
            if (taskComments.isEmpty() && LOGGER.isDebugEnabled()) {
                LOGGER.debug("getTaskComments() found no comments for the provided taskId");
            }
            List list3 = taskComments;
            list2 = list3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        List list4 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list);
        return list2;
    }

    TaskComment getTaskComment(String taskCommentId) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        TaskCommentImpl taskCommentImpl;
        TaskCommentImpl taskCommentImpl2;
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.verifyTaskCommentIdIsNotNullOrEmpty(taskCommentId);
        try {
            UserImpl creator;
            this.kadaiEngine.openConnection();
            TaskCommentImpl result = this.taskCommentMapper.findById(taskCommentId);
            if (result == null) {
                throw new TaskCommentNotFoundException(taskCommentId);
            }
            this.taskService.getTask(result.getTaskId());
            if (this.kadaiEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (creator = this.userMapper.findById(result.getCreator())) != null) {
                result.setCreatorFullName(creator.getFullName());
            }
            TaskCommentImpl taskCommentImpl3 = result;
            taskCommentImpl2 = taskCommentImpl3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskCommentImpl taskCommentImpl4 = taskCommentImpl = taskCommentImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentImpl);
        return taskCommentImpl2;
    }

    private void checkModifiedHasNotChanged(TaskComment oldTaskComment, TaskComment taskCommentImplToUpdate) throws ConcurrencyException {
        TaskComment taskComment = oldTaskComment;
        TaskComment taskComment2 = taskCommentImplToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)taskComment, (Object)taskComment2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!oldTaskComment.getModified().equals(taskCommentImplToUpdate.getModified())) {
            throw new ConcurrencyException(taskCommentImplToUpdate.getId());
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void initDefaultTaskCommentValues(TaskCommentImpl taskCommentImplToCreate) {
        TaskCommentImpl taskCommentImpl = taskCommentImplToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)taskCommentImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant now = Instant.now();
        taskCommentImplToCreate.setId(IdGenerator.generateWithPrefix((String)"TCI"));
        taskCommentImplToCreate.setModified(now);
        taskCommentImplToCreate.setCreated(now);
        String creator = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
        if (this.kadaiEngine.getEngine().getConfiguration().isSecurityEnabled() && creator == null) {
            throw new SystemException("KadaiSecurity is enabled, but the current UserId is NULL while creating a TaskComment.");
        }
        taskCommentImplToCreate.setCreator(creator);
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void validateNoneExistingTaskCommentId(String taskCommentId) throws InvalidArgumentException {
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskCommentId != null && !taskCommentId.equals("")) {
            throw new InvalidArgumentException(String.format("taskCommentId must be null/empty for creation, but found %s", taskCommentId));
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void verifyTaskCommentIdIsNotNullOrEmpty(String taskCommentId) throws InvalidArgumentException {
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskCommentId == null || taskCommentId.isEmpty()) {
            throw new InvalidArgumentException("taskCommentId must not be null/empty for retrieval/deletion");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCommentServiceImpl.java", TaskCommentServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "newTaskComment", "io.kadai.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskId", "", "io.kadai.task.api.models.TaskComment"), 63);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "updateTaskComment", "io.kadai.task.internal.TaskCommentServiceImpl", "io.kadai.task.api.models.TaskComment", "taskCommentToUpdate", "io.kadai.common.api.exceptions.ConcurrencyException:io.kadai.task.api.exceptions.TaskCommentNotFoundException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.task.api.exceptions.NotAuthorizedOnTaskCommentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.TaskComment"), 71);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "createTaskComment", "io.kadai.task.internal.TaskCommentServiceImpl", "io.kadai.task.api.models.TaskComment", "taskCommentToCreate", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.TaskComment"), 117);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "deleteTaskComment", "io.kadai.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskCommentId", "io.kadai.task.api.exceptions.TaskCommentNotFoundException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.task.api.exceptions.NotAuthorizedOnTaskCommentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 143);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getTaskComments", "io.kadai.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "java.util.List"), 178);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getTaskComment", "io.kadai.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskCommentId", "io.kadai.task.api.exceptions.TaskCommentNotFoundException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.TaskComment"), 200);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkModifiedHasNotChanged", "io.kadai.task.internal.TaskCommentServiceImpl", "io.kadai.task.api.models.TaskComment:io.kadai.task.api.models.TaskComment", "oldTaskComment:taskCommentImplToUpdate", "io.kadai.common.api.exceptions.ConcurrencyException", "void"), 236);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initDefaultTaskCommentValues", "io.kadai.task.internal.TaskCommentServiceImpl", "io.kadai.task.internal.models.TaskCommentImpl", "taskCommentImplToCreate", "", "void"), 244);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateNoneExistingTaskCommentId", "io.kadai.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskCommentId", "io.kadai.common.api.exceptions.InvalidArgumentException", "void"), 262);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "verifyTaskCommentIdIsNotNullOrEmpty", "io.kadai.task.internal.TaskCommentServiceImpl", "java.lang.String", "taskCommentId", "io.kadai.common.api.exceptions.InvalidArgumentException", "void"), 272);
    }
}

