/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.workbasket.api;

import io.kadai.common.api.BulkOperationResults;
import io.kadai.common.api.exceptions.ConcurrencyException;
import io.kadai.common.api.exceptions.DomainNotFoundException;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.workbasket.api.WorkbasketAccessItemQuery;
import io.kadai.workbasket.api.WorkbasketPermission;
import io.kadai.workbasket.api.WorkbasketQuery;
import io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import io.kadai.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import io.kadai.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import io.kadai.workbasket.api.exceptions.WorkbasketInUseException;
import io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException;
import io.kadai.workbasket.api.models.Workbasket;
import io.kadai.workbasket.api.models.WorkbasketAccessItem;
import io.kadai.workbasket.api.models.WorkbasketSummary;
import java.util.List;

public interface WorkbasketService {
    public Workbasket newWorkbasket(String var1, String var2);

    public Workbasket createWorkbasket(Workbasket var1) throws InvalidArgumentException, WorkbasketAlreadyExistException, DomainNotFoundException, NotAuthorizedException;

    public Workbasket getWorkbasket(String var1) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    public Workbasket getWorkbasket(String var1, String var2) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    public Workbasket updateWorkbasket(Workbasket var1) throws InvalidArgumentException, WorkbasketNotFoundException, ConcurrencyException, NotAuthorizedException, NotAuthorizedOnWorkbasketException;

    public boolean deleteWorkbasket(String var1) throws WorkbasketNotFoundException, WorkbasketInUseException, InvalidArgumentException, NotAuthorizedException, NotAuthorizedOnWorkbasketException;

    public BulkOperationResults<String, KadaiException> deleteWorkbaskets(List<String> var1) throws InvalidArgumentException, NotAuthorizedException;

    public void setDistributionTargets(String var1, List<String> var2) throws WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException;

    public List<WorkbasketSummary> getDistributionTargets(String var1) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    public List<WorkbasketSummary> getDistributionTargets(String var1, String var2) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    public List<WorkbasketSummary> getDistributionSources(String var1) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    public List<WorkbasketSummary> getDistributionSources(String var1, String var2) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    public void addDistributionTarget(String var1, String var2) throws WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException;

    public void removeDistributionTarget(String var1, String var2) throws NotAuthorizedException, NotAuthorizedOnWorkbasketException;

    public WorkbasketAccessItem newWorkbasketAccessItem(String var1, String var2);

    public WorkbasketAccessItem createWorkbasketAccessItem(WorkbasketAccessItem var1) throws InvalidArgumentException, WorkbasketNotFoundException, WorkbasketAccessItemAlreadyExistException, NotAuthorizedException;

    public void setWorkbasketAccessItems(String var1, List<WorkbasketAccessItem> var2) throws InvalidArgumentException, WorkbasketAccessItemAlreadyExistException, WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException;

    public List<WorkbasketAccessItem> getWorkbasketAccessItems(String var1) throws NotAuthorizedException;

    public WorkbasketAccessItem updateWorkbasketAccessItem(WorkbasketAccessItem var1) throws InvalidArgumentException, NotAuthorizedException;

    public void deleteWorkbasketAccessItem(String var1) throws NotAuthorizedException;

    public void deleteWorkbasketAccessItemsForAccessId(String var1) throws NotAuthorizedException;

    public WorkbasketQuery createWorkbasketQuery();

    public WorkbasketAccessItemQuery createWorkbasketAccessItemQuery() throws NotAuthorizedException;

    public List<WorkbasketPermission> getPermissionsForWorkbasket(String var1);

    public void checkAuthorization(String var1, WorkbasketPermission ... var2) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;

    public void checkAuthorization(String var1, String var2, WorkbasketPermission ... var3) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException;
}

