/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.workbasket.api.exceptions;

import io.kadai.common.api.exceptions.ErrorCode;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.workbasket.api.WorkbasketPermission;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class NotAuthorizedOnWorkbasketException
extends KadaiException {
    public static final String ERROR_KEY_KEY_DOMAIN = "NOT_AUTHORIZED_ON_WORKBASKET_WITH_KEY_AND_DOMAIN";
    public static final String ERROR_KEY_ID = "NOT_AUTHORIZED_ON_WORKBASKET_WITH_ID";
    private final String currentUserId;
    private final WorkbasketPermission[] requiredPermissions;
    private final String workbasketId;
    private final String workbasketKey;
    private final String domain;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public NotAuthorizedOnWorkbasketException(String currentUserId, String workbasketId, WorkbasketPermission ... requiredPermissions) {
        super(String.format("Not authorized. The current user '%s' has no '%s' permission(s) for Workbasket '%s'.", currentUserId, Arrays.toString((Object[])requiredPermissions), workbasketId), ErrorCode.of((String)ERROR_KEY_ID, Map.ofEntries(Map.entry("currentUserId", NotAuthorizedOnWorkbasketException.ensureNullIsHandled((Serializable)((Object)currentUserId))), Map.entry("workbasketId", NotAuthorizedOnWorkbasketException.ensureNullIsHandled((Serializable)((Object)workbasketId))), Map.entry("requiredPermissions", NotAuthorizedOnWorkbasketException.ensureNullIsHandled((Serializable)requiredPermissions)))));
        this.currentUserId = currentUserId;
        this.requiredPermissions = requiredPermissions;
        this.workbasketId = workbasketId;
        this.workbasketKey = null;
        this.domain = null;
    }

    public NotAuthorizedOnWorkbasketException(String currentUserId, String workbasketKey, String domain, WorkbasketPermission ... requiredPermissions) {
        super(String.format("Not authorized. The current user '%s' has no '%s' permission for Workbasket with key '%s' in domain '%s'.", currentUserId, Arrays.toString((Object[])requiredPermissions), workbasketKey, domain), ErrorCode.of((String)ERROR_KEY_KEY_DOMAIN, Map.ofEntries(Map.entry("currentUserId", NotAuthorizedOnWorkbasketException.ensureNullIsHandled((Serializable)((Object)currentUserId))), Map.entry("workbasketKey", NotAuthorizedOnWorkbasketException.ensureNullIsHandled((Serializable)((Object)workbasketKey))), Map.entry("domain", NotAuthorizedOnWorkbasketException.ensureNullIsHandled((Serializable)((Object)domain))), Map.entry("requiredPermissions", NotAuthorizedOnWorkbasketException.ensureNullIsHandled((Serializable)requiredPermissions)))));
        this.currentUserId = currentUserId;
        this.requiredPermissions = requiredPermissions;
        this.workbasketKey = workbasketKey;
        this.domain = domain;
        this.workbasketId = null;
    }

    public String getWorkbasketKey() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.workbasketKey);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getDomain() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.domain);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getWorkbasketId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.workbasketId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public WorkbasketPermission[] getRequiredPermissions() {
        WorkbasketPermission[] workbasketPermissionArray;
        WorkbasketPermission[] workbasketPermissionArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketPermission[] workbasketPermissionArray3 = workbasketPermissionArray2 = (workbasketPermissionArray = this.requiredPermissions);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketPermissionArray2);
        return workbasketPermissionArray;
    }

    public String getCurrentUserId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.currentUserId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    static {
        NotAuthorizedOnWorkbasketException.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NotAuthorizedOnWorkbasketException.java", NotAuthorizedOnWorkbasketException.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketKey", "io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "", "", "", "java.lang.String"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomain", "io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "", "", "", "java.lang.String"), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketId", "io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "", "", "", "java.lang.String"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequiredPermissions", "io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "", "", "", "[Lio.kadai.workbasket.api.WorkbasketPermission;"), 100);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCurrentUserId", "io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "", "", "", "java.lang.String"), 104);
    }
}

