/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.workbasket.internal;

import io.kadai.KadaiConfiguration;
import io.kadai.common.api.BulkOperationResults;
import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.SharedConstants;
import io.kadai.common.api.exceptions.ConcurrencyException;
import io.kadai.common.api.exceptions.DomainNotFoundException;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.util.IdGenerator;
import io.kadai.common.internal.util.LogSanitizer;
import io.kadai.common.internal.util.ObjectAttributeChangeDetector;
import io.kadai.spi.history.api.events.workbasket.WorkbasketAccessItemCreatedEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketAccessItemDeletedEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketAccessItemUpdatedEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketAccessItemsUpdatedEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketCreatedEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketDeletedEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketDistributionTargetAddedEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketDistributionTargetRemovedEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketDistributionTargetsUpdatedEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketMarkedForDeletionEvent;
import io.kadai.spi.history.api.events.workbasket.WorkbasketUpdatedEvent;
import io.kadai.spi.history.internal.HistoryEventManager;
import io.kadai.task.api.TaskState;
import io.kadai.workbasket.api.WorkbasketAccessItemQuery;
import io.kadai.workbasket.api.WorkbasketPermission;
import io.kadai.workbasket.api.WorkbasketQuery;
import io.kadai.workbasket.api.WorkbasketService;
import io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import io.kadai.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import io.kadai.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import io.kadai.workbasket.api.exceptions.WorkbasketInUseException;
import io.kadai.workbasket.api.exceptions.WorkbasketMarkedForDeletionException;
import io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException;
import io.kadai.workbasket.api.models.Workbasket;
import io.kadai.workbasket.api.models.WorkbasketAccessItem;
import io.kadai.workbasket.api.models.WorkbasketSummary;
import io.kadai.workbasket.internal.DistributionTargetMapper;
import io.kadai.workbasket.internal.WorkbasketAccessItemQueryImpl;
import io.kadai.workbasket.internal.WorkbasketAccessMapper;
import io.kadai.workbasket.internal.WorkbasketMapper;
import io.kadai.workbasket.internal.WorkbasketQueryImpl;
import io.kadai.workbasket.internal.models.WorkbasketAccessItemImpl;
import io.kadai.workbasket.internal.models.WorkbasketImpl;
import io.kadai.workbasket.internal.models.WorkbasketSummaryImpl;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbasketServiceImpl
implements WorkbasketService {
    private static final Logger LOGGER;
    private final InternalKadaiEngine kadaiEngine;
    private final WorkbasketMapper workbasketMapper;
    private final DistributionTargetMapper distributionTargetMapper;
    private final WorkbasketAccessMapper workbasketAccessMapper;
    private final HistoryEventManager historyEventManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;

    static {
        WorkbasketServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(WorkbasketServiceImpl.class);
    }

    public WorkbasketServiceImpl(InternalKadaiEngine kadaiEngine, HistoryEventManager historyEventManager, WorkbasketMapper workbasketMapper, DistributionTargetMapper distributionTargetMapper, WorkbasketAccessMapper workbasketAccessMapper) {
        this.kadaiEngine = kadaiEngine;
        this.workbasketMapper = workbasketMapper;
        this.distributionTargetMapper = distributionTargetMapper;
        this.workbasketAccessMapper = workbasketAccessMapper;
        this.historyEventManager = historyEventManager;
    }

    @Override
    public Workbasket getWorkbasket(String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        WorkbasketImpl workbasketImpl;
        WorkbasketImpl workbasketImpl2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.kadaiEngine.openConnection();
            WorkbasketImpl result = this.workbasketMapper.findById(workbasketId);
            if (result == null) {
                throw new WorkbasketNotFoundException(workbasketId);
            }
            if (!this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN, KadaiRole.BUSINESS_ADMIN, KadaiRole.TASK_ADMIN, KadaiRole.TASK_ROUTER)) {
                this.checkAuthorization(workbasketId, WorkbasketPermission.READ);
            }
            WorkbasketImpl workbasketImpl3 = result;
            workbasketImpl2 = workbasketImpl3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        WorkbasketImpl workbasketImpl4 = workbasketImpl = workbasketImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketImpl);
        return workbasketImpl2;
    }

    @Override
    public Workbasket getWorkbasket(String workbasketKey, String domain) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        Workbasket workbasket;
        Workbasket workbasket2;
        Workbasket workbasket3;
        String string = workbasketKey;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN, KadaiRole.BUSINESS_ADMIN, KadaiRole.TASK_ADMIN, KadaiRole.TASK_ROUTER)) {
            this.checkAuthorization(workbasketKey, domain, WorkbasketPermission.READ);
        }
        if ((workbasket3 = (Workbasket)this.kadaiEngine.executeInDatabaseConnection(() -> this.workbasketMapper.findByKeyAndDomain(workbasketKey, domain))) == null) {
            throw new WorkbasketNotFoundException(workbasketKey, domain);
        }
        Workbasket workbasket4 = workbasket2 = (workbasket = workbasket3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasket2);
        return workbasket;
    }

    @Override
    public Workbasket createWorkbasket(Workbasket newWorkbasket) throws InvalidArgumentException, WorkbasketAlreadyExistException, DomainNotFoundException, NotAuthorizedException {
        WorkbasketImpl workbasketImpl;
        WorkbasketImpl workbasketImpl2;
        Workbasket workbasket = newWorkbasket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workbasket);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        WorkbasketImpl workbasket2 = (WorkbasketImpl)newWorkbasket;
        try {
            this.kadaiEngine.openConnection();
            Instant now = Instant.now();
            workbasket2.setCreated(now);
            workbasket2.setModified(now);
            WorkbasketImpl existingWorkbasket = this.workbasketMapper.findByKeyAndDomain(newWorkbasket.getKey(), newWorkbasket.getDomain());
            if (existingWorkbasket != null) {
                throw new WorkbasketAlreadyExistException(existingWorkbasket.getKey(), existingWorkbasket.getDomain());
            }
            if (workbasket2.getId() == null || workbasket2.getId().isEmpty()) {
                workbasket2.setId(IdGenerator.generateWithPrefix((String)"WBI"));
            }
            this.validateWorkbasket(workbasket2);
            this.workbasketMapper.insert(workbasket2);
            if (this.historyEventManager.isEnabled()) {
                String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)this.newWorkbasket("", SharedConstants.MASTER_DOMAIN), (Object)newWorkbasket);
                this.historyEventManager.createEvent(new WorkbasketCreatedEvent(IdGenerator.generateWithPrefix((String)"WHI"), newWorkbasket, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method createWorkbasket() created Workbasket '{}'", (Object)workbasket2);
            }
            WorkbasketImpl workbasketImpl3 = workbasket2;
            workbasketImpl2 = workbasketImpl3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        WorkbasketImpl workbasketImpl4 = workbasketImpl = workbasketImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketImpl);
        return workbasketImpl2;
    }

    @Override
    public Workbasket updateWorkbasket(Workbasket workbasketToUpdate) throws InvalidArgumentException, WorkbasketNotFoundException, ConcurrencyException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        WorkbasketImpl workbasketImpl;
        WorkbasketImpl workbasketImpl2;
        Workbasket workbasket = workbasketToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)workbasket);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        WorkbasketImpl workbasketImplToUpdate = (WorkbasketImpl)workbasketToUpdate;
        this.validateNameAndType(workbasketToUpdate);
        try {
            Workbasket oldWorkbasket;
            this.kadaiEngine.openConnection();
            if (workbasketImplToUpdate.getId() == null || workbasketImplToUpdate.getId().isEmpty()) {
                oldWorkbasket = this.getWorkbasket(workbasketImplToUpdate.getKey(), workbasketImplToUpdate.getDomain());
            } else {
                oldWorkbasket = this.getWorkbasket(workbasketImplToUpdate.getId());
                if (!oldWorkbasket.getKey().equals(workbasketToUpdate.getKey()) || !oldWorkbasket.getDomain().equals(workbasketToUpdate.getDomain())) {
                    throw new WorkbasketNotFoundException(workbasketToUpdate.getKey(), workbasketToUpdate.getDomain());
                }
            }
            this.checkModifiedHasNotChanged(oldWorkbasket, workbasketImplToUpdate);
            workbasketImplToUpdate.setModified(Instant.now());
            if (workbasketImplToUpdate.getId() == null || workbasketImplToUpdate.getId().isEmpty()) {
                this.workbasketMapper.updateByKeyAndDomain(workbasketImplToUpdate);
            } else {
                this.workbasketMapper.update(workbasketImplToUpdate);
            }
            if (this.historyEventManager.isEnabled()) {
                String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldWorkbasket, (Object)workbasketToUpdate);
                this.historyEventManager.createEvent(new WorkbasketUpdatedEvent(IdGenerator.generateWithPrefix((String)"WHI"), workbasketToUpdate, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method updateWorkbasket() updated workbasket '{}'", (Object)workbasketImplToUpdate.getId());
            }
            WorkbasketImpl workbasketImpl3 = workbasketImplToUpdate;
            workbasketImpl2 = workbasketImpl3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        WorkbasketImpl workbasketImpl4 = workbasketImpl = workbasketImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketImpl);
        return workbasketImpl2;
    }

    @Override
    public WorkbasketAccessItem newWorkbasketAccessItem(String workbasketId, String accessId) {
        WorkbasketAccessItemImpl workbasketAccessItemImpl;
        WorkbasketAccessItemImpl workbasketAccessItemImpl2;
        String string = workbasketId;
        String string2 = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketAccessItemImpl accessItem = new WorkbasketAccessItemImpl();
        accessItem.setWorkbasketId(workbasketId);
        if (KadaiConfiguration.shouldUseLowerCaseForAccessIds()) {
            accessItem.setAccessId(accessId != null ? accessId.toLowerCase() : null);
        } else {
            accessItem.setAccessId(accessId);
        }
        WorkbasketAccessItemImpl workbasketAccessItemImpl3 = workbasketAccessItemImpl2 = (workbasketAccessItemImpl = accessItem);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketAccessItemImpl2);
        return workbasketAccessItemImpl;
    }

    @Override
    public WorkbasketAccessItem createWorkbasketAccessItem(WorkbasketAccessItem workbasketAccessItem) throws InvalidArgumentException, WorkbasketNotFoundException, WorkbasketAccessItemAlreadyExistException, NotAuthorizedException {
        WorkbasketAccessItemImpl workbasketAccessItemImpl;
        WorkbasketAccessItemImpl workbasketAccessItemImpl2;
        WorkbasketAccessItem workbasketAccessItem2 = workbasketAccessItem;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)workbasketAccessItem2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        WorkbasketAccessItemImpl accessItem = (WorkbasketAccessItemImpl)workbasketAccessItem;
        try {
            this.kadaiEngine.openConnection();
            accessItem.setId(IdGenerator.generateWithPrefix((String)"WAI"));
            if (workbasketAccessItem.getId() == null || workbasketAccessItem.getAccessId() == null || workbasketAccessItem.getWorkbasketId() == null) {
                throw new InvalidArgumentException(String.format("Checking the preconditions of the current WorkbasketAccessItem failed. WorkbasketAccessItem=%s", workbasketAccessItem));
            }
            WorkbasketImpl wb = this.workbasketMapper.findById(workbasketAccessItem.getWorkbasketId());
            if (wb == null) {
                throw new WorkbasketNotFoundException(workbasketAccessItem.getWorkbasketId());
            }
            accessItem.setWorkbasketKey(wb.getKey());
            try {
                this.workbasketAccessMapper.insert(accessItem);
                if (this.historyEventManager.isEnabled()) {
                    String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)this.newWorkbasketAccessItem("", ""), (Object)accessItem);
                    this.historyEventManager.createEvent(new WorkbasketAccessItemCreatedEvent(IdGenerator.generateWithPrefix((String)"WHI"), wb, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Method createWorkbasketAccessItem() created workbaskteAccessItem {}", (Object)accessItem);
                }
            }
            catch (PersistenceException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("when trying to insert WorkbasketAccessItem {} caught exception", (Object)accessItem, (Object)e);
                }
                Stream<String> accessItemExistsIdentifier = Stream.of("SQLCODE=-803", "uc_accessid_wbid", "UC_ACCESSID_WBID_INDEX_E", "ORA-00001");
                if (accessItemExistsIdentifier.anyMatch(e.getMessage()::contains)) {
                    throw new WorkbasketAccessItemAlreadyExistException(accessItem.getAccessId(), accessItem.getWorkbasketId());
                }
                throw e;
            }
            WorkbasketAccessItemImpl workbasketAccessItemImpl3 = accessItem;
            workbasketAccessItemImpl2 = workbasketAccessItemImpl3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        WorkbasketAccessItemImpl workbasketAccessItemImpl4 = workbasketAccessItemImpl = workbasketAccessItemImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketAccessItemImpl);
        return workbasketAccessItemImpl2;
    }

    @Override
    public WorkbasketAccessItem updateWorkbasketAccessItem(WorkbasketAccessItem workbasketAccessItem) throws InvalidArgumentException, NotAuthorizedException {
        WorkbasketAccessItemImpl workbasketAccessItemImpl;
        WorkbasketAccessItemImpl workbasketAccessItemImpl2;
        WorkbasketAccessItem workbasketAccessItem2 = workbasketAccessItem;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)workbasketAccessItem2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        WorkbasketAccessItemImpl accessItem = (WorkbasketAccessItemImpl)workbasketAccessItem;
        try {
            this.kadaiEngine.openConnection();
            WorkbasketAccessItemImpl originalItem = this.workbasketAccessMapper.findById(accessItem.getId());
            if (originalItem.getAccessId() != null && !originalItem.getAccessId().equals(accessItem.getAccessId()) || originalItem.getWorkbasketId() != null && !originalItem.getWorkbasketId().equals(accessItem.getWorkbasketId())) {
                throw new InvalidArgumentException("AccessId and WorkbasketId must not be changed in updateWorkbasketAccessItem calls");
            }
            this.workbasketAccessMapper.update(accessItem);
            if (this.historyEventManager.isEnabled()) {
                String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)originalItem, (Object)accessItem);
                WorkbasketImpl workbasket = this.workbasketMapper.findById(accessItem.getWorkbasketId());
                this.historyEventManager.createEvent(new WorkbasketAccessItemUpdatedEvent(IdGenerator.generateWithPrefix((String)"WHI"), workbasket, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method updateWorkbasketAccessItem() updated workbasketAccessItem {}", (Object)accessItem);
            }
            WorkbasketAccessItemImpl workbasketAccessItemImpl3 = accessItem;
            workbasketAccessItemImpl2 = workbasketAccessItemImpl3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        WorkbasketAccessItemImpl workbasketAccessItemImpl4 = workbasketAccessItemImpl = workbasketAccessItemImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketAccessItemImpl);
        return workbasketAccessItemImpl2;
    }

    @Override
    public void deleteWorkbasketAccessItem(String accessItemId) throws NotAuthorizedException {
        String string = accessItemId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            WorkbasketAccessItemImpl accessItem = null;
            if (this.historyEventManager.isEnabled()) {
                accessItem = this.workbasketAccessMapper.findById(accessItemId);
            }
            this.workbasketAccessMapper.delete(accessItemId);
            if (this.historyEventManager.isEnabled() && accessItem != null) {
                String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)accessItem, (Object)this.newWorkbasketAccessItem("", ""));
                WorkbasketImpl workbasket = this.workbasketMapper.findById(accessItem.getWorkbasketId());
                this.historyEventManager.createEvent(new WorkbasketAccessItemDeletedEvent(IdGenerator.generateWithPrefix((String)"WHI"), workbasket, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method deleteWorkbasketAccessItem() deleted workbasketAccessItem wit Id {}", (Object)accessItemId);
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    @Override
    public void checkAuthorization(String workbasketId, WorkbasketPermission ... requestedPermissions) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        String string = workbasketId;
        WorkbasketPermission[] workbasketPermissionArray = requestedPermissions;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, (Object)workbasketPermissionArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Optional<List> grantedPermissions;
            this.kadaiEngine.openConnection();
            if (this.workbasketMapper.findById(workbasketId) == null) {
                throw new WorkbasketNotFoundException(workbasketId);
            }
            if (!(this.skipAuthorizationCheck(requestedPermissions) || !(grantedPermissions = Optional.ofNullable(this.workbasketAccessMapper.findByWorkbasketAndAccessId(workbasketId, this.kadaiEngine.getEngine().getCurrentUserContext().getAccessIds())).map(this::getPermissionsFromWorkbasketAccessItem)).isEmpty() && new HashSet(grantedPermissions.get()).containsAll(Arrays.asList(requestedPermissions)))) {
                throw new NotAuthorizedOnWorkbasketException(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), workbasketId, requestedPermissions);
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var9_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_8);
    }

    @Override
    public void checkAuthorization(String workbasketKey, String domain, WorkbasketPermission ... requestedPermissions) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        String string = workbasketKey;
        String string2 = domain;
        WorkbasketPermission[] workbasketPermissionArray = requestedPermissions;
        Object[] objectArray = new Object[]{string, string2, workbasketPermissionArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Optional<List> grantedPermissions;
            this.kadaiEngine.openConnection();
            if (this.workbasketMapper.findByKeyAndDomain(workbasketKey, domain) == null) {
                throw new WorkbasketNotFoundException(workbasketKey, domain);
            }
            if (!(this.skipAuthorizationCheck(requestedPermissions) || !(grantedPermissions = Optional.ofNullable(this.workbasketAccessMapper.findByWorkbasketKeyDomainAndAccessId(workbasketKey, domain, this.kadaiEngine.getEngine().getCurrentUserContext().getAccessIds())).map(this::getPermissionsFromWorkbasketAccessItem)).isEmpty() && new HashSet(grantedPermissions.get()).containsAll(Arrays.asList(requestedPermissions)))) {
                throw new NotAuthorizedOnWorkbasketException(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), workbasketKey, domain, requestedPermissions);
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var12_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var12_11);
    }

    @Override
    public List<WorkbasketAccessItem> getWorkbasketAccessItems(String workbasketId) throws NotAuthorizedException {
        ArrayList<WorkbasketAccessItem> arrayList;
        ArrayList<WorkbasketAccessItem> arrayList2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        ArrayList<WorkbasketAccessItem> result = new ArrayList<WorkbasketAccessItem>();
        try {
            this.kadaiEngine.openConnection();
            List<WorkbasketAccessItemImpl> queryResult = this.workbasketAccessMapper.findByWorkbasketId(workbasketId);
            result.addAll(queryResult);
            ArrayList<WorkbasketAccessItem> arrayList3 = result;
            arrayList2 = arrayList3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        ArrayList<WorkbasketAccessItem> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public void setWorkbasketAccessItems(String workbasketId, List<WorkbasketAccessItem> wbAccessItems) throws WorkbasketAccessItemAlreadyExistException, InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        String string = workbasketId;
        List<WorkbasketAccessItem> list = wbAccessItems;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        Set<WorkbasketAccessItemImpl> accessItems = this.checkAccessItemsPreconditionsAndSetId(workbasketId, wbAccessItems);
        try {
            this.kadaiEngine.openConnection();
            this.getWorkbasket(workbasketId);
            List<Object> originalAccessItems = new ArrayList();
            if (this.historyEventManager.isEnabled()) {
                originalAccessItems = this.workbasketAccessMapper.findByWorkbasketId(workbasketId);
            }
            this.workbasketAccessMapper.deleteAllAccessItemsForWorkbasketId(workbasketId);
            accessItems.forEach(this.workbasketAccessMapper::insert);
            if (this.historyEventManager.isEnabled()) {
                String details = ObjectAttributeChangeDetector.determineChangesInAttributes(originalAccessItems, new ArrayList<WorkbasketAccessItemImpl>(accessItems));
                WorkbasketImpl workbasket = this.workbasketMapper.findById(workbasketId);
                this.historyEventManager.createEvent(new WorkbasketAccessItemsUpdatedEvent(IdGenerator.generateWithPrefix((String)"WHI"), workbasket, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var12_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var12_11);
    }

    @Override
    public WorkbasketQuery createWorkbasketQuery() {
        WorkbasketQueryImpl workbasketQueryImpl;
        WorkbasketQueryImpl workbasketQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketQueryImpl workbasketQueryImpl3 = workbasketQueryImpl2 = (workbasketQueryImpl = new WorkbasketQueryImpl(this.kadaiEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketQueryImpl2);
        return workbasketQueryImpl;
    }

    @Override
    public WorkbasketAccessItemQuery createWorkbasketAccessItemQuery() throws NotAuthorizedException {
        WorkbasketAccessItemQueryImpl workbasketAccessItemQueryImpl;
        WorkbasketAccessItemQueryImpl workbasketAccessItemQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.ADMIN, KadaiRole.BUSINESS_ADMIN);
        WorkbasketAccessItemQueryImpl workbasketAccessItemQueryImpl3 = workbasketAccessItemQueryImpl2 = (workbasketAccessItemQueryImpl = new WorkbasketAccessItemQueryImpl(this.kadaiEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketAccessItemQueryImpl2);
        return workbasketAccessItemQueryImpl;
    }

    @Override
    public Workbasket newWorkbasket(String key, String domain) {
        WorkbasketImpl workbasketImpl;
        WorkbasketImpl workbasketImpl2;
        String string = key;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketImpl wb = new WorkbasketImpl();
        wb.setDomain(domain);
        wb.setKey(key);
        WorkbasketImpl workbasketImpl3 = workbasketImpl2 = (workbasketImpl = wb);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketImpl2);
        return workbasketImpl;
    }

    @Override
    public List<WorkbasketPermission> getPermissionsForWorkbasket(String workbasketId) {
        List<WorkbasketPermission> list;
        List<WorkbasketPermission> list2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketAccessItemImpl wbAcc = this.workbasketAccessMapper.findByWorkbasketAndAccessId(workbasketId, this.kadaiEngine.getEngine().getCurrentUserContext().getAccessIds());
        List<WorkbasketPermission> list3 = list2 = (list = this.getPermissionsFromWorkbasketAccessItem(wbAcc));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    @Override
    public List<WorkbasketSummary> getDistributionTargets(String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        ArrayList<WorkbasketSummary> arrayList;
        ArrayList<WorkbasketSummary> arrayList2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<WorkbasketSummary> result = new ArrayList<WorkbasketSummary>();
        try {
            this.kadaiEngine.openConnection();
            this.getWorkbasket(workbasketId);
            if (!this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN, KadaiRole.BUSINESS_ADMIN, KadaiRole.TASK_ADMIN)) {
                this.checkAuthorization(workbasketId, WorkbasketPermission.READ);
            }
            List<WorkbasketSummaryImpl> distributionTargets = this.workbasketMapper.findDistributionTargets(workbasketId);
            result.addAll(distributionTargets);
            ArrayList<WorkbasketSummary> arrayList3 = result;
            arrayList2 = arrayList3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        ArrayList<WorkbasketSummary> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public List<WorkbasketSummary> getDistributionTargets(String workbasketKey, String domain) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        ArrayList<WorkbasketSummary> arrayList;
        ArrayList<WorkbasketSummary> arrayList2;
        String string = workbasketKey;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<WorkbasketSummary> result = new ArrayList<WorkbasketSummary>();
        try {
            this.kadaiEngine.openConnection();
            Workbasket workbasket = this.getWorkbasket(workbasketKey, domain);
            if (!this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN, KadaiRole.BUSINESS_ADMIN, KadaiRole.TASK_ADMIN)) {
                this.checkAuthorization(workbasket.getId(), WorkbasketPermission.READ);
            }
            List<WorkbasketSummaryImpl> distributionTargets = this.workbasketMapper.findDistributionTargets(workbasket.getId());
            result.addAll(distributionTargets);
            ArrayList<WorkbasketSummary> arrayList3 = result;
            arrayList2 = arrayList3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        ArrayList<WorkbasketSummary> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public void setDistributionTargets(String sourceWorkbasketId, List<String> targetWorkbasketIds) throws WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        String string = sourceWorkbasketId;
        List<String> list = targetWorkbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            WorkbasketImpl sourceWorkbasket = (WorkbasketImpl)this.getWorkbasket(sourceWorkbasketId);
            List<Object> originalTargetWorkbasketIds = new ArrayList();
            if (this.historyEventManager.isEnabled()) {
                originalTargetWorkbasketIds = this.distributionTargetMapper.findBySourceId(sourceWorkbasketId);
            }
            this.distributionTargetMapper.deleteAllDistributionTargetsBySourceId(sourceWorkbasketId);
            sourceWorkbasket.setModified(Instant.now());
            this.workbasketMapper.update(sourceWorkbasket);
            if (targetWorkbasketIds != null) {
                for (String targetId : targetWorkbasketIds) {
                    this.getWorkbasket(targetId);
                    this.distributionTargetMapper.insert(sourceWorkbasketId, targetId);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Method setDistributionTargets() created distribution target for source '{}' and target {}", (Object)LogSanitizer.stripLineBreakingChars((Object)sourceWorkbasketId), (Object)LogSanitizer.stripLineBreakingChars((Object)targetId));
                }
                if (this.historyEventManager.isEnabled() && !targetWorkbasketIds.isEmpty()) {
                    String details = ObjectAttributeChangeDetector.determineChangesInAttributes(originalTargetWorkbasketIds, targetWorkbasketIds);
                    this.historyEventManager.createEvent(new WorkbasketDistributionTargetsUpdatedEvent(IdGenerator.generateWithPrefix((String)"WHI"), sourceWorkbasket, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
            }
        }
        catch (Throwable throwable) {
            this.kadaiEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("setDistributionTargets set {} distribution targets to source workbasket {} ", (Object)(targetWorkbasketIds == null ? 0 : targetWorkbasketIds.size()), (Object)sourceWorkbasketId);
            }
            throw throwable;
        }
        this.kadaiEngine.returnConnection();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setDistributionTargets set {} distribution targets to source workbasket {} ", (Object)(targetWorkbasketIds == null ? 0 : targetWorkbasketIds.size()), (Object)sourceWorkbasketId);
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    @Override
    public void addDistributionTarget(String sourceWorkbasketId, String targetWorkbasketId) throws WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        String string = sourceWorkbasketId;
        String string2 = targetWorkbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            WorkbasketImpl sourceWorkbasket = (WorkbasketImpl)this.getWorkbasket(sourceWorkbasketId);
            this.getWorkbasket(targetWorkbasketId);
            int numOfDistTargets = this.distributionTargetMapper.getNumberOfDistributionTargets(sourceWorkbasketId, targetWorkbasketId);
            if (numOfDistTargets > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("addDistributionTarget detected that the specified distribution target exists already. Doing nothing.");
                }
            } else {
                this.distributionTargetMapper.insert(sourceWorkbasketId, targetWorkbasketId);
                if (this.historyEventManager.isEnabled()) {
                    String details = "{\"changes\":{\"newValue\":\"" + targetWorkbasketId + "\",\"oldValue\":\"\"}}";
                    this.historyEventManager.createEvent(new WorkbasketDistributionTargetAddedEvent(IdGenerator.generateWithPrefix((String)"WHI"), sourceWorkbasket, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("addDistributionTarget inserted distribution target sourceId = {}, targetId = {}", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
                }
                sourceWorkbasket.setModified(Instant.now());
                this.workbasketMapper.update(sourceWorkbasket);
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    @Override
    public void removeDistributionTarget(String sourceWorkbasketId, String targetWorkbasketId) throws NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        String string = sourceWorkbasketId;
        String string2 = targetWorkbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            int numberOfDistTargets = this.distributionTargetMapper.getNumberOfDistributionTargets(sourceWorkbasketId, targetWorkbasketId);
            if (numberOfDistTargets > 0) {
                WorkbasketImpl workbasket;
                this.distributionTargetMapper.delete(sourceWorkbasketId, targetWorkbasketId);
                if (this.historyEventManager.isEnabled() && (workbasket = this.workbasketMapper.findById(sourceWorkbasketId)) != null) {
                    String details = "{\"changes\":{\"newValue\":\"\",\"oldValue\":\"" + targetWorkbasketId + "\"}}";
                    this.historyEventManager.createEvent(new WorkbasketDistributionTargetRemovedEvent(IdGenerator.generateWithPrefix((String)"WHI"), workbasket, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("removeDistributionTarget deleted distribution target sourceId = {}, targetId = {}", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
                }
                try {
                    WorkbasketImpl sourceWorkbasket = (WorkbasketImpl)this.getWorkbasket(sourceWorkbasketId);
                    sourceWorkbasket.setModified(Instant.now());
                    this.workbasketMapper.update(sourceWorkbasket);
                }
                catch (WorkbasketNotFoundException workbasketNotFoundException) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("removeDistributionTarget found that the source workbasket {} doesn't exist. Ignoring the request... ", (Object)sourceWorkbasketId);
                    }
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("removeDistributionTarget detected that the specified distribution target doesn't exist. Doing nothing...");
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    @Override
    public boolean deleteWorkbasket(String workbasketId) throws WorkbasketNotFoundException, WorkbasketInUseException, InvalidArgumentException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        boolean bl;
        boolean bl2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        this.validateId(workbasketId);
        try {
            boolean canBeDeletedNow;
            Workbasket workbasketToDelete;
            this.kadaiEngine.openConnection();
            try {
                workbasketToDelete = this.getWorkbasket(workbasketId);
            }
            catch (WorkbasketNotFoundException ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Workbasket with workbasketId = {} is already deleted?", (Object)workbasketId);
                }
                throw ex;
            }
            long countTasksNotCompletedInWorkbasket = this.kadaiEngine.getEngine().runAsAdmin(() -> this.getCountTasksNotCompletedByWorkbasketId(workbasketId));
            if (countTasksNotCompletedInWorkbasket > 0L) {
                throw new WorkbasketInUseException(workbasketId);
            }
            long countTasksInWorkbasket = this.kadaiEngine.getEngine().runAsAdmin(() -> this.getCountTasksByWorkbasketId(workbasketId));
            boolean bl3 = canBeDeletedNow = countTasksInWorkbasket == 0L;
            if (canBeDeletedNow) {
                this.workbasketMapper.delete(workbasketId);
                this.deleteReferencesToWorkbasket(workbasketId);
                if (this.historyEventManager.isEnabled()) {
                    String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)workbasketToDelete, (Object)this.newWorkbasket("", SharedConstants.MASTER_DOMAIN));
                    this.historyEventManager.createEvent(new WorkbasketDeletedEvent(IdGenerator.generateWithPrefix((String)"WHI"), workbasketToDelete, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
            } else {
                this.markWorkbasketForDeletion(workbasketId);
            }
            boolean bl4 = canBeDeletedNow;
            bl2 = bl4;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        boolean bl5 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    @Override
    public BulkOperationResults<String, KadaiException> deleteWorkbaskets(List<String> workbasketsIds) throws InvalidArgumentException, NotAuthorizedException {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        List<String> list = workbasketsIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            if (workbasketsIds == null || workbasketsIds.isEmpty()) {
                throw new InvalidArgumentException("List of WorkbasketIds must not be null.");
            }
            BulkOperationResults bulkLog = new BulkOperationResults();
            Iterator<String> iterator = workbasketsIds.iterator();
            String workbasketIdForDeleting = null;
            while (iterator.hasNext()) {
                try {
                    workbasketIdForDeleting = iterator.next();
                    if (this.deleteWorkbasket(workbasketIdForDeleting)) continue;
                    bulkLog.addError((Object)workbasketIdForDeleting, (Exception)((Object)new WorkbasketMarkedForDeletionException(workbasketIdForDeleting)));
                }
                catch (KadaiException ex) {
                    bulkLog.addError((Object)workbasketIdForDeleting, (Exception)((Object)ex));
                }
            }
            BulkOperationResults bulkOperationResults3 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        BulkOperationResults bulkOperationResults4 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults2;
    }

    @Override
    public List<WorkbasketSummary> getDistributionSources(String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        ArrayList<WorkbasketSummary> arrayList;
        ArrayList<WorkbasketSummary> arrayList2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<WorkbasketSummary> result = new ArrayList<WorkbasketSummary>();
        try {
            this.kadaiEngine.openConnection();
            this.getWorkbasket(workbasketId);
            if (!this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN, KadaiRole.BUSINESS_ADMIN)) {
                this.checkAuthorization(workbasketId, WorkbasketPermission.READ);
            }
            List<WorkbasketSummaryImpl> distributionSources = this.workbasketMapper.findDistributionSources(workbasketId);
            result.addAll(distributionSources);
            ArrayList<WorkbasketSummary> arrayList3 = result;
            arrayList2 = arrayList3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        ArrayList<WorkbasketSummary> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public List<WorkbasketSummary> getDistributionSources(String workbasketKey, String domain) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        ArrayList<WorkbasketSummary> arrayList;
        ArrayList<WorkbasketSummary> arrayList2;
        String string = workbasketKey;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<WorkbasketSummary> result = new ArrayList<WorkbasketSummary>();
        try {
            this.kadaiEngine.openConnection();
            Workbasket workbasket = this.getWorkbasket(workbasketKey, domain);
            if (!this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN, KadaiRole.BUSINESS_ADMIN)) {
                this.checkAuthorization(workbasket.getId(), WorkbasketPermission.READ);
            }
            List<WorkbasketSummaryImpl> distributionSources = this.workbasketMapper.findDistributionSources(workbasket.getId());
            result.addAll(distributionSources);
            ArrayList<WorkbasketSummary> arrayList3 = result;
            arrayList2 = arrayList3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        ArrayList<WorkbasketSummary> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public void deleteWorkbasketAccessItemsForAccessId(String accessId) throws NotAuthorizedException {
        String string = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            if (KadaiConfiguration.shouldUseLowerCaseForAccessIds() && accessId != null) {
                accessId = accessId.toLowerCase();
            }
            List<Object> workbasketAccessItems = new ArrayList();
            if (this.historyEventManager.isEnabled()) {
                workbasketAccessItems = this.workbasketAccessMapper.findByAccessId(accessId);
            }
            this.workbasketAccessMapper.deleteAccessItemsForAccessId(accessId);
            if (this.historyEventManager.isEnabled()) {
                for (WorkbasketAccessItemImpl workbasketAccessItemImpl : workbasketAccessItems) {
                    String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)workbasketAccessItemImpl, (Object)new WorkbasketAccessItemImpl());
                    WorkbasketImpl workbasket = this.workbasketMapper.findById(workbasketAccessItemImpl.getWorkbasketId());
                    this.historyEventManager.createEvent(new WorkbasketAccessItemDeletedEvent(IdGenerator.generateWithPrefix((String)"WHI"), workbasket, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    public void checkModifiedHasNotChanged(Workbasket oldWorkbasket, WorkbasketImpl workbasketImplToUpdate) throws ConcurrencyException {
        Workbasket workbasket = oldWorkbasket;
        WorkbasketImpl workbasketImpl = workbasketImplToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)workbasket, (Object)workbasketImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!oldWorkbasket.getModified().equals(workbasketImplToUpdate.getModified())) {
            throw new ConcurrencyException(workbasketImplToUpdate.getId());
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private Set<WorkbasketAccessItemImpl> checkAccessItemsPreconditionsAndSetId(String workbasketId, List<WorkbasketAccessItem> wbAccessItems) throws InvalidArgumentException, WorkbasketAccessItemAlreadyExistException {
        HashSet<WorkbasketAccessItemImpl> hashSet;
        HashSet<WorkbasketAccessItemImpl> hashSet2;
        String string = workbasketId;
        List<WorkbasketAccessItem> list = wbAccessItems;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)string, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashSet<String> ids = new HashSet<String>();
        HashSet<WorkbasketAccessItemImpl> accessItems = new HashSet<WorkbasketAccessItemImpl>();
        for (WorkbasketAccessItem workbasketAccessItem : wbAccessItems) {
            if (workbasketAccessItem == null) continue;
            WorkbasketAccessItemImpl wbAccessItemImpl = (WorkbasketAccessItemImpl)workbasketAccessItem;
            if (wbAccessItemImpl.getWorkbasketId() == null) {
                throw new InvalidArgumentException(String.format("Checking the preconditions of the current WorkbasketAccessItem failed - WBID is NULL. WorkbasketAccessItem=%s", workbasketAccessItem));
            }
            if (!wbAccessItemImpl.getWorkbasketId().equals(workbasketId)) {
                throw new InvalidArgumentException(String.format("Checking the preconditions of the current WorkbasketAccessItem failed - the WBID does not match. Target-WBID=''%s'' WorkbasketAccessItem=%s", workbasketId, workbasketAccessItem));
            }
            String accessId = wbAccessItemImpl.getAccessId();
            if (accessId == null || accessId.isBlank()) {
                throw new InvalidArgumentException(String.format("Checking the preconditions of the current WorkbasketAccessItem failed - accessId is null or empty. WorkbasketAccessItem=%s, accessId=%s", workbasketAccessItem, accessId));
            }
            if (wbAccessItemImpl.getId() == null || wbAccessItemImpl.getId().isEmpty()) {
                wbAccessItemImpl.setId(IdGenerator.generateWithPrefix((String)"WAI"));
            }
            if (ids.contains(accessId)) {
                throw new WorkbasketAccessItemAlreadyExistException(accessId, wbAccessItemImpl.getWorkbasketId());
            }
            ids.add(accessId);
            accessItems.add(wbAccessItemImpl);
        }
        HashSet<WorkbasketAccessItemImpl> hashSet3 = hashSet2 = (hashSet = accessItems);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, hashSet2);
        return hashSet;
    }

    private long getCountTasksByWorkbasketId(String workbasketId) {
        long l;
        long l2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long l3 = l2 = (l = this.kadaiEngine.getEngine().getTaskService().createTaskQuery().workbasketIdIn(workbasketId).count());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l2));
        return l;
    }

    private long getCountTasksNotCompletedByWorkbasketId(String workbasketId) {
        long l;
        long l2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long l3 = l2 = (l = this.kadaiEngine.getEngine().getTaskService().createTaskQuery().workbasketIdIn(workbasketId).stateNotIn(TaskState.COMPLETED, TaskState.TERMINATED, TaskState.CANCELLED).count());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l2));
        return l;
    }

    /*
     * Unable to fully structure code
     */
    private boolean skipAuthorizationCheck(WorkbasketPermission ... requestedPermissions) {
        block6: {
            block7: {
                block5: {
                    var3_2 = requestedPermissions;
                    var2_3 = Factory.makeJP((JoinPoint.StaticPart)WorkbasketServiceImpl.ajc$tjp_30, (Object)this, (Object)this, (Object)var3_2);
                    LoggingAspect.aspectOf().beforeMethodExecuted(var2_3);
                    if (this.kadaiEngine.getEngine().getConfiguration().isSecurityEnabled()) break block5;
                    if (WorkbasketServiceImpl.LOGGER.isDebugEnabled()) {
                        WorkbasketServiceImpl.LOGGER.debug("Skipping permissions check since security is disabled.");
                    }
                    v0 = var4_4 = true;
                    break block6;
                }
                if (!Arrays.asList(requestedPermissions).contains((Object)WorkbasketPermission.READ)) break block7;
                if (!this.kadaiEngine.getEngine().isUserInRole(new KadaiRole[]{KadaiRole.ADMIN})) ** GOTO lbl-1000
                if (WorkbasketServiceImpl.LOGGER.isDebugEnabled()) {
                    WorkbasketServiceImpl.LOGGER.debug("Skipping read permissions check since user is in role ADMIN");
                }
                v0 = var4_4 = true;
                break block6;
            }
            if (this.kadaiEngine.getEngine().isUserInRole(new KadaiRole[]{KadaiRole.ADMIN, KadaiRole.TASK_ADMIN})) {
                if (WorkbasketServiceImpl.LOGGER.isDebugEnabled()) {
                    WorkbasketServiceImpl.LOGGER.debug("Skipping permissions check since user is in role ADMIN or TASK_ADMIN.");
                }
                v0 = var4_4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = var4_4 = false;
            }
        }
        v1 = var5_5 = v0;
        LoggingAspect.aspectOf().afterMethodExecuted(var2_3, Conversions.booleanObject((boolean)var5_5));
        return var4_4;
    }

    private void validateWorkbasket(Workbasket workbasket) throws DomainNotFoundException, InvalidArgumentException {
        Workbasket workbasket2 = workbasket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)workbasket2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validateNameAndType(workbasket);
        if (workbasket.getId() == null || workbasket.getId().length() == 0) {
            throw new InvalidArgumentException("Id must not be null for " + workbasket);
        }
        if (workbasket.getKey() == null || workbasket.getKey().length() == 0) {
            throw new InvalidArgumentException("Key must not be null for " + workbasket);
        }
        if (workbasket.getDomain() == null) {
            throw new InvalidArgumentException("Domain must not be null for " + workbasket);
        }
        if (!this.kadaiEngine.domainExists(workbasket.getDomain())) {
            throw new DomainNotFoundException(workbasket.getDomain());
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void validateId(String workbasketId) throws InvalidArgumentException {
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (workbasketId == null) {
            throw new InvalidArgumentException("The WorkbasketId can't be NULL");
        }
        if (workbasketId.isEmpty()) {
            throw new InvalidArgumentException("The WorkbasketId can't be EMPTY for deleteWorkbasket()");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void validateNameAndType(Workbasket workbasket) throws InvalidArgumentException {
        Workbasket workbasket2 = workbasket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)workbasket2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (workbasket.getName() == null) {
            throw new InvalidArgumentException("Name must not be NULL for " + workbasket);
        }
        if (workbasket.getName().length() == 0) {
            throw new InvalidArgumentException("Name must not be EMPTY for " + workbasket);
        }
        if (workbasket.getType() == null) {
            throw new InvalidArgumentException("Type must not be NULL for " + workbasket);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private List<WorkbasketPermission> getPermissionsFromWorkbasketAccessItem(WorkbasketAccessItem workbasketAccessItem) {
        ArrayList<WorkbasketPermission> arrayList;
        ArrayList<WorkbasketPermission> arrayList2;
        ArrayList<WorkbasketPermission> arrayList3;
        WorkbasketAccessItem workbasketAccessItem2 = workbasketAccessItem;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)workbasketAccessItem2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<WorkbasketPermission> permissions = new ArrayList<WorkbasketPermission>();
        if (workbasketAccessItem == null) {
            arrayList2 = arrayList3 = permissions;
        } else {
            WorkbasketPermission[] workbasketPermissionArray = WorkbasketPermission.values();
            int n = workbasketPermissionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorkbasketPermission permission = workbasketPermissionArray[n2];
                if (workbasketAccessItem.getPermission(permission)) {
                    permissions.add(permission);
                }
                ++n2;
            }
            arrayList2 = arrayList3 = permissions;
        }
        ArrayList<WorkbasketPermission> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList3;
    }

    private void markWorkbasketForDeletion(String workbasketId) throws InvalidArgumentException, NotAuthorizedException {
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.BUSINESS_ADMIN, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            this.validateId(workbasketId);
            WorkbasketImpl workbasket = this.workbasketMapper.findById(workbasketId);
            workbasket.setMarkedForDeletion(true);
            this.workbasketMapper.update(workbasket);
            if (this.historyEventManager.isEnabled()) {
                this.historyEventManager.createEvent(new WorkbasketMarkedForDeletionEvent(IdGenerator.generateWithPrefix((String)"WHI"), workbasket, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), null));
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private void deleteReferencesToWorkbasket(String workbasketId) {
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.distributionTargetMapper.deleteAllDistributionTargetsBySourceId(workbasketId);
        this.distributionTargetMapper.deleteAllDistributionTargetsByTargetId(workbasketId);
        this.workbasketAccessMapper.deleteAllAccessItemsForWorkbasketId(workbasketId);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketServiceImpl.java", WorkbasketServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasket", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.workbasket.api.models.Workbasket"), 102);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasket", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.lang.String", "workbasketKey:domain", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.workbasket.api.models.Workbasket"), 129);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketAccessItems", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "io.kadai.common.api.exceptions.NotAuthorizedException", "java.util.List"), 499);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWorkbasketAccessItems", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.util.List", "workbasketId:wbAccessItems", "io.kadai.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 515);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWorkbasketQuery", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "", "", "", "io.kadai.workbasket.api.WorkbasketQuery"), 562);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWorkbasketAccessItemQuery", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "", "", "io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.workbasket.api.WorkbasketAccessItemQuery"), 567);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newWorkbasket", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.lang.String", "key:domain", "", "io.kadai.workbasket.api.models.Workbasket"), 573);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPermissionsForWorkbasket", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "", "java.util.List"), 581);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDistributionTargets", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "java.util.List"), 589);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDistributionTargets", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.lang.String", "workbasketKey:domain", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "java.util.List"), 611);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDistributionTargets", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.util.List", "sourceWorkbasketId:targetWorkbasketIds", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 634);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addDistributionTarget", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.lang.String", "sourceWorkbasketId:targetWorkbasketId", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 697);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWorkbasket", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "io.kadai.workbasket.api.models.Workbasket", "newWorkbasket", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketAlreadyExistException:io.kadai.common.api.exceptions.DomainNotFoundException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.workbasket.api.models.Workbasket"), 152);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeDistributionTarget", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.lang.String", "sourceWorkbasketId:targetWorkbasketId", "io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 750);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteWorkbasket", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketInUseException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "boolean"), 815);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteWorkbaskets", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.util.List", "workbasketsIds", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.common.api.BulkOperationResults"), 879);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDistributionSources", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "java.util.List"), 912);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDistributionSources", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.lang.String", "workbasketKey:domain", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "java.util.List"), 932);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteWorkbasketAccessItemsForAccessId", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "accessId", "io.kadai.common.api.exceptions.NotAuthorizedException", "void"), 953);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkModifiedHasNotChanged", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "io.kadai.workbasket.api.models.Workbasket:io.kadai.workbasket.internal.models.WorkbasketImpl", "oldWorkbasket:workbasketImplToUpdate", "io.kadai.common.api.exceptions.ConcurrencyException", "void"), 999);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkAccessItemsPreconditionsAndSetId", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.util.List", "workbasketId:wbAccessItems", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException", "java.util.Set"), 1007);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getCountTasksByWorkbasketId", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "", "long"), 1056);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getCountTasksNotCompletedByWorkbasketId", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "", "long"), 1065);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateWorkbasket", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "io.kadai.workbasket.api.models.Workbasket", "workbasketToUpdate", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.common.api.exceptions.ConcurrencyException:io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.workbasket.api.models.Workbasket"), 201);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "skipAuthorizationCheck", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "[Lio.kadai.workbasket.api.WorkbasketPermission;", "requestedPermissions", "", "boolean"), 1075);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateWorkbasket", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "io.kadai.workbasket.api.models.Workbasket", "workbasket", "io.kadai.common.api.exceptions.DomainNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException", "void"), 1103);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateId", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "io.kadai.common.api.exceptions.InvalidArgumentException", "void"), 1122);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateNameAndType", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "io.kadai.workbasket.api.models.Workbasket", "workbasket", "io.kadai.common.api.exceptions.InvalidArgumentException", "void"), 1131);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getPermissionsFromWorkbasketAccessItem", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "io.kadai.workbasket.api.models.WorkbasketAccessItem", "workbasketAccessItem", "", "java.util.List"), 1143);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "markWorkbasketForDeletion", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "void"), 1157);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteReferencesToWorkbasket", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "workbasketId", "", "void"), 1180);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newWorkbasketAccessItem", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.lang.String", "workbasketId:accessId", "", "io.kadai.workbasket.api.models.WorkbasketAccessItem"), 264);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWorkbasketAccessItem", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "io.kadai.workbasket.api.models.WorkbasketAccessItem", "workbasketAccessItem", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.workbasket.api.models.WorkbasketAccessItem"), 276);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateWorkbasketAccessItem", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "io.kadai.workbasket.api.models.WorkbasketAccessItem", "workbasketAccessItem", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.workbasket.api.models.WorkbasketAccessItem"), 347);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteWorkbasketAccessItem", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String", "accessItemId", "io.kadai.common.api.exceptions.NotAuthorizedException", "void"), 392);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "checkAuthorization", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:[Lio.kadai.workbasket.api.WorkbasketPermission;", "workbasketId:requestedPermissions", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 430);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "checkAuthorization", "io.kadai.workbasket.internal.WorkbasketServiceImpl", "java.lang.String:java.lang.String:[Lio.kadai.workbasket.api.WorkbasketPermission;", "workbasketKey:domain:requestedPermissions", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 463);
    }
}

