/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.classification.api.exceptions;

import io.kadai.common.api.exceptions.ErrorCode;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.internal.logging.LoggingAspect;
import java.io.Serializable;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ClassificationNotFoundException
extends KadaiException {
    public static final String ERROR_KEY_ID = "CLASSIFICATION_WITH_ID_NOT_FOUND";
    public static final String ERROR_KEY_KEY_DOMAIN = "CLASSIFICATION_WITH_KEY_NOT_FOUND";
    private final String classificationId;
    private final String classificationKey;
    private final String domain;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public ClassificationNotFoundException(String classificationId) {
        super(String.format("Classification with id '%s' wasn't found", classificationId), ErrorCode.of((String)ERROR_KEY_ID, Map.of("classificationId", ClassificationNotFoundException.ensureNullIsHandled((Serializable)((Object)classificationId)))));
        this.classificationId = classificationId;
        this.classificationKey = null;
        this.domain = null;
    }

    public ClassificationNotFoundException(String key, String domain) {
        super(String.format("Classification with key '%s' and domain '%s' could not be found", key, domain), ErrorCode.of((String)ERROR_KEY_KEY_DOMAIN, Map.ofEntries(Map.entry("classificationKey", ClassificationNotFoundException.ensureNullIsHandled((Serializable)((Object)key))), Map.entry("domain", ClassificationNotFoundException.ensureNullIsHandled((Serializable)((Object)domain))))));
        this.classificationKey = key;
        this.domain = domain;
        this.classificationId = null;
    }

    public String getClassificationKey() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.classificationKey);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getDomain() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.domain);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getClassificationId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.classificationId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    static {
        ClassificationNotFoundException.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationNotFoundException.java", ClassificationNotFoundException.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationKey", "io.kadai.classification.api.exceptions.ClassificationNotFoundException", "", "", "", "java.lang.String"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomain", "io.kadai.classification.api.exceptions.ClassificationNotFoundException", "", "", "", "java.lang.String"), 63);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationId", "io.kadai.classification.api.exceptions.ClassificationNotFoundException", "", "", "", "java.lang.String"), 67);
    }
}

