/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.monitor.internal.reports;

import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.monitor.api.TaskTimestamp;
import io.kadai.monitor.api.reports.TaskCustomFieldValueReport;
import io.kadai.monitor.api.reports.header.TimeIntervalColumnHeader;
import io.kadai.monitor.api.reports.item.MonitorQueryItem;
import io.kadai.monitor.internal.MonitorMapper;
import io.kadai.monitor.internal.preprocessor.DaysToWorkingDaysReportPreProcessor;
import io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl;
import io.kadai.task.api.TaskCustomField;
import java.time.Instant;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class TaskCustomFieldValueReportBuilderImpl
extends TimeIntervalReportBuilderImpl<TaskCustomFieldValueReport.Builder, MonitorQueryItem, TimeIntervalColumnHeader>
implements TaskCustomFieldValueReport.Builder {
    private final TaskCustomField taskCustomField;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public TaskCustomFieldValueReportBuilderImpl(InternalKadaiEngine kadaiEngine, MonitorMapper monitorMapper, TaskCustomField taskCustomField) {
        super(kadaiEngine, monitorMapper);
        this.taskCustomField = taskCustomField;
    }

    @Override
    public TaskCustomFieldValueReport buildReport() throws InvalidArgumentException, NotAuthorizedException {
        TaskCustomFieldValueReport taskCustomFieldValueReport;
        TaskCustomFieldValueReport taskCustomFieldValueReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCustomFieldValueReport taskCustomFieldValueReport3 = taskCustomFieldValueReport2 = (taskCustomFieldValueReport = this.buildReport(TaskTimestamp.DUE));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCustomFieldValueReport2);
        return taskCustomFieldValueReport;
    }

    @Override
    public TaskCustomFieldValueReport buildReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        TaskCustomFieldValueReport taskCustomFieldValueReport;
        TaskCustomFieldValueReport taskCustomFieldValueReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.MONITOR, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            TaskCustomFieldValueReport report = new TaskCustomFieldValueReport(this.columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.monitorMapper.getTaskCountOfTaskCustomFieldValues(Instant.now(), timestamp, this);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.workingTimeCalculator, this.inWorkingDays));
            TaskCustomFieldValueReport taskCustomFieldValueReport3 = report;
            taskCustomFieldValueReport2 = taskCustomFieldValueReport3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskCustomFieldValueReport taskCustomFieldValueReport4 = taskCustomFieldValueReport = taskCustomFieldValueReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCustomFieldValueReport);
        return taskCustomFieldValueReport2;
    }

    @Override
    protected TaskCustomFieldValueReport.Builder _this() {
        TaskCustomFieldValueReportBuilderImpl taskCustomFieldValueReportBuilderImpl;
        TaskCustomFieldValueReportBuilderImpl taskCustomFieldValueReportBuilderImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCustomFieldValueReportBuilderImpl taskCustomFieldValueReportBuilderImpl3 = taskCustomFieldValueReportBuilderImpl2 = (taskCustomFieldValueReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCustomFieldValueReportBuilderImpl2);
        return taskCustomFieldValueReportBuilderImpl;
    }

    @Override
    protected String determineGroupedBy() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.taskCustomField.name());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    static {
        TaskCustomFieldValueReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCustomFieldValueReportBuilderImpl.java", TaskCustomFieldValueReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "io.kadai.monitor.internal.reports.TaskCustomFieldValueReportBuilderImpl", "", "", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.monitor.api.reports.TaskCustomFieldValueReport"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "io.kadai.monitor.internal.reports.TaskCustomFieldValueReportBuilderImpl", "io.kadai.monitor.api.TaskTimestamp", "timestamp", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.monitor.api.reports.TaskCustomFieldValueReport"), 58);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "_this", "io.kadai.monitor.internal.reports.TaskCustomFieldValueReportBuilderImpl", "", "", "", "io.kadai.monitor.api.reports.TaskCustomFieldValueReport$Builder"), 78);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "determineGroupedBy", "io.kadai.monitor.internal.reports.TaskCustomFieldValueReportBuilderImpl", "", "", "", "java.lang.String"), 83);
    }
}

