/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.monitor.internal.reports;

import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.monitor.api.reports.TaskStatusReport;
import io.kadai.monitor.api.reports.item.TaskQueryItem;
import io.kadai.monitor.internal.MonitorMapper;
import io.kadai.task.api.TaskState;
import io.kadai.workbasket.api.WorkbasketService;
import io.kadai.workbasket.api.models.WorkbasketSummary;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class TaskStatusReportBuilderImpl
implements TaskStatusReport.Builder {
    private final InternalKadaiEngine kadaiEngine;
    private final MonitorMapper monitorMapper;
    private final WorkbasketService workbasketService;
    private String[] domains;
    private TaskState[] states;
    private String[] workbasketIds;
    private Integer priorityMinimum;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public TaskStatusReportBuilderImpl(InternalKadaiEngine kadaiEngine, MonitorMapper monitorMapper) {
        this.kadaiEngine = kadaiEngine;
        this.monitorMapper = monitorMapper;
        this.workbasketService = kadaiEngine.getEngine().getWorkbasketService();
    }

    @Override
    public TaskStatusReport buildReport() throws NotAuthorizedException {
        TaskStatusReport taskStatusReport;
        TaskStatusReport taskStatusReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.MONITOR, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            List<TaskQueryItem> tasks = this.monitorMapper.getTasksCountByState(this.domains, this.states, this.workbasketIds, this.priorityMinimum);
            TaskStatusReport report = new TaskStatusReport(this.states != null ? Arrays.asList(this.states) : null);
            report.addItems(tasks);
            Map displayMap = this.kadaiEngine.getEngine().runAsAdmin(() -> this.workbasketService.createWorkbasketQuery().keyIn(report.getRows().keySet().toArray(new String[0])).domainIn(this.domains).list().stream().collect(Collectors.toMap(WorkbasketSummary::getKey, WorkbasketSummary::getName, (a, b) -> a)));
            report.augmentDisplayNames(displayMap);
            TaskStatusReport taskStatusReport3 = report;
            taskStatusReport2 = taskStatusReport3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskStatusReport taskStatusReport4 = taskStatusReport = taskStatusReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReport);
        return taskStatusReport2;
    }

    @Override
    public TaskStatusReportBuilderImpl stateIn(List<TaskState> states) {
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl2;
        List<TaskState> list = states;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (states != null) {
            this.states = states.toArray(new TaskState[0]);
        }
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl3 = taskStatusReportBuilderImpl2 = (taskStatusReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReportBuilderImpl2);
        return taskStatusReportBuilderImpl;
    }

    @Override
    public TaskStatusReportBuilderImpl priorityMinimum(Integer priorityMinimum) {
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl2;
        Integer n = priorityMinimum;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)n);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.priorityMinimum = priorityMinimum;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl3 = taskStatusReportBuilderImpl2 = (taskStatusReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReportBuilderImpl2);
        return taskStatusReportBuilderImpl;
    }

    @Override
    public TaskStatusReportBuilderImpl domainIn(List<String> domains) {
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl2;
        List<String> list = domains;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (domains != null) {
            this.domains = domains.toArray(new String[0]);
        }
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl3 = taskStatusReportBuilderImpl2 = (taskStatusReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReportBuilderImpl2);
        return taskStatusReportBuilderImpl;
    }

    @Override
    public TaskStatusReport.Builder workbasketIdsIn(List<String> workbasketIds) {
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl;
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl2;
        List<String> list = workbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (workbasketIds != null) {
            this.workbasketIds = workbasketIds.toArray(new String[0]);
        }
        TaskStatusReportBuilderImpl taskStatusReportBuilderImpl3 = taskStatusReportBuilderImpl2 = (taskStatusReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStatusReportBuilderImpl2);
        return taskStatusReportBuilderImpl;
    }

    static {
        TaskStatusReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskStatusReportBuilderImpl.java", TaskStatusReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "io.kadai.monitor.internal.reports.TaskStatusReportBuilderImpl", "", "", "io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.monitor.api.reports.TaskStatusReport"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stateIn", "io.kadai.monitor.internal.reports.TaskStatusReportBuilderImpl", "java.util.List", "states", "", "io.kadai.monitor.internal.reports.TaskStatusReportBuilderImpl"), 88);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "priorityMinimum", "io.kadai.monitor.internal.reports.TaskStatusReportBuilderImpl", "java.lang.Integer", "priorityMinimum", "", "io.kadai.monitor.internal.reports.TaskStatusReportBuilderImpl"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "domainIn", "io.kadai.monitor.internal.reports.TaskStatusReportBuilderImpl", "java.util.List", "domains", "", "io.kadai.monitor.internal.reports.TaskStatusReportBuilderImpl"), 102);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workbasketIdsIn", "io.kadai.monitor.internal.reports.TaskStatusReportBuilderImpl", "java.util.List", "workbasketIds", "", "io.kadai.monitor.api.reports.TaskStatusReport$Builder"), 110);
    }
}

