/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.monitor.internal.reports;

import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.monitor.api.SelectedItem;
import io.kadai.monitor.api.TaskTimestamp;
import io.kadai.monitor.api.reports.Report;
import io.kadai.monitor.api.reports.TimestampReport;
import io.kadai.monitor.api.reports.header.TimeIntervalColumnHeader;
import io.kadai.monitor.api.reports.item.TimestampQueryItem;
import io.kadai.monitor.internal.MonitorMapper;
import io.kadai.monitor.internal.preprocessor.DaysToWorkingDaysReportPreProcessor;
import io.kadai.monitor.internal.reports.TimeIntervalReportBuilderImpl;
import io.kadai.task.api.TaskState;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class TimestampReportBuilderImpl
extends TimeIntervalReportBuilderImpl<TimestampReport.Builder, TimestampQueryItem, TimeIntervalColumnHeader>
implements TimestampReport.Builder {
    private List<TaskTimestamp> status = Arrays.asList(TaskTimestamp.CREATED, TaskTimestamp.COMPLETED);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public TimestampReportBuilderImpl(InternalKadaiEngine kadaiEngine, MonitorMapper monitorMapper) {
        super(kadaiEngine, monitorMapper);
    }

    @Override
    public TimestampReport.Builder stateIn(List<TaskState> states) {
        List<TaskState> list = states;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        throw new UnsupportedOperationException("The states have no influence regarding this report. Use withTimestamps instead");
    }

    @Override
    public List<String> listTaskIdsForSelectedItems(List<SelectedItem> selectedItems, TaskTimestamp timestamp) {
        List<SelectedItem> list = selectedItems;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, list, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        throw new UnsupportedOperationException();
    }

    @Override
    public TimestampReport.Builder withTimestamps(List<TaskTimestamp> taskTimestamps) {
        TimestampReport.Builder builder;
        TimestampReport.Builder builder2;
        List<TaskTimestamp> list = taskTimestamps;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.status = new ArrayList<TaskTimestamp>(taskTimestamps);
        TimestampReport.Builder builder3 = builder2 = (builder = this._this());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)builder2);
        return builder;
    }

    @Override
    public Report<TimestampQueryItem, TimeIntervalColumnHeader> buildReport(TaskTimestamp timestamp) throws InvalidArgumentException, NotAuthorizedException {
        TimestampReport timestampReport;
        TimestampReport timestampReport2;
        TaskTimestamp taskTimestamp = timestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimestampReport timestampReport3 = timestampReport2 = (timestampReport = this.buildReport());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timestampReport2);
        return timestampReport;
    }

    @Override
    public TimestampReport buildReport() throws InvalidArgumentException, NotAuthorizedException {
        TimestampReport timestampReport;
        TimestampReport timestampReport2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.MONITOR, KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            TimestampReport report = new TimestampReport(this.columnHeaders);
            List items = this.status.stream().map(this::getTasksCountForStatusGroupedByOrgLevel).flatMap(Collection::stream).toList();
            report.addItems(items, new DaysToWorkingDaysReportPreProcessor(this.columnHeaders, this.workingTimeCalculator, this.inWorkingDays));
            TimestampReport timestampReport3 = report;
            timestampReport2 = timestampReport3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TimestampReport timestampReport4 = timestampReport = timestampReport2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timestampReport);
        return timestampReport2;
    }

    @Override
    protected TimestampReport.Builder _this() {
        TimestampReportBuilderImpl timestampReportBuilderImpl;
        TimestampReportBuilderImpl timestampReportBuilderImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimestampReportBuilderImpl timestampReportBuilderImpl3 = timestampReportBuilderImpl2 = (timestampReportBuilderImpl = this);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)timestampReportBuilderImpl2);
        return timestampReportBuilderImpl;
    }

    @Override
    protected String determineGroupedBy() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        throw new UnsupportedOperationException();
    }

    private List<TimestampQueryItem> getTasksCountForStatusGroupedByOrgLevel(TaskTimestamp s) {
        List<TimestampQueryItem> list;
        List<TimestampQueryItem> list2;
        TaskTimestamp taskTimestamp = s;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)((Object)taskTimestamp));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TimestampQueryItem> list3 = list2 = (list = this.monitorMapper.getTasksCountForStatusGroupedByOrgLevel(Instant.now(), s, this));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    static {
        TimestampReportBuilderImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TimestampReportBuilderImpl.java", TimestampReportBuilderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stateIn", "io.kadai.monitor.internal.reports.TimestampReportBuilderImpl", "java.util.List", "states", "", "io.kadai.monitor.api.reports.TimestampReport$Builder"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listTaskIdsForSelectedItems", "io.kadai.monitor.internal.reports.TimestampReportBuilderImpl", "java.util.List:io.kadai.monitor.api.TaskTimestamp", "selectedItems:timestamp", "", "java.util.List"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "withTimestamps", "io.kadai.monitor.internal.reports.TimestampReportBuilderImpl", "java.util.List", "taskTimestamps", "", "io.kadai.monitor.api.reports.TimestampReport$Builder"), 66);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "io.kadai.monitor.internal.reports.TimestampReportBuilderImpl", "io.kadai.monitor.api.TaskTimestamp", "timestamp", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.monitor.api.reports.Report"), 72);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildReport", "io.kadai.monitor.internal.reports.TimestampReportBuilderImpl", "", "", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.monitor.api.reports.TimestampReport"), 78);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "_this", "io.kadai.monitor.internal.reports.TimestampReportBuilderImpl", "", "", "", "io.kadai.monitor.api.reports.TimestampReport$Builder"), 103);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "determineGroupedBy", "io.kadai.monitor.internal.reports.TimestampReportBuilderImpl", "", "", "", "java.lang.String"), 108);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksCountForStatusGroupedByOrgLevel", "io.kadai.monitor.internal.reports.TimestampReportBuilderImpl", "io.kadai.monitor.api.TaskTimestamp", "s", "", "java.util.List"), 112);
    }
}

