/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.internal;

import io.kadai.task.internal.ObjectReferenceQueryImpl;
import io.kadai.task.internal.ObjectReferenceQuerySqlProvider;
import io.kadai.task.internal.models.ObjectReferenceImpl;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;

public interface ObjectReferenceMapper {
    @Select(value={"<script>SELECT ID, COMPANY, SYSTEM, SYSTEM_INSTANCE, TYPE, VALUE FROM OBJECT_REFERENCE WHERE ID = #{id}ORDER BY VALUE ASC, TYPE ASC, SYSTEM_INSTANCE ASC, SYSTEM ASC, COMPANY ASC<if test=\"_databaseId == 'db2'\"> with UR </if> </script>"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="company", column="COMPANY"), @Result(property="system", column="SYSTEM"), @Result(property="systemInstance", column="SYSTEM_INSTANCE"), @Result(property="type", column="TYPE"), @Result(property="value", column="VALUE")})
    public ObjectReferenceImpl findById(@Param(value="id") String var1);

    @Select(value={"<script>SELECT ID, TASK_ID, COMPANY, SYSTEM, SYSTEM_INSTANCE, TYPE, VALUE FROM OBJECT_REFERENCE WHERE TASK_ID = #{taskId} ORDER BY VALUE ASC, TYPE ASC, SYSTEM_INSTANCE ASC, SYSTEM ASC, COMPANY ASC<if test=\"_databaseId == 'db2'\"> with UR </if> </script>"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="taskId", column="TASK_ID"), @Result(property="company", column="COMPANY"), @Result(property="system", column="SYSTEM"), @Result(property="systemInstance", column="SYSTEM_INSTANCE"), @Result(property="type", column="TYPE"), @Result(property="value", column="VALUE")})
    public List<ObjectReferenceImpl> findObjectReferencesByTaskId(@Param(value="taskId") String var1);

    @Select(value={"<script>SELECT ID, TASK_ID, COMPANY, SYSTEM, SYSTEM_INSTANCE, TYPE, VALUE FROM OBJECT_REFERENCE <where><choose><when  test='taskIds == null'> 1 = 2 </when><otherwise>TASK_ID IN (<foreach collection='taskIds' item='item' separator=',' >#{item}</foreach>) </otherwise></choose></where>ORDER BY VALUE ASC, TYPE ASC, SYSTEM_INSTANCE ASC, SYSTEM ASC, COMPANY ASC<if test=\"_databaseId == 'db2'\"> with UR </if> </script>"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="taskId", column="TASK_ID"), @Result(property="company", column="COMPANY"), @Result(property="system", column="SYSTEM"), @Result(property="systemInstance", column="SYSTEM_INSTANCE"), @Result(property="type", column="TYPE"), @Result(property="value", column="VALUE")})
    public List<ObjectReferenceImpl> findObjectReferencesByTaskIds(@Param(value="taskIds") Collection<String> var1);

    @Select(value={"<script>SELECT ID, COMPANY, SYSTEM, SYSTEM_INSTANCE, TYPE, VALUE FROM OBJECT_REFERENCE WHERE COMPANY = #{objectReference.company} AND SYSTEM = #{objectReference.system} AND SYSTEM_INSTANCE = #{objectReference.systemInstance} AND TYPE = #{objectReference.type} AND VALUE = #{objectReference.value} ORDER BY VALUE ASC, TYPE ASC, SYSTEM_INSTANCE ASC, SYSTEM ASC, COMPANY ASC<if test=\"_databaseId == 'db2'\"> with UR </if> </script>"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="company", column="COMPANY"), @Result(property="system", column="SYSTEM"), @Result(property="systemInstance", column="SYSTEM_INSTANCE"), @Result(property="type", column="TYPE"), @Result(property="value", column="VALUE")})
    public ObjectReferenceImpl findByObjectReference(@Param(value="objectReference") ObjectReferenceImpl var1);

    @SelectProvider(type=ObjectReferenceQuerySqlProvider.class, method="queryObjectReferences")
    @Results(value={@Result(property="id", column="ID"), @Result(property="company", column="COMPANY"), @Result(property="system", column="SYSTEM"), @Result(property="systemInstance", column="SYSTEM_INSTANCE"), @Result(property="type", column="TYPE"), @Result(property="value", column="VALUE")})
    public List<ObjectReferenceImpl> queryObjectReferences(ObjectReferenceQueryImpl var1);

    @SelectProvider(type=ObjectReferenceQuerySqlProvider.class, method="countQueryObjectReferences")
    public long countQueryObjectReferences(ObjectReferenceQueryImpl var1);

    @SelectProvider(type=ObjectReferenceQuerySqlProvider.class, method="queryObjectReferenceColumnValues")
    public List<String> queryObjectReferenceColumnValues(ObjectReferenceQueryImpl var1);

    @Insert(value={"INSERT INTO OBJECT_REFERENCE (ID, TASK_ID, COMPANY, SYSTEM, SYSTEM_INSTANCE, TYPE, VALUE) VALUES (#{ref.id}, #{ref.taskId}, #{ref.company}, #{ref.system}, #{ref.systemInstance}, #{ref.type}, #{ref.value})"})
    public void insert(@Param(value="ref") ObjectReferenceImpl var1);

    @Update(value={"UPDATE OBJECT_REFERENCE SET COMPANY = #{ref.company}, SYSTEM = #{ref.system}, SYSTEM_INSTANCE = #{ref.systemInstance}, TYPE = #{ref.type}, VALUE = #{ref.value} WHERE ID = #{ref.id}"})
    public void update(@Param(value="ref") ObjectReferenceImpl var1);

    @Delete(value={"DELETE FROM OBJECT_REFERENCE WHERE ID = #{id}"})
    public void delete(String var1);

    @Delete(value={"<script>DELETE FROM OBJECT_REFERENCE WHERE TASK_ID IN(<foreach item='item' collection='taskIds' separator=',' >#{item}</foreach>)</script>"})
    public void deleteMultipleByTaskIds(@Param(value="taskIds") List<String> var1);
}

