/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.internal;

import io.kadai.classification.api.models.ClassificationSummary;
import io.kadai.common.api.BulkOperationResults;
import io.kadai.common.api.WorkingTimeCalculator;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.util.Pair;
import io.kadai.task.api.models.AttachmentSummary;
import io.kadai.task.api.models.Task;
import io.kadai.task.internal.AttachmentMapper;
import io.kadai.task.internal.TaskMapper;
import io.kadai.task.internal.TaskServiceImpl;
import io.kadai.task.internal.models.AttachmentSummaryImpl;
import io.kadai.task.internal.models.MinimalTaskSummary;
import io.kadai.task.internal.models.TaskImpl;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceLevelHandler {
    private static final Logger LOGGER;
    private static final Duration MAX_DURATION;
    private final InternalKadaiEngine kadaiEngine;
    private final TaskMapper taskMapper;
    private final AttachmentMapper attachmentMapper;
    private final WorkingTimeCalculator workingTimeCalculator;
    private final TaskServiceImpl taskServiceImpl;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;

    static {
        ServiceLevelHandler.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ServiceLevelHandler.class);
        MAX_DURATION = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    }

    ServiceLevelHandler(InternalKadaiEngine kadaiEngine, TaskMapper taskMapper, AttachmentMapper attachmentMapper, TaskServiceImpl taskServiceImpl) {
        this.kadaiEngine = kadaiEngine;
        this.taskMapper = taskMapper;
        this.attachmentMapper = attachmentMapper;
        this.workingTimeCalculator = kadaiEngine.getEngine().getWorkingTimeCalculator();
        this.taskServiceImpl = taskServiceImpl;
    }

    public void refreshPriorityAndDueDatesOfTasks(List<MinimalTaskSummary> tasks, boolean serviceLevelChanged, boolean priorityChanged) {
        List<MinimalTaskSummary> list = tasks;
        boolean bl = serviceLevelChanged;
        boolean bl2 = priorityChanged;
        Object[] objectArray = new Object[]{list, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<AttachmentSummaryImpl> attachments = this.getAttachmentSummaries(tasks);
        List<ClassificationSummary> allInvolvedClassifications = this.findAllClassificationsReferencedByTasksAndAttachments(tasks, attachments);
        if (serviceLevelChanged) {
            List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithDuration = this.resolveDurationsInClassifications(allInvolvedClassifications);
            this.updateTaskDueDatesOnClassificationUpdate(tasks, attachments, allInvolvedClassificationsWithDuration);
        }
        if (priorityChanged) {
            List<MinimalTaskSummary> tasksWithoutManualPriority = tasks.stream().filter(Predicate.not(MinimalTaskSummary::isManualPriorityActive)).toList();
            this.updateTaskPriorityOnClassificationUpdate(tasksWithoutManualPriority, attachments, allInvolvedClassifications);
        }
        Object var12_12 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var12_12);
    }

    BulkLog setPlannedPropertyOfTasksImpl(Instant planned, List<MinimalTaskSummary> tasks) {
        BulkLog bulkLog;
        BulkLog bulkLog2;
        Instant instant = planned;
        List<MinimalTaskSummary> list = tasks;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)instant, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkLog bulkLog3 = new BulkLog();
        List<AttachmentSummaryImpl> attachments = this.getAttachmentSummaries(tasks);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found attachments {}.", attachments);
        }
        List<ClassificationSummary> allInvolvedClassifications = this.findAllClassificationsReferencedByTasksAndAttachments(tasks, attachments);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found involved classifications {}.", allInvolvedClassifications);
        }
        List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithDuration = this.resolveDurationsInClassifications(allInvolvedClassifications);
        Map<Duration, List<String>> durationToTaskIdsMap = this.getDurationToTaskIdsMap(tasks, attachments, allInvolvedClassificationsWithDuration);
        BulkLog updateResult = this.updatePlannedPropertyOfAffectedTasks(planned, durationToTaskIdsMap);
        bulkLog3.addAllErrors(updateResult);
        BulkLog bulkLog4 = bulkLog2 = (bulkLog = bulkLog3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog2);
        return bulkLog;
    }

    TaskImpl updatePrioPlannedDueOfTask(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws InvalidArgumentException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl taskImpl3;
        TaskImpl taskImpl4 = newTaskImpl;
        TaskImpl taskImpl5 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)taskImpl4, (Object)taskImpl5);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean onlyPriority = false;
        if (newTaskImpl.getClassificationSummary() == null || newTaskImpl.getClassificationSummary().getServiceLevel() == null) {
            this.setPlannedDueOnMissingServiceLevel(newTaskImpl);
            onlyPriority = true;
        }
        if (this.isPriorityAndDurationAlreadyCorrect(newTaskImpl, oldTaskImpl)) {
            taskImpl2 = taskImpl3 = newTaskImpl;
        } else {
            if (newTaskImpl.getPlanned() == null && newTaskImpl.getDue() == null) {
                newTaskImpl.setPlanned(Instant.now());
            }
            DurationPrioHolder durationPrioHolder = this.determineTaskPrioDuration(newTaskImpl, onlyPriority);
            if (newTaskImpl.isManualPriorityActive()) {
                newTaskImpl.setPriority(newTaskImpl.getManualPriority());
            } else {
                newTaskImpl.setPriority(durationPrioHolder.priority());
            }
            taskImpl2 = onlyPriority ? (taskImpl3 = newTaskImpl) : (oldTaskImpl == null ? (taskImpl3 = this.updatePlannedDueOnCreationOfNewTask(newTaskImpl, durationPrioHolder.duration())) : (taskImpl3 = this.updatePlannedDueOnTaskUpdate(newTaskImpl, oldTaskImpl, durationPrioHolder.duration())));
        }
        TaskImpl taskImpl6 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl3;
    }

    private DurationPrioHolder determineTaskPrioDuration(TaskImpl newTaskImpl, boolean onlyPriority) {
        DurationPrioHolder durationPrioHolder;
        DurationPrioHolder durationPrioHolder2;
        TaskImpl taskImpl = newTaskImpl;
        boolean bl = onlyPriority;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)taskImpl, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<ClassificationSummary> classificationsInvolved = this.getClassificationsReferencedByATask(newTaskImpl);
        ArrayList<ClassificationWithServiceLevelResolved> resolvedClassifications = new ArrayList();
        if (onlyPriority) {
            for (ClassificationSummary c : classificationsInvolved) {
                resolvedClassifications.add(new ClassificationWithServiceLevelResolved(c.getId(), MAX_DURATION, 0));
            }
        } else {
            resolvedClassifications = this.resolveDurationsInClassifications(new ArrayList<ClassificationSummary>(classificationsInvolved));
        }
        DurationPrioHolder durationPrioHolder3 = durationPrioHolder2 = (durationPrioHolder = this.getFinalPrioDurationOfTask(resolvedClassifications, onlyPriority));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)durationPrioHolder2);
        return durationPrioHolder;
    }

    private void setPlannedDueOnMissingServiceLevel(TaskImpl task) {
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant now = Instant.now();
        if (task.getDue() == null && task.getPlanned() == null) {
            task.setDue(now);
            task.setPlanned(now);
        } else if (task.getDue() == null) {
            task.setDue(task.getPlanned());
        } else {
            task.setPlanned(task.getDue());
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    private void updateTaskPriorityOnClassificationUpdate(List<MinimalTaskSummary> existingTasks, List<AttachmentSummaryImpl> attachments, List<ClassificationSummary> allInvolvedClassifications) {
        List<MinimalTaskSummary> list = existingTasks;
        List<AttachmentSummaryImpl> list2 = attachments;
        List<ClassificationSummary> list3 = allInvolvedClassifications;
        Object[] objectArray = new Object[]{list, list2, list3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<Integer, List<String>> priorityToTaskIdsMap = this.getPriorityToTasksIdsMap(existingTasks, attachments, allInvolvedClassifications);
        TaskImpl referenceTask = new TaskImpl();
        referenceTask.setModified(Instant.now());
        priorityToTaskIdsMap.forEach((prio, taskIdList) -> {
            referenceTask.setPriority((int)prio);
            if (!taskIdList.isEmpty()) {
                this.taskMapper.updatePriorityOfTasks((List<String>)taskIdList, referenceTask);
            }
        });
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private Map<Integer, List<String>> getPriorityToTasksIdsMap(List<MinimalTaskSummary> existingTasks, List<AttachmentSummaryImpl> attachments, List<ClassificationSummary> allInvolvedClassifications) {
        Map<Integer, List<String>> map;
        Map<Integer, List<String>> map2;
        List<MinimalTaskSummary> list = existingTasks;
        List<AttachmentSummaryImpl> list2 = attachments;
        List<ClassificationSummary> list3 = allInvolvedClassifications;
        Object[] objectArray = new Object[]{list, list2, list3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, Integer> classificationIdToPriorityMap = allInvolvedClassifications.stream().collect(Collectors.toMap(ClassificationSummary::getId, ClassificationSummary::getPriority));
        Map<String, Set<String>> taskIdToClassificationIdsMap = this.getTaskIdToClassificationsMap(existingTasks, attachments);
        List<TaskIdPriority> taskIdPriorities = existingTasks.stream().map(t -> new TaskIdPriority(t.getTaskId(), this.determinePriorityForATask((MinimalTaskSummary)t, classificationIdToPriorityMap, taskIdToClassificationIdsMap))).toList();
        Map<Integer, List<String>> map3 = map2 = (map = taskIdPriorities.stream().collect(Collectors.groupingBy(TaskIdPriority::getPriority, Collectors.mapping(TaskIdPriority::getTaskId, Collectors.toList()))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    private int determinePriorityForATask(MinimalTaskSummary minimalTaskSummary, Map<String, Integer> classificationIdToPriorityMap, Map<String, Set<String>> taskIdToClassificationIdsMap) {
        int n;
        int n2;
        MinimalTaskSummary minimalTaskSummary2 = minimalTaskSummary;
        Map<String, Integer> map = classificationIdToPriorityMap;
        Map<String, Set<String>> map2 = taskIdToClassificationIdsMap;
        Object[] objectArray = new Object[]{minimalTaskSummary2, map, map2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int actualPriority = 0;
        for (String classificationId : taskIdToClassificationIdsMap.get(minimalTaskSummary.getTaskId())) {
            int prio = classificationIdToPriorityMap.get(classificationId);
            if (prio <= actualPriority) continue;
            actualPriority = prio;
        }
        int n3 = n2 = (n = actualPriority);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private BulkLog updateTaskDueDatesOnClassificationUpdate(List<MinimalTaskSummary> existingTasks, List<AttachmentSummaryImpl> attachments, List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithDuration) {
        BulkLog bulkLog;
        BulkLog bulkLog2;
        List<MinimalTaskSummary> list = existingTasks;
        List<AttachmentSummaryImpl> list2 = attachments;
        List<ClassificationWithServiceLevelResolved> list3 = allInvolvedClassificationsWithDuration;
        Object[] objectArray = new Object[]{list, list2, list3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<InstantDurationHolder, List<TaskDuration>> tasksPerPlannedAndDuration = this.getTasksPerPlannedAndDuration(existingTasks, attachments, allInvolvedClassificationsWithDuration);
        BulkLog bulkLog3 = bulkLog2 = (bulkLog = this.updateDuePropertyOfAffectedTasks(tasksPerPlannedAndDuration));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog2);
        return bulkLog;
    }

    private TaskImpl updatePlannedDueOnTaskUpdate(TaskImpl newTaskImpl, TaskImpl oldTaskImpl, Duration duration) throws InvalidArgumentException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl taskImpl3;
        TaskImpl taskImpl4 = newTaskImpl;
        TaskImpl taskImpl5 = oldTaskImpl;
        Duration duration2 = duration;
        Object[] objectArray = new Object[]{taskImpl4, taskImpl5, duration2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.kadaiEngine.getEngine().getConfiguration().isEnforceServiceLevel() && newTaskImpl.getDue() != null && newTaskImpl.getPlanned() != null) {
            taskImpl2 = taskImpl3 = newTaskImpl;
        } else {
            boolean forcedPlannedRecalculation;
            boolean forcedDueRecalculation = newTaskImpl.getDue() == null;
            boolean bl = forcedPlannedRecalculation = newTaskImpl.getPlanned() == null;
            if (forcedDueRecalculation) {
                this.recalcDueBasedPlanned(newTaskImpl, duration);
            } else if (forcedPlannedRecalculation) {
                this.recalcPlannedBasedOnDue(newTaskImpl, oldTaskImpl, duration);
            } else if (oldTaskImpl.getDue().equals(newTaskImpl.getDue())) {
                this.recalcDueBasedPlanned(newTaskImpl, duration);
            } else {
                this.recalcPlannedBasedOnDue(newTaskImpl, oldTaskImpl, duration);
            }
            taskImpl2 = taskImpl3 = newTaskImpl;
        }
        TaskImpl taskImpl6 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl3;
    }

    private void recalcPlannedBasedOnDue(TaskImpl newTaskImpl, TaskImpl oldTaskImpl, Duration duration) throws InvalidArgumentException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        Duration duration2 = duration;
        Object[] objectArray = new Object[]{taskImpl, taskImpl2, duration2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant calcDue = this.normalizeDue(newTaskImpl.getDue());
        Instant calcPlanned = this.calculatePlanned(calcDue, duration);
        if (this.plannedHasChanged(newTaskImpl, oldTaskImpl)) {
            this.ensureServiceLevelIsNotViolated(newTaskImpl, duration, calcPlanned);
        }
        newTaskImpl.setPlanned(calcPlanned);
        newTaskImpl.setDue(calcDue);
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private void recalcDueBasedPlanned(TaskImpl newTaskImpl, Duration duration) {
        TaskImpl taskImpl = newTaskImpl;
        Duration duration2 = duration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)taskImpl, (Object)duration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant planned = this.normalizePlanned(newTaskImpl.getPlanned());
        newTaskImpl.setPlanned(planned);
        newTaskImpl.setDue(this.calculateDue(planned, duration));
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    private boolean plannedHasChanged(Task newTask, Task oldTask) {
        boolean bl;
        boolean bl2;
        Task task = newTask;
        Task task2 = oldTask;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)task, (Object)task2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = newTask.getPlanned() != null && !oldTask.getPlanned().equals(newTask.getPlanned()) ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private Instant calculateDue(Instant planned, Duration duration) {
        Instant instant;
        Instant instant2;
        Instant instant3 = planned;
        Duration duration2 = duration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)instant3, (Object)duration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant dueExclusive = this.workingTimeCalculator.addWorkingTime(planned, duration);
        if (this.kadaiEngine.getEngine().getConfiguration().isUseWorkingTimeCalculation() && !planned.equals(dueExclusive)) {
            dueExclusive = dueExclusive.minusMillis(1L);
        }
        Instant instant4 = instant2 = (instant = dueExclusive);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    private Instant calculatePlanned(Instant due, Duration duration) {
        Instant instant;
        Instant instant2;
        Instant instant3;
        Instant instant4 = due;
        Duration duration2 = duration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)instant4, (Object)duration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (Duration.ZERO.equals(duration)) {
            instant2 = instant3 = due;
        } else {
            Instant normalize = this.kadaiEngine.getEngine().getConfiguration().isUseWorkingTimeCalculation() ? due.plusMillis(1L) : due;
            instant2 = instant3 = this.workingTimeCalculator.subtractWorkingTime(normalize, duration);
        }
        Instant instant5 = instant = instant2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant);
        return instant3;
    }

    private Instant normalizeDue(Instant due) {
        Instant instant;
        Instant instant2;
        Instant instant3 = due;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)instant3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant4 = instant2 = this.kadaiEngine.getEngine().getConfiguration().isUseWorkingTimeCalculation() ? (instant = this.workingTimeCalculator.subtractWorkingTime(due.plusMillis(1L), Duration.ZERO).minusMillis(1L)) : (instant = this.workingTimeCalculator.subtractWorkingTime(due, Duration.ZERO));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    private Instant normalizePlanned(Instant instant) {
        Instant instant2;
        Instant instant3;
        Instant instant4 = instant;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)instant4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant5 = instant3 = (instant2 = this.workingTimeCalculator.addWorkingTime(instant, Duration.ZERO));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant3);
        return instant2;
    }

    private void ensureServiceLevelIsNotViolated(TaskImpl task, Duration duration, Instant calcPlanned) throws InvalidArgumentException {
        TaskImpl taskImpl = task;
        Duration duration2 = duration;
        Instant instant = calcPlanned;
        Object[] objectArray = new Object[]{taskImpl, duration2, instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (task.getPlanned() != null && !task.getPlanned().equals(calcPlanned) && this.workingTimeCalculator.workingTimeBetween(task.getPlanned(), calcPlanned).compareTo(Duration.ofMillis(1L)) > 0) {
            throw new InvalidArgumentException(String.format("Cannot update a task with given planned %s and due date %s not matching the service level %s.", task.getPlanned(), task.getDue(), duration));
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private TaskImpl updatePlannedDueOnCreationOfNewTask(TaskImpl newTask, Duration duration) throws InvalidArgumentException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl taskImpl3;
        TaskImpl taskImpl4 = newTask;
        Duration duration2 = duration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)taskImpl4, (Object)duration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.kadaiEngine.getEngine().getConfiguration().isEnforceServiceLevel() && newTask.getDue() != null && newTask.getPlanned() != null) {
            taskImpl2 = taskImpl3 = newTask;
        } else {
            if (newTask.getDue() != null) {
                Instant calcDue = this.normalizeDue(newTask.getDue());
                Instant calcPlanned = this.calculatePlanned(calcDue, duration);
                this.ensureServiceLevelIsNotViolated(newTask, duration, calcPlanned);
                newTask.setDue(calcDue);
                newTask.setPlanned(calcPlanned);
            } else {
                this.recalcDueBasedPlanned(newTask, duration);
            }
            taskImpl2 = taskImpl3 = newTask;
        }
        TaskImpl taskImpl5 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl3;
    }

    private BulkLog updateDuePropertyOfAffectedTasks(Map<InstantDurationHolder, List<TaskDuration>> tasksPerPlannedAndDuration) {
        BulkLog bulkLog;
        BulkLog bulkLog2;
        Map<InstantDurationHolder, List<TaskDuration>> map = tasksPerPlannedAndDuration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkLog bulkLog3 = new BulkLog();
        tasksPerPlannedAndDuration.forEach((instDurHld, taskDurationList) -> bulkLog3.addAllErrors(this.updateDuePropertyOfTasksWithIdenticalDueDate((InstantDurationHolder)instDurHld, (List<TaskDuration>)taskDurationList)));
        BulkLog bulkLog4 = bulkLog2 = (bulkLog = bulkLog3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog2);
        return bulkLog;
    }

    private BulkOperationResults<String, KadaiException> updateDuePropertyOfTasksWithIdenticalDueDate(InstantDurationHolder durationHolder, List<TaskDuration> taskDurationList) {
        BulkLog bulkLog;
        BulkLog bulkLog2;
        InstantDurationHolder instantDurationHolder = durationHolder;
        List<TaskDuration> list = taskDurationList;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)instantDurationHolder, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkLog bulkLog3 = new BulkLog();
        TaskImpl referenceTask = new TaskImpl();
        referenceTask.setPlanned(durationHolder.getPlanned());
        referenceTask.setModified(Instant.now());
        referenceTask.setDue(this.calculateDue(referenceTask.getPlanned(), durationHolder.getDuration()));
        List<String> taskIdsToUpdate = taskDurationList.stream().map(TaskDuration::getTaskId).toList();
        Pair<List<MinimalTaskSummary>, BulkLog> existingAndAuthorizedTasks = this.taskServiceImpl.getMinimalTaskSummaries(taskIdsToUpdate);
        bulkLog3.addAllErrors((BulkOperationResults)existingAndAuthorizedTasks.getRight());
        this.taskMapper.updateTaskDueDates((List)existingAndAuthorizedTasks.getLeft(), referenceTask);
        BulkLog bulkLog4 = bulkLog2 = (bulkLog = bulkLog3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog2);
        return bulkLog;
    }

    private BulkLog updatePlannedPropertyOfAffectedTasks(Instant planned, Map<Duration, List<String>> taskIdsByDueDuration) {
        BulkLog bulkLog;
        BulkLog bulkLog2;
        Instant instant = planned;
        Map<Duration, List<String>> map = taskIdsByDueDuration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)instant, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkLog bulkLog3 = new BulkLog();
        TaskImpl referenceTask = new TaskImpl();
        referenceTask.setPlanned(planned);
        referenceTask.setModified(Instant.now());
        taskIdsByDueDuration.forEach((duration, taskIds) -> {
            referenceTask.setDue(this.calculateDue(planned, (Duration)duration));
            Pair<List<MinimalTaskSummary>, BulkLog> existingAndAuthorizedTasks = this.taskServiceImpl.getMinimalTaskSummaries((Collection<String>)taskIds);
            bulkLog3.addAllErrors((BulkOperationResults)existingAndAuthorizedTasks.getRight());
            this.taskMapper.updateTaskDueDates((List)existingAndAuthorizedTasks.getLeft(), referenceTask);
        });
        BulkLog bulkLog4 = bulkLog2 = (bulkLog = bulkLog3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog2);
        return bulkLog;
    }

    private Map<Duration, List<String>> getDurationToTaskIdsMap(List<MinimalTaskSummary> minimalTaskSummariesAuthorizedFor, List<AttachmentSummaryImpl> attachments, List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithServiceLevelResolved) {
        Map<Duration, List<String>> map;
        Map<Duration, List<String>> map2;
        List<MinimalTaskSummary> list = minimalTaskSummariesAuthorizedFor;
        List<AttachmentSummaryImpl> list2 = attachments;
        List<ClassificationWithServiceLevelResolved> list3 = allInvolvedClassificationsWithServiceLevelResolved;
        Object[] objectArray = new Object[]{list, list2, list3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<TaskDuration> resultingTaskDurations = new ArrayList<TaskDuration>();
        Map<String, Set<String>> taskIdToClassificationIdsMap = this.getTaskIdToClassificationsMap(minimalTaskSummariesAuthorizedFor, attachments);
        Map<String, Duration> classificationIdToDurationMap = allInvolvedClassificationsWithServiceLevelResolved.stream().collect(Collectors.toMap(ClassificationWithServiceLevelResolved::getClassificationId, ClassificationWithServiceLevelResolved::getDurationFromClassification));
        for (MinimalTaskSummary task : minimalTaskSummariesAuthorizedFor) {
            Duration duration = this.determineMinimalDurationForATask(taskIdToClassificationIdsMap.get(task.getTaskId()), classificationIdToDurationMap);
            TaskDuration taskDuration = new TaskDuration(task.getTaskId(), duration, task.getPlanned());
            resultingTaskDurations.add(taskDuration);
        }
        Map<Duration, List<String>> map3 = map2 = (map = resultingTaskDurations.stream().collect(Collectors.groupingBy(TaskDuration::getDuration, Collectors.mapping(TaskDuration::getTaskId, Collectors.toList()))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    private Map<InstantDurationHolder, List<TaskDuration>> getTasksPerPlannedAndDuration(List<MinimalTaskSummary> minimalTaskSummaries, List<AttachmentSummaryImpl> attachments, List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithServiceLevelResolved) {
        Map<InstantDurationHolder, List<TaskDuration>> map;
        Map<InstantDurationHolder, List<TaskDuration>> map2;
        List<MinimalTaskSummary> list = minimalTaskSummaries;
        List<AttachmentSummaryImpl> list2 = attachments;
        List<ClassificationWithServiceLevelResolved> list3 = allInvolvedClassificationsWithServiceLevelResolved;
        Object[] objectArray = new Object[]{list, list2, list3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, Duration> durationPerClassificationId = this.getClassificationIdToDurationMap(allInvolvedClassificationsWithServiceLevelResolved);
        ArrayList<TaskDuration> resultingTaskDurations = new ArrayList<TaskDuration>();
        Map<String, Set<String>> taskIdClassificationIdsMap = this.getTaskIdToClassificationsMap(minimalTaskSummaries, attachments);
        for (MinimalTaskSummary task : minimalTaskSummaries) {
            Duration duration = this.determineMinimalDurationForATask(taskIdClassificationIdsMap.get(task.getTaskId()), durationPerClassificationId);
            TaskDuration taskDuration = new TaskDuration(task.getTaskId(), duration, task.getPlanned());
            resultingTaskDurations.add(taskDuration);
        }
        Map<InstantDurationHolder, List<TaskDuration>> map3 = map2 = (map = resultingTaskDurations.stream().collect(Collectors.groupingBy(TaskDuration::getPlannedDuration)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    private Map<String, Duration> getClassificationIdToDurationMap(List<ClassificationWithServiceLevelResolved> allInvolvedClassificationsWithServiceLevelResolved) {
        Map<String, Duration> map;
        Map<String, Duration> map2;
        List<ClassificationWithServiceLevelResolved> list = allInvolvedClassificationsWithServiceLevelResolved;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, Duration> map3 = map2 = (map = allInvolvedClassificationsWithServiceLevelResolved.stream().collect(Collectors.toMap(ClassificationWithServiceLevelResolved::getClassificationId, ClassificationWithServiceLevelResolved::getDurationFromClassification)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    private Duration determineMinimalDurationForATask(Set<String> classificationIds, Map<String, Duration> classificationIdDurationMap) {
        Duration duration;
        Duration duration2;
        Set<String> set = classificationIds;
        Map<String, Duration> map = classificationIdDurationMap;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, set, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration result = MAX_DURATION;
        for (String classificationId : classificationIds) {
            Duration actualDuration = classificationIdDurationMap.get(classificationId);
            if (result.compareTo(actualDuration) <= 0) continue;
            result = actualDuration;
        }
        Duration duration3 = duration2 = (duration = result);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    private Map<String, Set<String>> getTaskIdToClassificationsMap(List<MinimalTaskSummary> minimalTaskSummaries, List<AttachmentSummaryImpl> attachments) {
        HashMap<String, Set<String>> hashMap;
        HashMap<String, Set<String>> hashMap2;
        List<MinimalTaskSummary> list = minimalTaskSummaries;
        List<AttachmentSummaryImpl> list2 = attachments;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashMap<String, Set<String>> resultingTaskIdToClassificationIdsMap = new HashMap<String, Set<String>>();
        for (MinimalTaskSummary task : minimalTaskSummaries) {
            Set classificationIds = attachments.stream().filter(a -> task.getTaskId().equals(a.getTaskId())).map(AttachmentSummaryImpl::getClassificationSummary).map(ClassificationSummary::getId).collect(Collectors.toSet());
            classificationIds.add(task.getClassificationId());
            resultingTaskIdToClassificationIdsMap.put(task.getTaskId(), classificationIds);
        }
        HashMap<String, Set<String>> hashMap3 = hashMap2 = (hashMap = resultingTaskIdToClassificationIdsMap);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, hashMap2);
        return hashMap;
    }

    private List<ClassificationWithServiceLevelResolved> resolveDurationsInClassifications(List<ClassificationSummary> allInvolvedClassifications) {
        ArrayList<ClassificationWithServiceLevelResolved> arrayList;
        ArrayList<ClassificationWithServiceLevelResolved> arrayList2;
        List<ClassificationSummary> list = allInvolvedClassifications;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<ClassificationWithServiceLevelResolved> result = new ArrayList<ClassificationWithServiceLevelResolved>();
        for (ClassificationSummary classification : allInvolvedClassifications) {
            Duration serviceLevel = Duration.parse(classification.getServiceLevel());
            result.add(new ClassificationWithServiceLevelResolved(classification.getId(), serviceLevel, classification.getPriority()));
        }
        ArrayList<ClassificationWithServiceLevelResolved> arrayList3 = arrayList2 = (arrayList = result);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    private List<AttachmentSummaryImpl> getAttachmentSummaries(List<MinimalTaskSummary> existingTasksAuthorizedFor) {
        ArrayList<AttachmentSummaryImpl> arrayList;
        List<MinimalTaskSummary> list = existingTasksAuthorizedFor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> existingTaskIdsAuthorizedFor = existingTasksAuthorizedFor.stream().map(MinimalTaskSummary::getTaskId).toList();
        ArrayList<AttachmentSummaryImpl> arrayList2 = existingTaskIdsAuthorizedFor.isEmpty() ? new ArrayList() : this.attachmentMapper.findAttachmentSummariesByTaskIds(existingTaskIdsAuthorizedFor);
        ArrayList<AttachmentSummaryImpl> arrayList3 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    private List<ClassificationSummary> findAllClassificationsReferencedByTasksAndAttachments(List<MinimalTaskSummary> existingTasksAuthorizedFor, List<AttachmentSummaryImpl> attachments) {
        ArrayList<ClassificationSummary> arrayList;
        List<ClassificationSummary> list;
        List<ClassificationSummary> list2;
        List<MinimalTaskSummary> list3 = existingTasksAuthorizedFor;
        List<AttachmentSummaryImpl> list4 = attachments;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, list3, list4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<String> classificationIds = attachments.stream().map(AttachmentSummaryImpl::getClassificationSummary).map(ClassificationSummary::getId).collect(Collectors.toSet());
        Set classificationIdsFromTasks = existingTasksAuthorizedFor.stream().map(MinimalTaskSummary::getClassificationId).collect(Collectors.toSet());
        classificationIds.addAll(classificationIdsFromTasks);
        if (classificationIds.isEmpty()) {
            list = list2 = new ArrayList<ClassificationSummary>();
        } else {
            String[] idsArrayForQuery = new String[classificationIds.size()];
            idsArrayForQuery = classificationIds.toArray(idsArrayForQuery);
            list = list2 = this.kadaiEngine.getEngine().getClassificationService().createClassificationQuery().idIn(idsArrayForQuery).list();
        }
        ArrayList<ClassificationSummary> arrayList2 = arrayList = list;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return list2;
    }

    private DurationPrioHolder getFinalPrioDurationOfTask(List<ClassificationWithServiceLevelResolved> cl, boolean onlyPriority) {
        DurationPrioHolder durationPrioHolder;
        DurationPrioHolder durationPrioHolder2;
        List<ClassificationWithServiceLevelResolved> list = cl;
        boolean bl = onlyPriority;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, list, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration = MAX_DURATION;
        int priority = Integer.MIN_VALUE;
        for (ClassificationWithServiceLevelResolved classification : cl) {
            Duration actualDuration = classification.getDurationFromClassification();
            if (!onlyPriority && duration.compareTo(actualDuration) > 0) {
                duration = actualDuration;
            }
            if (classification.getPriority() <= priority) continue;
            priority = classification.getPriority();
        }
        DurationPrioHolder durationPrioHolder3 = durationPrioHolder2 = (durationPrioHolder = new DurationPrioHolder(duration, priority));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)durationPrioHolder2);
        return durationPrioHolder;
    }

    private Set<ClassificationSummary> getClassificationsReferencedByATask(TaskImpl taskImpl) {
        HashSet<ClassificationSummary> hashSet;
        HashSet<ClassificationSummary> hashSet2;
        TaskImpl taskImpl2 = taskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashSet<ClassificationSummary> classifications = taskImpl.getAttachments() == null ? new HashSet<ClassificationSummary>() : taskImpl.getAttachments().stream().map(AttachmentSummary::getClassificationSummary).collect(Collectors.toSet());
        classifications.add(taskImpl.getClassificationSummary());
        HashSet<ClassificationSummary> hashSet3 = hashSet2 = (hashSet = classifications);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, hashSet2);
        return hashSet;
    }

    private boolean isPriorityAndDurationAlreadyCorrect(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (oldTaskImpl == null) {
            bl2 = bl3 = false;
        } else {
            boolean isClassificationKeyChanged = !Objects.equals(newTaskImpl.getClassificationKey(), oldTaskImpl.getClassificationKey());
            boolean isClassificationIdChanged = !Objects.equals(newTaskImpl.getClassificationId(), oldTaskImpl.getClassificationId());
            boolean isManualPriorityChanged = newTaskImpl.getManualPriority() != oldTaskImpl.getManualPriority();
            bl2 = oldTaskImpl.getPlanned().equals(newTaskImpl.getPlanned()) && oldTaskImpl.getDue().equals(newTaskImpl.getDue()) && !isClassificationKeyChanged && !isClassificationIdChanged && !isManualPriorityChanged && this.areAttachmentsUnchanged(newTaskImpl, oldTaskImpl) ? (bl3 = true) : (bl3 = false);
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    private boolean areAttachmentsUnchanged(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) {
        boolean bl;
        boolean bl2;
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set oldAttachmentIds = oldTaskImpl.getAttachments().stream().map(AttachmentSummary::getId).collect(Collectors.toSet());
        Set newAttachmentIds = newTaskImpl.getAttachments().stream().map(AttachmentSummary::getId).collect(Collectors.toSet());
        Set oldClassificationIds = oldTaskImpl.getAttachments().stream().map(AttachmentSummary::getClassificationSummary).map(ClassificationSummary::getId).collect(Collectors.toSet());
        Set newClassificationIds = newTaskImpl.getAttachments().stream().map(AttachmentSummary::getClassificationSummary).map(ClassificationSummary::getId).collect(Collectors.toSet());
        boolean bl3 = bl2 = oldAttachmentIds.size() == newAttachmentIds.size() && newAttachmentIds.containsAll(oldAttachmentIds) && oldClassificationIds.size() == newClassificationIds.size() && newClassificationIds.containsAll(oldClassificationIds) ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ServiceLevelHandler.java", ServiceLevelHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshPriorityAndDueDatesOfTasks", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List:boolean:boolean", "tasks:serviceLevelChanged:priorityChanged", "", "void"), 76);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "setPlannedPropertyOfTasksImpl", "io.kadai.task.internal.ServiceLevelHandler", "java.time.Instant:java.util.List", "planned:tasks", "", "io.kadai.task.internal.ServiceLevelHandler$BulkLog"), 105);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "recalcPlannedBasedOnDue", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl:io.kadai.task.internal.models.TaskImpl:java.time.Duration", "newTaskImpl:oldTaskImpl:duration", "io.kadai.common.api.exceptions.InvalidArgumentException", "void"), 298);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "recalcDueBasedPlanned", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl:java.time.Duration", "newTaskImpl:duration", "", "void"), 310);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "plannedHasChanged", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.api.models.Task:io.kadai.task.api.models.Task", "newTask:oldTask", "", "boolean"), 316);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateDue", "io.kadai.task.internal.ServiceLevelHandler", "java.time.Instant:java.time.Duration", "planned:duration", "", "java.time.Instant"), 320);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculatePlanned", "io.kadai.task.internal.ServiceLevelHandler", "java.time.Instant:java.time.Duration", "due:duration", "", "java.time.Instant"), 334);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "normalizeDue", "io.kadai.task.internal.ServiceLevelHandler", "java.time.Instant", "due", "", "java.time.Instant"), 348);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "normalizePlanned", "io.kadai.task.internal.ServiceLevelHandler", "java.time.Instant", "instant", "", "java.time.Instant"), 361);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "ensureServiceLevelIsNotViolated", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl:java.time.Duration:java.time.Instant", "task:duration:calcPlanned", "io.kadai.common.api.exceptions.InvalidArgumentException", "void"), 386);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updatePlannedDueOnCreationOfNewTask", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl:java.time.Duration", "newTask:duration", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.task.internal.models.TaskImpl"), 405);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateDuePropertyOfAffectedTasks", "io.kadai.task.internal.ServiceLevelHandler", "java.util.Map", "tasksPerPlannedAndDuration", "", "io.kadai.task.internal.ServiceLevelHandler$BulkLog"), 426);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "updatePrioPlannedDueOfTask", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl:io.kadai.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.task.internal.models.TaskImpl"), 128);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateDuePropertyOfTasksWithIdenticalDueDate", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.ServiceLevelHandler$InstantDurationHolder:java.util.List", "durationHolder:taskDurationList", "", "io.kadai.common.api.BulkOperationResults"), 436);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updatePlannedPropertyOfAffectedTasks", "io.kadai.task.internal.ServiceLevelHandler", "java.time.Instant:java.util.Map", "planned:taskIdsByDueDuration", "", "io.kadai.task.internal.ServiceLevelHandler$BulkLog"), 452);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDurationToTaskIdsMap", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List:java.util.List:java.util.List", "minimalTaskSummariesAuthorizedFor:attachments:allInvolvedClassificationsWithServiceLevelResolved", "", "java.util.Map"), 471);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksPerPlannedAndDuration", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List:java.util.List:java.util.List", "minimalTaskSummaries:attachments:allInvolvedClassificationsWithServiceLevelResolved", "", "java.util.Map"), 502);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getClassificationIdToDurationMap", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List", "allInvolvedClassificationsWithServiceLevelResolved", "", "java.util.Map"), 527);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineMinimalDurationForATask", "io.kadai.task.internal.ServiceLevelHandler", "java.util.Set:java.util.Map", "classificationIds:classificationIdDurationMap", "", "java.time.Duration"), 538);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTaskIdToClassificationsMap", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List:java.util.List", "minimalTaskSummaries:attachments", "", "java.util.Map"), 551);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "resolveDurationsInClassifications", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List", "allInvolvedClassifications", "", "java.util.List"), 567);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getAttachmentSummaries", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List", "existingTasksAuthorizedFor", "", "java.util.List"), 579);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findAllClassificationsReferencedByTasksAndAttachments", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List:java.util.List", "existingTasksAuthorizedFor:attachments", "", "java.util.List"), 589);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineTaskPrioDuration", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl:boolean", "newTaskImpl:onlyPriority", "", "io.kadai.task.internal.ServiceLevelHandler$DurationPrioHolder"), 166);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFinalPrioDurationOfTask", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List:boolean", "cl:onlyPriority", "", "io.kadai.task.internal.ServiceLevelHandler$DurationPrioHolder"), 616);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getClassificationsReferencedByATask", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl", "taskImpl", "", "java.util.Set"), 632);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isPriorityAndDurationAlreadyCorrect", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl:io.kadai.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "", "boolean"), 643);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "areAttachmentsUnchanged", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl:io.kadai.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "", "boolean"), 664);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setPlannedDueOnMissingServiceLevel", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl", "task", "", "void"), 184);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateTaskPriorityOnClassificationUpdate", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List:java.util.List:java.util.List", "existingTasks:attachments:allInvolvedClassifications", "", "void"), 196);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getPriorityToTasksIdsMap", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List:java.util.List:java.util.List", "existingTasks:attachments:allInvolvedClassifications", "", "java.util.Map"), 213);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determinePriorityForATask", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.MinimalTaskSummary:java.util.Map:java.util.Map", "minimalTaskSummary:classificationIdToPriorityMap:taskIdToClassificationIdsMap", "", "int"), 241);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateTaskDueDatesOnClassificationUpdate", "io.kadai.task.internal.ServiceLevelHandler", "java.util.List:java.util.List:java.util.List", "existingTasks:attachments:allInvolvedClassificationsWithDuration", "", "io.kadai.task.internal.ServiceLevelHandler$BulkLog"), 257);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updatePlannedDueOnTaskUpdate", "io.kadai.task.internal.ServiceLevelHandler", "io.kadai.task.internal.models.TaskImpl:io.kadai.task.internal.models.TaskImpl:java.time.Duration", "newTaskImpl:oldTaskImpl:duration", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.task.internal.models.TaskImpl"), 267);
    }

    static class BulkLog
    extends BulkOperationResults<String, KadaiException> {
        BulkLog() {
        }
    }

    private static final class ClassificationWithServiceLevelResolved {
        private final int priority;
        private final String classificationId;
        private final Duration duration;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        ClassificationWithServiceLevelResolved(String id, Duration serviceLevel, int priority) {
            this.classificationId = id;
            this.duration = serviceLevel;
            this.priority = priority;
        }

        String getClassificationId() {
            String string;
            String string2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = this.classificationId);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        Duration getDurationFromClassification() {
            Duration duration;
            Duration duration2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Duration duration3 = duration2 = (duration = this.duration);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
            return duration;
        }

        int getPriority() {
            int n;
            int n2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int n3 = n2 = (n = this.priority);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
            return n;
        }

        static {
            ClassificationWithServiceLevelResolved.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ServiceLevelHandler.java", ClassificationWithServiceLevelResolved.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getClassificationId", "io.kadai.task.internal.ServiceLevelHandler$ClassificationWithServiceLevelResolved", "", "", "", "java.lang.String"), 810);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getDurationFromClassification", "io.kadai.task.internal.ServiceLevelHandler$ClassificationWithServiceLevelResolved", "", "", "", "java.time.Duration"), 814);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getPriority", "io.kadai.task.internal.ServiceLevelHandler$ClassificationWithServiceLevelResolved", "", "", "", "int"), 818);
        }
    }

    static final class DurationPrioHolder
    extends Record {
        private final Duration duration;
        private final int priority;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        DurationPrioHolder(Duration duration, int priority) {
            this.duration = duration;
            this.priority = priority;
        }

        public Duration duration() {
            Duration duration;
            Duration duration2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Duration duration3 = duration2 = (duration = this.duration);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
            return duration;
        }

        public int priority() {
            int n;
            int n2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int n3 = n2 = (n = this.priority);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
            return n;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DurationPrioHolder.class, "duration;priority", "duration", "priority"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DurationPrioHolder.class, "duration;priority", "duration", "priority"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DurationPrioHolder.class, "duration;priority", "duration", "priority"}, this, object);
        }

        static {
            DurationPrioHolder.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ServiceLevelHandler.java", DurationPrioHolder.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "duration", "io.kadai.task.internal.ServiceLevelHandler$DurationPrioHolder", "", "", "", "java.time.Duration"), 692);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "priority", "io.kadai.task.internal.ServiceLevelHandler$DurationPrioHolder", "", "", "", "int"), 692);
        }
    }

    private static final class InstantDurationHolder {
        private Instant planned;
        private Duration duration;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

        InstantDurationHolder(Instant planned, Duration duration) {
            this.planned = planned;
            this.duration = duration;
        }

        public Instant getPlanned() {
            Instant instant;
            Instant instant2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Instant instant3 = instant2 = (instant = this.planned);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
            return instant;
        }

        public void setPlanned(Instant planned) {
            Instant instant = planned;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)instant);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.planned = planned;
            Object var4_4 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
        }

        public Duration getDuration() {
            Duration duration;
            Duration duration2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Duration duration3 = duration2 = (duration = this.duration);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
            return duration;
        }

        public void setDuration(Duration duration) {
            Duration duration2 = duration;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)duration2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.duration = duration;
            Object var4_4 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
        }

        public int hashCode() {
            return Objects.hash(this.planned, this.duration);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstantDurationHolder other = (InstantDurationHolder)obj;
            return Objects.equals(this.planned, other.planned) && Objects.equals(this.duration, other.duration);
        }

        static {
            InstantDurationHolder.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ServiceLevelHandler.java", InstantDurationHolder.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPlanned", "io.kadai.task.internal.ServiceLevelHandler$InstantDurationHolder", "", "", "", "java.time.Instant"), 761);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPlanned", "io.kadai.task.internal.ServiceLevelHandler$InstantDurationHolder", "java.time.Instant", "planned", "", "void"), 765);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDuration", "io.kadai.task.internal.ServiceLevelHandler$InstantDurationHolder", "", "", "", "java.time.Duration"), 769);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDuration", "io.kadai.task.internal.ServiceLevelHandler$InstantDurationHolder", "java.time.Duration", "duration", "", "void"), 773);
        }
    }

    private static final class TaskDuration {
        private final String taskId;
        private final Duration duration;
        private final Instant planned;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

        TaskDuration(String id, Duration serviceLevel, Instant planned) {
            this.taskId = id;
            this.duration = serviceLevel;
            this.planned = planned;
        }

        String getTaskId() {
            String string;
            String string2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = this.taskId);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        Duration getDuration() {
            Duration duration;
            Duration duration2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Duration duration3 = duration2 = (duration = this.duration);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
            return duration;
        }

        Instant getPlanned() {
            Instant instant;
            Instant instant2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Instant instant3 = instant2 = (instant = this.planned);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
            return instant;
        }

        InstantDurationHolder getPlannedDuration() {
            InstantDurationHolder instantDurationHolder;
            InstantDurationHolder instantDurationHolder2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            InstantDurationHolder instantDurationHolder3 = instantDurationHolder2 = (instantDurationHolder = new InstantDurationHolder(this.planned, this.duration));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantDurationHolder2);
            return instantDurationHolder;
        }

        static {
            TaskDuration.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ServiceLevelHandler.java", TaskDuration.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getTaskId", "io.kadai.task.internal.ServiceLevelHandler$TaskDuration", "", "", "", "java.lang.String"), 707);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getDuration", "io.kadai.task.internal.ServiceLevelHandler$TaskDuration", "", "", "", "java.time.Duration"), 711);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getPlanned", "io.kadai.task.internal.ServiceLevelHandler$TaskDuration", "", "", "", "java.time.Instant"), 715);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getPlannedDuration", "io.kadai.task.internal.ServiceLevelHandler$TaskDuration", "", "", "", "io.kadai.task.internal.ServiceLevelHandler$InstantDurationHolder"), 719);
        }
    }

    private static final class TaskIdPriority {
        private String taskId;
        private int priority;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

        TaskIdPriority(String taskId, int priority) {
            this.taskId = taskId;
            this.priority = priority;
        }

        public String getTaskId() {
            String string;
            String string2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = this.taskId);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        public void setTaskId(String taskId) {
            String string = taskId;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.taskId = taskId;
            Object var4_4 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
        }

        public Integer getPriority() {
            Integer n;
            Integer n2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Integer n3 = n2 = (n = Integer.valueOf(this.priority));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)n2);
            return n;
        }

        public void setPriority(int priority) {
            int n = priority;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.priority = priority;
            Object var4_4 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
        }

        static {
            TaskIdPriority.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ServiceLevelHandler.java", TaskIdPriority.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskId", "io.kadai.task.internal.ServiceLevelHandler$TaskIdPriority", "", "", "", "java.lang.String"), 734);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTaskId", "io.kadai.task.internal.ServiceLevelHandler$TaskIdPriority", "java.lang.String", "taskId", "", "void"), 738);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriority", "io.kadai.task.internal.ServiceLevelHandler$TaskIdPriority", "", "", "", "java.lang.Integer"), 742);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPriority", "io.kadai.task.internal.ServiceLevelHandler$TaskIdPriority", "int", "priority", "", "void"), 746);
        }
    }
}

