/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.internal;

import io.kadai.classification.api.ClassificationService;
import io.kadai.classification.api.exceptions.ClassificationNotFoundException;
import io.kadai.classification.api.models.Classification;
import io.kadai.classification.api.models.ClassificationSummary;
import io.kadai.common.api.BulkOperationResults;
import io.kadai.common.api.KadaiRole;
import io.kadai.common.api.exceptions.ConcurrencyException;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.util.CheckedConsumer;
import io.kadai.common.internal.util.CheckedFunction;
import io.kadai.common.internal.util.CollectionUtil;
import io.kadai.common.internal.util.EnumUtil;
import io.kadai.common.internal.util.IdGenerator;
import io.kadai.common.internal.util.ObjectAttributeChangeDetector;
import io.kadai.common.internal.util.Pair;
import io.kadai.spi.history.api.events.task.TaskCancelledEvent;
import io.kadai.spi.history.api.events.task.TaskClaimCancelledEvent;
import io.kadai.spi.history.api.events.task.TaskClaimedEvent;
import io.kadai.spi.history.api.events.task.TaskCompletedEvent;
import io.kadai.spi.history.api.events.task.TaskCreatedEvent;
import io.kadai.spi.history.api.events.task.TaskDeletedEvent;
import io.kadai.spi.history.api.events.task.TaskRequestChangesEvent;
import io.kadai.spi.history.api.events.task.TaskRequestReviewEvent;
import io.kadai.spi.history.api.events.task.TaskTerminatedEvent;
import io.kadai.spi.history.api.events.task.TaskUpdatedEvent;
import io.kadai.spi.history.internal.HistoryEventManager;
import io.kadai.spi.priority.internal.PriorityServiceManager;
import io.kadai.spi.routing.api.RoutingTarget;
import io.kadai.spi.task.internal.AfterRequestChangesManager;
import io.kadai.spi.task.internal.AfterRequestReviewManager;
import io.kadai.spi.task.internal.BeforeRequestChangesManager;
import io.kadai.spi.task.internal.BeforeRequestReviewManager;
import io.kadai.spi.task.internal.CreateTaskPreprocessorManager;
import io.kadai.spi.task.internal.ReviewRequiredManager;
import io.kadai.spi.task.internal.TaskEndstatePreprocessorManager;
import io.kadai.task.api.CallbackState;
import io.kadai.task.api.TaskCommentQuery;
import io.kadai.task.api.TaskCustomField;
import io.kadai.task.api.TaskQuery;
import io.kadai.task.api.TaskService;
import io.kadai.task.api.TaskState;
import io.kadai.task.api.exceptions.AttachmentPersistenceException;
import io.kadai.task.api.exceptions.InvalidCallbackStateException;
import io.kadai.task.api.exceptions.InvalidOwnerException;
import io.kadai.task.api.exceptions.InvalidTaskStateException;
import io.kadai.task.api.exceptions.NotAuthorizedOnTaskCommentException;
import io.kadai.task.api.exceptions.ObjectReferencePersistenceException;
import io.kadai.task.api.exceptions.TaskAlreadyExistException;
import io.kadai.task.api.exceptions.TaskCommentNotFoundException;
import io.kadai.task.api.exceptions.TaskNotFoundException;
import io.kadai.task.api.models.Attachment;
import io.kadai.task.api.models.AttachmentSummary;
import io.kadai.task.api.models.ObjectReference;
import io.kadai.task.api.models.Task;
import io.kadai.task.api.models.TaskComment;
import io.kadai.task.api.models.TaskSummary;
import io.kadai.task.internal.AttachmentHandler;
import io.kadai.task.internal.AttachmentMapper;
import io.kadai.task.internal.ObjectReferenceHandler;
import io.kadai.task.internal.ObjectReferenceMapper;
import io.kadai.task.internal.ServiceLevelHandler;
import io.kadai.task.internal.TaskCommentMapper;
import io.kadai.task.internal.TaskCommentQueryImpl;
import io.kadai.task.internal.TaskCommentServiceImpl;
import io.kadai.task.internal.TaskCustomPropertySelector;
import io.kadai.task.internal.TaskMapper;
import io.kadai.task.internal.TaskQueryImpl;
import io.kadai.task.internal.TaskTransferrer;
import io.kadai.task.internal.models.AttachmentImpl;
import io.kadai.task.internal.models.AttachmentSummaryImpl;
import io.kadai.task.internal.models.MinimalTaskSummary;
import io.kadai.task.internal.models.ObjectReferenceImpl;
import io.kadai.task.internal.models.TaskImpl;
import io.kadai.task.internal.models.TaskSummaryImpl;
import io.kadai.user.internal.UserMapper;
import io.kadai.user.internal.models.UserImpl;
import io.kadai.workbasket.api.WorkbasketPermission;
import io.kadai.workbasket.api.WorkbasketService;
import io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException;
import io.kadai.workbasket.api.models.Workbasket;
import io.kadai.workbasket.api.models.WorkbasketSummary;
import io.kadai.workbasket.internal.WorkbasketQueryImpl;
import io.kadai.workbasket.internal.models.WorkbasketSummaryImpl;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.exceptions.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServiceImpl
implements TaskService {
    private static final Logger LOGGER;
    private final InternalKadaiEngine kadaiEngine;
    private final WorkbasketService workbasketService;
    private final ClassificationService classificationService;
    private final TaskMapper taskMapper;
    private final TaskTransferrer taskTransferrer;
    private final TaskCommentServiceImpl taskCommentService;
    private final ServiceLevelHandler serviceLevelHandler;
    private final AttachmentHandler attachmentHandler;
    private final AttachmentMapper attachmentMapper;
    private final ObjectReferenceMapper objectReferenceMapper;
    private final ObjectReferenceHandler objectReferenceHandler;
    private final UserMapper userMapper;
    private final HistoryEventManager historyEventManager;
    private final CreateTaskPreprocessorManager createTaskPreprocessorManager;
    private final PriorityServiceManager priorityServiceManager;
    private final ReviewRequiredManager reviewRequiredManager;
    private final BeforeRequestReviewManager beforeRequestReviewManager;
    private final AfterRequestReviewManager afterRequestReviewManager;
    private final BeforeRequestChangesManager beforeRequestChangesManager;
    private final AfterRequestChangesManager afterRequestChangesManager;
    private final TaskEndstatePreprocessorManager taskEndstatePreprocessorManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_81;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_82;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_83;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_84;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_85;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_86;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_87;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_88;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_89;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_90;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_91;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_92;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_93;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_94;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_95;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_96;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_97;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_98;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_99;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_100;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_101;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_102;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_103;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_104;

    static {
        TaskServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    }

    public TaskServiceImpl(InternalKadaiEngine kadaiEngine, TaskMapper taskMapper, TaskCommentMapper taskCommentMapper, AttachmentMapper attachmentMapper, ObjectReferenceMapper objectReferenceMapper, UserMapper userMapper) {
        this.kadaiEngine = kadaiEngine;
        this.taskMapper = taskMapper;
        this.workbasketService = kadaiEngine.getEngine().getWorkbasketService();
        this.attachmentMapper = attachmentMapper;
        this.objectReferenceMapper = objectReferenceMapper;
        this.userMapper = userMapper;
        this.classificationService = kadaiEngine.getEngine().getClassificationService();
        this.historyEventManager = kadaiEngine.getHistoryEventManager();
        this.createTaskPreprocessorManager = kadaiEngine.getCreateTaskPreprocessorManager();
        this.priorityServiceManager = kadaiEngine.getPriorityServiceManager();
        this.reviewRequiredManager = kadaiEngine.getReviewRequiredManager();
        this.beforeRequestReviewManager = kadaiEngine.getBeforeRequestReviewManager();
        this.afterRequestReviewManager = kadaiEngine.getAfterRequestReviewManager();
        this.beforeRequestChangesManager = kadaiEngine.getBeforeRequestChangesManager();
        this.afterRequestChangesManager = kadaiEngine.getAfterRequestChangesManager();
        this.taskEndstatePreprocessorManager = kadaiEngine.getTaskEndstatePreprocessorManager();
        this.taskTransferrer = new TaskTransferrer(kadaiEngine, taskMapper, this);
        this.taskCommentService = new TaskCommentServiceImpl(kadaiEngine, taskCommentMapper, userMapper, taskMapper, this);
        this.serviceLevelHandler = new ServiceLevelHandler(kadaiEngine, taskMapper, attachmentMapper, this);
        this.attachmentHandler = new AttachmentHandler(attachmentMapper, this.classificationService);
        this.objectReferenceHandler = new ObjectReferenceHandler(objectReferenceMapper);
    }

    private static Predicate<TaskSummaryImpl> addErrorToBulkLog(CheckedConsumer<TaskSummaryImpl, KadaiException> checkedConsumer, BulkOperationResults<String, KadaiException> bulkLog) {
        Predicate<TaskSummaryImpl> predicate;
        Predicate<TaskSummaryImpl> predicate2;
        CheckedConsumer<TaskSummaryImpl, KadaiException> checkedConsumer2 = checkedConsumer;
        BulkOperationResults<String, KadaiException> bulkOperationResults = bulkLog;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, checkedConsumer2, bulkOperationResults);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Predicate<TaskSummaryImpl> predicate3 = predicate2 = (predicate = summary -> {
            try {
                checkedConsumer.accept(summary);
                return true;
            }
            catch (KadaiException e) {
                bulkLog.addError((Object)summary.getId(), (Exception)((Object)e));
                return false;
            }
        });
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, predicate2);
        return predicate;
    }

    private static void terminateCancelCommonActions(TaskImpl task, TaskState targetState) {
        TaskImpl taskImpl = task;
        TaskState taskState = targetState;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)taskImpl, (Object)((Object)taskState));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant now = Instant.now();
        task.setModified(now);
        task.setCompleted(now);
        task.setState(targetState);
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private static void claimActionsOnTask(TaskSummaryImpl task, String userId, String userLongName, Instant now) {
        TaskSummaryImpl taskSummaryImpl = task;
        String string = userId;
        String string2 = userLongName;
        Instant instant = now;
        Object[] objectArray = new Object[]{taskSummaryImpl, string, string2, instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        task.setOwner(userId);
        task.setOwnerLongName(userLongName);
        task.setModified(now);
        task.setClaimed(now);
        task.setRead(true);
        if (Set.of(TaskState.READY_FOR_REVIEW, TaskState.IN_REVIEW).contains((Object)task.getState())) {
            task.setState(TaskState.IN_REVIEW);
        } else {
            task.setState(TaskState.CLAIMED);
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private static void cancelClaimActionsOnTask(TaskSummaryImpl task, Instant now, boolean keepOwner) {
        TaskSummaryImpl taskSummaryImpl = task;
        Instant instant = now;
        boolean bl = keepOwner;
        Object[] objectArray = new Object[]{taskSummaryImpl, instant, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!keepOwner) {
            task.setOwner(null);
            task.setOwnerLongName(null);
        }
        task.setModified(now);
        task.setClaimed(null);
        task.setRead(true);
        if (task.getState() == TaskState.IN_REVIEW) {
            task.setState(TaskState.READY_FOR_REVIEW);
        } else {
            task.setState(TaskState.READY);
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private static void completeActionsOnTask(TaskSummaryImpl task, String userId, Instant now) {
        TaskSummaryImpl taskSummaryImpl = task;
        String string = userId;
        Instant instant = now;
        Object[] objectArray = new Object[]{taskSummaryImpl, string, instant};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        task.setCompleted(now);
        task.setModified(now);
        task.setState(TaskState.COMPLETED);
        task.setOwner(userId);
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    @Override
    public List<String> updateTasks(ObjectReference selectionCriteria, Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ObjectReference objectReference = selectionCriteria;
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)objectReference, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReferenceImpl.validate(selectionCriteria, "ObjectReference", "updateTasks call");
        this.validateCustomFields(customFieldsToUpdate);
        TaskCustomPropertySelector fieldSelector = new TaskCustomPropertySelector();
        TaskImpl updated = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.kadaiEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(selectionCriteria);
            ArrayList<TaskSummary> tasksWithPermissions = new ArrayList<TaskSummary>();
            for (TaskSummary taskSummary : taskSummaries) {
                if (!this.checkEditTasksPerm(taskSummary)) continue;
                tasksWithPermissions.add(taskSummary);
            }
            ArrayList<String> changedTasks = new ArrayList<String>();
            if (!tasksWithPermissions.isEmpty()) {
                changedTasks = tasksWithPermissions.stream().map(TaskSummary::getId).toList();
                this.taskMapper.updateTasks(changedTasks, updated, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", changedTasks);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList3 = changedTasks;
            arrayList2 = arrayList3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        ArrayList<String> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    private static void checkIfTaskIsTerminatedOrCancelled(TaskSummary task) throws InvalidTaskStateException {
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (task.getState().in(TaskState.CANCELLED, TaskState.TERMINATED)) {
            throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])new TaskState[]{TaskState.CANCELLED, TaskState.TERMINATED}));
        }
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    @Override
    public Task claim(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.claim(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceClaim(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.claim(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task cancelClaim(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.cancelClaim(taskId, false, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceCancelClaim(String taskId) throws TaskNotFoundException, InvalidTaskStateException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            task2 = this.cancelClaim(taskId, true, false);
        }
        catch (InvalidOwnerException e) {
            throw new SystemException("this should not have happened. You've discovered a new bug!", (Throwable)((Object)e));
        }
        Task task3 = task = task2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task);
        return task2;
    }

    @Override
    public Task cancelClaim(String taskId, boolean keepOwner) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        boolean bl = keepOwner;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.cancelClaim(taskId, false, keepOwner));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceCancelClaim(String taskId, boolean keepOwner) throws TaskNotFoundException, InvalidTaskStateException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        boolean bl = keepOwner;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            task2 = this.cancelClaim(taskId, true, keepOwner);
        }
        catch (InvalidOwnerException e) {
            throw new SystemException("this should not have happened. You've discovered a new bug!", (Throwable)((Object)e));
        }
        Task task3 = task = task2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task);
        return task2;
    }

    @Override
    public Task requestReview(String taskId) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.requestReview(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceRequestReview(String taskId) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.requestReview(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task requestChanges(String taskId) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.requestChanges(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceRequestChanges(String taskId) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.requestChanges(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task completeTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.completeTask(taskId, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task forceCompleteTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.completeTask(taskId, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task createTask(Task taskToCreate) throws WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidArgumentException, AttachmentPersistenceException, ObjectReferencePersistenceException, NotAuthorizedOnWorkbasketException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        Task task = taskToCreate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)task);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.createTaskPreprocessorManager.isEnabled()) {
            taskToCreate = this.createTaskPreprocessorManager.processTaskBeforeCreation(taskToCreate);
        }
        TaskImpl task2 = (TaskImpl)taskToCreate;
        try {
            String classificationKey;
            Workbasket workbasket;
            this.kadaiEngine.openConnection();
            if (task2.getId() != null && !task2.getId().isEmpty()) {
                throw new InvalidArgumentException("taskId must be empty when creating a task");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task {} cannot be found, so it can be created.", (Object)task2.getId());
            }
            if (task2.getWorkbasketSummary() != null && task2.getWorkbasketSummary().getId() != null) {
                workbasket = this.workbasketService.getWorkbasket(task2.getWorkbasketSummary().getId());
            } else if (task2.getWorkbasketKey() != null) {
                workbasket = this.workbasketService.getWorkbasket(task2.getWorkbasketKey(), task2.getDomain());
            } else {
                RoutingTarget routingTarget = this.calculateWorkbasketDuringTaskCreation(task2);
                String owner = routingTarget.getOwner() == null ? task2.getOwner() : routingTarget.getOwner();
                workbasket = this.workbasketService.getWorkbasket(routingTarget.getWorkbasketId());
                task2.setOwner(owner);
            }
            if (workbasket.isMarkedForDeletion()) {
                throw new WorkbasketNotFoundException(workbasket.getId());
            }
            task2.setWorkbasketSummary(workbasket.asSummary());
            task2.setDomain(workbasket.getDomain());
            if (!this.kadaiEngine.getEngine().isUserInRole(KadaiRole.TASK_ROUTER)) {
                this.workbasketService.checkAuthorization(task2.getWorkbasketSummary().getId(), WorkbasketPermission.APPEND);
            }
            if ((classificationKey = task2.getClassificationKey()) == null || classificationKey.length() == 0) {
                throw new InvalidArgumentException("classificationKey of task must not be empty");
            }
            Classification classification = this.classificationService.getClassification(classificationKey, workbasket.getDomain());
            task2.setClassificationSummary(classification.asSummary());
            ObjectReferenceImpl.validate(task2.getPrimaryObjRef(), "primary ObjectReference", "Task");
            this.standardSettingsOnTaskCreation(task2, classification);
            this.setCallbackStateOnTaskCreation(task2);
            this.priorityServiceManager.calculatePriorityOfTask(task2).ifPresent(task2::setPriority);
            try {
                this.taskMapper.insert(task2);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Method createTask() created Task '{}'.", (Object)task2.getId());
                }
                if (this.historyEventManager.isEnabled()) {
                    String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)this.newTask(), (Object)task2);
                    this.historyEventManager.createEvent(new TaskCreatedEvent(IdGenerator.generateWithPrefix((String)"THI"), task2, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
                }
            }
            catch (PersistenceException e) {
                String msg;
                String string = msg = e.getMessage() != null ? e.getMessage().toLowerCase() : null;
                if (msg != null && (msg.contains("violation") || msg.contains("violates") || msg.contains("violated") || msg.contains("verletzt")) && msg.contains("external_id")) {
                    throw new TaskAlreadyExistException(task2.getExternalId());
                }
                throw e;
            }
            TaskImpl taskImpl3 = task2;
            taskImpl2 = taskImpl3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    @Override
    public Task getTask(String id) throws NotAuthorizedOnWorkbasketException, TaskNotFoundException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        JoinPoint joinPoint;
        block10: {
            String string = id;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                this.kadaiEngine.openConnection();
                TaskImpl resultTask = this.taskMapper.findById(id);
                if (resultTask != null) {
                    UserImpl owner;
                    List<ObjectReferenceImpl> secondaryObjectReferences;
                    WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
                    query.setUsedToAugmentTasks(true);
                    String workbasketId = resultTask.getWorkbasketSummary().getId();
                    List workbaskets = query.idIn(workbasketId).callerHasPermissions(WorkbasketPermission.READTASKS).list();
                    if (workbaskets.isEmpty()) {
                        throw new NotAuthorizedOnWorkbasketException(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), workbasketId, WorkbasketPermission.READ, WorkbasketPermission.READTASKS);
                    }
                    resultTask.setWorkbasketSummary((WorkbasketSummary)workbaskets.get(0));
                    List<AttachmentImpl> attachmentImpls = this.attachmentMapper.findAttachmentsByTaskId(resultTask.getId());
                    if (attachmentImpls == null) {
                        attachmentImpls = new ArrayList<AttachmentImpl>();
                    }
                    if ((secondaryObjectReferences = this.objectReferenceMapper.findObjectReferencesByTaskId(resultTask.getId())) == null) {
                        secondaryObjectReferences = new ArrayList<ObjectReferenceImpl>();
                    }
                    Map<String, ClassificationSummary> classificationSummariesById = this.findClassificationForTaskImplAndAttachments(resultTask, attachmentImpls);
                    this.addClassificationSummariesToAttachments(attachmentImpls, classificationSummariesById);
                    resultTask.setAttachments(new ArrayList<Attachment>(attachmentImpls));
                    resultTask.setSecondaryObjectReferences(new ArrayList<ObjectReference>(secondaryObjectReferences));
                    String classificationId = resultTask.getClassificationSummary().getId();
                    ClassificationSummary classification = classificationSummariesById.get(classificationId);
                    if (classification == null) {
                        throw new SystemException("Could not find a Classification for task " + resultTask.getId());
                    }
                    resultTask.setClassificationSummary(classification);
                    if (resultTask.getOwner() != null && !resultTask.getOwner().isEmpty() && this.kadaiEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (owner = this.userMapper.findById(resultTask.getOwner())) != null) {
                        resultTask.setOwnerLongName(owner.getLongName());
                    }
                    TaskImpl taskImpl3 = resultTask;
                    taskImpl2 = taskImpl3;
                    break block10;
                }
                throw new TaskNotFoundException(id);
            }
            finally {
                this.kadaiEngine.returnConnection();
            }
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    @Override
    public Task transfer(String taskId, String destinationWorkbasketId, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.taskTransferrer.transfer(taskId, destinationWorkbasketId, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task transfer(String taskId, String workbasketKey, String domain, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = workbasketKey;
        String string3 = domain;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.taskTransferrer.transfer(taskId, workbasketKey, domain, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task transferWithOwner(String taskId, String destinationWorkbasketId, String owner, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        String string3 = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.taskTransferrer.transferWithOwner(taskId, destinationWorkbasketId, owner, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task transferWithOwner(String taskId, String workbasketKey, String domain, String owner, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = workbasketKey;
        String string3 = domain;
        String string4 = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, string3, string4, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.taskTransferrer.transferWithOwner(taskId, workbasketKey, domain, owner, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task setTaskRead(String taskId, boolean isRead) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = taskId;
        boolean bl = isRead;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.kadaiEngine.openConnection();
            TaskImpl task = (TaskImpl)this.getTask(taskId);
            task.setRead(isRead);
            task.setModified(Instant.now());
            this.taskMapper.update(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method setTaskRead() set read property of Task '{}' to {} ", (Object)task, (Object)isRead);
            }
            TaskImpl taskImpl3 = task;
            taskImpl2 = taskImpl3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    @Override
    public TaskQuery createTaskQuery() {
        TaskQueryImpl taskQueryImpl;
        TaskQueryImpl taskQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskQueryImpl taskQueryImpl3 = taskQueryImpl2 = (taskQueryImpl = new TaskQueryImpl(this.kadaiEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskQueryImpl2);
        return taskQueryImpl;
    }

    @Override
    public TaskCommentQuery createTaskCommentQuery() {
        TaskCommentQueryImpl taskCommentQueryImpl;
        TaskCommentQueryImpl taskCommentQueryImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskCommentQueryImpl taskCommentQueryImpl3 = taskCommentQueryImpl2 = (taskCommentQueryImpl = new TaskCommentQueryImpl(this.kadaiEngine));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQueryImpl2);
        return taskCommentQueryImpl;
    }

    @Override
    public Task newTask() {
        Task task;
        Task task2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Task task3 = task2 = (task = this.newTask(null));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    @Override
    public Task newTask(String workbasketId) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setId(workbasketId);
        task.setWorkbasketSummary(wb);
        task.setCallbackState(CallbackState.NONE);
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    @Override
    public Task newTask(String workbasketKey, String domain) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = workbasketKey;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setKey(workbasketKey);
        wb.setDomain(domain);
        task.setWorkbasketSummary(wb);
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    @Override
    public TaskComment newTaskComment(String taskId) {
        TaskComment taskComment;
        TaskComment taskComment2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment3 = taskComment2 = (taskComment = this.taskCommentService.newTaskComment(taskId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment2);
        return taskComment;
    }

    @Override
    public Attachment newAttachment() {
        AttachmentImpl attachmentImpl;
        AttachmentImpl attachmentImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        AttachmentImpl attachmentImpl3 = attachmentImpl2 = (attachmentImpl = new AttachmentImpl());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)attachmentImpl2);
        return attachmentImpl;
    }

    @Override
    public ObjectReference newObjectReference() {
        ObjectReferenceImpl objectReferenceImpl;
        ObjectReferenceImpl objectReferenceImpl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReferenceImpl objectReferenceImpl3 = objectReferenceImpl2 = (objectReferenceImpl = new ObjectReferenceImpl());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)objectReferenceImpl2);
        return objectReferenceImpl;
    }

    @Override
    public ObjectReference newObjectReference(String company, String system, String systemInstance, String type, String value) {
        ObjectReferenceImpl objectReferenceImpl;
        ObjectReferenceImpl objectReferenceImpl2;
        String string = company;
        String string2 = system;
        String string3 = systemInstance;
        String string4 = type;
        String string5 = value;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReferenceImpl objectReferenceImpl3 = objectReferenceImpl2 = (objectReferenceImpl = new ObjectReferenceImpl(company, system, systemInstance, type, value));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)objectReferenceImpl2);
        return objectReferenceImpl;
    }

    @Override
    public Task updateTask(Task task) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, AttachmentPersistenceException, ObjectReferencePersistenceException, ClassificationNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task2;
        Task task3;
        Task task4 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)task4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
        TaskImpl newTaskImpl = (TaskImpl)task;
        try {
            this.kadaiEngine.openConnection();
            TaskImpl oldTaskImpl = (TaskImpl)this.getTask(newTaskImpl.getId());
            this.checkConcurrencyAndSetModified(newTaskImpl, oldTaskImpl);
            if (!this.checkEditTasksPerm(oldTaskImpl)) {
                throw new NotAuthorizedOnWorkbasketException(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), oldTaskImpl.getWorkbasketSummary().getId(), WorkbasketPermission.EDITTASKS);
            }
            this.attachmentHandler.insertAndDeleteAttachmentsOnTaskUpdate(newTaskImpl, oldTaskImpl);
            this.objectReferenceHandler.insertAndDeleteObjectReferencesOnTaskUpdate(newTaskImpl, oldTaskImpl);
            ObjectReferenceImpl.validate(newTaskImpl.getPrimaryObjRef(), "primary ObjectReference", "Task");
            this.standardUpdateActions(oldTaskImpl, newTaskImpl);
            this.priorityServiceManager.calculatePriorityOfTask(newTaskImpl).ifPresent(newTaskImpl::setPriority);
            this.taskMapper.update(newTaskImpl);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Method updateTask() updated task '{}' for user '{}'.", (Object)task.getId(), (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTaskImpl, (Object)newTaskImpl);
                this.historyEventManager.createEvent(new TaskUpdatedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Task task5 = task3 = (task2 = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task3);
        return task2;
    }

    @Override
    public BulkOperationResults<String, KadaiException> transferTasks(String destinationWorkbasketId, List<String> taskIds, boolean setTransferFlag) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        String string = destinationWorkbasketId;
        List<String> list = taskIds;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, list, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.taskTransferrer.transfer(taskIds, destinationWorkbasketId, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public BulkOperationResults<String, KadaiException> transferTasks(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds, boolean setTransferFlag) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        String string = destinationWorkbasketKey;
        String string2 = destinationWorkbasketDomain;
        List<String> list = taskIds;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, list, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.taskTransferrer.transfer(taskIds, destinationWorkbasketKey, destinationWorkbasketDomain, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public BulkOperationResults<String, KadaiException> transferTasksWithOwner(String destinationWorkbasketId, List<String> taskIds, String owner, boolean setTransferFlag) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        String string = destinationWorkbasketId;
        List<String> list = taskIds;
        String string2 = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, list, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.taskTransferrer.transferWithOwner(taskIds, destinationWorkbasketId, owner, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public BulkOperationResults<String, KadaiException> transferTasksWithOwner(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds, String owner, boolean setTransferFlag) throws InvalidArgumentException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        String string = destinationWorkbasketKey;
        String string2 = destinationWorkbasketDomain;
        List<String> list = taskIds;
        String string3 = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, list, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.taskTransferrer.transferWithOwner(taskIds, destinationWorkbasketKey, destinationWorkbasketDomain, owner, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public void deleteTask(String taskId) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException {
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.deleteTask(taskId, false);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public void forceDeleteTask(String taskId) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException {
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.deleteTask(taskId, true);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public Optional<Task> selectAndClaim(TaskQuery taskQuery) throws NotAuthorizedOnWorkbasketException {
        Optional optional;
        Optional optional2;
        Optional optional3;
        TaskQuery taskQuery2 = taskQuery;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)taskQuery2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ((TaskQueryImpl)taskQuery).selectAndClaimEquals(true);
        try {
            optional2 = optional3 = this.kadaiEngine.executeInDatabaseConnection(() -> Optional.ofNullable((TaskSummary)taskQuery.single()).map(TaskSummary::getId).map(CheckedFunction.wrap(this::claim)));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception exception) {
            optional2 = optional3 = Optional.empty();
        }
        Optional optional4 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optional);
        return optional3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BulkOperationResults<String, KadaiException> deleteTasks(List<String> taskIds) throws InvalidArgumentException, NotAuthorizedException {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        BulkOperationResults bulkOperationResults3;
        JoinPoint joinPoint;
        block10: {
            List<String> list = taskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.ADMIN);
            this.kadaiEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("List of TaskIds must not be null.");
            }
            taskIds = new ArrayList<String>(taskIds);
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (taskIds.isEmpty()) {
                BulkOperationResults bulkOperationResults4 = bulkLog;
                bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults4;
                break block10;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
            Iterator<String> taskIdIterator = taskIds.iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForTaskDeletionById((BulkOperationResults<String, KadaiException>)bulkLog, taskSummaries, taskIdIterator);
            }
            if (!taskIds.isEmpty()) {
                this.attachmentMapper.deleteMultipleByTaskIds(taskIds);
                this.objectReferenceMapper.deleteMultipleByTaskIds(taskIds);
                this.taskMapper.deleteMultiple(taskIds);
                if (this.kadaiEngine.getEngine().isHistoryEnabled() && this.kadaiEngine.getEngine().getConfiguration().isDeleteHistoryEventsOnTaskDeletionEnabled()) {
                    this.historyEventManager.deleteEvents(taskIds);
                }
                if (this.historyEventManager.isEnabled()) {
                    taskIds.forEach(this::createTaskDeletedEvent);
                }
            }
            BulkOperationResults bulkOperationResults5 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults5;
            break block10;
            finally {
                this.kadaiEngine.returnConnection();
            }
        }
        BulkOperationResults bulkOperationResults6 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults3;
    }

    @Override
    public BulkOperationResults<String, KadaiException> completeTasks(List<String> taskIds) throws InvalidArgumentException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.completeTasks(taskIds, false));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public BulkOperationResults<String, KadaiException> forceCompleteTasks(List<String> taskIds) throws InvalidArgumentException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.completeTasks(taskIds, true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    @Override
    public List<String> updateTasks(List<String> taskIds, Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        List<String> list = taskIds;
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, list, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.validateCustomFields(customFieldsToUpdate);
        TaskCustomPropertySelector fieldSelector = new TaskCustomPropertySelector();
        TaskImpl updatedTask = this.initUpdatedTask(customFieldsToUpdate, fieldSelector);
        try {
            this.kadaiEngine.openConnection();
            List<TaskSummary> taskSummaries = this.getTasksToChange(taskIds);
            ArrayList<TaskSummary> tasksWithPermissions = new ArrayList<TaskSummary>();
            for (TaskSummary taskSummary : taskSummaries) {
                if (!this.checkEditTasksPerm(taskSummary)) continue;
                tasksWithPermissions.add(taskSummary);
            }
            ArrayList<String> changedTasks = new ArrayList<String>();
            if (!tasksWithPermissions.isEmpty()) {
                changedTasks = tasksWithPermissions.stream().map(TaskSummary::getId).toList();
                this.taskMapper.updateTasks(changedTasks, updatedTask, fieldSelector);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateTasks() updated the following tasks: {} ", changedTasks);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("updateTasks() found no tasks for update ");
            }
            ArrayList<String> arrayList3 = changedTasks;
            arrayList2 = arrayList3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        ArrayList<String> arrayList4 = arrayList = arrayList2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList);
        return arrayList2;
    }

    @Override
    public Task cancelTask(String taskId) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl cancelledTask;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.kadaiEngine.openConnection();
            if (taskId == null || taskId.isEmpty()) {
                throw new TaskNotFoundException(taskId);
            }
            cancelledTask = (TaskImpl)this.getTask(taskId);
            TaskState state = cancelledTask.getState();
            if (state.isEndState()) {
                throw new InvalidTaskStateException(taskId, state, TaskState.READY, TaskState.CLAIMED, TaskState.READY_FOR_REVIEW, TaskState.IN_REVIEW);
            }
            TaskServiceImpl.terminateCancelCommonActions(cancelledTask, TaskState.CANCELLED);
            cancelledTask = (TaskImpl)this.taskEndstatePreprocessorManager.processTaskBeforeEndstate(cancelledTask);
            this.taskMapper.update(cancelledTask);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task '{}' cancelled by user '{}'.", (Object)cancelledTask.getId(), (Object)this.kadaiEngine.getEngine().getCurrentUserContext().getUserid());
            }
            if (this.historyEventManager.isEnabled()) {
                this.historyEventManager.createEvent(new TaskCancelledEvent(IdGenerator.generateWithPrefix((String)"THI"), cancelledTask, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = cancelledTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    @Override
    public TaskComment createTaskComment(TaskComment taskComment) throws TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        TaskComment taskComment2;
        TaskComment taskComment3;
        TaskComment taskComment4 = taskComment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)taskComment4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment5 = taskComment3 = (taskComment2 = this.taskCommentService.createTaskComment(taskComment));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment3);
        return taskComment2;
    }

    @Override
    public TaskComment updateTaskComment(TaskComment taskComment) throws ConcurrencyException, TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException {
        TaskComment taskComment2;
        TaskComment taskComment3;
        TaskComment taskComment4 = taskComment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)taskComment4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment5 = taskComment3 = (taskComment2 = this.taskCommentService.updateTaskComment(taskComment));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment3);
        return taskComment2;
    }

    @Override
    public void deleteTaskComment(String taskCommentId) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedOnWorkbasketException {
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskCommentService.deleteTaskComment(taskCommentId);
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    @Override
    public TaskComment getTaskComment(String taskCommentid) throws TaskCommentNotFoundException, TaskNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        TaskComment taskComment;
        TaskComment taskComment2;
        String string = taskCommentid;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment3 = taskComment2 = (taskComment = this.taskCommentService.getTaskComment(taskCommentid));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskComment2);
        return taskComment;
    }

    @Override
    public List<TaskComment> getTaskComments(String taskId) throws TaskNotFoundException, NotAuthorizedOnWorkbasketException {
        List<TaskComment> list;
        List<TaskComment> list2;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TaskComment> list3 = list2 = (list = this.taskCommentService.getTaskComments(taskId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BulkOperationResults<String, KadaiException> setCallbackStateForTasks(List<String> externalIds, CallbackState state) {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        BulkOperationResults bulkOperationResults3;
        JoinPoint joinPoint;
        block7: {
            List<String> list = externalIds;
            CallbackState callbackState = state;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, list, (Object)((Object)callbackState));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.kadaiEngine.openConnection();
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (externalIds == null || externalIds.isEmpty()) {
                BulkOperationResults bulkOperationResults4 = bulkLog;
                bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults4;
                break block7;
            }
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(null, externalIds);
            Iterator<String> taskIdIterator = new ArrayList<String>(externalIds).iterator();
            while (taskIdIterator.hasNext()) {
                this.removeSingleTaskForCallbackStateByExternalId((BulkOperationResults<String, KadaiException>)bulkLog, taskSummaries, taskIdIterator, state);
            }
            if (!externalIds.isEmpty()) {
                this.taskMapper.setCallbackStateMultiple(externalIds, state);
            }
            BulkOperationResults bulkOperationResults5 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults5;
            break block7;
            finally {
                this.kadaiEngine.returnConnection();
            }
        }
        BulkOperationResults bulkOperationResults6 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults3;
    }

    @Override
    public BulkOperationResults<String, KadaiException> setOwnerOfTasks(String owner, List<String> taskIds) {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        BulkOperationResults bulkOperationResults3;
        JoinPoint joinPoint;
        block7: {
            String string = owner;
            List<String> list = taskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this, (Object)string, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            BulkOperationResults bulkLog = new BulkOperationResults();
            if (taskIds == null || taskIds.isEmpty()) {
                bulkOperationResults2 = bulkOperationResults3 = bulkLog;
            } else {
                this.kadaiEngine.openConnection();
                Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> existingAndAuthorizedTasks = this.getMinimalTaskSummaries(taskIds);
                bulkLog.addAllErrors((BulkOperationResults)existingAndAuthorizedTasks.getRight());
                Pair<List<String>, ServiceLevelHandler.BulkLog> taskIdsToUpdate = this.filterOutTasksWhichAreInInvalidState((Collection)existingAndAuthorizedTasks.getLeft());
                bulkLog.addAllErrors((BulkOperationResults)taskIdsToUpdate.getRight());
                if (!((List)taskIdsToUpdate.getLeft()).isEmpty()) {
                    this.taskMapper.setOwnerOfTasks(owner, (List)taskIdsToUpdate.getLeft(), Instant.now());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received the Request to set owner on {} tasks, actually modified tasks = {}, could not set owner on {} tasks.", new Object[]{taskIds.size(), ((List)taskIdsToUpdate.getLeft()).size(), bulkLog.getFailedIds().size()});
                }
                BulkOperationResults bulkOperationResults4 = bulkLog;
                bulkOperationResults2 = bulkOperationResults3 = bulkOperationResults4;
            }
            break block7;
            finally {
                this.kadaiEngine.returnConnection();
            }
        }
        BulkOperationResults bulkOperationResults5 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults3;
    }

    @Override
    public BulkOperationResults<String, KadaiException> setPlannedPropertyOfTasks(Instant planned, List<String> argTaskIds) {
        ServiceLevelHandler.BulkLog bulkLog;
        ServiceLevelHandler.BulkLog bulkLog2;
        ServiceLevelHandler.BulkLog bulkLog3;
        JoinPoint joinPoint;
        block5: {
            Instant instant = planned;
            List<String> list = argTaskIds;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this, (Object)instant, list);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ServiceLevelHandler.BulkLog bulkLog4 = new ServiceLevelHandler.BulkLog();
            if (argTaskIds == null || argTaskIds.isEmpty()) {
                bulkLog2 = bulkLog3 = bulkLog4;
            } else {
                this.kadaiEngine.openConnection();
                Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(argTaskIds);
                List tasksToModify = (List)resultsPair.getLeft();
                bulkLog4.addAllErrors((BulkOperationResults)resultsPair.getRight());
                ServiceLevelHandler.BulkLog errorsFromProcessing = this.serviceLevelHandler.setPlannedPropertyOfTasksImpl(planned, tasksToModify);
                bulkLog4.addAllErrors(errorsFromProcessing);
                ServiceLevelHandler.BulkLog bulkLog5 = bulkLog4;
                bulkLog2 = bulkLog3 = bulkLog5;
            }
            break block5;
            finally {
                this.kadaiEngine.returnConnection();
            }
        }
        ServiceLevelHandler.BulkLog bulkLog6 = bulkLog = bulkLog2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog);
        return bulkLog3;
    }

    @Override
    public Task terminateTask(String taskId) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl terminatedTask;
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.ADMIN, KadaiRole.TASK_ADMIN);
        try {
            this.kadaiEngine.openConnection();
            if (taskId == null || taskId.isEmpty()) {
                throw new TaskNotFoundException(taskId);
            }
            terminatedTask = (TaskImpl)this.getTask(taskId);
            TaskState state = terminatedTask.getState();
            if (state.isEndState()) {
                throw new InvalidTaskStateException(taskId, state, TaskState.READY, TaskState.CLAIMED, TaskState.READY_FOR_REVIEW, TaskState.IN_REVIEW);
            }
            TaskServiceImpl.terminateCancelCommonActions(terminatedTask, TaskState.TERMINATED);
            terminatedTask = (TaskImpl)this.taskEndstatePreprocessorManager.processTaskBeforeEndstate(terminatedTask);
            this.taskMapper.update(terminatedTask);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task '{}' cancelled by user '{}'.", (Object)terminatedTask.getId(), (Object)this.kadaiEngine.getEngine().getCurrentUserContext().getUserid());
            }
            if (this.historyEventManager.isEnabled()) {
                this.historyEventManager.createEvent(new TaskTerminatedEvent(IdGenerator.generateWithPrefix((String)"THI"), terminatedTask, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid()));
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = terminatedTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    public List<String> findTasksIdsAffectedByClassificationChange(String classificationId) {
        List<String> list;
        List<String> list2;
        String string = classificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List tasksAffectedDirectly = this.createTaskQuery().classificationIdIn(classificationId).stateIn(TaskState.READY, TaskState.CLAIMED).list();
        List affectedPairs = tasksAffectedDirectly.stream().map(t -> Pair.of((Object)t.getId(), (Object)t.getPlanned())).collect(Collectors.toList());
        List<Pair<String, Instant>> taskIdsAndPlannedFromAttachments = this.attachmentMapper.findTaskIdsAndPlannedAffectedByClassificationChange(classificationId);
        List<String> taskIdsFromAttachments = taskIdsAndPlannedFromAttachments.stream().map(Pair::getLeft).toList();
        List<Object> filteredTaskIdsAndPlannedFromAttachments = taskIdsFromAttachments.isEmpty() ? new ArrayList() : this.taskMapper.filterTaskIdsForReadyAndClaimed(taskIdsFromAttachments);
        affectedPairs.addAll(filteredTaskIdsAndPlannedFromAttachments);
        List<String> affectedTaskIds = affectedPairs.stream().sorted(Comparator.comparing(Pair::getRight)).distinct().map(Pair::getLeft).toList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the following tasks are affected by the update of classification {} : {}", (Object)classificationId, affectedTaskIds);
        }
        List<String> list3 = list2 = (list = affectedTaskIds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> filterTasksAuthorizedForAndLogErrorsForNotAuthorized(List<MinimalTaskSummary> existingTasks) {
        Pair pair;
        Pair pair2;
        Pair pair3;
        List<MinimalTaskSummary> list = existingTasks;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        if (this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN, KadaiRole.TASK_ADMIN)) {
            pair2 = pair3 = Pair.of(existingTasks, (Object)((Object)bulkLog));
        } else {
            List accessIds = this.kadaiEngine.getEngine().getCurrentUserContext().getAccessIds();
            List<Pair<String, String>> taskAndWorkbasketIdsNotAuthorizedFor = this.taskMapper.getTaskAndWorkbasketIdsNotAuthorizedFor(existingTasks, accessIds);
            String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
            for (Pair<String, String> taskAndWorkbasketIds : taskAndWorkbasketIdsNotAuthorizedFor) {
                bulkLog.addError((String)taskAndWorkbasketIds.getLeft(), (Exception)((Object)new NotAuthorizedOnWorkbasketException(userId, (String)taskAndWorkbasketIds.getRight(), WorkbasketPermission.READ)));
            }
            Set taskIdsToRemove = taskAndWorkbasketIdsNotAuthorizedFor.stream().map(Pair::getLeft).collect(Collectors.toSet());
            List<MinimalTaskSummary> tasksAuthorizedFor = existingTasks.stream().filter(Predicate.not(t -> taskIdsToRemove.contains(t.getTaskId()))).toList();
            pair2 = pair3 = Pair.of(tasksAuthorizedFor, (Object)((Object)bulkLog));
        }
        Pair pair4 = pair = pair2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pair);
        return pair3;
    }

    public void refreshPriorityAndDueDatesOfTasksOnClassificationUpdate(List<String> taskIds, boolean serviceLevelChanged, boolean priorityChanged) {
        List<String> list = taskIds;
        boolean bl = serviceLevelChanged;
        boolean bl2 = priorityChanged;
        Object[] objectArray = new Object[]{list, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> resultsPair = this.getMinimalTaskSummaries(taskIds);
        List tasks = (List)resultsPair.getLeft();
        try {
            this.kadaiEngine.openConnection();
            Set<String> adminAccessIds = this.kadaiEngine.getEngine().getConfiguration().getRoleMap().get(KadaiRole.ADMIN);
            if (adminAccessIds.contains(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid())) {
                this.serviceLevelHandler.refreshPriorityAndDueDatesOfTasks(tasks, serviceLevelChanged, priorityChanged);
            } else {
                this.kadaiEngine.getEngine().runAsAdmin(() -> this.serviceLevelHandler.refreshPriorityAndDueDatesOfTasks(tasks, serviceLevelChanged, priorityChanged));
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var13_13 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_13);
    }

    Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> getMinimalTaskSummaries(Collection<String> argTaskIds) {
        Pair pair;
        Pair pair2;
        Collection<String> collection = argTaskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, collection);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        HashSet<String> taskIds = new HashSet<String>(argTaskIds);
        List<MinimalTaskSummary> minimalTaskSummaries = this.taskMapper.findExistingTasks(taskIds, null);
        bulkLog.addAllErrors(this.addExceptionsForNonExistingTasksToBulkLog(taskIds, minimalTaskSummaries));
        Pair<List<MinimalTaskSummary>, ServiceLevelHandler.BulkLog> filteredPair = this.filterTasksAuthorizedForAndLogErrorsForNotAuthorized(minimalTaskSummaries);
        bulkLog.addAllErrors((BulkOperationResults)filteredPair.getRight());
        Pair pair3 = pair2 = (pair = Pair.of((Object)((List)filteredPair.getLeft()), (Object)((Object)bulkLog)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pair2);
        return pair;
    }

    private static boolean taskIsNotClaimed(TaskSummary task) {
        boolean bl;
        boolean bl2;
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, null, null, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = task.getClaimed() != null && (task.getState() == TaskState.CLAIMED || task.getState() == TaskState.IN_REVIEW) ? (bl = false) : (bl = true);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    ServiceLevelHandler.BulkLog addExceptionsForNonExistingTasksToBulkLog(Collection<String> requestTaskIds, List<MinimalTaskSummary> existingMinimalTaskSummaries) {
        ServiceLevelHandler.BulkLog bulkLog;
        ServiceLevelHandler.BulkLog bulkLog2;
        Collection<String> collection = requestTaskIds;
        List<MinimalTaskSummary> list = existingMinimalTaskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this, collection, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ServiceLevelHandler.BulkLog bulkLog3 = new ServiceLevelHandler.BulkLog();
        Set existingTaskIds = existingMinimalTaskSummaries.stream().map(MinimalTaskSummary::getTaskId).collect(Collectors.toSet());
        requestTaskIds.stream().filter(Predicate.not(existingTaskIds::contains)).forEach(taskId -> bulkLog3.addError(taskId, (Exception)((Object)new TaskNotFoundException((String)taskId))));
        ServiceLevelHandler.BulkLog bulkLog4 = bulkLog2 = (bulkLog = bulkLog3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkLog2);
        return bulkLog;
    }

    List<TaskSummary> augmentTaskSummariesByContainedSummariesWithPartitioning(List<TaskSummaryImpl> taskSummaries) {
        List<TaskSummary> list;
        List<TaskSummary> list2;
        List<TaskSummaryImpl> list3 = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TaskSummary> list4 = list2 = (list = CollectionUtil.partitionBasedOnSize(taskSummaries, (int)32000).stream().map(this::appendComplexAttributesToTaskSummariesWithoutPartitioning).flatMap(Collection::stream).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private Pair<List<String>, ServiceLevelHandler.BulkLog> filterOutTasksWhichAreInInvalidState(Collection<MinimalTaskSummary> minimalTaskSummaries) {
        Pair pair;
        Pair pair2;
        Collection<MinimalTaskSummary> collection = minimalTaskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this, collection);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> filteredTasks = new ArrayList<String>(minimalTaskSummaries.size());
        ServiceLevelHandler.BulkLog bulkLog = new ServiceLevelHandler.BulkLog();
        for (MinimalTaskSummary taskSummary : minimalTaskSummaries) {
            if (!taskSummary.getTaskState().in(TaskState.READY, TaskState.READY_FOR_REVIEW)) {
                bulkLog.addError(taskSummary.getTaskId(), (Exception)((Object)new InvalidTaskStateException(taskSummary.getTaskId(), taskSummary.getTaskState(), TaskState.READY, TaskState.READY_FOR_REVIEW)));
                continue;
            }
            filteredTasks.add(taskSummary.getTaskId());
        }
        Pair pair3 = pair2 = (pair = Pair.of(filteredTasks, (Object)((Object)bulkLog)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pair2);
        return pair;
    }

    private List<TaskSummaryImpl> appendComplexAttributesToTaskSummariesWithoutPartitioning(List<TaskSummaryImpl> taskSummaries) {
        List<TaskSummaryImpl> list;
        List<TaskSummaryImpl> list2;
        List<TaskSummaryImpl> list3 = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<String> taskIds = taskSummaries.stream().map(TaskSummaryImpl::getId).collect(Collectors.toSet());
        if (taskIds.isEmpty()) {
            taskIds = null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("augmentTaskSummariesByContainedSummariesWithoutPartitioning() with sublist {} about to query for attachmentSummaries ", taskSummaries);
        }
        List<AttachmentSummaryImpl> attachmentSummaries = this.attachmentMapper.findAttachmentSummariesByTaskIds(taskIds);
        Map<String, ClassificationSummary> classificationSummariesById = this.findClassificationsForTasksAndAttachments(taskSummaries, attachmentSummaries);
        this.addClassificationSummariesToAttachments(attachmentSummaries, classificationSummariesById);
        this.addClassificationSummariesToTaskSummaries(taskSummaries, classificationSummariesById);
        this.addAttachmentSummariesToTaskSummaries(taskSummaries, attachmentSummaries);
        Map<String, WorkbasketSummary> workbasketSummariesById = this.findWorkbasketsForTasks(taskSummaries);
        List<ObjectReferenceImpl> objectReferences = this.objectReferenceMapper.findObjectReferencesByTaskIds(taskIds);
        this.addWorkbasketSummariesToTaskSummaries(taskSummaries, workbasketSummariesById);
        this.addObjectReferencesToTaskSummaries(taskSummaries, objectReferences);
        List<TaskSummaryImpl> list4 = list2 = (list = taskSummaries);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private BulkOperationResults<String, KadaiException> completeTasks(List<String> taskIds, boolean forced) throws InvalidArgumentException {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        List<String> list = taskIds;
        boolean bl = forced;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, (Object)this, (Object)this, list, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.kadaiEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("TaskIds can't be used as NULL-Parameter.");
            }
            BulkOperationResults bulkLog = new BulkOperationResults();
            Instant now = Instant.now().truncatedTo(ChronoUnit.MILLIS);
            Stream<TaskSummaryImpl> filteredSummaries = this.filterNotExistingTaskIds(taskIds, (BulkOperationResults<String, KadaiException>)bulkLog).filter(task -> task.getState() != TaskState.COMPLETED).filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, KadaiException>)((CheckedConsumer)TaskServiceImpl::checkIfTaskIsTerminatedOrCancelled), (BulkOperationResults<String, KadaiException>)bulkLog));
            if (!forced) {
                filteredSummaries = filteredSummaries.filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, KadaiException>)((CheckedConsumer)this::checkPreconditionsForCompleteTask), (BulkOperationResults<String, KadaiException>)bulkLog));
            } else {
                UserImpl user;
                String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
                String userLongName = this.kadaiEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() ? ((user = this.userMapper.findById(userId)) != null ? user.getLongName() : null) : null;
                filteredSummaries = filteredSummaries.filter(TaskServiceImpl.addErrorToBulkLog((CheckedConsumer<TaskSummaryImpl, KadaiException>)((CheckedConsumer)summary -> {
                    if (TaskServiceImpl.taskIsNotClaimed(summary)) {
                        this.checkPreconditionsForClaimTask((TaskSummary)summary, true);
                        TaskServiceImpl.claimActionsOnTask(summary, userId, userLongName, now);
                    }
                }), (BulkOperationResults<String, KadaiException>)bulkLog));
            }
            this.updateTasksToBeCompleted(filteredSummaries, now);
            BulkOperationResults bulkOperationResults3 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        BulkOperationResults bulkOperationResults4 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults2;
    }

    private Stream<TaskSummaryImpl> filterNotExistingTaskIds(List<String> taskIds, BulkOperationResults<String, KadaiException> bulkLog) {
        Stream<TaskSummaryImpl> stream;
        Stream<TaskSummaryImpl> stream2;
        List<String> list = taskIds;
        BulkOperationResults<String, KadaiException> bulkOperationResults = bulkLog;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this, list, bulkOperationResults);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, TaskSummaryImpl> taskSummaryMap = this.getTasksToChange(taskIds).stream().collect(Collectors.toMap(TaskSummary::getId, TaskSummaryImpl.class::cast));
        Stream<TaskSummaryImpl> stream3 = stream2 = (stream = taskIds.stream().map(id -> Pair.of((Object)id, (Object)((TaskSummaryImpl)taskSummaryMap.get(id)))).filter(pair -> {
            if (pair.getRight() != null) {
                return true;
            }
            String taskId = (String)pair.getLeft();
            bulkLog.addError((Object)taskId, (Exception)((Object)new TaskNotFoundException(taskId)));
            return false;
        }).map(Pair::getRight));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, stream2);
        return stream;
    }

    private void checkConcurrencyAndSetModified(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ConcurrencyException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (oldTaskImpl.getModified() != null && !oldTaskImpl.getModified().equals(newTaskImpl.getModified()) || oldTaskImpl.getClaimed() != null && !oldTaskImpl.getClaimed().equals(newTaskImpl.getClaimed()) || oldTaskImpl.getState() != null && !oldTaskImpl.getState().equals((Object)newTaskImpl.getState())) {
            throw new ConcurrencyException(newTaskImpl.getId());
        }
        newTaskImpl.setModified(Instant.now());
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private Task claim(String taskId, boolean forceClaim) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = forceClaim;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            UserImpl user;
            this.kadaiEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskImpl oldTask = this.duplicateTaskExactly(task);
            Instant now = Instant.now();
            this.checkPreconditionsForClaimTask(task, forceClaim);
            String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
            String userLongName = null;
            if (this.kadaiEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (user = this.userMapper.findById(userId)) != null) {
                userLongName = user.getLongName();
            }
            TaskServiceImpl.claimActionsOnTask(task, userId, userLongName, now);
            this.taskMapper.update(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task '{}' claimed by user '{}'.", (Object)task.getId(), (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)task);
                this.historyEventManager.createEvent(new TaskClaimedEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private Task requestReview(String taskId, boolean force) throws TaskNotFoundException, InvalidTaskStateException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
        try {
            this.kadaiEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            task = (TaskImpl)this.beforeRequestReviewManager.beforeRequestReview(task);
            TaskImpl oldTask = this.duplicateTaskExactly(task);
            if (force && task.getState().isEndState()) {
                throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
            }
            if (!force && TaskServiceImpl.taskIsNotClaimed(task)) {
                throw new InvalidTaskStateException(task.getId(), task.getState(), TaskState.CLAIMED, TaskState.IN_REVIEW);
            }
            if (!force && !task.getOwner().equals(userId)) {
                throw new InvalidOwnerException(userId, task.getId());
            }
            task.setState(TaskState.READY_FOR_REVIEW);
            task.setOwner(null);
            task.setModified(Instant.now());
            this.taskMapper.requestReview(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Requested review for Task '{}' by user '{}'.", (Object)task.getId(), (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)task);
                this.historyEventManager.createEvent(new TaskRequestReviewEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
            task = (TaskImpl)this.afterRequestReviewManager.afterRequestReview(task);
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private Task requestChanges(String taskId, boolean force) throws InvalidTaskStateException, TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_71, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
        try {
            this.kadaiEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            task = (TaskImpl)this.beforeRequestChangesManager.beforeRequestChanges(task);
            TaskImpl oldTask = this.duplicateTaskExactly(task);
            if (force && task.getState().isEndState()) {
                throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
            }
            if (!force && task.getState() != TaskState.IN_REVIEW) {
                throw new InvalidTaskStateException(task.getId(), task.getState(), TaskState.IN_REVIEW);
            }
            if (!force && !task.getOwner().equals(userId)) {
                throw new InvalidOwnerException(userId, task.getId());
            }
            task.setState(TaskState.READY);
            task.setOwner(null);
            task.setModified(Instant.now());
            this.taskMapper.requestChanges(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Requested changes for Task '{}' by user '{}'.", (Object)task.getId(), (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)task);
                this.historyEventManager.createEvent(new TaskRequestChangesEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
            task = (TaskImpl)this.afterRequestChangesManager.afterRequestChanges(task);
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private void checkPreconditionsForClaimTask(TaskSummary task, boolean forced) throws InvalidOwnerException, InvalidTaskStateException, NotAuthorizedOnWorkbasketException {
        TaskSummary taskSummary = task;
        boolean bl = forced;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_72, (Object)this, (Object)this, (Object)taskSummary, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskState state = task.getState();
        if (state.isEndState()) {
            throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
        }
        String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
        if (!(forced || state != TaskState.CLAIMED && state != TaskState.IN_REVIEW || task.getOwner().equals(userId))) {
            throw new InvalidOwnerException(userId, task.getId());
        }
        if (!this.checkEditTasksPerm(task)) {
            throw new NotAuthorizedOnWorkbasketException(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), task.getWorkbasketSummary().getId(), WorkbasketPermission.EDITTASKS);
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private void checkPreconditionsForCompleteTask(TaskSummary task) throws InvalidOwnerException, InvalidTaskStateException, NotAuthorizedOnWorkbasketException {
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_73, (Object)this, (Object)this, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (TaskServiceImpl.taskIsNotClaimed(task)) {
            throw new InvalidTaskStateException(task.getId(), task.getState(), TaskState.CLAIMED, TaskState.IN_REVIEW);
        }
        if (!this.kadaiEngine.getEngine().getCurrentUserContext().getAccessIds().contains(task.getOwner()) && !this.kadaiEngine.getEngine().isUserInRole(KadaiRole.ADMIN)) {
            throw new InvalidOwnerException(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), task.getId());
        }
        if (!this.checkEditTasksPerm(task)) {
            throw new NotAuthorizedOnWorkbasketException(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), task.getWorkbasketSummary().getId(), WorkbasketPermission.EDITTASKS);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private Task cancelClaim(String taskId, boolean forceUnclaim, boolean keepOwner) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl task;
        String string = taskId;
        boolean bl = forceUnclaim;
        boolean bl2 = keepOwner;
        Object[] objectArray = new Object[]{string, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_74, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
        try {
            this.kadaiEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskImpl oldTask = this.duplicateTaskExactly(task);
            TaskState state = task.getState();
            if (!this.checkEditTasksPerm(task)) {
                throw new NotAuthorizedOnWorkbasketException(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), task.getWorkbasketSummary().getId(), WorkbasketPermission.EDITTASKS);
            }
            if (state.isEndState()) {
                throw new InvalidTaskStateException(taskId, state, (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
            }
            if (!(state != TaskState.CLAIMED && state != TaskState.IN_REVIEW || forceUnclaim || userId.equals(task.getOwner()))) {
                throw new InvalidOwnerException(userId, taskId);
            }
            Instant now = Instant.now();
            TaskServiceImpl.cancelClaimActionsOnTask(task, now, keepOwner);
            this.taskMapper.update(task);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task '{}' unclaimed by user '{}'.", (Object)task.getId(), (Object)userId);
            }
            if (this.historyEventManager.isEnabled()) {
                String changeDetails = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)task);
                this.historyEventManager.createEvent(new TaskClaimCancelledEvent(IdGenerator.generateWithPrefix((String)"THI"), task, userId, changeDetails));
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = task);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Task completeTask(String taskId, boolean isForced) throws TaskNotFoundException, InvalidOwnerException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        Task task3;
        JoinPoint joinPoint;
        block12: {
            TaskImpl task4;
            String string = taskId;
            boolean bl = isForced;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_75, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String userId = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
            try {
                this.kadaiEngine.openConnection();
                task4 = (TaskImpl)this.getTask(taskId);
                if (this.reviewRequiredManager.reviewRequired(task4)) {
                    Task task5 = this.requestReview(taskId);
                    task2 = task3 = task5;
                    break block12;
                }
                if (task4.getState() == TaskState.COMPLETED) {
                    TaskImpl taskImpl = task4;
                    task2 = task3 = taskImpl;
                    break block12;
                }
                TaskServiceImpl.checkIfTaskIsTerminatedOrCancelled(task4);
                if (!isForced) {
                    this.checkPreconditionsForCompleteTask(task4);
                } else if (TaskServiceImpl.taskIsNotClaimed(task4)) {
                    task4 = (TaskImpl)this.forceClaim(taskId);
                }
                Instant now = Instant.now();
                TaskServiceImpl.completeActionsOnTask(task4, userId, now);
                task4 = (TaskImpl)this.taskEndstatePreprocessorManager.processTaskBeforeEndstate(task4);
                this.taskMapper.update(task4);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Task '{}' completed by user '{}'.", (Object)task4.getId(), (Object)userId);
                }
                if (this.historyEventManager.isEnabled()) {
                    this.historyEventManager.createEvent(new TaskCompletedEvent(IdGenerator.generateWithPrefix((String)"THI"), task4, userId));
                }
            }
            finally {
                this.kadaiEngine.returnConnection();
            }
            task2 = task3 = task4;
        }
        Task task6 = task = task2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task);
        return task3;
    }

    private void deleteTask(String taskId, boolean forceDelete) throws TaskNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException, InvalidCallbackStateException {
        String string = taskId;
        boolean bl = forceDelete;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_76, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.kadaiEngine.getEngine().checkRoleMembership(KadaiRole.ADMIN);
        try {
            this.kadaiEngine.openConnection();
            TaskImpl task = (TaskImpl)this.getTask(taskId);
            if (!task.getState().isEndState() && !forceDelete) {
                throw new InvalidTaskStateException(taskId, task.getState(), TaskState.END_STATES);
            }
            if (!task.getState().in(TaskState.TERMINATED, TaskState.CANCELLED) && CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)task.getCallbackState())) {
                throw new InvalidCallbackStateException(taskId, task.getCallbackState(), (CallbackState[])EnumUtil.allValuesExceptFor((Enum[])new CallbackState[]{CallbackState.CALLBACK_PROCESSING_REQUIRED}));
            }
            this.attachmentMapper.deleteMultipleByTaskIds(Collections.singletonList(taskId));
            this.objectReferenceMapper.deleteMultipleByTaskIds(Collections.singletonList(taskId));
            this.taskMapper.delete(taskId);
            if (this.kadaiEngine.getEngine().isHistoryEnabled() && this.kadaiEngine.getEngine().getConfiguration().isDeleteHistoryEventsOnTaskDeletionEnabled()) {
                this.historyEventManager.deleteEvents(Collections.singletonList(taskId));
            }
            if (this.historyEventManager.isEnabled()) {
                this.createTaskDeletedEvent(taskId);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task {} deleted.", (Object)task.getId());
            }
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private void removeSingleTaskForTaskDeletionById(BulkOperationResults<String, KadaiException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> taskIdIterator) {
        BulkOperationResults<String, KadaiException> bulkOperationResults = bulkLog;
        List<MinimalTaskSummary> list = taskSummaries;
        Iterator<String> iterator = taskIdIterator;
        Object[] objectArray = new Object[]{bulkOperationResults, list, iterator};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_77, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String currentTaskId = taskIdIterator.next();
        if (currentTaskId == null || currentTaskId.equals("")) {
            bulkLog.addError((Object)"", (Exception)((Object)new TaskNotFoundException(null)));
            taskIdIterator.remove();
        } else {
            MinimalTaskSummary foundSummary = taskSummaries.stream().filter(taskSummary -> currentTaskId.equals(taskSummary.getTaskId())).findFirst().orElse(null);
            if (foundSummary == null) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new TaskNotFoundException(currentTaskId)));
                taskIdIterator.remove();
            } else if (!foundSummary.getTaskState().isEndState()) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new InvalidTaskStateException(currentTaskId, foundSummary.getTaskState(), TaskState.END_STATES)));
                taskIdIterator.remove();
            } else if (!foundSummary.getTaskState().in(TaskState.CANCELLED, TaskState.TERMINATED) && CallbackState.CALLBACK_PROCESSING_REQUIRED.equals((Object)foundSummary.getCallbackState())) {
                bulkLog.addError((Object)currentTaskId, (Exception)((Object)new InvalidCallbackStateException(currentTaskId, foundSummary.getCallbackState(), (CallbackState[])EnumUtil.allValuesExceptFor((Enum[])new CallbackState[]{CallbackState.CALLBACK_PROCESSING_REQUIRED}))));
                taskIdIterator.remove();
            }
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private void removeSingleTaskForCallbackStateByExternalId(BulkOperationResults<String, KadaiException> bulkLog, List<MinimalTaskSummary> taskSummaries, Iterator<String> externalIdIterator, CallbackState desiredCallbackState) {
        BulkOperationResults<String, KadaiException> bulkOperationResults = bulkLog;
        List<MinimalTaskSummary> list = taskSummaries;
        Iterator<String> iterator = externalIdIterator;
        CallbackState callbackState = desiredCallbackState;
        Object[] objectArray = new Object[]{bulkOperationResults, list, iterator, callbackState};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_78, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String currentExternalId = externalIdIterator.next();
        if (currentExternalId == null || currentExternalId.equals("")) {
            bulkLog.addError((Object)"", (Exception)((Object)new TaskNotFoundException(null)));
            externalIdIterator.remove();
        } else {
            Optional<MinimalTaskSummary> foundSummary = taskSummaries.stream().filter(taskSummary -> currentExternalId.equals(taskSummary.getExternalId())).findFirst();
            if (foundSummary.isPresent()) {
                Optional<KadaiException> invalidStateException = this.desiredCallbackStateCanBeSetForFoundSummary(foundSummary.get(), desiredCallbackState);
                if (invalidStateException.isPresent()) {
                    bulkLog.addError((Object)currentExternalId, (Exception)((Object)invalidStateException.get()));
                    externalIdIterator.remove();
                }
            } else {
                bulkLog.addError((Object)currentExternalId, (Exception)((Object)new TaskNotFoundException(currentExternalId)));
                externalIdIterator.remove();
            }
        }
        Object var14_14 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var14_14);
    }

    private Optional<KadaiException> desiredCallbackStateCanBeSetForFoundSummary(MinimalTaskSummary foundSummary, CallbackState desiredCallbackState) {
        Optional<KadaiException> optional;
        Optional<KadaiException> optional2;
        Optional<KadaiException> optional3;
        JoinPoint joinPoint;
        block7: {
            MinimalTaskSummary minimalTaskSummary = foundSummary;
            CallbackState callbackState = desiredCallbackState;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_79, (Object)this, (Object)this, (Object)minimalTaskSummary, (Object)((Object)callbackState));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            CallbackState currentTaskCallbackState = foundSummary.getCallbackState();
            TaskState currentTaskState = foundSummary.getTaskState();
            switch (desiredCallbackState) {
                case CALLBACK_PROCESSING_COMPLETED: {
                    if (currentTaskState.isEndState()) break;
                    optional2 = optional3 = Optional.of(new InvalidTaskStateException(foundSummary.getTaskId(), foundSummary.getTaskState(), TaskState.END_STATES));
                    break block7;
                }
                case CLAIMED: {
                    if (!currentTaskState.equals((Object)TaskState.CLAIMED)) {
                        optional2 = optional3 = Optional.of(new InvalidTaskStateException(foundSummary.getTaskId(), foundSummary.getTaskState(), TaskState.CLAIMED));
                    } else {
                        if (currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_REQUIRED)) break;
                        optional2 = optional3 = Optional.of(new InvalidCallbackStateException(foundSummary.getTaskId(), currentTaskCallbackState, CallbackState.CALLBACK_PROCESSING_REQUIRED));
                    }
                    break block7;
                }
                case CALLBACK_PROCESSING_REQUIRED: {
                    if (!currentTaskCallbackState.equals((Object)CallbackState.CALLBACK_PROCESSING_COMPLETED)) break;
                    optional2 = optional3 = Optional.of(new InvalidCallbackStateException(foundSummary.getTaskId(), currentTaskCallbackState, (CallbackState[])EnumUtil.allValuesExceptFor((Enum[])new CallbackState[]{CallbackState.CALLBACK_PROCESSING_COMPLETED})));
                    break block7;
                }
                default: {
                    optional2 = optional3 = Optional.of(new InvalidCallbackStateException(foundSummary.getTaskId(), currentTaskCallbackState, CallbackState.CALLBACK_PROCESSING_COMPLETED, CallbackState.CLAIMED, CallbackState.CALLBACK_PROCESSING_REQUIRED));
                    break block7;
                }
            }
            optional2 = optional3 = Optional.empty();
        }
        Optional<KadaiException> optional4 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional);
        return optional3;
    }

    private void standardSettingsOnTaskCreation(TaskImpl task, Classification classification) throws InvalidArgumentException, ClassificationNotFoundException, AttachmentPersistenceException, ObjectReferencePersistenceException {
        UserImpl user;
        TaskImpl taskImpl = task;
        Classification classification2 = classification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_80, (Object)this, (Object)this, (Object)taskImpl, (Object)classification2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant now = Instant.now();
        task.setId(IdGenerator.generateWithPrefix((String)"TKI"));
        if (task.getExternalId() == null) {
            task.setExternalId(IdGenerator.generateWithPrefix((String)"ETI"));
        }
        task.setState(TaskState.READY);
        task.setCreated(now);
        task.setModified(now);
        task.setRead(false);
        task.setTransferred(false);
        String creator = this.kadaiEngine.getEngine().getCurrentUserContext().getUserid();
        if (this.kadaiEngine.getEngine().getConfiguration().isSecurityEnabled() && creator == null) {
            throw new SystemException("KadaiSecurity is enabled, but the current UserId is NULL while creating a Task.");
        }
        task.setCreator(creator);
        if (task.getBusinessProcessId() == null) {
            task.setBusinessProcessId(IdGenerator.generateWithPrefix((String)"BPI"));
        }
        if (task.getPlanned() == null && (classification == null || task.getDue() == null)) {
            task.setPlanned(now);
        }
        if (task.getName() == null && classification != null) {
            task.setName(classification.getName());
        }
        if (task.getDescription() == null && classification != null) {
            task.setDescription(classification.getDescription());
        }
        if (task.getOwner() != null && this.kadaiEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (user = this.userMapper.findById(task.getOwner())) != null) {
            task.setOwnerLongName(user.getLongName());
        }
        this.setDefaultTaskReceivedDateFromAttachments(task);
        this.attachmentHandler.insertNewAttachmentsOnTaskCreation(task);
        this.objectReferenceHandler.insertNewSecondaryObjectReferencesOnTaskCreation(task);
        this.serviceLevelHandler.updatePrioPlannedDueOfTask(task, null);
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void setDefaultTaskReceivedDateFromAttachments(TaskImpl task) {
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_81, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (task.getReceived() == null) {
            task.getAttachments().stream().map(AttachmentSummary::getReceived).filter(Objects::nonNull).min(Instant::compareTo).ifPresent(task::setReceived);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void setCallbackStateOnTaskCreation(TaskImpl task) throws InvalidArgumentException {
        String value;
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_82, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, String> callbackInfo = task.getCallbackInfo();
        if (callbackInfo != null && callbackInfo.containsKey("callbackState") && (value = callbackInfo.get("callbackState")) != null && !value.isEmpty()) {
            try {
                CallbackState state = CallbackState.valueOf(value);
                task.setCallbackState(state);
            }
            catch (Exception e) {
                LOGGER.warn("Attempted to determine callback state from {} and caught exception", (Object)value, (Object)e);
                throw new InvalidArgumentException(String.format("Attempted to set callback state for task %s.", task.getId()), (Throwable)e);
            }
        }
        Object var7_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_8);
    }

    private void updateTasksToBeCompleted(Stream<TaskSummaryImpl> taskSummaries, Instant now) {
        Stream<TaskSummaryImpl> stream = taskSummaries;
        Instant instant = now;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_83, (Object)this, (Object)this, stream, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TaskSummary> taskSummaryList = taskSummaries.map(summary -> {
            TaskServiceImpl.completeActionsOnTask(summary, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), now);
            return summary;
        }).toList();
        List<String> taskIds = taskSummaryList.stream().map(TaskSummary::getId).toList();
        List<String> updateClaimedTaskIds = taskSummaryList.stream().filter(summary -> now.equals(summary.getClaimed())).map(TaskSummary::getId).toList();
        TaskSummary claimedReference = taskSummaryList.stream().filter(summary -> updateClaimedTaskIds.contains(summary.getId())).findFirst().orElse(null);
        if (!taskSummaryList.isEmpty()) {
            this.taskMapper.updateCompleted(taskIds, taskSummaryList.get(0));
            if (!updateClaimedTaskIds.isEmpty()) {
                this.taskMapper.updateClaimed(updateClaimedTaskIds, claimedReference);
            }
            if (this.historyEventManager.isEnabled()) {
                this.createTasksCompletedEvents(taskSummaryList);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private RoutingTarget calculateWorkbasketDuringTaskCreation(TaskImpl task) {
        RoutingTarget routingTarget;
        RoutingTarget routingTarget2;
        RoutingTarget routingTarget3;
        TaskImpl taskImpl = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_84, (Object)this, (Object)this, (Object)taskImpl);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.kadaiEngine.getEngine().getConfiguration().isIncludeOwnerWhenRouting()) {
            String workbasketId = this.kadaiEngine.getTaskRoutingManager().determineWorkbasketId(task);
            if (workbasketId == null) {
                throw new InvalidArgumentException("Cannot create a Task outside a Workbasket");
            }
            routingTarget3 = new RoutingTarget(workbasketId);
        } else {
            routingTarget3 = this.kadaiEngine.getTaskRoutingManager().determineRoutingTarget(task).orElseThrow(() -> new InvalidArgumentException("Cannot create a Task in an empty RoutingTarget"));
        }
        RoutingTarget routingTarget4 = routingTarget2 = (routingTarget = routingTarget3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)routingTarget2);
        return routingTarget;
    }

    private Map<String, WorkbasketSummary> findWorkbasketsForTasks(List<? extends TaskSummary> taskSummaries) {
        Map<String, WorkbasketSummary> map;
        Map<String, WorkbasketSummary> map2;
        Map<String, WorkbasketSummary> map3;
        List<? extends TaskSummary> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_85, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            map2 = map3 = Collections.emptyMap();
        } else {
            Set<String> workbasketIds = taskSummaries.stream().map(TaskSummary::getWorkbasketSummary).map(WorkbasketSummary::getId).collect(Collectors.toSet());
            map2 = map3 = this.queryWorkbasketsForTasks(workbasketIds).stream().collect(Collectors.toMap(WorkbasketSummary::getId, Function.identity()));
        }
        Map<String, WorkbasketSummary> map4 = map = map2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map);
        return map3;
    }

    private Map<String, ClassificationSummary> findClassificationsForTasksAndAttachments(List<? extends TaskSummary> taskSummaries, List<? extends AttachmentSummaryImpl> attachmentSummaries) {
        Map<String, ClassificationSummary> map;
        Map<String, ClassificationSummary> map2;
        Map<String, ClassificationSummary> map3;
        List<? extends TaskSummary> list = taskSummaries;
        List<? extends AttachmentSummaryImpl> list2 = attachmentSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_86, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            map2 = map3 = Collections.emptyMap();
        } else {
            Set<String> classificationIds = Stream.concat(taskSummaries.stream().map(TaskSummary::getClassificationSummary), attachmentSummaries.stream().map(AttachmentSummary::getClassificationSummary)).map(ClassificationSummary::getId).collect(Collectors.toSet());
            map2 = map3 = this.queryClassificationsForTasksAndAttachments(classificationIds).stream().collect(Collectors.toMap(ClassificationSummary::getId, Function.identity()));
        }
        Map<String, ClassificationSummary> map4 = map = map2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map);
        return map3;
    }

    private Map<String, ClassificationSummary> findClassificationForTaskImplAndAttachments(TaskImpl task, List<AttachmentImpl> attachmentImpls) {
        Map<String, ClassificationSummary> map;
        Map<String, ClassificationSummary> map2;
        TaskImpl taskImpl = task;
        List<AttachmentImpl> list = attachmentImpls;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_87, (Object)this, (Object)this, (Object)taskImpl, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, ClassificationSummary> map3 = map2 = (map = this.findClassificationsForTasksAndAttachments(Collections.singletonList(task), attachmentImpls));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    private List<ClassificationSummary> queryClassificationsForTasksAndAttachments(Set<String> classificationIds) {
        List list;
        List list2;
        Set<String> set = classificationIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_88, (Object)this, (Object)this, set);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("queryClassificationsForTasksAndAttachments() about to query classifications and exit");
        }
        List list3 = list2 = (list = this.classificationService.createClassificationQuery().idIn(classificationIds.toArray(new String[0])).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private List<WorkbasketSummary> queryWorkbasketsForTasks(Set<String> workbasketIds) {
        List list;
        List list2;
        Set<String> set = workbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_89, (Object)this, (Object)this, set);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("queryWorkbasketsForTasks() about to query workbaskets and exit");
        }
        List list3 = list2 = (list = this.workbasketService.createWorkbasketQuery().idIn(workbasketIds.toArray(new String[0])).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private void addClassificationSummariesToTaskSummaries(List<TaskSummaryImpl> tasks, Map<String, ClassificationSummary> classificationSummaryById) {
        List<TaskSummaryImpl> list = tasks;
        Map<String, ClassificationSummary> map = classificationSummaryById;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_90, (Object)this, (Object)this, list, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (tasks != null && !tasks.isEmpty()) {
            for (TaskSummaryImpl task : tasks) {
                String classificationId = task.getClassificationSummary().getId();
                ClassificationSummary classificationSummary = classificationSummaryById.get(classificationId);
                if (classificationSummary == null) {
                    throw new SystemException("Did not find a Classification for task (Id=" + task.getId() + ",Classification=" + task.getClassificationSummary().getId() + ")");
                }
                task.setClassificationSummary(classificationSummary);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void addWorkbasketSummariesToTaskSummaries(List<TaskSummaryImpl> tasks, Map<String, WorkbasketSummary> workbasketSummaryById) {
        List<TaskSummaryImpl> list = tasks;
        Map<String, WorkbasketSummary> map = workbasketSummaryById;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_91, (Object)this, (Object)this, list, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (tasks != null && !tasks.isEmpty()) {
            for (TaskSummaryImpl task : tasks) {
                String workbasketId = task.getWorkbasketSummary().getId();
                WorkbasketSummary workbasketSummary = workbasketSummaryById.get(workbasketId);
                if (workbasketSummary == null) {
                    throw new SystemException("Did not find a Workbasket for task (Id=" + task.getId() + ",Workbasket=" + task.getWorkbasketSummary().getId() + ")");
                }
                task.setWorkbasketSummary(workbasketSummary);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void addAttachmentSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries) {
        List<TaskSummaryImpl> list = taskSummaries;
        List<AttachmentSummaryImpl> list2 = attachmentSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_92, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries != null && !taskSummaries.isEmpty()) {
            Map taskSummariesById = taskSummaries.stream().collect(Collectors.toMap(TaskSummary::getId, Function.identity(), (a, b) -> b));
            for (AttachmentSummaryImpl attachmentSummary : attachmentSummaries) {
                String taskId = attachmentSummary.getTaskId();
                TaskSummaryImpl taskSummary = (TaskSummaryImpl)taskSummariesById.get(taskId);
                if (taskSummary == null) continue;
                taskSummary.addAttachmentSummary(attachmentSummary);
            }
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private void addClassificationSummariesToAttachments(List<? extends AttachmentSummaryImpl> attachments, Map<String, ClassificationSummary> classificationSummariesById) {
        List<? extends AttachmentSummaryImpl> list = attachments;
        Map<String, ClassificationSummary> map = classificationSummariesById;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_93, (Object)this, (Object)this, list, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (attachments != null && !attachments.isEmpty()) {
            for (AttachmentSummaryImpl attachmentSummaryImpl : attachments) {
                String classificationId = attachmentSummaryImpl.getClassificationSummary().getId();
                ClassificationSummary classificationSummary = classificationSummariesById.get(classificationId);
                if (classificationSummary == null) {
                    throw new SystemException("Could not find a Classification for attachment " + attachmentSummaryImpl);
                }
                attachmentSummaryImpl.setClassificationSummary(classificationSummary);
            }
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void addObjectReferencesToTaskSummaries(List<TaskSummaryImpl> taskSummaries, List<ObjectReferenceImpl> objectReferences) {
        List<TaskSummaryImpl> list = taskSummaries;
        List<ObjectReferenceImpl> list2 = objectReferences;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_94, (Object)this, (Object)this, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries != null && !taskSummaries.isEmpty()) {
            Map taskSummariesById = taskSummaries.stream().collect(Collectors.toMap(TaskSummary::getId, Function.identity(), (a, b) -> b));
            for (ObjectReferenceImpl objectReference : objectReferences) {
                String taskId = objectReference.getTaskId();
                TaskSummaryImpl taskSummary = (TaskSummaryImpl)taskSummariesById.get(taskId);
                if (taskSummary == null) continue;
                taskSummary.addSecondaryObjectReference(objectReference);
            }
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private TaskImpl initUpdatedTask(Map<TaskCustomField, String> customFieldsToUpdate, TaskCustomPropertySelector fieldSelector) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        TaskCustomPropertySelector taskCustomPropertySelector = fieldSelector;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_95, (Object)this, (Object)this, map, (Object)taskCustomPropertySelector);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl newTask = new TaskImpl();
        newTask.setModified(Instant.now());
        for (Map.Entry<TaskCustomField, String> entry : customFieldsToUpdate.entrySet()) {
            TaskCustomField key = entry.getKey();
            fieldSelector.setCustomProperty(key, true);
            newTask.setCustomField(key, entry.getValue());
        }
        TaskImpl taskImpl3 = taskImpl2 = (taskImpl = newTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private void validateCustomFields(Map<TaskCustomField, String> customFieldsToUpdate) throws InvalidArgumentException {
        Map<TaskCustomField, String> map = customFieldsToUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_96, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (customFieldsToUpdate == null || customFieldsToUpdate.isEmpty()) {
            throw new InvalidArgumentException("The customFieldsToUpdate argument to updateTasks must not be empty.");
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private List<TaskSummary> getTasksToChange(List<String> taskIds) {
        List list;
        List list2;
        List<String> list3 = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_97, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list4 = list2 = (list = this.createTaskQuery().idIn(taskIds.toArray(new String[0])).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private List<TaskSummary> getTasksToChange(ObjectReference selectionCriteria) {
        List list;
        List list2;
        ObjectReference objectReference = selectionCriteria;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_98, (Object)this, (Object)this, (Object)objectReference);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list3 = list2 = (list = this.createTaskQuery().primaryObjectReferenceCompanyIn(selectionCriteria.getCompany()).primaryObjectReferenceSystemIn(selectionCriteria.getSystem()).primaryObjectReferenceSystemInstanceIn(selectionCriteria.getSystemInstance()).primaryObjectReferenceTypeIn(selectionCriteria.getType()).primaryObjectReferenceValueIn(selectionCriteria.getValue()).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private void standardUpdateActions(TaskImpl oldTaskImpl, TaskImpl newTaskImpl) throws InvalidArgumentException, ClassificationNotFoundException, InvalidTaskStateException {
        UserImpl user;
        boolean isOwnerChanged;
        TaskImpl taskImpl = oldTaskImpl;
        TaskImpl taskImpl2 = newTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_99, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (oldTaskImpl.getExternalId() == null || !oldTaskImpl.getExternalId().equals(newTaskImpl.getExternalId())) {
            throw new InvalidArgumentException("A task's external Id cannot be changed via update of the task");
        }
        String newWorkbasketKey = newTaskImpl.getWorkbasketKey();
        if (newWorkbasketKey != null && !newWorkbasketKey.equals(oldTaskImpl.getWorkbasketKey())) {
            throw new InvalidArgumentException("A task's Workbasket cannot be changed via update of the task");
        }
        if (newTaskImpl.getClassificationSummary() == null) {
            newTaskImpl.setClassificationSummary(oldTaskImpl.getClassificationSummary());
        }
        this.setDefaultTaskReceivedDateFromAttachments(newTaskImpl);
        this.updateClassificationSummary(newTaskImpl, oldTaskImpl);
        TaskImpl newTaskImpl1 = this.serviceLevelHandler.updatePrioPlannedDueOfTask(newTaskImpl, oldTaskImpl);
        if (newTaskImpl1.getBusinessProcessId() == null) {
            newTaskImpl1.setBusinessProcessId(oldTaskImpl.getBusinessProcessId());
        }
        boolean bl = isOwnerChanged = !Objects.equals(newTaskImpl1.getOwner(), oldTaskImpl.getOwner());
        if (isOwnerChanged && !oldTaskImpl.getState().in(TaskState.READY, TaskState.READY_FOR_REVIEW)) {
            throw new InvalidTaskStateException(oldTaskImpl.getId(), oldTaskImpl.getState(), TaskState.READY, TaskState.READY_FOR_REVIEW);
        }
        if (isOwnerChanged && this.kadaiEngine.getEngine().getConfiguration().isAddAdditionalUserInfo() && (user = this.userMapper.findById(newTaskImpl.getOwner())) != null) {
            newTaskImpl.setOwnerLongName(user.getLongName());
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    private void updateClassificationSummary(TaskImpl newTaskImpl, TaskImpl oldTaskImpl) throws ClassificationNotFoundException {
        TaskImpl taskImpl = newTaskImpl;
        TaskImpl taskImpl2 = oldTaskImpl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_100, (Object)this, (Object)this, (Object)taskImpl, (Object)taskImpl2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationSummary oldClassificationSummary = oldTaskImpl.getClassificationSummary();
        ClassificationSummary newClassificationSummary = newTaskImpl.getClassificationSummary();
        if (newClassificationSummary == null) {
            newClassificationSummary = oldClassificationSummary;
        }
        if (!oldClassificationSummary.getKey().equals(newClassificationSummary.getKey())) {
            Classification newClassification = this.classificationService.getClassification(newClassificationSummary.getKey(), newTaskImpl.getWorkbasketSummary().getDomain());
            newClassificationSummary = newClassification.asSummary();
            newTaskImpl.setClassificationSummary(newClassificationSummary);
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void createTasksCompletedEvents(List<? extends TaskSummary> taskSummaries) {
        List<? extends TaskSummary> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_101, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        taskSummaries.forEach(task -> this.historyEventManager.createEvent(new TaskCompletedEvent(IdGenerator.generateWithPrefix((String)"THI"), (TaskSummary)task, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid())));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private void createTaskDeletedEvent(String taskId) {
        String string = taskId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_102, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.historyEventManager.createEvent(new TaskDeletedEvent(IdGenerator.generateWithPrefix((String)"THI"), this.newTask().asSummary(), taskId, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid()));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private TaskImpl duplicateTaskExactly(TaskImpl task) {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        TaskImpl taskImpl3 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_103, (Object)this, (Object)this, (Object)taskImpl3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskImpl oldTask = task.copy();
        oldTask.setId(task.getId());
        oldTask.setExternalId(task.getExternalId());
        oldTask.setAttachments(task.getAttachments());
        oldTask.setSecondaryObjectReferences(task.getSecondaryObjectReferences());
        TaskImpl taskImpl4 = taskImpl2 = (taskImpl = oldTask);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl2);
        return taskImpl;
    }

    private boolean checkEditTasksPerm(TaskSummary task) {
        boolean bl;
        boolean bl2;
        TaskSummary taskSummary = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_104, (Object)this, (Object)this, (Object)taskSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
        String workbasketId = task.getWorkbasketSummary().getId();
        WorkbasketSummary workbasket = (WorkbasketSummary)query.idIn(workbasketId).callerHasPermissions(WorkbasketPermission.EDITTASKS).single();
        boolean bl3 = bl2 = workbasket != null ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskServiceImpl.java", TaskServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "addErrorToBulkLog", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.common.internal.util.CheckedConsumer:io.kadai.common.api.BulkOperationResults", "checkedConsumer:bulkLog", "", "java.util.function.Predicate"), 182);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "terminateCancelCommonActions", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl:io.kadai.task.api.TaskState", "task:targetState", "", "void"), 196);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCancelClaim", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 320);
        ajc$tjp_100 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateClassificationSummary", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl:io.kadai.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "io.kadai.classification.api.exceptions.ClassificationNotFoundException", "void"), 2306);
        ajc$tjp_101 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTasksCompletedEvents", "io.kadai.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "void"), 2322);
        ajc$tjp_102 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTaskDeletedEvent", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "", "void"), 2332);
        ajc$tjp_103 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "duplicateTaskExactly", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl", "task", "", "io.kadai.task.internal.models.TaskImpl"), 2341);
        ajc$tjp_104 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkEditTasksPerm", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.TaskSummary", "task", "", "boolean"), 2350);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelClaim", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:keepOwner", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 330);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCancelClaim", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:keepOwner", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 339);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "requestReview", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 349);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceRequestReview", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 358);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "requestChanges", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 367);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceRequestChanges", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 376);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "completeTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 385);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCompleteTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 394);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTask", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.Task", "taskToCreate", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.classification.api.exceptions.ClassificationNotFoundException:io.kadai.task.api.exceptions.TaskAlreadyExistException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.task.api.exceptions.AttachmentPersistenceException:io.kadai.task.api.exceptions.ObjectReferencePersistenceException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 403);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "claimActionsOnTask", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskSummaryImpl:java.lang.String:java.lang.String:java.time.Instant", "task:userId:userLongName:now", "", "void"), 203);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "id", "io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.TaskNotFoundException", "io.kadai.task.api.models.Task"), 527);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketId:setTransferFlag", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 590);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transfer", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.lang.String:boolean", "taskId:workbasketKey:domain:setTransferFlag", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 599);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferWithOwner", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketId:owner:setTransferFlag", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 608);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferWithOwner", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:boolean", "taskId:workbasketKey:domain:owner:setTransferFlag", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 619);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTaskRead", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:isRead", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 629);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskQuery", "io.kadai.task.internal.TaskServiceImpl", "", "", "", "io.kadai.task.api.TaskQuery"), 648);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskCommentQuery", "io.kadai.task.internal.TaskServiceImpl", "", "", "", "io.kadai.task.api.TaskCommentQuery"), 653);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTask", "io.kadai.task.internal.TaskServiceImpl", "", "", "", "io.kadai.task.api.models.Task"), 658);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "workbasketId", "", "io.kadai.task.api.models.Task"), 663);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "cancelClaimActionsOnTask", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskSummaryImpl:java.time.Instant:boolean", "task:now:keepOwner", "", "void"), 217);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String", "workbasketKey:domain", "", "io.kadai.task.api.models.Task"), 673);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newTaskComment", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "", "io.kadai.task.api.models.TaskComment"), 683);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newAttachment", "io.kadai.task.internal.TaskServiceImpl", "", "", "", "io.kadai.task.api.models.Attachment"), 688);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newObjectReference", "io.kadai.task.internal.TaskServiceImpl", "", "", "", "io.kadai.task.api.models.ObjectReference"), 693);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "newObjectReference", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "company:system:systemInstance:type:value", "", "io.kadai.task.api.models.ObjectReference"), 698);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTask", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.Task", "task", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.ConcurrencyException:io.kadai.task.api.exceptions.AttachmentPersistenceException:io.kadai.task.api.exceptions.ObjectReferencePersistenceException:io.kadai.classification.api.exceptions.ClassificationNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 704);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.util.List:boolean", "destinationWorkbasketId:taskIds:setTransferFlag", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 764);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasks", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.util.List:boolean", "destinationWorkbasketKey:destinationWorkbasketDomain:taskIds:setTransferFlag", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 773);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasksWithOwner", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.util.List:java.lang.String:boolean", "destinationWorkbasketId:taskIds:owner:setTransferFlag", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 786);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "transferTasksWithOwner", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.lang.String:java.util.List:java.lang.String:boolean", "destinationWorkbasketKey:destinationWorkbasketDomain:taskIds:owner:setTransferFlag", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 796);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "completeActionsOnTask", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskSummaryImpl:java.lang.String:java.time.Instant", "task:userId:now", "", "void"), 233);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.task.api.exceptions.InvalidCallbackStateException", "void"), 810);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceDeleteTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.task.api.exceptions.InvalidCallbackStateException", "void"), 820);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "selectAndClaim", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.TaskQuery", "taskQuery", "io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "java.util.Optional"), 830);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTasks", "io.kadai.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "io.kadai.common.api.BulkOperationResults"), 847);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "completeTasks", "io.kadai.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.common.api.BulkOperationResults"), 895);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceCompleteTasks", "io.kadai.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.common.api.BulkOperationResults"), 901);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTasks", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:java.util.Map", "taskIds:customFieldsToUpdate", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.util.List"), 907);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 948);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskComment", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.TaskComment", "taskComment", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.TaskComment"), 995);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskComment", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.TaskComment", "taskComment", "io.kadai.common.api.exceptions.ConcurrencyException:io.kadai.task.api.exceptions.TaskCommentNotFoundException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.task.api.exceptions.NotAuthorizedOnTaskCommentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.TaskComment"), 1001);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTasks", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.ObjectReference:java.util.Map", "selectionCriteria:customFieldsToUpdate", "io.kadai.common.api.exceptions.InvalidArgumentException", "java.util.List"), 241);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTaskComment", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskCommentId", "io.kadai.task.api.exceptions.TaskCommentNotFoundException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.task.api.exceptions.NotAuthorizedOnTaskCommentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 1012);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComment", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskCommentid", "io.kadai.task.api.exceptions.TaskCommentNotFoundException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.TaskComment"), 1022);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComments", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "java.util.List"), 1031);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setCallbackStateForTasks", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:io.kadai.task.api.CallbackState", "externalIds:state", "", "io.kadai.common.api.BulkOperationResults"), 1038);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOwnerOfTasks", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:java.util.List", "owner:taskIds", "", "io.kadai.common.api.BulkOperationResults"), 1066);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPlannedPropertyOfTasks", "io.kadai.task.internal.TaskServiceImpl", "java.time.Instant:java.util.List", "planned:argTaskIds", "", "io.kadai.common.api.BulkOperationResults"), 1103);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "terminateTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 1125);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findTasksIdsAffectedByClassificationChange", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "classificationId", "", "java.util.List"), 1176);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "filterTasksAuthorizedForAndLogErrorsForNotAuthorized", "io.kadai.task.internal.TaskServiceImpl", "java.util.List", "existingTasks", "", "io.kadai.common.internal.util.Pair"), 1217);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshPriorityAndDueDatesOfTasksOnClassificationUpdate", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:boolean:boolean", "taskIds:serviceLevelChanged:priorityChanged", "", "void"), 1246);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "checkIfTaskIsTerminatedOrCancelled", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.TaskSummary", "task", "io.kadai.task.api.exceptions.InvalidTaskStateException", "void"), 282);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getMinimalTaskSummaries", "io.kadai.task.internal.TaskServiceImpl", "java.util.Collection", "argTaskIds", "", "io.kadai.common.internal.util.Pair"), 1270);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "taskIsNotClaimed", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.TaskSummary", "task", "", "boolean"), 1283);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "addExceptionsForNonExistingTasksToBulkLog", "io.kadai.task.internal.TaskServiceImpl", "java.util.Collection:java.util.List", "requestTaskIds:existingMinimalTaskSummaries", "", "io.kadai.task.internal.ServiceLevelHandler$BulkLog"), 1288);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "augmentTaskSummariesByContainedSummariesWithPartitioning", "io.kadai.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "java.util.List"), 1301);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterOutTasksWhichAreInInvalidState", "io.kadai.task.internal.TaskServiceImpl", "java.util.Collection", "minimalTaskSummaries", "", "io.kadai.common.internal.util.Pair"), 1311);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "appendComplexAttributesToTaskSummariesWithoutPartitioning", "io.kadai.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "java.util.List"), 1332);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "completeTasks", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:boolean", "taskIds:forced", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.common.api.BulkOperationResults"), 1365);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterNotExistingTaskIds", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:io.kadai.common.api.BulkOperationResults", "taskIds:bulkLog", "", "java.util.stream.Stream"), 1417);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkConcurrencyAndSetModified", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl:io.kadai.task.internal.models.TaskImpl", "newTaskImpl:oldTaskImpl", "io.kadai.common.api.exceptions.ConcurrencyException", "void"), 1437);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "claim", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:forceClaim", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 1452);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "claim", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 293);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "requestReview", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:force", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 1498);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "requestChanges", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:force", "io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.task.api.models.Task"), 1551);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPreconditionsForClaimTask", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.TaskSummary:boolean", "task:forced", "io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 1602);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPreconditionsForCompleteTask", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.TaskSummary", "task", "io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 1624);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "cancelClaim", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:boolean:boolean", "taskId:forceUnclaim:keepOwner", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 1646);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "completeTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:isForced", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 1697);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteTask", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String:boolean", "taskId:forceDelete", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.common.api.exceptions.NotAuthorizedException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException:io.kadai.task.api.exceptions.InvalidCallbackStateException", "void"), 1743);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeSingleTaskForTaskDeletionById", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.common.api.BulkOperationResults:java.util.List:java.util.Iterator", "bulkLog:taskSummaries:taskIdIterator", "", "void"), 1790);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeSingleTaskForCallbackStateByExternalId", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.common.api.BulkOperationResults:java.util.List:java.util.Iterator:io.kadai.task.api.CallbackState", "bulkLog:taskSummaries:externalIdIterator:desiredCallbackState", "", "void"), 1828);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "desiredCallbackStateCanBeSetForFoundSummary", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.MinimalTaskSummary:io.kadai.task.api.CallbackState", "foundSummary:desiredCallbackState", "", "java.util.Optional"), 1856);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "forceClaim", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 302);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "standardSettingsOnTaskCreation", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl:io.kadai.classification.api.models.Classification", "task:classification", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.classification.api.exceptions.ClassificationNotFoundException:io.kadai.task.api.exceptions.AttachmentPersistenceException:io.kadai.task.api.exceptions.ObjectReferencePersistenceException", "void"), 1905);
        ajc$tjp_81 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setDefaultTaskReceivedDateFromAttachments", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl", "task", "", "void"), 1960);
        ajc$tjp_82 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setCallbackStateOnTaskCreation", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl", "task", "io.kadai.common.api.exceptions.InvalidArgumentException", "void"), 1970);
        ajc$tjp_83 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateTasksToBeCompleted", "io.kadai.task.internal.TaskServiceImpl", "java.util.stream.Stream:java.time.Instant", "taskSummaries:now", "", "void"), 1988);
        ajc$tjp_84 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateWorkbasketDuringTaskCreation", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl", "task", "", "io.kadai.spi.routing.api.RoutingTarget"), 2025);
        ajc$tjp_85 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findWorkbasketsForTasks", "io.kadai.task.internal.TaskServiceImpl", "java.util.List", "taskSummaries", "", "java.util.Map"), 2043);
        ajc$tjp_86 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findClassificationsForTasksAndAttachments", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "taskSummaries:attachmentSummaries", "", "java.util.Map"), 2059);
        ajc$tjp_87 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findClassificationForTaskImplAndAttachments", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl:java.util.List", "task:attachmentImpls", "", "java.util.Map"), 2077);
        ajc$tjp_88 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "queryClassificationsForTasksAndAttachments", "io.kadai.task.internal.TaskServiceImpl", "java.util.Set", "classificationIds", "", "java.util.List"), 2083);
        ajc$tjp_89 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "queryWorkbasketsForTasks", "io.kadai.task.internal.TaskServiceImpl", "java.util.Set", "workbasketIds", "", "java.util.List"), 2096);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelClaim", "io.kadai.task.internal.TaskServiceImpl", "java.lang.String", "taskId", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.task.api.exceptions.InvalidOwnerException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 311);
        ajc$tjp_90 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addClassificationSummariesToTaskSummaries", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:java.util.Map", "tasks:classificationSummaryById", "", "void"), 2108);
        ajc$tjp_91 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addWorkbasketSummariesToTaskSummaries", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:java.util.Map", "tasks:workbasketSummaryById", "", "void"), 2130);
        ajc$tjp_92 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addAttachmentSummariesToTaskSummaries", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "taskSummaries:attachmentSummaries", "", "void"), 2151);
        ajc$tjp_93 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addClassificationSummariesToAttachments", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:java.util.Map", "attachments:classificationSummariesById", "", "void"), 2178);
        ajc$tjp_94 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addObjectReferencesToTaskSummaries", "io.kadai.task.internal.TaskServiceImpl", "java.util.List:java.util.List", "taskSummaries:objectReferences", "", "void"), 2198);
        ajc$tjp_95 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initUpdatedTask", "io.kadai.task.internal.TaskServiceImpl", "java.util.Map:io.kadai.task.internal.TaskCustomPropertySelector", "customFieldsToUpdate:fieldSelector", "", "io.kadai.task.internal.models.TaskImpl"), 2224);
        ajc$tjp_96 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateCustomFields", "io.kadai.task.internal.TaskServiceImpl", "java.util.Map", "customFieldsToUpdate", "io.kadai.common.api.exceptions.InvalidArgumentException", "void"), 2238);
        ajc$tjp_97 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksToChange", "io.kadai.task.internal.TaskServiceImpl", "java.util.List", "taskIds", "", "java.util.List"), 2247);
        ajc$tjp_98 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksToChange", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.api.models.ObjectReference", "selectionCriteria", "", "java.util.List"), 2251);
        ajc$tjp_99 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "standardUpdateActions", "io.kadai.task.internal.TaskServiceImpl", "io.kadai.task.internal.models.TaskImpl:io.kadai.task.internal.models.TaskImpl", "oldTaskImpl:newTaskImpl", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.classification.api.exceptions.ClassificationNotFoundException:io.kadai.task.api.exceptions.InvalidTaskStateException", "void"), 2261);
    }
}

