/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.internal;

import io.kadai.common.api.BulkOperationResults;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.internal.InternalKadaiEngine;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.util.EnumUtil;
import io.kadai.common.internal.util.IdGenerator;
import io.kadai.common.internal.util.ObjectAttributeChangeDetector;
import io.kadai.spi.history.api.events.task.TaskTransferredEvent;
import io.kadai.spi.history.internal.HistoryEventManager;
import io.kadai.task.api.TaskState;
import io.kadai.task.api.exceptions.InvalidTaskStateException;
import io.kadai.task.api.exceptions.TaskNotFoundException;
import io.kadai.task.api.models.Task;
import io.kadai.task.api.models.TaskSummary;
import io.kadai.task.internal.TaskMapper;
import io.kadai.task.internal.TaskServiceImpl;
import io.kadai.task.internal.models.TaskImpl;
import io.kadai.task.internal.models.TaskSummaryImpl;
import io.kadai.workbasket.api.WorkbasketPermission;
import io.kadai.workbasket.api.WorkbasketService;
import io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException;
import io.kadai.workbasket.api.models.WorkbasketSummary;
import io.kadai.workbasket.internal.WorkbasketQueryImpl;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

final class TaskTransferrer {
    private final InternalKadaiEngine kadaiEngine;
    private final WorkbasketService workbasketService;
    private final TaskServiceImpl taskService;
    private final TaskMapper taskMapper;
    private final HistoryEventManager historyEventManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;

    TaskTransferrer(InternalKadaiEngine kadaiEngine, TaskMapper taskMapper, TaskServiceImpl taskService) {
        this.kadaiEngine = kadaiEngine;
        this.taskService = taskService;
        this.taskMapper = taskMapper;
        this.workbasketService = kadaiEngine.getEngine().getWorkbasketService();
        this.historyEventManager = kadaiEngine.getHistoryEventManager();
    }

    Task transfer(String taskId, String destinationWorkbasketId, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId).asSummary();
        Task task3 = task2 = (task = this.transferSingleTask(taskId, destinationWorkbasket, null, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    Task transfer(String taskId, String destinationWorkbasketKey, String destinationDomain, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketKey;
        String string3 = destinationDomain;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, destinationDomain).asSummary();
        Task task3 = task2 = (task = this.transferSingleTask(taskId, destinationWorkbasket, null, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    BulkOperationResults<String, KadaiException> transfer(List<String> taskIds, String destinationWorkbasketId, boolean setTransferFlag) throws WorkbasketNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        List<String> list = taskIds;
        String string = destinationWorkbasketId;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId).asSummary();
        this.checkDestinationWorkbasket(destinationWorkbasket);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferMultipleTasks(taskIds, destinationWorkbasket, null, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    BulkOperationResults<String, KadaiException> transfer(List<String> taskIds, String destinationWorkbasketKey, String destinationDomain, boolean setTransferFlag) throws WorkbasketNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        List<String> list = taskIds;
        String string = destinationWorkbasketKey;
        String string2 = destinationDomain;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, destinationDomain).asSummary();
        this.checkDestinationWorkbasket(destinationWorkbasket);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferMultipleTasks(taskIds, destinationWorkbasket, null, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    BulkOperationResults<String, KadaiException> transferWithOwner(List<String> taskIds, String destinationWorkbasketId, String owner, boolean setTransferFlag) throws WorkbasketNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        List<String> list = taskIds;
        String string = destinationWorkbasketId;
        String string2 = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId).asSummary();
        this.checkDestinationWorkbasket(destinationWorkbasket);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferMultipleTasks(taskIds, destinationWorkbasket, owner, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    BulkOperationResults<String, KadaiException> transferWithOwner(List<String> taskIds, String destinationWorkbasketKey, String destinationDomain, String owner, boolean setTransferFlag) throws WorkbasketNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        BulkOperationResults<String, KadaiException> bulkOperationResults;
        BulkOperationResults<String, KadaiException> bulkOperationResults2;
        List<String> list = taskIds;
        String string = destinationWorkbasketKey;
        String string2 = destinationDomain;
        String string3 = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, string, string2, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, destinationDomain).asSummary();
        this.checkDestinationWorkbasket(destinationWorkbasket);
        BulkOperationResults<String, KadaiException> bulkOperationResults3 = bulkOperationResults2 = (bulkOperationResults = this.transferMultipleTasks(taskIds, destinationWorkbasket, owner, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, bulkOperationResults2);
        return bulkOperationResults;
    }

    Task transferWithOwner(String taskId, String destinationWorkbasketId, String owner, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketId;
        String string3 = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId).asSummary();
        Task task3 = task2 = (task = this.transferSingleTask(taskId, destinationWorkbasket, owner, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    Task transferWithOwner(String taskId, String destinationWorkbasketKey, String destinationDomain, String owner, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task;
        Task task2;
        String string = taskId;
        String string2 = destinationWorkbasketKey;
        String string3 = destinationDomain;
        String string4 = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, string2, string3, string4, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketSummary destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, destinationDomain).asSummary();
        Task task3 = task2 = (task = this.transferSingleTask(taskId, destinationWorkbasket, owner, setTransferFlag));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)task2);
        return task;
    }

    private Task transferSingleTask(String taskId, WorkbasketSummary destinationWorkbasket, String owner, boolean setTransferFlag) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        TaskImpl taskImpl;
        TaskImpl taskImpl2;
        String string = taskId;
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        String string2 = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{string, workbasketSummary, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            this.kadaiEngine.openConnection();
            TaskImpl task = (TaskImpl)this.taskService.getTask(taskId);
            TaskImpl oldTask = task.copy();
            oldTask.setId(task.getId());
            oldTask.setExternalId(task.getExternalId());
            WorkbasketSummary originWorkbasket = task.getWorkbasketSummary();
            this.checkPreconditionsForTransferTask(task, destinationWorkbasket, originWorkbasket);
            this.applyTransferValuesForTask(task, destinationWorkbasket, owner, setTransferFlag);
            this.taskMapper.update(task);
            if (this.historyEventManager.isEnabled()) {
                this.createTransferredEvent(oldTask, task, originWorkbasket.getId(), destinationWorkbasket.getId());
            }
            TaskImpl taskImpl3 = task;
            taskImpl2 = taskImpl3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        TaskImpl taskImpl4 = taskImpl = taskImpl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskImpl);
        return taskImpl2;
    }

    private BulkOperationResults<String, KadaiException> transferMultipleTasks(List<String> taskToBeTransferred, WorkbasketSummary destinationWorkbasket, String owner, boolean setTransferFlag) throws InvalidArgumentException {
        BulkOperationResults bulkOperationResults;
        BulkOperationResults bulkOperationResults2;
        List<String> list = taskToBeTransferred;
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        String string = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, workbasketSummary, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskToBeTransferred == null || taskToBeTransferred.isEmpty()) {
            throw new InvalidArgumentException("TaskIds must not be null or empty.");
        }
        BulkOperationResults bulkLog = new BulkOperationResults();
        ArrayList<String> taskIds = new ArrayList<String>(taskToBeTransferred);
        try {
            this.kadaiEngine.openConnection();
            List<TaskSummary> taskSummaries = this.kadaiEngine.getEngine().runAsAdmin(() -> this.taskService.createTaskQuery().idIn(taskIds.toArray(new String[0])).list());
            taskSummaries = this.filterOutTasksWhichDoNotMatchTransferCriteria(taskIds, taskSummaries, (BulkOperationResults<String, KadaiException>)bulkLog);
            this.updateTransferableTasks(taskSummaries, destinationWorkbasket, owner, setTransferFlag);
            BulkOperationResults bulkOperationResults3 = bulkLog;
            bulkOperationResults2 = bulkOperationResults3;
        }
        finally {
            this.kadaiEngine.returnConnection();
        }
        BulkOperationResults bulkOperationResults4 = bulkOperationResults = bulkOperationResults2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bulkOperationResults);
        return bulkOperationResults2;
    }

    private void checkPreconditionsForTransferTask(Task task, WorkbasketSummary destinationWorkbasket, WorkbasketSummary originWorkbasket) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, InvalidTaskStateException {
        Task task2 = task;
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        WorkbasketSummary workbasketSummary2 = originWorkbasket;
        Object[] objectArray = new Object[]{task2, workbasketSummary, workbasketSummary2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (task.getState().isEndState()) {
            throw new InvalidTaskStateException(task.getId(), task.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
        }
        this.workbasketService.checkAuthorization(originWorkbasket.getId(), WorkbasketPermission.TRANSFER);
        this.checkDestinationWorkbasket(destinationWorkbasket);
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private void checkDestinationWorkbasket(WorkbasketSummary destinationWorkbasket) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)workbasketSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.workbasketService.checkAuthorization(destinationWorkbasket.getId(), WorkbasketPermission.APPEND);
        if (destinationWorkbasket.isMarkedForDeletion()) {
            throw new WorkbasketNotFoundException(destinationWorkbasket.getId());
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private List<TaskSummary> filterOutTasksWhichDoNotMatchTransferCriteria(List<String> taskIds, List<TaskSummary> taskSummaries, BulkOperationResults<String, KadaiException> bulkLog) {
        ArrayList<TaskSummary> arrayList;
        ArrayList<TaskSummary> arrayList2;
        List<String> list = taskIds;
        List<TaskSummary> list2 = taskSummaries;
        BulkOperationResults<String, KadaiException> bulkOperationResults = bulkLog;
        Object[] objectArray = new Object[]{list, list2, bulkOperationResults};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map taskIdToTaskSummary = taskSummaries.stream().collect(Collectors.toMap(TaskSummary::getId, Function.identity()));
        Set<String> workbasketIds = this.getSourceWorkbasketIdsWithTransferPermission(taskSummaries);
        ArrayList<TaskSummary> filteredOutTasks = new ArrayList<TaskSummary>(taskIds.size());
        for (String taskId : new HashSet<String>(taskIds)) {
            TaskSummary taskSummary;
            Optional<KadaiException> error = this.checkTaskForTransferCriteria(workbasketIds, taskId, taskSummary = (TaskSummary)taskIdToTaskSummary.get(taskId));
            if (error.isPresent()) {
                bulkLog.addError((Object)taskId, (Exception)error.get());
                continue;
            }
            filteredOutTasks.add(taskSummary);
        }
        ArrayList<TaskSummary> arrayList3 = arrayList2 = (arrayList = filteredOutTasks);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    private Optional<KadaiException> checkTaskForTransferCriteria(Set<String> sourceWorkbasketIds, String taskId, TaskSummary taskSummary) {
        Optional<KadaiException> optional;
        Optional<KadaiException> optional2;
        Set<String> set = sourceWorkbasketIds;
        String string = taskId;
        TaskSummary taskSummary2 = taskSummary;
        Object[] objectArray = new Object[]{set, string, taskSummary2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        KadaiException error = null;
        if (taskId == null || taskId.isEmpty()) {
            error = new TaskNotFoundException(null);
        } else if (taskSummary == null) {
            error = new TaskNotFoundException(taskId);
        } else if (taskSummary.getState().isEndState()) {
            error = new InvalidTaskStateException(taskId, taskSummary.getState(), (TaskState[])EnumUtil.allValuesExceptFor((Enum[])TaskState.END_STATES));
        } else if (!sourceWorkbasketIds.contains(taskSummary.getWorkbasketSummary().getId())) {
            error = new NotAuthorizedOnWorkbasketException(this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), taskSummary.getWorkbasketSummary().getId(), WorkbasketPermission.TRANSFER);
        }
        Optional<KadaiException> optional3 = optional2 = (optional = Optional.ofNullable(error));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional2);
        return optional;
    }

    private Set<String> getSourceWorkbasketIdsWithTransferPermission(List<TaskSummary> taskSummaries) {
        Set<String> set;
        Set<String> set2;
        Set<String> set3;
        List<TaskSummary> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskSummaries.isEmpty()) {
            set2 = set3 = Collections.emptySet();
        } else {
            WorkbasketQueryImpl query = (WorkbasketQueryImpl)this.workbasketService.createWorkbasketQuery();
            query.setUsedToAugmentTasks(true);
            String[] workbasketIds = (String[])taskSummaries.stream().map(TaskSummary::getWorkbasketSummary).map(WorkbasketSummary::getId).distinct().toArray(String[]::new);
            List sourceWorkbaskets = query.callerHasPermissions(WorkbasketPermission.TRANSFER).idIn(workbasketIds).list();
            set2 = set3 = sourceWorkbaskets.stream().map(WorkbasketSummary::getId).collect(Collectors.toSet());
        }
        Set<String> set4 = set = set2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set);
        return set3;
    }

    private void updateTransferableTasks(List<TaskSummary> taskSummaries, WorkbasketSummary destinationWorkbasket, String owner, boolean setTransferFlag) {
        List<TaskSummary> list = taskSummaries;
        WorkbasketSummary workbasketSummary = destinationWorkbasket;
        String string = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{list, workbasketSummary, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<TaskState, List<TaskSummary>> summariesByState = this.groupTasksByState(taskSummaries);
        for (Map.Entry<TaskState, List<TaskSummary>> entry : summariesByState.entrySet()) {
            TaskState goalState = entry.getKey();
            List<TaskSummary> taskSummariesWithSameGoalState = entry.getValue();
            if (taskSummariesWithSameGoalState.isEmpty()) continue;
            TaskImpl updateObject = new TaskImpl();
            updateObject.setState(goalState);
            this.applyTransferValuesForTask(updateObject, destinationWorkbasket, owner, setTransferFlag);
            this.taskMapper.updateTransfered(taskSummariesWithSameGoalState.stream().map(TaskSummary::getId).collect(Collectors.toSet()), updateObject);
            if (!this.historyEventManager.isEnabled()) continue;
            taskSummaries.forEach(oldSummary -> {
                TaskSummaryImpl newSummary = (TaskSummaryImpl)oldSummary.copy();
                newSummary.setId(oldSummary.getId());
                newSummary.setExternalId(oldSummary.getExternalId());
                this.applyTransferValuesForTask(newSummary, destinationWorkbasket, owner, setTransferFlag);
                this.createTransferredEvent((TaskSummary)oldSummary, newSummary, oldSummary.getWorkbasketSummary().getId(), newSummary.getWorkbasketSummary().getId());
            });
        }
        Object var17_17 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var17_17);
    }

    private void applyTransferValuesForTask(TaskSummaryImpl task, WorkbasketSummary workbasket, String owner, boolean setTransferFlag) {
        TaskSummaryImpl taskSummaryImpl = task;
        WorkbasketSummary workbasketSummary = workbasket;
        String string = owner;
        boolean bl = setTransferFlag;
        Object[] objectArray = new Object[]{taskSummaryImpl, workbasketSummary, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        task.setRead(false);
        task.setTransferred(setTransferFlag);
        task.setState(this.getStateAfterTransfer(task));
        task.setOwner(owner);
        task.setWorkbasketSummary(workbasket);
        task.setDomain(workbasket.getDomain());
        task.setModified(Instant.now());
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private void createTransferredEvent(TaskSummary oldTask, TaskSummary newTask, String originWorkbasketId, String destinationWorkbasketId) {
        TaskSummary taskSummary = oldTask;
        TaskSummary taskSummary2 = newTask;
        String string = originWorkbasketId;
        String string2 = destinationWorkbasketId;
        Object[] objectArray = new Object[]{taskSummary, taskSummary2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String details = ObjectAttributeChangeDetector.determineChangesInAttributes((Object)oldTask, (Object)newTask);
        this.historyEventManager.createEvent(new TaskTransferredEvent(IdGenerator.generateWithPrefix((String)"THI"), newTask, originWorkbasketId, destinationWorkbasketId, this.kadaiEngine.getEngine().getCurrentUserContext().getUserid(), details));
        Object var12_12 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var12_12);
    }

    private TaskState getStateAfterTransfer(TaskSummary taskSummary) {
        TaskState taskState;
        TaskState taskState2;
        TaskSummary taskSummary2 = taskSummary;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)taskSummary2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskState stateBeforeTransfer = taskSummary.getState();
        TaskState taskState3 = taskState2 = stateBeforeTransfer.equals((Object)TaskState.CLAIMED) ? (taskState = TaskState.READY) : (stateBeforeTransfer.equals((Object)TaskState.IN_REVIEW) ? (taskState = TaskState.READY_FOR_REVIEW) : (taskState = stateBeforeTransfer));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskState2);
        return taskState;
    }

    private Map<TaskState, List<TaskSummary>> groupTasksByState(List<TaskSummary> taskSummaries) {
        Map<TaskState, List<TaskSummary>> map;
        Map<TaskState, List<TaskSummary>> map2;
        List<TaskSummary> list = taskSummaries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<TaskState, List<TaskSummary>> result = Map.ofEntries(Map.entry(TaskState.READY, new ArrayList()), Map.entry(TaskState.READY_FOR_REVIEW, new ArrayList()));
        for (TaskSummary taskSummary : taskSummaries) {
            List relevantSummaries = (List)result.get((Object)this.getStateAfterTransfer(taskSummary));
            relevantSummaries.add(taskSummary);
        }
        Map<TaskState, List<TaskSummary>> map3 = map2 = (map = result);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    static {
        TaskTransferrer.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskTransferrer.java", TaskTransferrer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transfer", "io.kadai.task.internal.TaskTransferrer", "java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketId:setTransferFlag", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 74);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transfer", "io.kadai.task.internal.TaskTransferrer", "java.lang.String:java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketKey:destinationDomain:setTransferFlag", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 84);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPreconditionsForTransferTask", "io.kadai.task.internal.TaskTransferrer", "io.kadai.task.api.models.Task:io.kadai.workbasket.api.models.WorkbasketSummary:io.kadai.workbasket.api.models.WorkbasketSummary", "task:destinationWorkbasket:originWorkbasket", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "void"), 238);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkDestinationWorkbasket", "io.kadai.task.internal.TaskTransferrer", "io.kadai.workbasket.api.models.WorkbasketSummary", "destinationWorkbasket", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "void"), 251);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filterOutTasksWhichDoNotMatchTransferCriteria", "io.kadai.task.internal.TaskTransferrer", "java.util.List:java.util.List:io.kadai.common.api.BulkOperationResults", "taskIds:taskSummaries:bulkLog", "", "java.util.List"), 261);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkTaskForTransferCriteria", "io.kadai.task.internal.TaskTransferrer", "java.util.Set:java.lang.String:io.kadai.task.api.models.TaskSummary", "sourceWorkbasketIds:taskId:taskSummary", "", "java.util.Optional"), 286);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSourceWorkbasketIdsWithTransferPermission", "io.kadai.task.internal.TaskTransferrer", "java.util.List", "taskSummaries", "", "java.util.Set"), 307);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateTransferableTasks", "io.kadai.task.internal.TaskTransferrer", "java.util.List:io.kadai.workbasket.api.models.WorkbasketSummary:java.lang.String:boolean", "taskSummaries:destinationWorkbasket:owner:setTransferFlag", "", "void"), 327);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "applyTransferValuesForTask", "io.kadai.task.internal.TaskTransferrer", "io.kadai.task.internal.models.TaskSummaryImpl:io.kadai.workbasket.api.models.WorkbasketSummary:java.lang.String:boolean", "task:workbasket:owner:setTransferFlag", "", "void"), 366);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createTransferredEvent", "io.kadai.task.internal.TaskTransferrer", "io.kadai.task.api.models.TaskSummary:io.kadai.task.api.models.TaskSummary:java.lang.String:java.lang.String", "oldTask:newTask:originWorkbasketId:destinationWorkbasketId", "", "void"), 377);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getStateAfterTransfer", "io.kadai.task.internal.TaskTransferrer", "io.kadai.task.api.models.TaskSummary", "taskSummary", "", "io.kadai.task.api.TaskState"), 393);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "groupTasksByState", "io.kadai.task.internal.TaskTransferrer", "java.util.List", "taskSummaries", "", "java.util.Map"), 405);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transfer", "io.kadai.task.internal.TaskTransferrer", "java.util.List:java.lang.String:boolean", "taskIds:destinationWorkbasketId:setTransferFlag", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 98);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transfer", "io.kadai.task.internal.TaskTransferrer", "java.util.List:java.lang.String:java.lang.String:boolean", "taskIds:destinationWorkbasketKey:destinationDomain:setTransferFlag", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 110);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transferWithOwner", "io.kadai.task.internal.TaskTransferrer", "java.util.List:java.lang.String:java.lang.String:boolean", "taskIds:destinationWorkbasketId:owner:setTransferFlag", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 125);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transferWithOwner", "io.kadai.task.internal.TaskTransferrer", "java.util.List:java.lang.String:java.lang.String:java.lang.String:boolean", "taskIds:destinationWorkbasketKey:destinationDomain:owner:setTransferFlag", "io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "io.kadai.common.api.BulkOperationResults"), 137);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transferWithOwner", "io.kadai.task.internal.TaskTransferrer", "java.lang.String:java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketId:owner:setTransferFlag", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 153);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "transferWithOwner", "io.kadai.task.internal.TaskTransferrer", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:boolean", "taskId:destinationWorkbasketKey:destinationDomain:owner:setTransferFlag", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 164);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transferSingleTask", "io.kadai.task.internal.TaskTransferrer", "java.lang.String:io.kadai.workbasket.api.models.WorkbasketSummary:java.lang.String:boolean", "taskId:destinationWorkbasket:owner:setTransferFlag", "io.kadai.task.api.exceptions.TaskNotFoundException:io.kadai.workbasket.api.exceptions.WorkbasketNotFoundException:io.kadai.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:io.kadai.task.api.exceptions.InvalidTaskStateException", "io.kadai.task.api.models.Task"), 179);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transferMultipleTasks", "io.kadai.task.internal.TaskTransferrer", "java.util.List:io.kadai.workbasket.api.models.WorkbasketSummary:java.lang.String:boolean", "taskToBeTransferred:destinationWorkbasket:owner:setTransferFlag", "io.kadai.common.api.exceptions.InvalidArgumentException", "io.kadai.common.api.BulkOperationResults"), 208);
    }
}

