/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.internal.jobs;

import io.kadai.KadaiConfiguration;
import io.kadai.common.api.BaseQuery;
import io.kadai.common.api.BulkOperationResults;
import io.kadai.common.api.KadaiEngine;
import io.kadai.common.api.ScheduledJob;
import io.kadai.common.api.TimeInterval;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.jobs.AbstractKadaiJob;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.transaction.KadaiTransactionProvider;
import io.kadai.common.internal.util.CollectionUtil;
import io.kadai.common.internal.util.LogSanitizer;
import io.kadai.task.api.models.TaskSummary;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCleanupJob
extends AbstractKadaiJob {
    private static final Logger LOGGER;
    private final Duration minimumAge;
    private final int batchSize;
    private final boolean allCompletedSameParentBusiness;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        TaskCleanupJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskCleanupJob.class);
    }

    public TaskCleanupJob(KadaiEngine kadaiEngine, KadaiTransactionProvider txProvider, ScheduledJob scheduledJob) {
        super(kadaiEngine, txProvider, scheduledJob, true);
        this.minimumAge = kadaiEngine.getConfiguration().getTaskCleanupJobMinimumAge();
        this.batchSize = kadaiEngine.getConfiguration().getJobBatchSize();
        this.allCompletedSameParentBusiness = kadaiEngine.getConfiguration().isTaskCleanupJobAllCompletedSameParentBusiness();
    }

    public static Duration getLockExpirationPeriod(KadaiConfiguration kadaiConfiguration) {
        Duration duration;
        Duration duration2;
        KadaiConfiguration kadaiConfiguration2 = kadaiConfiguration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)kadaiConfiguration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = kadaiConfiguration.getTaskCleanupJobLockExpirationPeriod());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    @Override
    public void execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant completedBefore = Instant.now().minus(this.minimumAge);
        LOGGER.info("Running job to delete all tasks completed before ({})", (Object)completedBefore);
        try {
            List<TaskSummary> tasksCompletedBefore = this.getTasksCompletedBefore(completedBefore);
            int totalNumberOfTasksDeleted = CollectionUtil.partitionBasedOnSize(tasksCompletedBefore, (int)this.batchSize).stream().mapToInt(this::deleteTasksTransactionally).sum();
            LOGGER.info("Job ended successfully. {} tasks deleted.", (Object)totalNumberOfTasksDeleted);
        }
        catch (Exception e) {
            throw new SystemException("Error while processing TaskCleanupJob.", (Throwable)e);
        }
        Object var5_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_6);
    }

    @Override
    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = TaskCleanupJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private List<TaskSummary> getTasksCompletedBefore(Instant untilDate) {
        List<TaskSummary> list;
        List<TaskSummary> list2;
        Instant instant = untilDate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<TaskSummary> tasksToDelete = this.kadaiEngineImpl.getTaskService().createTaskQuery().completedWithin(new TimeInterval(null, untilDate)).orderByBusinessProcessId(BaseQuery.SortDirection.ASCENDING).list();
        if (this.allCompletedSameParentBusiness) {
            HashMap numberParentTasksShouldHave = new HashMap();
            HashMap countParentTask = new HashMap();
            tasksToDelete.forEach(task -> {
                if (!numberParentTasksShouldHave.containsKey(task.getParentBusinessProcessId())) {
                    numberParentTasksShouldHave.put(task.getParentBusinessProcessId(), this.kadaiEngineImpl.getTaskService().createTaskQuery().parentBusinessProcessIdIn(task.getParentBusinessProcessId()).count());
                }
                countParentTask.merge(task.getParentBusinessProcessId(), 1L, Long::sum);
            });
            List<String> taskIdsNotAllCompletedSameParentBusiness = numberParentTasksShouldHave.entrySet().stream().filter(entry -> Objects.nonNull(entry.getKey())).filter(Predicate.not(entry -> ((String)entry.getKey()).isEmpty())).filter(Predicate.not(entry -> ((Long)entry.getValue()).equals(countParentTask.get(entry.getKey())))).map(Map.Entry::getKey).toList();
            tasksToDelete = tasksToDelete.stream().filter(taskSummary -> !taskIdsNotAllCompletedSameParentBusiness.contains(taskSummary.getParentBusinessProcessId())).toList();
        }
        List<TaskSummary> list3 = list2 = (list = tasksToDelete);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private int deleteTasksTransactionally(List<TaskSummary> tasksToBeDeleted) {
        int n;
        int n2;
        List<TaskSummary> list = tasksToBeDeleted;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = ((Integer)KadaiTransactionProvider.executeInTransactionIfPossible((KadaiTransactionProvider)this.txProvider, () -> {
            try {
                return this.deleteTasks(tasksToBeDeleted);
            }
            catch (Exception ex) {
                LOGGER.warn("Could not delete tasks.", (Throwable)ex);
                return 0;
            }
        })).intValue());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private int deleteTasks(List<TaskSummary> tasksToBeDeleted) throws InvalidArgumentException, NotAuthorizedException {
        int n;
        int n2;
        List<TaskSummary> list = tasksToBeDeleted;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> tasksIdsToBeDeleted = tasksToBeDeleted.stream().map(TaskSummary::getId).toList();
        BulkOperationResults<String, KadaiException> results = this.kadaiEngineImpl.getTaskService().deleteTasks(tasksIdsToBeDeleted);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} tasks deleted.", (Object)(tasksIdsToBeDeleted.size() - results.getFailedIds().size()));
        }
        for (String failedId : results.getFailedIds()) {
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("Task with id {} could not be deleted. Reason: {}", (Object)LogSanitizer.stripLineBreakingChars((Object)failedId), (Object)LogSanitizer.stripLineBreakingChars((Object)results.getErrorForId((Object)failedId)));
        }
        int n3 = n2 = (n = tasksIdsToBeDeleted.size() - results.getFailedIds().size());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public String toString() {
        return "TaskCleanupJob [firstRun=" + this.firstRun + ", runEvery=" + this.runEvery + ", kadaiEngineImpl=" + this.kadaiEngineImpl + ", txProvider=" + this.txProvider + ", scheduledJob=" + this.scheduledJob + ", minimumAge=" + this.minimumAge + ", batchSize=" + this.batchSize + ", allCompletedSameParentBusiness=" + this.allCompletedSameParentBusiness + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCleanupJob.java", TaskCleanupJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getLockExpirationPeriod", "io.kadai.task.internal.jobs.TaskCleanupJob", "io.kadai.KadaiConfiguration", "kadaiConfiguration", "", "java.time.Duration"), 65);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "io.kadai.task.internal.jobs.TaskCleanupJob", "", "", "", "void"), 70);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "io.kadai.task.internal.jobs.TaskCleanupJob", "", "", "", "java.lang.String"), 88);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTasksCompletedBefore", "io.kadai.task.internal.jobs.TaskCleanupJob", "java.time.Instant", "untilDate", "", "java.util.List"), 92);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteTasksTransactionally", "io.kadai.task.internal.jobs.TaskCleanupJob", "java.util.List", "tasksToBeDeleted", "", "int"), 140);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteTasks", "io.kadai.task.internal.jobs.TaskCleanupJob", "java.util.List", "tasksToBeDeleted", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "int"), 153);
    }
}

