/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.internal.jobs;

import io.kadai.KadaiConfiguration;
import io.kadai.common.api.KadaiEngine;
import io.kadai.common.api.ScheduledJob;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.jobs.AbstractKadaiJob;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.transaction.KadaiTransactionProvider;
import io.kadai.common.internal.util.CollectionUtil;
import io.kadai.task.internal.jobs.helper.TaskUpdatePriorityWorker;
import java.time.Duration;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdatePriorityJob
extends AbstractKadaiJob {
    private static final Logger LOGGER;
    private final int batchSize;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        TaskUpdatePriorityJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskUpdatePriorityJob.class);
    }

    public TaskUpdatePriorityJob(KadaiEngine kadaiEngine) {
        this(kadaiEngine, null, null);
    }

    public TaskUpdatePriorityJob(KadaiEngine kadaiEngine, KadaiTransactionProvider txProvider, ScheduledJob scheduledJob) {
        super(kadaiEngine, txProvider, scheduledJob, true);
        this.batchSize = kadaiEngine.getConfiguration().getTaskUpdatePriorityJobBatchSize();
        this.runEvery = kadaiEngine.getConfiguration().getTaskUpdatePriorityJobRunEvery();
        this.firstRun = kadaiEngine.getConfiguration().getTaskUpdatePriorityJobFirstRun();
    }

    public static Duration getLockExpirationPeriod(KadaiConfiguration kadaiConfiguration) {
        Duration duration;
        Duration duration2;
        KadaiConfiguration kadaiConfiguration2 = kadaiConfiguration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)kadaiConfiguration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = kadaiConfiguration.getTaskUpdatePriorityJobLockExpirationPeriod());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    @Override
    public void execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskUpdatePriorityWorker worker = new TaskUpdatePriorityWorker(this.kadaiEngineImpl);
        LOGGER.info("Running job to calculate all non finished task priorities");
        try {
            CollectionUtil.partitionBasedOnSize(worker.getAllRelevantTaskIds(), (int)this.getBatchSize()).forEach(worker::executeBatch);
            LOGGER.info("Job to update priority of tasks has finished.");
        }
        catch (Exception e) {
            throw new SystemException("Error while processing TaskUpdatePriorityJob.", (Throwable)e);
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    public int getBatchSize() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.batchSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    @Override
    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = TaskUpdatePriorityJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String toString() {
        return "TaskUpdatePriorityJob [firstRun=" + this.firstRun + ", runEvery=" + this.runEvery + ", kadaiEngineImpl=" + this.kadaiEngineImpl + ", txProvider=" + this.txProvider + ", scheduledJob=" + this.scheduledJob + ", batchSize=" + this.batchSize + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskUpdatePriorityJob.java", TaskUpdatePriorityJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getLockExpirationPeriod", "io.kadai.task.internal.jobs.TaskUpdatePriorityJob", "io.kadai.KadaiConfiguration", "kadaiConfiguration", "", "java.time.Duration"), 53);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "io.kadai.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "void"), 58);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBatchSize", "io.kadai.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "int"), 70);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "io.kadai.task.internal.jobs.TaskUpdatePriorityJob", "", "", "", "java.lang.String"), 75);
    }
}

