/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.task.internal.jobs.helper;

import io.kadai.common.api.BaseQuery;
import io.kadai.common.api.KadaiEngine;
import io.kadai.common.internal.KadaiEngineImpl;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.util.CheckedConsumer;
import io.kadai.spi.priority.internal.PriorityServiceManager;
import io.kadai.task.api.TaskQueryColumnName;
import io.kadai.task.api.TaskState;
import io.kadai.task.api.models.TaskSummary;
import io.kadai.task.internal.jobs.helper.SqlConnectionRunner;
import io.kadai.task.internal.jobs.helper.TaskUpdatePriorityBatchStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.IntPredicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class TaskUpdatePriorityWorker {
    private final SqlConnectionRunner sqlConnectionRunner;
    private final KadaiEngine kadaiEngine;
    private final PriorityServiceManager priorityServiceManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public TaskUpdatePriorityWorker(KadaiEngine kadaiEngine) {
        this.kadaiEngine = kadaiEngine;
        this.sqlConnectionRunner = new SqlConnectionRunner(kadaiEngine);
        this.priorityServiceManager = ((KadaiEngineImpl)kadaiEngine).getPriorityServiceManager();
    }

    public static IntPredicate hasDifferentPriority(TaskSummary taskSummary) {
        IntPredicate intPredicate;
        IntPredicate intPredicate2;
        TaskSummary taskSummary2 = taskSummary;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)taskSummary2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        IntPredicate intPredicate3 = intPredicate2 = (intPredicate = prio -> Objects.nonNull(taskSummary) && prio != taskSummary.getPriority());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)intPredicate2);
        return intPredicate;
    }

    public List<String> executeBatch(List<String> taskIds) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> updatedTaskIds = new ArrayList<String>();
        this.sqlConnectionRunner.runWithConnection((CheckedConsumer<Connection, SQLException>)((CheckedConsumer)connection -> {
            TaskUpdatePriorityBatchStatement taskUpdateBatch = new TaskUpdatePriorityBatchStatement((Connection)connection);
            List<TaskSummary> list3 = this.getTaskSummariesByIds(taskIds);
            for (TaskSummary taskSummary : list3) {
                OptionalInt calculatedPriority = this.getCalculatedPriority(taskSummary);
                if (!calculatedPriority.isPresent()) continue;
                String taskId = taskSummary.getId();
                updatedTaskIds.add(taskId);
                taskUpdateBatch.addPriorityUpdate(taskId, calculatedPriority.getAsInt());
            }
            taskUpdateBatch.executeBatch();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }));
        ArrayList<String> arrayList3 = arrayList2 = (arrayList = updatedTaskIds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, arrayList2);
        return arrayList;
    }

    public List<String> getAllRelevantTaskIds() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list3 = list2 = (list = this.kadaiEngine.getTaskService().createTaskQuery().stateNotIn(TaskState.END_STATES).listValues(TaskQueryColumnName.ID, BaseQuery.SortDirection.ASCENDING));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public List<TaskSummary> getTaskSummariesByIds(List<String> taskIds) {
        List list;
        List list2;
        List<String> list3 = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list4 = list2 = (list = this.kadaiEngine.getTaskService().createTaskQuery().idIn(taskIds.toArray(new String[0])).list());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public OptionalInt getCalculatedPriority(TaskSummary taskSummary) {
        OptionalInt optionalInt;
        OptionalInt optionalInt2;
        TaskSummary taskSummary2 = taskSummary;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)taskSummary2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        OptionalInt computedPriority = this.priorityServiceManager.calculatePriorityOfTask(taskSummary);
        OptionalInt optionalInt3 = optionalInt2 = computedPriority.isPresent() && TaskUpdatePriorityWorker.hasDifferentPriority(taskSummary).test(computedPriority.getAsInt()) ? (optionalInt = computedPriority) : (optionalInt = OptionalInt.empty());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optionalInt2);
        return optionalInt;
    }

    static {
        TaskUpdatePriorityWorker.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskUpdatePriorityWorker.java", TaskUpdatePriorityWorker.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "hasDifferentPriority", "io.kadai.task.internal.jobs.helper.TaskUpdatePriorityWorker", "io.kadai.task.api.models.TaskSummary", "taskSummary", "", "java.util.function.IntPredicate"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeBatch", "io.kadai.task.internal.jobs.helper.TaskUpdatePriorityWorker", "java.util.List", "taskIds", "", "java.util.List"), 51);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllRelevantTaskIds", "io.kadai.task.internal.jobs.helper.TaskUpdatePriorityWorker", "", "", "", "java.util.List"), 83);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskSummariesByIds", "io.kadai.task.internal.jobs.helper.TaskUpdatePriorityWorker", "java.util.List", "taskIds", "", "java.util.List"), 91);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCalculatedPriority", "io.kadai.task.internal.jobs.helper.TaskUpdatePriorityWorker", "io.kadai.task.api.models.TaskSummary", "taskSummary", "", "java.util.OptionalInt"), 99);
    }
}

