/*
 * Decompiled with CFR 0.152.
 */
package io.kadai.workbasket.internal.jobs;

import io.kadai.KadaiConfiguration;
import io.kadai.common.api.BaseQuery;
import io.kadai.common.api.BulkOperationResults;
import io.kadai.common.api.KadaiEngine;
import io.kadai.common.api.ScheduledJob;
import io.kadai.common.api.exceptions.InvalidArgumentException;
import io.kadai.common.api.exceptions.KadaiException;
import io.kadai.common.api.exceptions.NotAuthorizedException;
import io.kadai.common.api.exceptions.SystemException;
import io.kadai.common.internal.jobs.AbstractKadaiJob;
import io.kadai.common.internal.logging.LoggingAspect;
import io.kadai.common.internal.transaction.KadaiTransactionProvider;
import io.kadai.common.internal.util.CollectionUtil;
import io.kadai.workbasket.api.WorkbasketQueryColumnName;
import java.time.Duration;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbasketCleanupJob
extends AbstractKadaiJob {
    private static final Logger LOGGER;
    private final int batchSize;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        WorkbasketCleanupJob.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(WorkbasketCleanupJob.class);
    }

    public WorkbasketCleanupJob(KadaiEngine kadaiEngine, KadaiTransactionProvider txProvider, ScheduledJob job) {
        super(kadaiEngine, txProvider, job, true);
        this.batchSize = kadaiEngine.getConfiguration().getJobBatchSize();
    }

    public static Duration getLockExpirationPeriod(KadaiConfiguration kadaiConfiguration) {
        Duration duration;
        Duration duration2;
        KadaiConfiguration kadaiConfiguration2 = kadaiConfiguration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)kadaiConfiguration2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = (duration = kadaiConfiguration.getWorkbasketCleanupJobLockExpirationPeriod());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    @Override
    public void execute() throws KadaiException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LOGGER.info("Running job to delete all workbaskets marked for deletion");
        try {
            List<String> workbasketsMarkedForDeletion = this.getWorkbasketsMarkedForDeletion();
            int totalNumberOfWorkbasketDeleted = CollectionUtil.partitionBasedOnSize(workbasketsMarkedForDeletion, (int)this.batchSize).stream().mapToInt(this::deleteWorkbasketsTransactionally).sum();
            LOGGER.info("Job ended successfully. {} workbaskets deleted.", (Object)totalNumberOfWorkbasketDeleted);
        }
        catch (Exception e) {
            throw new SystemException("Error while processing WorkbasketCleanupJob.", (Throwable)e);
        }
        Object var4_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_5);
    }

    @Override
    protected String getType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = WorkbasketCleanupJob.class.getName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private List<String> getWorkbasketsMarkedForDeletion() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List list3 = list2 = (list = this.kadaiEngineImpl.getWorkbasketService().createWorkbasketQuery().markedForDeletion(true).listValues(WorkbasketQueryColumnName.ID, BaseQuery.SortDirection.ASCENDING));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private int deleteWorkbasketsTransactionally(List<String> workbasketsToBeDeleted) {
        int n;
        int n2;
        List<String> list = workbasketsToBeDeleted;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = ((Integer)KadaiTransactionProvider.executeInTransactionIfPossible((KadaiTransactionProvider)this.txProvider, () -> {
            try {
                return this.deleteWorkbaskets(workbasketsToBeDeleted);
            }
            catch (Exception e) {
                LOGGER.warn("Could not delete workbaskets.", (Throwable)e);
                return 0;
            }
        })).intValue());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private int deleteWorkbaskets(List<String> workbasketsToBeDeleted) throws InvalidArgumentException, NotAuthorizedException {
        int n;
        int n2;
        List<String> list = workbasketsToBeDeleted;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        BulkOperationResults<String, KadaiException> results = this.kadaiEngineImpl.getWorkbasketService().deleteWorkbaskets(workbasketsToBeDeleted);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} workbasket deleted.", (Object)(workbasketsToBeDeleted.size() - results.getFailedIds().size()));
        }
        for (String failedId : results.getFailedIds()) {
            LOGGER.warn("Workbasket with id {} could not be deleted. Reason:", (Object)failedId, (Object)results.getErrorForId((Object)failedId));
        }
        int n3 = n2 = (n = workbasketsToBeDeleted.size() - results.getFailedIds().size());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketCleanupJob.java", WorkbasketCleanupJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getLockExpirationPeriod", "io.kadai.workbasket.internal.jobs.WorkbasketCleanupJob", "io.kadai.KadaiConfiguration", "kadaiConfiguration", "", "java.time.Duration"), 55);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "io.kadai.workbasket.internal.jobs.WorkbasketCleanupJob", "", "", "io.kadai.common.api.exceptions.KadaiException", "void"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "io.kadai.workbasket.internal.jobs.WorkbasketCleanupJob", "", "", "", "java.lang.String"), 76);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getWorkbasketsMarkedForDeletion", "io.kadai.workbasket.internal.jobs.WorkbasketCleanupJob", "", "", "", "java.util.List"), 80);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteWorkbasketsTransactionally", "io.kadai.workbasket.internal.jobs.WorkbasketCleanupJob", "java.util.List", "workbasketsToBeDeleted", "", "int"), 89);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteWorkbaskets", "io.kadai.workbasket.internal.jobs.WorkbasketCleanupJob", "java.util.List", "workbasketsToBeDeleted", "io.kadai.common.api.exceptions.InvalidArgumentException:io.kadai.common.api.exceptions.NotAuthorizedException", "int"), 102);
    }
}

