/*
 * Decompiled with CFR 0.152.
 */
package io.kaitai.struct.format;

import io.kaitai.struct.format.DocSpec;
import io.kaitai.struct.format.DocSpec$;
import io.kaitai.struct.format.EnumValueSpec;
import io.kaitai.struct.format.Identifier$;
import io.kaitai.struct.format.ParseUtils$;
import io.kaitai.struct.format.YAMLParseException$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class EnumValueSpec$
implements Serializable {
    public static EnumValueSpec$ MODULE$;
    private final Set<String> LEGAL_KEYS;

    static {
        new EnumValueSpec$();
    }

    public EnumValueSpec fromYaml(Object src, List<String> path) {
        EnumValueSpec enumValueSpec;
        Object object = src;
        if (object instanceof String) {
            String string = (String)object;
            enumValueSpec = this.fromSimpleName(string, path);
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            enumValueSpec = this.fromSimpleName(((Object)BoxesRunTime.boxToBoolean((boolean)bl)).toString(), path);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            enumValueSpec = this.fromMap(ParseUtils$.MODULE$.anyMapToStrMap((Map<Object, Object>)map, path), path);
        } else {
            throw YAMLParseException$.MODULE$.badType("string or map", src, path);
        }
        return enumValueSpec;
    }

    public EnumValueSpec fromSimpleName(String name, List<String> path) {
        Identifier$.MODULE$.checkIdentifierSource(name, "enum member", path);
        return new EnumValueSpec(name, DocSpec$.MODULE$.EMPTY());
    }

    public Set<String> LEGAL_KEYS() {
        return this.LEGAL_KEYS;
    }

    public EnumValueSpec fromMap(Map<String, Object> srcMap, List<String> path) {
        ParseUtils$.MODULE$.ensureLegalKeys(srcMap, this.LEGAL_KEYS(), path, (Option<String>)new Some((Object)"enum value spec"));
        String name = ParseUtils$.MODULE$.getValueStr(srcMap, "id", path);
        Identifier$.MODULE$.checkIdentifierSource(name, "enum value spec id", path);
        DocSpec doc = DocSpec$.MODULE$.fromYaml(srcMap, path);
        return new EnumValueSpec(name, doc);
    }

    public EnumValueSpec apply(String name, DocSpec doc) {
        return new EnumValueSpec(name, doc);
    }

    public Option<Tuple2<String, DocSpec>> unapply(EnumValueSpec x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.name(), (Object)x$0.doc()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private EnumValueSpec$() {
        MODULE$ = this;
        this.LEGAL_KEYS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "doc", "doc-ref"}));
    }
}

