/*
 * Decompiled with CFR 0.152.
 */
package akka.kamon.instrumentation;

import akka.actor.ActorCell;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Cell;
import akka.kamon.instrumentation.ActorMonitor;
import akka.kamon.instrumentation.ActorMonitors;
import akka.kamon.instrumentation.ActorMonitors$;
import akka.kamon.instrumentation.CellInfo;
import akka.kamon.instrumentation.CellInfo$;
import kamon.akka.Metrics;
import kamon.akka.Metrics$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class ActorMonitor$ {
    public static final ActorMonitor$ MODULE$;

    static {
        new ActorMonitor$();
    }

    public ActorMonitor createActorMonitor(Cell cell, ActorSystem system, ActorRef ref, ActorRef parent, boolean actorCellCreation) {
        CellInfo cellInfo = CellInfo$.MODULE$.cellInfoFor(cell, system, ref, parent, actorCellCreation);
        if (cell instanceof ActorCell) {
            Metrics$.MODULE$.forSystem(system.name()).activeActors().increment();
        }
        ActorMonitor monitor = cellInfo.isRouter() ? ActorMonitors$.MODULE$.ContextPropagationOnly(cellInfo) : (cellInfo.isRoutee() && cellInfo.isTracked() ? this.createRouteeMonitor(cellInfo) : this.createRegularActorMonitor(cellInfo));
        return cellInfo.isTraced() ? new ActorMonitors.TracedMonitor(cellInfo, monitor) : monitor;
    }

    public ActorMonitor createRegularActorMonitor(CellInfo cellInfo) {
        ActorMonitor actorMonitor;
        if (!cellInfo.isTracked() && cellInfo.trackingGroups().isEmpty()) {
            actorMonitor = ActorMonitors$.MODULE$.ContextPropagationOnly(cellInfo);
        } else {
            None$ actorMetrics = cellInfo.isTracked() ? new Some((Object)Metrics$.MODULE$.forActor(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorOrRouterClass().getName())) : None$.MODULE$;
            actorMonitor = new ActorMonitors.TrackedActor((Option<Metrics.ActorMetrics>)actorMetrics, this.trackingGroupMetrics(cellInfo), cellInfo.actorCellCreation(), cellInfo);
        }
        return actorMonitor;
    }

    public ActorMonitor createRouteeMonitor(CellInfo cellInfo) {
        Metrics.RouterMetrics routerMetrics = Metrics$.MODULE$.forRouter(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorOrRouterClass().getName(), (String)cellInfo.routeeClass().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Class<?> x$1) {
                return x$1.getName();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Unknown";
            }
        }));
        return new ActorMonitors.TrackedRoutee(routerMetrics, this.trackingGroupMetrics(cellInfo), cellInfo.actorCellCreation(), cellInfo);
    }

    private Seq<Metrics.ActorGroupMetrics> trackingGroupMetrics(CellInfo cellInfo) {
        return (Seq)cellInfo.trackingGroups().map((Function1)new Serializable(cellInfo){
            public static final long serialVersionUID = 0L;
            private final CellInfo cellInfo$2;

            public final Metrics.ActorGroupMetrics apply(String groupName) {
                return Metrics$.MODULE$.forGroup(groupName, this.cellInfo$2.systemName());
            }
            {
                this.cellInfo$2 = cellInfo$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ActorMonitor$() {
        MODULE$ = this;
    }
}

