/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.client;

import akka.dispatch.ExecutionContexts;
import akka.http.impl.engine.client.PoolInterfaceActor;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.headers.RawHeader;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.akka.http.AkkaHttp$;
import kamon.context.HasContext;
import kamon.context.HasContext$;
import kamon.context.TextMap;
import kamon.trace.Span;
import kamon.trace.SpanCustomizer;
import kamon.trace.SpanCustomizer$;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclareMixin;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Aspect
@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\u0004\b\u0001IAQ!\u0007\u0001\u0005\u0002iAQ!\b\u0001\u0005\u0002yAQA\u0011\u0001\u0005\u0002\rCQA\u0015\u0001\u0005\u0002MCQa\u0018\u0001\u0005\u0002\u0001\u0014Ad\u00117jK:$(+Z9vKN$\u0018J\\:ueVlWM\u001c;bi&|gN\u0003\u0002\t\u0013\u000511\r\\5f]RT!AC\u0006\u0002\r\u0015tw-\u001b8f\u0015\taQ\"\u0001\u0003j[Bd'B\u0001\b\u0010\u0003\u0011AG\u000f\u001e9\u000b\u0003A\tA!Y6lC\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011aB\u0001\u0010_:\u001c\u0016N\\4mKJ+\u0017/^3tiR\u0019qD\t\u0018\u0011\u0005Q\u0001\u0013BA\u0011\u0016\u0005\r\te.\u001f\u0005\u0006G\t\u0001\r\u0001J\u0001\u0004a*\u0004\bCA\u0013-\u001b\u00051#BA\u0014)\u0003\u0011a\u0017M\\4\u000b\u0005%R\u0013aB1ta\u0016\u001cGO\u001b\u0006\u0002W\u0005\u0019qN]4\n\u000552#a\u0005)s_\u000e,W\rZ5oO*{\u0017N\u001c)pS:$\b\"B\u0018\u0003\u0001\u0004\u0001\u0014a\u0002:fcV,7\u000f\u001e\t\u0003cYj\u0011A\r\u0006\u0003gQ\nQ!\\8eK2T!!N\u0007\u0002\u0011M\u001c\u0017\r\\1eg2L!a\u000e\u001a\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0015\u0005\u0005ez\u0004\t\u0005\u0002;{5\t1H\u0003\u0002=M\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005yZ$AB!s_VtG-A\u0003wC2,X-I\u0001B\u0003M+\u00070Z2vi&|g\u000e\u000b\u0016!C.\\\u0017M\f5uiBt3oY1mC\u0012\u001cHN\f%uiB,\u0005\u0010\u001e\u0018tS:<G.\u001a*fcV,7\u000f\u001e\u0015/]%J\u0003E\n\u0014!CJ<7\u000f\u000b:fcV,7\u000f\u001e\u0017!U1\u0002#\u0006\f\u0011+S\u0005YR.\u001b=j]\u000e{g\u000e^3yi&sGo\u001c)p_2\u0014V-];fgR$\u0012\u0001\u0012\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000bqaY8oi\u0016DHOC\u0001J\u0003\u0015Y\u0017-\\8o\u0013\tYeI\u0001\u0006ICN\u001cuN\u001c;fqRDCaA'@!B\u0011!HT\u0005\u0003\u001fn\u0012A\u0002R3dY\u0006\u0014X-T5yS:\f\u0013!U\u0001<C.\\\u0017M\f5uiBt\u0013.\u001c9m]\u0015tw-\u001b8f]\rd\u0017.\u001a8u]A{w\u000e\\%oi\u0016\u0014h-Y2f\u0003\u000e$xN\u001d\u0018Q_>d'+Z9vKN$\u0018aG1gi\u0016\u0014\bk\\8m%\u0016\fX/Z:u\u0007>t7\u000f\u001e:vGR|'\u000f\u0006\u0002U/B\u0011A#V\u0005\u0003-V\u0011A!\u00168ji\")\u0001\f\u0002a\u0001\t\u0006Y\u0001o\\8m%\u0016\fX/Z:uQ\u0011!!lP/\u0011\u0005iZ\u0016B\u0001/<\u0005\u0015\te\r^3sC\u0005q\u0016aY3yK\u000e,H/[8oQ\u0005\\7.\u0019\u0018iiR\u0004h&[7qY:*gnZ5oK:\u001aG.[3oi:\u0002vn\u001c7J]R,'OZ1dK\u0006\u001bGo\u001c:/!>|GNU3rk\u0016\u001cHO\f8fo\"rc&K\u0015!M\u0019\u0002C\u000f[5tQA|w\u000e\u001c*fcV,7\u000f^\u0015\u0002+\u0005\u0014x.\u001e8e\t&\u001c\b/\u0019;dQJ+\u0017/^3tiR\u0019q$\u00192\t\u000b\r*\u0001\u0019\u0001\u0013\t\u000ba+\u0001\u0019A2\u0013\u0007\u00114GI\u0002\u0003f\u0001\u0001\u0019'\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA4x\u001d\tAWO\u0004\u0002ji:\u0011!n\u001d\b\u0003WJt!\u0001\\9\u000f\u00055\u0004X\"\u00018\u000b\u0005=\f\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\tqq\"\u0003\u0002\r\u001b%\u0011!bC\u0005\u0003\u0011%I!A^\u0004\u0002%A{w\u000e\\%oi\u0016\u0014h-Y2f\u0003\u000e$xN]\u0005\u0003qf\u00141\u0002U8pYJ+\u0017/^3ti*\u0011ao\u0002\u0015\u0005\u000bez40I\u0001}\u0003\u0015,\u00070Z2vi&|g\u000e\u000b\u0016!C.\\\u0017M\f5uiBt\u0013.\u001c9m]\u0015tw-\u001b8f]\rd\u0017.\u001a8u]A{w\u000e\\%oi\u0016\u0014h-Y2f\u0003\u000e$xN\u001d\u0018eSN\u0004\u0018\r^2i%\u0016\fX/Z:uQ9r\u0013&\u000b\u0011'M\u0001\n'oZ:)a>|GNU3rk\u0016\u001cH/\u000b\u0015\u0003\u0001y\u0004\"AO@\n\u0007\u0005\u00051H\u0001\u0004BgB,7\r\u001e")
public class ClientRequestInstrumentation {
    @Around(value="execution(* akka.http.scaladsl.HttpExt.singleRequest(..)) && args(request, *, *, *)")
    public Object onSingleRequest(ProceedingJoinPoint pjp, HttpRequest request) {
        String operationName = AkkaHttp$.MODULE$.clientOperationName(request);
        SpanCustomizer customizer = (SpanCustomizer)Kamon$.MODULE$.currentContext().get(SpanCustomizer$.MODULE$.ContextKey());
        Span span = customizer.customize(Kamon$.MODULE$.buildSpan(operationName).withTag("component", "akka.http.client").withTag("span.kind", "client").withTag("http.url", request.getUri().toString()).withTag("http.method", request.method().value())).start();
        Future responseFuture = (Future)Kamon$.MODULE$.withSpan(span, false, (Function0 & Serializable & scala.Serializable)() -> (Future)pjp.proceed());
        responseFuture.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientRequestInstrumentation.$anonfun$onSingleRequest$2(span, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ExecutionContexts.sameThreadExecutionContext$.MODULE$);
        return responseFuture;
    }

    @DeclareMixin(value="akka.http.impl.engine.client.PoolInterfaceActor.PoolRequest")
    public HasContext mixinContextIntoPoolRequest() {
        return HasContext$.MODULE$.fromCurrentContext();
    }

    @After(value="execution(akka.http.impl.engine.client.PoolInterfaceActor.PoolRequest.new(..)) && this(poolRequest)")
    public void afterPoolRequestConstructor(HasContext poolRequest) {
        poolRequest.context();
    }

    @Around(value="execution(* akka.http.impl.engine.client.PoolInterfaceActor.dispatchRequest(..)) && args(poolRequest)")
    public Object aroundDispatchRequest(ProceedingJoinPoint pjp, PoolInterfaceActor.PoolRequest poolRequest) {
        Iterator contextHeaders = ((TextMap)Kamon$.MODULE$.contextCodec().HttpHeaders().encode(((HasContext)poolRequest).context())).values().map((Function1 & Serializable & scala.Serializable)c -> new RawHeader((String)c._1(), (String)c._2()));
        HttpRequest requestWithContext = poolRequest.request().withHeaders((Seq)poolRequest.request().headers().$plus$plus((GenTraversableOnce)contextHeaders, Seq$.MODULE$.canBuildFrom()));
        return pjp.proceed(new Object[]{poolRequest.copy(requestWithContext, poolRequest.copy$default$2())});
    }

    public static final /* synthetic */ void $anonfun$onSingleRequest$2(Span span$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            HttpResponse response = (HttpResponse)success.value();
            StatusCode status = response.status();
            Object object = status.isFailure() ? span$1.addError(status.reason()) : BoxedUnit.UNIT;
            Span spanWithStatusTag = AkkaHttp$.MODULE$.addHttpStatusCodeAsMetricTag() ? span$1.tagMetric("http.status_code", ((Object)BoxesRunTime.boxToInteger((int)status.intValue())).toString()) : span$1.tag("http.status_code", (long)status.intValue());
            spanWithStatusTag.finish();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            span$1.addError(t.getMessage(), t).finish();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }
}

