/*
 * Decompiled with CFR 0.152.
 */
package akka.kamon.instrumentation;

import akka.kamon.instrumentation.ActorMonitor;
import akka.kamon.instrumentation.ActorMonitors$;
import akka.kamon.instrumentation.EnvelopeContext;
import kamon.Kamon$;
import kamon.akka.ActorMetrics;
import kamon.akka.RouterMetrics;
import kamon.metric.Entity;
import kamon.trace.Tracer$;
import kamon.util.RelativeNanoTimestamp$;
import org.aspectj.lang.ProceedingJoinPoint;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%q!B\u0001\u0003\u0011\u0003I\u0011!D!di>\u0014Xj\u001c8ji>\u00148O\u0003\u0002\u0004\t\u0005y\u0011N\\:ueVlWM\u001c;bi&|gN\u0003\u0002\u0006\r\u0005)1.Y7p]*\tq!\u0001\u0003bW.\f7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002\u000e\u0003\u000e$xN]'p]&$xN]:\u0014\u0005-q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0003\u0016\u0017\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013!9\u0001d\u0003b\u0001\n\u0003I\u0012AF\"p]R,\u0007\u0010\u001e)s_B\fw-\u0019;j_:|e\u000e\\=\u0016\u0003i\u00112a\u0007\b \r\u0011aR\u0004\u0001\u000e\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \t\ryY\u0001\u0015!\u0003\u001b\u0003]\u0019uN\u001c;fqR\u0004&o\u001c9bO\u0006$\u0018n\u001c8P]2L\b\u0005\u0005\u0002\u000bA%\u0011\u0011E\u0001\u0002\r\u0003\u000e$xN]'p]&$xN\u001d\u0004\u0005G-\u0001AE\u0001\u0007Ue\u0006\u001c7.\u001a3BGR|'oE\u0002#\u001d}A\u0001B\n\u0012\u0003\u0006\u0004%\taJ\u0001\u0007K:$\u0018\u000e^=\u0016\u0003!\u0002\"!K\u0017\u000e\u0003)R!a\u000b\u0017\u0002\r5,GO]5d\u0015\u0005)\u0011B\u0001\u0018+\u0005\u0019)e\u000e^5us\"A\u0001G\tB\u0001B\u0003%\u0001&A\u0004f]RLG/\u001f\u0011\t\u0011I\u0012#\u0011!Q\u0001\nM\nA\"Y2u_JlU\r\u001e:jGN\u0004\"\u0001\u000e\u001c\u000e\u0003UR!a\u0002\u0017\n\u0005]*$\u0001D!di>\u0014X*\u001a;sS\u000e\u001c\b\"B\u000b#\t\u0003IDc\u0001\u001e={A\u00111HI\u0007\u0002\u0017!)a\u0005\u000fa\u0001Q!)!\u0007\u000fa\u0001g!)qH\tC\u0001\u0001\u000612-\u00199ukJ,WI\u001c<fY>\u0004XmQ8oi\u0016DH\u000fF\u0001B!\tQ!)\u0003\u0002D\u0005\tyQI\u001c<fY>\u0004XmQ8oi\u0016DH\u000fC\u0003FE\u0011\u0005a)\u0001\bqe>\u001cWm]:NKN\u001c\u0018mZ3\u0015\u0007995\u000bC\u0003I\t\u0002\u0007\u0011*A\u0002qUB\u0004\"AS)\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0003\u001d>\u000bq!Y:qK\u000e$(NC\u0001Q\u0003\ry'oZ\u0005\u0003%.\u00131\u0003\u0015:pG\u0016,G-\u001b8h\u0015>Lg\u000eU8j]RDQ\u0001\u0016#A\u0002\u0005\u000bq\"\u001a8wK2|\u0007/Z\"p]R,\u0007\u0010\u001e\u0005\u0006-\n\"\taV\u0001\u000faJ|7-Z:t\r\u0006LG.\u001e:f)\tA6\f\u0005\u0002\u00103&\u0011!\f\u0005\u0002\u0005+:LG\u000fC\u0003]+\u0002\u0007Q,A\u0004gC&dWO]3\u0011\u0005y3gBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011\u0007\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011Q\rE\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007NA\u0005UQJ|w/\u00192mK*\u0011Q\r\u0005\u0005\u0006U\n\"\ta[\u0001\bG2,\u0017M\\;q)\u0005Af\u0001B7\f\u00019\u0014Q\u0002\u0016:bG.,GMU8vi\u0016,7c\u00017\u000f?!Aa\u0005\u001cBC\u0002\u0013\u0005q\u0005\u0003\u00051Y\n\u0005\t\u0015!\u0003)\u0011!\u0011HN!A!\u0002\u0013\u0019\u0018!\u0004:pkR,'/T3ue&\u001c7\u000f\u0005\u00025i&\u0011Q/\u000e\u0002\u000e%>,H/\u001a:NKR\u0014\u0018nY:\t\u000bUaG\u0011A<\u0015\u0007aL(\u0010\u0005\u0002<Y\")aE\u001ea\u0001Q!)!O\u001ea\u0001g\")q\b\u001cC\u0001\u0001\")Q\t\u001cC\u0001{R\u0019aB`@\t\u000b!c\b\u0019A%\t\u000bQc\b\u0019A!\t\rYcG\u0011AA\u0002)\rA\u0016Q\u0001\u0005\u00079\u0006\u0005\u0001\u0019A/\t\u000b)dG\u0011A6")
public final class ActorMonitors {
    public static ActorMonitor ContextPropagationOnly() {
        return ActorMonitors$.MODULE$.ContextPropagationOnly();
    }

    public static class TrackedActor
    implements ActorMonitor {
        private final Entity entity;
        private final ActorMetrics actorMetrics;

        public Entity entity() {
            return this.entity;
        }

        @Override
        public EnvelopeContext captureEnvelopeContext() {
            this.actorMetrics.mailboxSize().increment();
            return new EnvelopeContext(RelativeNanoTimestamp$.MODULE$.now(), Tracer$.MODULE$.currentContext());
        }

        @Override
        public Object processMessage(ProceedingJoinPoint pjp, EnvelopeContext envelopeContext) {
            long timestampBeforeProcessing = RelativeNanoTimestamp$.MODULE$.now();
            try {
                return Tracer$.MODULE$.withContext(envelopeContext.context(), (Function0)new Serializable(this, pjp){
                    public static final long serialVersionUID = 0L;
                    private final ProceedingJoinPoint pjp$2;

                    public final Object apply() {
                        return this.pjp$2.proceed();
                    }
                    {
                        this.pjp$2 = pjp$2;
                    }
                });
            }
            finally {
                long timestampAfterProcessing = RelativeNanoTimestamp$.MODULE$.now();
                long timeInMailbox = RelativeNanoTimestamp$.MODULE$.$minus$extension(timestampBeforeProcessing, envelopeContext.nanoTime());
                long processingTime = RelativeNanoTimestamp$.MODULE$.$minus$extension(timestampAfterProcessing, timestampBeforeProcessing);
                this.actorMetrics.processingTime().record(processingTime);
                this.actorMetrics.timeInMailbox().record(timeInMailbox);
                this.actorMetrics.mailboxSize().decrement();
            }
        }

        @Override
        public void processFailure(Throwable failure) {
            this.actorMetrics.errors().increment();
        }

        @Override
        public void cleanup() {
            Kamon$.MODULE$.metrics().removeEntity(this.entity());
        }

        public TrackedActor(Entity entity, ActorMetrics actorMetrics) {
            this.entity = entity;
            this.actorMetrics = actorMetrics;
        }
    }

    public static class TrackedRoutee
    implements ActorMonitor {
        private final Entity entity;
        private final RouterMetrics routerMetrics;

        public Entity entity() {
            return this.entity;
        }

        @Override
        public EnvelopeContext captureEnvelopeContext() {
            return new EnvelopeContext(RelativeNanoTimestamp$.MODULE$.now(), Tracer$.MODULE$.currentContext());
        }

        @Override
        public Object processMessage(ProceedingJoinPoint pjp, EnvelopeContext envelopeContext) {
            long timestampBeforeProcessing = RelativeNanoTimestamp$.MODULE$.now();
            try {
                return Tracer$.MODULE$.withContext(envelopeContext.context(), (Function0)new Serializable(this, pjp){
                    public static final long serialVersionUID = 0L;
                    private final ProceedingJoinPoint pjp$3;

                    public final Object apply() {
                        return this.pjp$3.proceed();
                    }
                    {
                        this.pjp$3 = pjp$3;
                    }
                });
            }
            finally {
                long timestampAfterProcessing = RelativeNanoTimestamp$.MODULE$.now();
                long timeInMailbox = RelativeNanoTimestamp$.MODULE$.$minus$extension(timestampBeforeProcessing, envelopeContext.nanoTime());
                long processingTime = RelativeNanoTimestamp$.MODULE$.$minus$extension(timestampAfterProcessing, timestampBeforeProcessing);
                this.routerMetrics.processingTime().record(processingTime);
                this.routerMetrics.timeInMailbox().record(timeInMailbox);
            }
        }

        @Override
        public void processFailure(Throwable failure) {
            this.routerMetrics.errors().increment();
        }

        @Override
        public void cleanup() {
        }

        public TrackedRoutee(Entity entity, RouterMetrics routerMetrics) {
            this.entity = entity;
            this.routerMetrics = routerMetrics;
        }
    }
}

