/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.instrumentations;

import akka.actor.ActorRef;
import akka.pattern.AskTimeoutException;
import akka.util.Timeout;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.instrumentation.akka.AkkaInstrumentation;
import kamon.instrumentation.akka.AkkaInstrumentation$;
import kamon.instrumentation.akka.AkkaInstrumentation$AskPatternTimeoutWarningSetting$Heavyweight$;
import kamon.instrumentation.akka.AkkaInstrumentation$AskPatternTimeoutWarningSetting$Lightweight$;
import kamon.instrumentation.akka.AkkaInstrumentation$AskPatternTimeoutWarningSetting$Off$;
import kamon.instrumentation.akka.instrumentations.AkkaPrivateAccess;
import kamon.instrumentation.akka.instrumentations.AskPatternInstrumentation;
import kamon.util.CallingThreadExecutionContext$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class AskPatternInstrumentation$ {
    public static AskPatternInstrumentation$ MODULE$;
    private final Logger _log;

    static {
        new AskPatternInstrumentation$();
    }

    private Logger _log() {
        return this._log;
    }

    @Advice.OnMethodExit(suppress=Throwable.class)
    public void onExit(@Advice.Origin String origin, @Advice.Return Future<Object> future, @Advice.Argument(value=0) ActorRef actor, @Advice.Argument(value=2) Timeout timeout) {
        if (AkkaPrivateAccess.isInternalAndActiveActorRef(actor) && Kamon$.MODULE$.currentContext().nonEmpty()) {
            AkkaInstrumentation.AskPatternTimeoutWarningSetting askPatternTimeoutWarningSetting = AkkaInstrumentation$.MODULE$.settings().askPatternWarning();
            if (!AkkaInstrumentation$AskPatternTimeoutWarningSetting$Off$.MODULE$.equals(askPatternTimeoutWarningSetting)) {
                if (AkkaInstrumentation$AskPatternTimeoutWarningSetting$Lightweight$.MODULE$.equals(askPatternTimeoutWarningSetting)) {
                    this.hookLightweightWarning(future, this.sourceLocation(origin), actor);
                } else if (AkkaInstrumentation$AskPatternTimeoutWarningSetting$Heavyweight$.MODULE$.equals(askPatternTimeoutWarningSetting)) {
                    this.hookHeavyweightWarning(future, new AskPatternInstrumentation.StackTraceCaptureException(), actor);
                } else {
                    throw new MatchError((Object)askPatternTimeoutWarningSetting);
                }
            }
            this.hookHeavyweightWarning(future, new AskPatternInstrumentation.StackTraceCaptureException(), actor);
        }
    }

    private PartialFunction<Throwable, BoxedUnit> ifAskTimeoutException(Function0<BoxedUnit> code) {
        return new scala.Serializable(code){
            public static final long serialVersionUID = 0L;
            private final Function0 code$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                if (x1 instanceof AskTimeoutException) {
                    this.code$1.apply$mcV$sp();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = x1 instanceof AskTimeoutException ? true : true;
                return bl;
            }
            {
                this.code$1 = code$1;
            }
        };
    }

    private void hookLightweightWarning(Future<Object> future, AskPatternInstrumentation.SourceLocation sourceLocation, ActorRef actor) {
        String locationString = (String)Option$.MODULE$.apply((Object)sourceLocation).map((Function1 & Serializable & scala.Serializable)location -> new StringBuilder(1).append(location.declaringType()).append(":").append(location.method()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<unknown position>");
        future.failed().foreach(this.ifAskTimeoutException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$._log().warn(new StringBuilder(51).append("Timeout triggered for ask pattern to actor [").append(actor.path().name()).append("] at [").append(locationString).append("]").toString())), (ExecutionContext)CallingThreadExecutionContext$.MODULE$);
    }

    private void hookHeavyweightWarning(Future<Object> future, AskPatternInstrumentation.StackTraceCaptureException captureException, ActorRef actor) {
        String locationString = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])captureException.getStackTrace())).drop(3))).mkString("", System.lineSeparator(), System.lineSeparator());
        future.failed().foreach(this.ifAskTimeoutException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$._log().warn(new StringBuilder(51).append("Timeout triggered for ask pattern to actor [").append(actor.path().name()).append("] at [").append(locationString).append("]").toString())), (ExecutionContext)CallingThreadExecutionContext$.MODULE$);
    }

    private AskPatternInstrumentation.SourceLocation sourceLocation(String origin) {
        String[] methodDescription = origin.split(" ");
        return new AskPatternInstrumentation.SourceLocation(methodDescription[0], methodDescription[1]);
    }

    private AskPatternInstrumentation$() {
        MODULE$ = this;
        this._log = LoggerFactory.getLogger(AskPatternInstrumentation.class);
    }
}

