/*
 * Decompiled with CFR 0.152.
 */
package kamon.apm;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import kamino.IngestionV1;
import kamon.Kamon$;
import kamon.apm.KamonApmApiClient;
import kamon.apm.package;
import kamon.apm.package$;
import kamon.apm.shaded.com.google.protobuf.ByteString;
import kamon.metric.Distribution;
import kamon.metric.DynamicRange$;
import kamon.metric.Instrument;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.metric.PeriodSnapshot;
import kamon.metric.PeriodSnapshot$;
import kamon.module.CombinedReporter;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.status.Environment;
import kamon.tag.TagSet;
import kamon.trace.Span;
import kamon.util.Clock$;
import kamon.util.UnitConverter;
import org.HdrHistogram.ZigZag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t%e\u0001B\u0014)\u00015B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\r\u0002!\ta\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019)\u0006\u0001)A\u0005\u001b\"9a\u000b\u0001a\u0001\n\u00139\u0006bB0\u0001\u0001\u0004%I\u0001\u0019\u0005\u0007M\u0002\u0001\u000b\u0015\u0002-\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\"9q\u000e\u0001a\u0001\n\u0013\u0001\bB\u0002:\u0001A\u0003&\u0011\u000eC\u0004t\u0001\t\u0007I\u0011\u0002;\t\rm\u0004\u0001\u0015!\u0003v\u0011\u001da\bA1A\u0005\nuDq!!\u0005\u0001A\u0003%a\u0010C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016!A\u00111\u0005\u0001!\u0002\u0013\t9\u0002\u0003\u0004G\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002T\u0001!\t%!\u0016\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\t\u0019\f\u0001C\u0005\u0003kCq!!9\u0001\t\u0013\t\u0019\u000fC\u0004\u0002t\u0002!I!!>\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006!9!\u0011\u0003\u0001\u0005\n\tM\u0001b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u000f\u001d\u00119\u0006\u000bE\u0001\u000532aa\n\u0015\t\u0002\tm\u0003B\u0002$#\t\u0003\u0011iF\u0002\u0004\u0003`\t\u0002!\u0011\r\u0005\u0007\r\u0012\"\tA!\u001b\t\u000f\t=D\u0005\"\u0011\u0003r\tA1*Y7p]\u0006\u0003XN\u0003\u0002*U\u0005\u0019\u0011\r]7\u000b\u0003-\nQa[1n_:\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b9\u001b\u00051$BA\u001c+\u0003\u0019iw\u000eZ;mK&\u0011\u0011H\u000e\u0002\u0011\u0007>l'-\u001b8fIJ+\u0007o\u001c:uKJ\f!bY8oM&<\u0007+\u0019;i!\ta4I\u0004\u0002>\u0003B\u0011a\bM\u0007\u0002\u007f)\u0011\u0001\tL\u0001\u0007yI|w\u000e\u001e \n\u0005\t\u0003\u0014A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!A\u0011\u0019\u0002\rqJg.\u001b;?)\tA%\n\u0005\u0002J\u00015\t\u0001\u0006C\u0003;\u0005\u0001\u00071(A\b`[\u0006D8K\\1qg\"|G/Q4f+\u0005i\u0005C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u0011!\u0018.\\3\u000b\u0003I\u000bAA[1wC&\u0011Ak\u0014\u0002\t\tV\u0014\u0018\r^5p]\u0006\u0001r,\\1y':\f\u0007o\u001d5pi\u0006;W\rI\u0001\n?N,G\u000f^5oON,\u0012\u0001\u0017\t\u00033rs!!\u0013.\n\u0005mC\u0013a\u00029bG.\fw-Z\u0005\u0003;z\u0013\u0001bU3ui&twm\u001d\u0006\u00037\"\nQbX:fiRLgnZ:`I\u0015\fHCA1e!\ty#-\u0003\u0002da\t!QK\\5u\u0011\u001d)g!!AA\u0002a\u000b1\u0001\u001f\u00132\u0003)y6/\u001a;uS:<7\u000fI\u0001\f?\"$H\u000f]\"mS\u0016tG/F\u0001j!\ry#\u000e\\\u0005\u0003WB\u0012aa\u00149uS>t\u0007CA%n\u0013\tq\u0007FA\tLC6|g.\u00119n\u0003BL7\t\\5f]R\fqb\u00185uiB\u001cE.[3oi~#S-\u001d\u000b\u0003CFDq!Z\u0005\u0002\u0002\u0003\u0007\u0011.\u0001\u0007`QR$\bo\u00117jK:$\b%\u0001\u0007`m\u0006dW/\u001a\"vM\u001a,'/F\u0001v!\t1\u00180D\u0001x\u0015\tA\u0018+A\u0002oS>L!A_<\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0007`m\u0006dW/\u001a\"vM\u001a,'\u000fI\u0001\r?\u0006\u001c7-^7vY\u0006$xN]\u000b\u0002}B\u0019q0a\u0003\u000f\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002+\u0003\u0019iW\r\u001e:jG&!\u0011\u0011BA\u0002\u00039\u0001VM]5pINs\u0017\r]:i_RLA!!\u0004\u0002\u0010\tY\u0011iY2v[Vd\u0017\r^8s\u0015\u0011\tI!a\u0001\u0002\u001b}\u000b7mY;nk2\fGo\u001c:!\u00039yVO\\5u\u0007>tg/\u001a:uKJ,\"!a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b+\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00121\u0004\u0002\u000e+:LGoQ8om\u0016\u0014H/\u001a:\u0002\u001f}+h.\u001b;D_:4XM\u001d;fe\u0002\"\u0012\u0001S\u0001\u0005gR|\u0007\u000fF\u0001b\u0003-\u0011XmY8oM&<WO]3\u0015\u0007\u0005\fy\u0003C\u0004\u00022M\u0001\r!a\r\u0002\r\r|gNZ5h!\u0011\t)$!\u0011\u000e\u0005\u0005]\"\u0002BA\u0019\u0003sQA!a\u000f\u0002>\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002@\u0005\u00191m\\7\n\t\u0005\r\u0013q\u0007\u0002\u0007\u0007>tg-[4\u0002)I,\u0007o\u001c:u!\u0016\u0014\u0018n\u001c3T]\u0006\u00048\u000f[8u)\r\t\u0017\u0011\n\u0005\b\u0003\u0017\"\u0002\u0019AA'\u0003!\u0019h.\u00199tQ>$\b\u0003BA\u0001\u0003\u001fJA!!\u0015\u0002\u0004\tq\u0001+\u001a:j_\u0012\u001cf.\u00199tQ>$\u0018a\u0003:fa>\u0014Ho\u00159b]N$2!YA,\u0011\u001d\tI&\u0006a\u0001\u00037\nQa\u001d9b]N\u0004b!!\u0018\u0002f\u0005-d\u0002BA0\u0003Gr1APA1\u0013\u0005\t\u0014BA.1\u0013\u0011\t9'!\u001b\u0003\u0007M+\u0017O\u0003\u0002\\aA!\u0011QNA=\u001d\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:U\u0005)AO]1dK&!\u0011qOA9\u0003\u0011\u0019\u0006/\u00198\n\t\u0005m\u0014Q\u0010\u0002\t\r&t\u0017n\u001d5fI*!\u0011qOA9\u0003=\u0011X\r]8si&sw-Z:uS>tGcA1\u0002\u0004\"9\u00111\n\fA\u0002\u00055\u0013A\u0003:fa>\u0014HOQ8piR\u0019\u0011-!#\t\u000f\u0005-u\u00031\u0001\u0002\u000e\u00069\u0012N\\5uS\u0006d\u0017N_1uS>tG+[7fgR\fW\u000e\u001d\t\u0004_\u0005=\u0015bAAIa\t!Aj\u001c8h\u00039\u0011X\r]8siNCW\u000f\u001e3po:$2!YAL\u0011\u001d\tI\n\u0007a\u0001\u0003\u001b\u000b\u0011c\u001d5vi\u0012|wO\u001c+j[\u0016\u001cH/Y7q\u00031qw\u000eZ3JI\u0016tG/\u001b;z)\t\ty\n\u0005\u0003\u0002\"\u00065f\u0002BAR\u0003Sk!!!*\u000b\u0005\u0005\u001d\u0016AB6b[&tw.\u0003\u0003\u0002,\u0006\u0015\u0016aC%oO\u0016\u001cH/[8o-FJA!a,\u00022\naaj\u001c3f\u0013\u0012,g\u000e^5us*!\u00111VAS\u0003Y!x.\u00138hKN$\u0018n\u001c8NKR\u0014\u0018n\u0019,bYV,G\u0003BA\\\u0003#$B!!/\u0002BB1\u0011QLA3\u0003w\u0003B!!)\u0002>&!\u0011qXAY\u0005\u0019iU\r\u001e:jG\"9\u0011Q\u0001\u000eA\u0002\u0005\r\u0007CBAc\u0003\u0017\fiI\u0004\u0003\u0002\u0002\u0005\u001d\u0017\u0002BAe\u0003\u0007\ta\"T3ue&\u001c7K\\1qg\"|G/\u0003\u0003\u0002N\u0006='A\u0002,bYV,7O\u0003\u0003\u0002J\u0006\r\u0001bBAj5\u0001\u0007\u0011Q[\u0001\u000b[\u0016$(/[2UsB,\u0007\u0003BAl\u0003;tA!!7\u0002*:\u0019a(a7\n\u0005\u0005\u001d\u0016\u0002BAp\u0003c\u0013a\"\u00138tiJ,X.\u001a8u)f\u0004X-A\u0012u_&sw-Z:uS>tW*\u001a;sS\u000e4En\\1uS:<\u0007k\\5oiZ\u000bG.^3\u0015\t\u0005\u0015\u0018\u0011\u001f\u000b\u0005\u0003s\u000b9\u000fC\u0004\u0002\u0006m\u0001\r!!;\u0011\r\u0005\u0015\u00171ZAv!\ry\u0013Q^\u0005\u0004\u0003_\u0004$A\u0002#pk\ndW\rC\u0004\u0002Tn\u0001\r!!6\u0002;Q|\u0017J\\4fgRLwN\\'fiJL7\rR5tiJL'-\u001e;j_:$B!a>\u0003\u0002Q!\u0011\u0011XA}\u0011\u001d\t)\u0001\ba\u0001\u0003w\u0004B!!2\u0002~&!\u0011q`Ah\u00055!\u0015n\u001d;sS\n,H/[8og\"9\u00111\u001b\u000fA\u0002\u0005U\u0017aC2p]Z,'\u000f^*qC:$BAa\u0002\u0003\u000eA!\u0011\u0011\u0015B\u0005\u0013\u0011\u0011Y!!-\u0003\tM\u0003\u0018M\u001c\u0005\b\u0005\u001fi\u0002\u0019AA6\u0003\u0011\u0019\b/\u00198\u0002\u001bM$(/\u001b8hS\u001aLH+Y4t)\u0011\u0011)Ba\b\u0011\r\t]!1D\u001e<\u001b\t\u0011IBC\u0002\u0002\u001eEKAA!\b\u0003\u001a\t\u0019Q*\u00199\t\u000f\t\u0005b\u00041\u0001\u0003$\u0005!A/Y4t!\u0011\u0011)Ca\u000b\u000e\u0005\t\u001d\"b\u0001B\u0015U\u0005\u0019A/Y4\n\t\t5\"q\u0005\u0002\u0007)\u0006<7+\u001a;\u0002\u001f\r|gN^3siN\u0003\u0018M\\&j]\u0012$BAa\r\u0003:A!\u0011q\u001bB\u001b\u0013\u0011\u00119$!-\u0003\u0011M\u0003\u0018M\\&j]\u0012DqAa\u000f \u0001\u0004\u0011i$\u0001\u0003lS:$\u0007\u0003BA7\u0005\u007fIAA!\u0011\u0002~\t!1*\u001b8e\u0003M\u0019wN\u001c<feR\u001c\u0006/\u00198Q_NLG/[8o)\u0011\u00119E!\u0014\u0011\t\u0005]'\u0011J\u0005\u0005\u0005\u0017\n\tL\u0001\u0007Ta\u0006t\u0007k\\:ji&|g\u000eC\u0004\u0003P\u0001\u0002\rA!\u0015\u0002\u0011A|7/\u001b;j_:\u0004B!!\u001c\u0003T%!!QKA?\u0005!\u0001vn]5uS>t\u0017\u0001C&b[>t\u0017\t]7\u0011\u0005%\u00133C\u0001\u0012/)\t\u0011IFA\u0004GC\u000e$xN]=\u0014\t\u0011r#1\r\t\u0004k\t\u0015\u0014b\u0001B4m\tiQj\u001c3vY\u00164\u0015m\u0019;pef$\"Aa\u001b\u0011\u0007\t5D%D\u0001#\u0003\u0019\u0019'/Z1uKR!!1\u000fB=!\r)$QO\u0005\u0004\u0005o2$AB'pIVdW\rC\u0004\u0003|\u0019\u0002\rA! \u0002\u0011M,G\u000f^5oON\u0004BAa \u0003\u0006:\u0019QG!!\n\u0007\t\re'A\u0007N_\u0012,H.\u001a$bGR|'/_\u0005\u0004;\n\u001d%b\u0001BBm\u0001")
public class KamonApm
implements CombinedReporter {
    private final String configPath;
    private final Duration _maxSnapshotAge;
    private package.Settings _settings;
    private Option<KamonApmApiClient> _httpClient;
    private final ByteBuffer _valueBuffer;
    private final PeriodSnapshot.Accumulator _accumulator;
    private final UnitConverter _unitConverter;

    private Duration _maxSnapshotAge() {
        return this._maxSnapshotAge;
    }

    private package.Settings _settings() {
        return this._settings;
    }

    private void _settings_$eq(package.Settings x$1) {
        this._settings = x$1;
    }

    private Option<KamonApmApiClient> _httpClient() {
        return this._httpClient;
    }

    private void _httpClient_$eq(Option<KamonApmApiClient> x$1) {
        this._httpClient = x$1;
    }

    private ByteBuffer _valueBuffer() {
        return this._valueBuffer;
    }

    private PeriodSnapshot.Accumulator _accumulator() {
        return this._accumulator;
    }

    private UnitConverter _unitConverter() {
        return this._unitConverter;
    }

    public void stop() {
        this.reportShutdown(Kamon$.MODULE$.clock().millis());
        this._httpClient().foreach((Function1 & Serializable)x$1 -> {
            x$1.stop();
            return BoxedUnit.UNIT;
        });
        package$.MODULE$._logger().info("Stopped the Kamon APM Reporter.");
    }

    public void reconfigure(Config config) {
        this._settings_$eq(package$.MODULE$.readSettings(config, this.configPath));
        this._httpClient().foreach((Function1 & Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        this._httpClient_$eq((Option<KamonApmApiClient>)Option$.MODULE$.apply((Object)new KamonApmApiClient(this._settings())));
    }

    public void reportPeriodSnapshot(PeriodSnapshot snapshot) {
        long snapshotAge = Duration.between(snapshot.to(), Kamon$.MODULE$.clock().instant()).toMillis();
        if (snapshotAge >= 0L && snapshotAge < this._maxSnapshotAge().toMillis()) {
            if (package$.MODULE$.isAcceptableApiKey(this._settings().apiKey())) {
                this.reportIngestion(snapshot);
            } else {
                package$.MODULE$._logger().error(new StringBuilder(66).append("Dropping metrics because an invalid API key has been configured [").append(this._settings().apiKey()).append("]").toString());
            }
        } else {
            package$.MODULE$._logger().warn("Dropping stale metrics for period from: [{}], to: [{}]. The snapshot is [{} millis] old", new Object[]{Long.toString(snapshot.from().toEpochMilli()), Long.toString(snapshot.to().toEpochMilli()), Long.toString(snapshotAge)});
        }
    }

    public void reportSpans(scala.collection.immutable.Seq<Span.Finished> spans) {
        block0: {
            block1: {
                if (!spans.nonEmpty()) break block0;
                if (!package$.MODULE$.isAcceptableApiKey(this._settings().apiKey())) break block1;
                Instant spansFinishLimit = Kamon$.MODULE$.clock().instant().minus(this._maxSnapshotAge());
                scala.collection.immutable.Seq recentSpans = (scala.collection.immutable.Seq)spans.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KamonApm.$anonfun$reportSpans$1(spansFinishLimit, x$3)));
                if (!recentSpans.nonEmpty()) break block0;
                Environment env = Kamon$.MODULE$.environment();
                scala.collection.immutable.Seq apmSpans = (scala.collection.immutable.Seq)recentSpans.map((Function1 & Serializable)span -> this.convertSpan((Span.Finished)span));
                IngestionV1.SpanBatch batch = IngestionV1.SpanBatch.newBuilder().setAgent(this._settings().agent()).setServiceName(env.service()).setHost(env.host()).setInstance(env.instance()).setApiKey(this._settings().apiKey()).putAllEnvironmentTags(this._settings().environmentTags()).addAllSpans((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)apmSpans).asJava()).build();
                this._httpClient().foreach((Function1 & Serializable)x$4 -> {
                    x$4.postSpans(batch);
                    return BoxedUnit.UNIT;
                });
                break block0;
            }
            package$.MODULE$._logger().error(new StringBuilder(64).append("Dropping Spans because an invalid API key has been configured [").append(this._settings().apiKey()).append("]").toString());
        }
    }

    private void reportIngestion(PeriodSnapshot snapshot) {
        this._accumulator().add(snapshot).foreach((Function1 & Serializable)accumulatedSnapshot -> {
            KamonApm.$anonfun$reportIngestion$1(this, accumulatedSnapshot);
            return BoxedUnit.UNIT;
        });
    }

    private void reportBoot(long initializationTimestamp) {
        IngestionV1.Hello hello = IngestionV1.Hello.newBuilder().setNode(this.nodeIdentity()).setTime(initializationTimestamp).setIncarnation(Kamon$.MODULE$.environment().incarnation()).setVersion(this._settings().appVersion()).build();
        this._httpClient().foreach((Function1 & Serializable)x$6 -> {
            x$6.postHello(hello);
            return BoxedUnit.UNIT;
        });
    }

    private void reportShutdown(long shutdownTimestamp) {
        IngestionV1.Goodbye goodBye = IngestionV1.Goodbye.newBuilder().setNode(this.nodeIdentity()).setTime(shutdownTimestamp).build();
        this._httpClient().foreach((Function1 & Serializable)x$7 -> {
            x$7.postGoodbye(goodBye);
            return BoxedUnit.UNIT;
        });
    }

    private IngestionV1.NodeIdentity nodeIdentity() {
        Environment env = Kamon$.MODULE$.environment();
        return IngestionV1.NodeIdentity.newBuilder().setService(env.service()).setInstance(env.instance()).setHost(env.host()).setApiKey(this._settings().apiKey()).setAgent(this._settings().agent()).build();
    }

    private scala.collection.immutable.Seq<IngestionV1.Metric> toIngestionMetricValue(IngestionV1.InstrumentType metricType, MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        return (scala.collection.immutable.Seq)metric.instruments().map((Function1 & Serializable)x0$1 -> {
            Instrument.Snapshot snapshot = x0$1;
            if (snapshot == null) {
                throw new MatchError((Object)snapshot);
            }
            TagSet tags = snapshot.tags();
            long value = BoxesRunTime.unboxToLong((Object)snapshot.value());
            this._valueBuffer().clear();
            ZigZag.putLong((ByteBuffer)this._valueBuffer(), (long)((long)this._unitConverter().convertValue((double)value, ((Metric.Settings.ForValueInstrument)metric.settings()).unit())));
            this._valueBuffer().flip();
            IngestionV1.Metric metric = IngestionV1.Metric.newBuilder().setName(metric.name()).putAllTags(this.stringifyTags(tags)).setInstrumentType(metricType).setData(ByteString.copyFrom(this._valueBuffer())).build();
            return metric;
        });
    }

    private scala.collection.immutable.Seq<IngestionV1.Metric> toIngestionMetricFloatingPointValue(IngestionV1.InstrumentType metricType, MetricSnapshot<Metric.Settings.ForValueInstrument, Object> metric) {
        return (scala.collection.immutable.Seq)metric.instruments().map((Function1 & Serializable)x0$1 -> {
            TagSet tags;
            Instrument.Snapshot snapshot = x0$1;
            if (snapshot != null) {
                tags = snapshot.tags();
                double value = BoxesRunTime.unboxToDouble((Object)snapshot.value());
                this._valueBuffer().clear();
                long convertedValue = (long)this._unitConverter().convertValue(value, ((Metric.Settings.ForValueInstrument)metric.settings()).unit());
                int offset = package$.MODULE$.countsArrayIndex(convertedValue);
                if (offset > 0) {
                    ZigZag.putLong((ByteBuffer)this._valueBuffer(), (long)(-offset));
                }
            } else {
                throw new MatchError((Object)snapshot);
            }
            ZigZag.putLong((ByteBuffer)this._valueBuffer(), (long)1L);
            this._valueBuffer().flip();
            IngestionV1.Metric metric = IngestionV1.Metric.newBuilder().setName(metric.name()).putAllTags(this.stringifyTags(tags)).setInstrumentType(metricType).setData(ByteString.copyFrom(this._valueBuffer())).build();
            return metric;
        });
    }

    private scala.collection.immutable.Seq<IngestionV1.Metric> toIngestionMetricDistribution(IngestionV1.InstrumentType metricType, MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> metric) {
        return (scala.collection.immutable.Seq)metric.instruments().map((Function1 & Serializable)x0$1 -> {
            Instrument.Snapshot snapshot = x0$1;
            if (snapshot == null) {
                throw new MatchError((Object)snapshot);
            }
            TagSet tags = snapshot.tags();
            Distribution distribution = (Distribution)snapshot.value();
            Distribution convertedDistribution = this._unitConverter().convertDistribution(distribution, ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit());
            ByteBuffer counts = ((Distribution.ZigZagCounts)convertedDistribution).countsArray();
            IngestionV1.Metric metric = IngestionV1.Metric.newBuilder().setName(metric.name()).putAllTags(this.stringifyTags(tags)).setInstrumentType(metricType).setData(ByteString.copyFrom(counts)).build();
            return metric;
        });
    }

    private IngestionV1.Span convertSpan(Span.Finished span) {
        scala.collection.immutable.Seq marks = (scala.collection.immutable.Seq)span.marks().map((Function1 & Serializable)m -> IngestionV1.Mark.newBuilder().setInstant(m.instant().toEpochMilli()).setKey(m.key()).build());
        scala.collection.immutable.Seq links = (scala.collection.immutable.Seq)span.links().map((Function1 & Serializable)link -> IngestionV1.Link.newBuilder().setKind(IngestionV1.LinkKind.FOLLOWS_FROM).setTraceId(link.trace().id().string()).setSpanId(link.spanId().string()).build());
        Map<String, String> tags = this.stringifyTags(span.tags());
        Map<String, String> metricTags = this.stringifyTags(span.metricTags());
        return IngestionV1.Span.newBuilder().setId(span.id().string()).setTraceId(span.trace().id().string()).setParentId(span.parentId().string()).setOperationName(span.operationName()).setStartMicros(Clock$.MODULE$.toEpochMicros(span.from())).setEndMicros(Clock$.MODULE$.toEpochMicros(span.to())).putAllTags(tags).putAllMetricTags(metricTags).addAllMarks((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)marks).asJava()).setHasError(span.hasError()).setWasDelayed(span.wasDelayed()).setKind(this.convertSpanKind(span.kind())).setPosition(this.convertSpanPosition(span.position())).addAllLinks((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)links).asJava()).build();
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> stringifyTags(TagSet tags) {
        void var2_2;
        HashMap javaMap = new HashMap();
        tags.iterator((Function1 & Serializable)x$8 -> x$8.toString()).foreach((Function1 & Serializable)pair -> (String)javaMap.put(pair.key(), pair.value()));
        return var2_2;
    }

    private IngestionV1.SpanKind convertSpanKind(Span.Kind kind) {
        IngestionV1.SpanKind spanKind;
        Span.Kind kind2 = kind;
        if (Span.Kind$.Server$.MODULE$.equals(kind2)) {
            spanKind = IngestionV1.SpanKind.SERVER;
        } else if (Span.Kind$.Client$.MODULE$.equals(kind2)) {
            spanKind = IngestionV1.SpanKind.CLIENT;
        } else if (Span.Kind$.Producer$.MODULE$.equals(kind2)) {
            spanKind = IngestionV1.SpanKind.PRODUCER;
        } else if (Span.Kind$.Consumer$.MODULE$.equals(kind2)) {
            spanKind = IngestionV1.SpanKind.CONSUMER;
        } else if (Span.Kind$.Internal$.MODULE$.equals(kind2)) {
            spanKind = IngestionV1.SpanKind.INTERNAL;
        } else if (Span.Kind$.Unknown$.MODULE$.equals(kind2)) {
            spanKind = IngestionV1.SpanKind.UNKNOWN;
        } else {
            throw new MatchError((Object)kind2);
        }
        return spanKind;
    }

    private IngestionV1.SpanPosition convertSpanPosition(Span.Position position) {
        IngestionV1.SpanPosition spanPosition;
        Span.Position position2 = position;
        if (Span.Position$.Root$.MODULE$.equals(position2)) {
            spanPosition = IngestionV1.SpanPosition.ROOT;
        } else if (Span.Position$.LocalRoot$.MODULE$.equals(position2)) {
            spanPosition = IngestionV1.SpanPosition.LOCAL_ROOT;
        } else if (Span.Position$.Unknown$.MODULE$.equals(position2)) {
            spanPosition = IngestionV1.SpanPosition.POSITION_UNKNOWN;
        } else {
            throw new MatchError((Object)position2);
        }
        return spanPosition;
    }

    public static final /* synthetic */ void $anonfun$new$2(Throwable t) {
        package$.MODULE$._logger().error("Failed boot", t);
    }

    public static final /* synthetic */ boolean $anonfun$reportSpans$1(Instant spansFinishLimit$1, Span.Finished x$3) {
        return x$3.to().isAfter(spansFinishLimit$1);
    }

    public static final /* synthetic */ void $anonfun$reportIngestion$1(KamonApm $this, PeriodSnapshot accumulatedSnapshot) {
        scala.collection.immutable.Seq histograms = (scala.collection.immutable.Seq)accumulatedSnapshot.histograms().flatMap((Function1 & Serializable)metric -> $this.toIngestionMetricDistribution(IngestionV1.InstrumentType.HISTOGRAM, (MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)metric));
        scala.collection.immutable.Seq timers = (scala.collection.immutable.Seq)accumulatedSnapshot.timers().flatMap((Function1 & Serializable)metric -> $this.toIngestionMetricDistribution(IngestionV1.InstrumentType.HISTOGRAM, (MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)metric));
        scala.collection.immutable.Seq rangeSamplers = (scala.collection.immutable.Seq)accumulatedSnapshot.rangeSamplers().flatMap((Function1 & Serializable)metric -> $this.toIngestionMetricDistribution(IngestionV1.InstrumentType.MIN_MAX_COUNTER, (MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)metric));
        scala.collection.immutable.Seq gauges = (scala.collection.immutable.Seq)accumulatedSnapshot.gauges().flatMap((Function1 & Serializable)metric -> $this.toIngestionMetricFloatingPointValue(IngestionV1.InstrumentType.GAUGE, (MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric));
        scala.collection.immutable.Seq counters = (scala.collection.immutable.Seq)accumulatedSnapshot.counters().flatMap((Function1 & Serializable)metric -> $this.toIngestionMetricValue(IngestionV1.InstrumentType.COUNTER, (MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)metric));
        IngestionV1.Plan plan = IngestionV1.Plan.METRIC_TRACING;
        scala.collection.immutable.Seq allMetrics = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)histograms.$plus$plus((IterableOnce)timers)).$plus$plus((IterableOnce)rangeSamplers)).$plus$plus((IterableOnce)gauges)).$plus$plus((IterableOnce)counters);
        IngestionV1.Interval.Builder interval = IngestionV1.Interval.newBuilder().setFrom(accumulatedSnapshot.from().toEpochMilli()).setTo(accumulatedSnapshot.to().toEpochMilli());
        IngestionV1.MetricBatch batch = IngestionV1.MetricBatch.newBuilder().setInterval(interval).setApiKey($this._settings().apiKey()).setAgent($this._settings().agent()).setService(Kamon$.MODULE$.environment().service()).setHost(Kamon$.MODULE$.environment().host()).setInstance(Kamon$.MODULE$.environment().instance()).putAllEnvironmentTags($this._settings().environmentTags()).addAllMetrics((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allMetrics).asJava()).setPlan(plan).build();
        $this._httpClient().foreach((Function1 & Serializable)x$5 -> {
            x$5.postIngestion(batch);
            return BoxedUnit.UNIT;
        });
    }

    public KamonApm(String configPath) {
        this.configPath = configPath;
        this._maxSnapshotAge = Duration.ofMinutes(30L);
        this._settings = package$.MODULE$.readSettings(Kamon$.MODULE$.config(), configPath);
        this._httpClient = Option$.MODULE$.apply((Object)new KamonApmApiClient(this._settings()));
        this._valueBuffer = ByteBuffer.wrap((byte[])Array$.MODULE$.ofDim(16, (ClassTag)ClassTag$.MODULE$.Byte()));
        this._accumulator = PeriodSnapshot$.MODULE$.accumulator(Duration.ofSeconds(60L), Duration.ofSeconds(1L));
        this._unitConverter = new UnitConverter(MeasurementUnit$.MODULE$.time().nanoseconds(), MeasurementUnit$.MODULE$.information().bytes(), DynamicRange$.MODULE$.Default());
        if (package$.MODULE$.isAcceptableApiKey(this._settings().apiKey())) {
            String serviceName = Kamon$.MODULE$.environment().service();
            package$.MODULE$._logger().info(new StringBuilder(94).append("Starting the Kamon APM Reporter. Your service will be displayed as [").append(serviceName).append("] at https://apm.kamon.io/").toString());
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.reportBoot(Kamon$.MODULE$.clock().millis())).failed().foreach((Function1 & Serializable)t -> {
                KamonApm.$anonfun$new$2(t);
                return BoxedUnit.UNIT;
            });
        } else {
            package$.MODULE$._logger().warn(new StringBuilder(61).append("The Kamon APM Reporter was started with an invalid API key [").append(this._settings().apiKey()).append("]").toString());
        }
    }

    public KamonApm() {
        this("kamon.apm");
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new KamonApm();
        }
    }
}

