/*
 * Decompiled with CFR 0.152.
 */
package kamon.apm;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import kamino.IngestionV1;
import kamon.Kamon$;
import kamon.apm.package;
import kamon.apm.shaded.okhttp3.MediaType;
import kamon.apm.shaded.okhttp3.OkHttpClient;
import kamon.apm.shaded.okhttp3.Request;
import kamon.apm.shaded.okhttp3.RequestBody;
import kamon.apm.shaded.okhttp3.Response;
import kamon.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\u000b\u0016\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006U\u0001!\ta\u000b\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0011\u0019A\u0004\u0001)A\u0005a!9\u0011\b\u0001b\u0001\n\u0013Q\u0004BB!\u0001A\u0003%1\bC\u0004C\u0001\t\u0007I\u0011B\"\t\r1\u0003\u0001\u0015!\u0003E\u0011\u001di\u0005\u00011A\u0005\n9Cq!\u0016\u0001A\u0002\u0013%a\u000b\u0003\u0004]\u0001\u0001\u0006Ka\u0014\u0005\u0006;\u0002!\tA\u0018\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\u0006{\u0002!\tA \u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fAq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002X\u0001!I!!\u0017\u0003#-\u000bWn\u001c8Ba6\f\u0005/[\"mS\u0016tGO\u0003\u0002\u0017/\u0005\u0019\u0011\r]7\u000b\u0003a\tQa[1n_:\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\f\u0001b]3ui&twm\u001d\t\u0003G\u001dr!\u0001J\u0013\u000e\u0003UI!AJ\u000b\u0002\u000fA\f7m[1hK&\u0011\u0001&\u000b\u0002\t'\u0016$H/\u001b8hg*\u0011a%F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051j\u0003C\u0001\u0013\u0001\u0011\u0015\t#\u00011\u0001#\u0003\u001dyFn\\4hKJ,\u0012\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003gQ\nQa\u001d7gi)T\u0011!N\u0001\u0004_J<\u0017BA\u001c3\u0005\u0019aunZ4fe\u0006Aq\f\\8hO\u0016\u0014\b%A\u0006`QR$\bo\u00117jK:$X#A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0003y\nqa\\6iiR\u00048'\u0003\u0002A{\taqj\u001b%uiB\u001cE.[3oi\u0006aq\f\u001b;ua\u000ec\u0017.\u001a8uA\u0005\tr,\u00199j\u0017\u0016L\b*Z1eKJt\u0015-\\3\u0016\u0003\u0011\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\t1\fgn\u001a\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tYeI\u0001\u0004TiJLgnZ\u0001\u0013?\u0006\u0004\u0018nS3z\u0011\u0016\fG-\u001a:OC6,\u0007%\u0001\u0007`Y\u0006\u001cH/\u0011;uK6\u0004H/F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011\u0006*\u0001\u0003uS6,\u0017B\u0001+R\u0005\u001dIen\u001d;b]R\f\u0001c\u00187bgR\fE\u000f^3naR|F%Z9\u0015\u0005]S\u0006C\u0001\u000fY\u0013\tIVD\u0001\u0003V]&$\bbB.\u000b\u0003\u0003\u0005\raT\u0001\u0004q\u0012\n\u0014!D0mCN$\u0018\t\u001e;f[B$\b%A\u0007q_N$\u0018J\\4fgRLwN\u001c\u000b\u0003/~CQ\u0001\u0019\u0007A\u0002\u0005\f1\"\\3ue&\u001c')\u0019;dQB\u0011!\r\u001c\b\u0003G&t!\u0001Z4\u000e\u0003\u0015T!AZ\r\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0017AB6b[&tw.\u0003\u0002kW\u0006Y\u0011J\\4fgRLwN\u001c,2\u0015\u0005A\u0017BA7o\u0005-iU\r\u001e:jG\n\u000bGo\u00195\u000b\u0005)\\\u0017!\u00039pgRDU\r\u001c7p)\t9\u0016\u000fC\u0003s\u001b\u0001\u00071/A\u0003iK2dw\u000e\u0005\u0002ci&\u0011QO\u001c\u0002\u0006\u0011\u0016dGn\\\u0001\fa>\u001cHoR8pI\nLX\r\u0006\u0002Xq\")\u0011P\u0004a\u0001u\u00069qm\\8e\u0005f,\u0007C\u00012|\u0013\tahNA\u0004H_>$'-_3\u0002\u0013A|7\u000f^*qC:\u001cHCA,\u0000\u0011\u001d\t\ta\u0004a\u0001\u0003\u0007\t\u0011b\u001d9b]\n\u000bGo\u00195\u0011\u0007\t\f)!C\u0002\u0002\b9\u0014\u0011b\u00159b]\n\u000bGo\u00195\u0002\tM$x\u000e\u001d\u000b\u0002/\u0006i\u0001o\\:u/&$\bNU3uef$\u0012bVA\t\u0003C\t\u0019$a\u000e\t\u000f\u0005M\u0011\u00031\u0001\u0002\u0016\u0005!!m\u001c3z!\u0015a\u0012qCA\u000e\u0013\r\tI\"\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00049\u0005u\u0011bAA\u0010;\t!!)\u001f;f\u0011\u001d\t\u0019#\u0005a\u0001\u0003K\tA\"\u001a8ea>Lg\u000e\u001e(b[\u0016\u0004B!a\n\u000209!\u0011\u0011FA\u0016!\t!W$C\u0002\u0002.u\ta\u0001\u0015:fI\u00164\u0017bA&\u00022)\u0019\u0011QF\u000f\t\u000f\u0005U\u0012\u00031\u0001\u0002&\u00051\u0011\r]5Ve2Dq!!\u000f\u0012\u0001\u0004\tY$A\u0004sKR\u0014\u0018.Z:\u0011\u0007q\ti$C\u0002\u0002@u\u00111!\u00138uQ\r\t\u00121\t\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011J\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0005\u001d#a\u0002;bS2\u0014XmY\u0001\u0011GJ,\u0017\r^3IiR\u00048\t\\5f]R$2aOA*\u0011\u0019\t)F\u0005a\u0001E\u000511m\u001c8gS\u001e\fqAY1dW>4g-F\u0001X\u0001")
public class KamonApmApiClient {
    private final package.Settings settings;
    private final Logger _logger;
    private final OkHttpClient _httpClient;
    private final String _apiKeyHeaderName;
    private Instant _lastAttempt;

    private Logger _logger() {
        return this._logger;
    }

    private OkHttpClient _httpClient() {
        return this._httpClient;
    }

    private String _apiKeyHeaderName() {
        return this._apiKeyHeaderName;
    }

    private Instant _lastAttempt() {
        return this._lastAttempt;
    }

    private void _lastAttempt_$eq(Instant x$1) {
        this._lastAttempt = x$1;
    }

    public void postIngestion(IngestionV1.MetricBatch metricBatch) {
        this.postWithRetry(metricBatch.toByteArray(), "metrics-ingestion", this.settings.ingestionRoute(), this.settings.ingestionRetries());
    }

    public void postHello(IngestionV1.Hello hello) {
        this.postWithRetry(hello.toByteArray(), "hello", this.settings.bootMark(), this.settings.bootRetries());
    }

    public void postGoodbye(IngestionV1.Goodbye goodBye) {
        this.postWithRetry(goodBye.toByteArray(), "goodbye", this.settings.shutdownMark(), this.settings.shutdownRetries());
    }

    public void postSpans(IngestionV1.SpanBatch spanBatch) {
        this.postWithRetry(spanBatch.toByteArray(), "spans-ingestion", this.settings.tracingRoute(), this.settings.tracingRetries());
    }

    public void stop() {
        this._httpClient().dispatcher().executorService().shutdown();
        this._httpClient().connectionPool().evictAll();
    }

    private void postWithRetry(byte[] body, String endpointName, String apiUrl, int retries) {
        block19: {
            Try try_;
            Failure failure;
            boolean bl;
            while (true) {
                Clock clock = Kamon$.MODULE$.clock();
                Duration timeSinceLastPost = Duration.between(this._lastAttempt(), clock.instant());
                if (timeSinceLastPost.compareTo(this.settings.clientBackoff()) < 0) {
                    this.backoff();
                }
                Function0 & Serializable request = (Function0 & Serializable)() -> {
                    RequestBody reqBody = RequestBody.create(MediaType.parse("application/octet-stream"), body);
                    Request request = new Request.Builder().url(apiUrl).post(reqBody).addHeader(this._apiKeyHeaderName(), $this.settings.apiKey()).build();
                    return this._httpClient().newCall(request).execute();
                };
                bl = false;
                failure = null;
                try_ = this.tryPosting$1(clock, request).flatMap((Function1 & Serializable)response -> KamonApmApiClient.parseResponse$1(response));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    IngestionV1.IngestionResponse ingestionResult = (IngestionV1.IngestionResponse)success.value();
                    boolean bl2 = false;
                    IngestionV1.IngestionStatus ingestionStatus = null;
                    IngestionV1.IngestionStatus ingestionStatus2 = ingestionResult.getStatus();
                    if (IngestionV1.IngestionStatus.OK.equals(ingestionStatus2)) {
                        this._logger().trace("[{}] request succeeded", (Object)endpointName);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (IngestionV1.IngestionStatus.STALE.equals(ingestionStatus2)) {
                        this._logger().warn("[{}] request declined, stale data", (Object)endpointName);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (IngestionV1.IngestionStatus.BLOCKED.equals(ingestionStatus2)) {
                        this._logger().warn("[{}] request declined, plan limits reached", (Object)endpointName);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (IngestionV1.IngestionStatus.UNAUTHORIZED.equals(ingestionStatus2)) {
                        this._logger().error("[{}] request declined, missing or wrong API key", (Object)endpointName);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (IngestionV1.IngestionStatus.CORRUPTED.equals(ingestionStatus2)) {
                        this._logger().warn("[{}] request declined, illegal batch", (Object)endpointName);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (IngestionV1.IngestionStatus.ERROR.equals(ingestionStatus2)) {
                            bl2 = true;
                            ingestionStatus = ingestionStatus2;
                            if (retries > 0) {
                                this._logger().warn("[{}] request declined, unknown error", (Object)endpointName);
                                this.backoff();
                                --retries;
                                continue;
                            }
                        }
                        if (bl2) {
                            this._logger().warn("[{}] request declined, unknown error", (Object)endpointName);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)ingestionStatus2);
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block19;
                }
                if (!(try_ instanceof Failure)) break;
                bl = true;
                failure = (Failure)try_;
                Throwable connectionException = failure.exception();
                if (retries <= 0) break;
                this._logger().warn(new StringBuilder(38).append("Connection error, retrying... (").append(retries).append(" left) ").append(connectionException.getMessage()).toString());
                this.backoff();
                --retries;
            }
            if (bl) {
                Throwable connectionException = failure.exception();
                this._logger().error(new StringBuilder(50).append("Ingestion error, no retries, dropping snapshot... ").append(connectionException.getMessage()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
        }
    }

    private OkHttpClient createHttpClient(package.Settings config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(config.connectionTimeout().toMillis(), TimeUnit.MILLISECONDS).readTimeout(config.readTimeout().toMillis(), TimeUnit.MILLISECONDS);
        config.proxy().foreach((Function1 & Serializable)pt -> builder.proxy(new Proxy((Proxy.Type)((Object)pt), new InetSocketAddress(config.proxyHost(), config.proxyPort()))));
        return builder.build();
    }

    private void backoff() {
        Thread.sleep(this.settings.clientBackoff().toMillis());
    }

    private final Try tryPosting$1(Clock clock$1, Function0 request$1) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this._lastAttempt_$eq(clock$1.instant());
            return (Response)request$1.apply();
        });
    }

    private static final Try parseResponse$1(Response response) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            IngestionV1.IngestionResponse ingestionResponse;
            IngestionV1.IngestionResponse.Builder respBuilder = IngestionV1.IngestionResponse.newBuilder();
            byte[] body = response.body().bytes();
            int n = response.code();
            switch (n) {
                case 200: {
                    ingestionResponse = respBuilder.setStatus(IngestionV1.IngestionStatus.OK).build();
                    break;
                }
                case 490: {
                    if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(body))) {
                        ingestionResponse = IngestionV1.IngestionResponse.parseFrom(body);
                        break;
                    }
                }
                default: {
                    ingestionResponse = respBuilder.setStatus(IngestionV1.IngestionStatus.ERROR).build();
                    break;
                }
            }
            return ingestionResponse;
        });
    }

    public KamonApmApiClient(package.Settings settings) {
        this.settings = settings;
        this._logger = LoggerFactory.getLogger(KamonApmApiClient.class);
        this._httpClient = this.createHttpClient(settings);
        this._apiKeyHeaderName = "kamino-api-key";
        this._lastAttempt = Instant.EPOCH;
    }
}

