/*
 * Decompiled with CFR 0.152.
 */
package kamon.apm;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.Proxy;
import java.time.Duration;
import java.util.HashMap;
import java.util.regex.Pattern;
import kamino.IngestionV1;
import kamon.Kamon$;
import kamon.apm.package;
import kamon.tag.Tag$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final Logger _logger = LoggerFactory.getLogger((String)"kamon.apm");
    private static final Pattern _apiKeyPattern = Pattern.compile("^[a-zA-Z0-9]*$");

    public Logger _logger() {
        return _logger;
    }

    private Pattern _apiKeyPattern() {
        return _apiKeyPattern;
    }

    public package.Settings readSettings(Config config, String path) {
        None$ none$;
        int x$15;
        String x$14;
        Duration x$13;
        Duration x$12;
        int x$11;
        int x$10;
        int x$9;
        int x$8;
        String x$7;
        String x$6;
        String x$5;
        Duration x$4;
        Duration x$3;
        IngestionV1.Plan x$2;
        String x$1;
        HashMap<String, String> environmentTagsMap;
        block6: {
            Config apmConfig = config.getConfig(path);
            String apiKey = apmConfig.getString("api-key");
            if (apiKey.equals("none")) {
                this._logger().error("No API key defined in the kamon.apm.api-key setting");
            }
            environmentTagsMap = new HashMap<String, String>();
            Kamon$.MODULE$.environment().tags().all().foreach((Function1 & Serializable)t -> environmentTagsMap.put(t.key(), String.valueOf(Tag$.MODULE$.unwrapValue(t))));
            x$1 = apiKey;
            x$2 = apmConfig.getBoolean("enable-tracing") ? IngestionV1.Plan.METRIC_TRACING : IngestionV1.Plan.METRIC_ONLY;
            x$3 = apmConfig.getDuration("client.timeouts.connection");
            x$4 = apmConfig.getDuration("client.timeouts.read");
            x$5 = apmConfig.getString("app-version");
            x$6 = apmConfig.getString("ingestion-api");
            x$7 = apmConfig.getString("agent");
            x$8 = apmConfig.getInt("retries.boot");
            x$9 = apmConfig.getInt("retries.ingestion");
            x$10 = apmConfig.getInt("retries.shutdown");
            x$11 = apmConfig.getInt("retries.tracing");
            x$12 = apmConfig.getDuration("retries.backoff");
            x$13 = apmConfig.getDuration("client.backoff");
            x$14 = apmConfig.getString("proxy.host");
            x$15 = apmConfig.getInt("proxy.port");
            String string = apmConfig.getString("proxy.type").toLowerCase();
            switch (string == null ? 0 : string.hashCode()) {
                case -887328209: {
                    if (!"system".equals(string)) break;
                    none$ = None$.MODULE$;
                    break block6;
                }
                case 99617003: {
                    if (!"https".equals(string)) break;
                    none$ = new Some((Object)Proxy.Type.HTTP);
                    break block6;
                }
                case 109610287: {
                    if (!"socks".equals(string)) break;
                    none$ = new Some((Object)Proxy.Type.SOCKS);
                    break block6;
                }
            }
            throw new MatchError((Object)string);
        }
        None$ x$16 = none$;
        HashMap<String, String> x$17 = environmentTagsMap;
        return new package.Settings(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Proxy.Type>)x$16, x$14, x$15, x$17);
    }

    public boolean isAcceptableApiKey(String apiKey) {
        return apiKey != null && apiKey.length() == 26 && this._apiKeyPattern().matcher(apiKey).matches();
    }

    public int countsArrayIndex(long value) {
        int SubBucketHalfCountMagnitude = 7;
        int SubBucketHalfCount = 128;
        int UnitMagnitude = 0;
        int SubBucketCount = (int)Math.pow(2.0, SubBucketHalfCountMagnitude + 1);
        int LeadingZeroCountBase = 64 - UnitMagnitude - SubBucketHalfCountMagnitude - 1;
        long SubBucketMask = (long)SubBucketCount - 1L << UnitMagnitude;
        if (value < 0L) {
            throw new ArrayIndexOutOfBoundsException("Histogram recorded value cannot be negative.");
        }
        int bucketIndex = package$.getBucketIndex$1(value, LeadingZeroCountBase, SubBucketMask);
        int subBucketIndex = package$.getSubBucketIndex$1(value, bucketIndex, UnitMagnitude);
        return package$.countsArrayIndex$1(bucketIndex, subBucketIndex, SubBucketHalfCountMagnitude, SubBucketHalfCount);
    }

    private static final int countsArrayIndex$1(int bucketIndex, int subBucketIndex, int SubBucketHalfCountMagnitude$1, int SubBucketHalfCount$1) {
        int bucketBaseIndex = bucketIndex + 1 << SubBucketHalfCountMagnitude$1;
        int offsetInBucket = subBucketIndex - SubBucketHalfCount$1;
        return bucketBaseIndex + offsetInBucket;
    }

    private static final int getBucketIndex$1(long value, int LeadingZeroCountBase$1, long SubBucketMask$1) {
        return LeadingZeroCountBase$1 - Long.numberOfLeadingZeros(value | SubBucketMask$1);
    }

    private static final int getSubBucketIndex$1(long value, long bucketIndex, int UnitMagnitude$1) {
        return (int)Math.floor((double)value / Math.pow(2.0, bucketIndex + (long)UnitMagnitude$1));
    }

    private package$() {
    }
}

