/*
 * Decompiled with CFR 0.152.
 */
package kamon.autoweave.loader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kamon.autoweave.loader.AttachmentProviders$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.control.NoStackTrace;

public final class AgentLoader$ {
    public static final AgentLoader$ MODULE$;

    static {
        new AgentLoader$();
    }

    /*
     * WARNING - void declaration
     */
    private String getPidFromRuntimeMBean() {
        void var2_2;
        String jvm = ManagementFactory.getRuntimeMXBean().getName();
        String pid = jvm.substring(0, jvm.indexOf(64));
        return var2_2;
    }

    public void attachAgentToJVM(Class<?> agent, Seq<Class<?>> resources) {
        this.attachToRunningJVM(agent, resources);
    }

    public void attachAgentToJVM(Class<?> agent) {
        this.attachAgentToJVM(agent, (Seq)Seq$.MODULE$.empty());
    }

    public Seq<Class<?>> attachAgentToJVM$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     */
    private File generateAgentJar(Class<?> agent, Seq<Class<?>> resources) {
        void var3_3;
        File jarFile = File.createTempFile("agent", ".jar");
        jarFile.deleteOnExit();
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(new Attributes.Name("Agent-Class"), agent.getName());
        mainAttributes.put(new Attributes.Name("Can-Retransform-Classes"), "true");
        mainAttributes.put(new Attributes.Name("Can-Redefine-Classes"), "true");
        mainAttributes.put(new Attributes.Name("Can-Set-Native-Method-Prefix"), "true");
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        jos.putNextEntry(new JarEntry(new StringBuilder().append((Object)agent.getName().replace('.', '/')).append((Object)".class").toString()));
        jos.write(this.kamon$autoweave$loader$AgentLoader$$getBytesFromStream(agent.getClassLoader().getResourceAsStream(this.kamon$autoweave$loader$AgentLoader$$unqualify(agent))));
        jos.closeEntry();
        resources.foreach((Function1)new Serializable(jos){
            public static final long serialVersionUID = 0L;
            private final JarOutputStream jos$1;

            public final void apply(Class<?> clazz) {
                String name = AgentLoader$.MODULE$.kamon$autoweave$loader$AgentLoader$$unqualify(clazz);
                this.jos$1.putNextEntry(new JarEntry(name));
                this.jos$1.write(AgentLoader$.MODULE$.kamon$autoweave$loader$AgentLoader$$getBytesFromStream(clazz.getClassLoader().getResourceAsStream(name)));
                this.jos$1.closeEntry();
            }
            {
                this.jos$1 = jos$1;
            }
        });
        jos.close();
        return var3_3;
    }

    private void attachToRunningJVM(Class<?> agent, Seq<Class<?>> resources) {
        Option<Class<?>> option = AttachmentProviders$.MODULE$.resolve();
        if (option instanceof Some) {
            Some some = (Some)option;
            Class virtualMachine = (Class)some.x();
            Object virtualMachineInstance = virtualMachine.getDeclaredMethod("attach", String.class).invoke(null, this.getPidFromRuntimeMBean());
            virtualMachine.getDeclaredMethod("loadAgent", String.class, String.class).invoke(virtualMachineInstance, this.generateAgentJar(agent, resources).getAbsolutePath(), "");
            virtualMachine.getDeclaredMethod("detach", new Class[0]).invoke(virtualMachineInstance, new Object[0]);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new NoStackTrace(){

                public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                    return super.fillInStackTrace();
                }

                public Throwable fillInStackTrace() {
                    return NoStackTrace.class.fillInStackTrace((NoStackTrace)this);
                }
                {
                    NoStackTrace.class.$init$((NoStackTrace)this);
                }
            };
        }
        throw new MatchError(option);
    }

    public byte[] kamon$autoweave$loader$AgentLoader$$getBytesFromStream(InputStream stream) {
        return (byte[])((TraversableOnce)package$.MODULE$.Stream().continually((Function0)new Serializable(stream){
            public static final long serialVersionUID = 0L;
            private final InputStream stream$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.stream$1.read();
            }
            {
                this.stream$1 = stream$1;
            }
        }).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return x$1 != -1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$2) {
                return (byte)x$2;
            }
        }, Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
    }

    public String kamon$autoweave$loader$AgentLoader$$unqualify(Class<?> clazz) {
        return new StringBuilder().append((Object)clazz.getName().replace('.', '/')).append((Object)".class").toString();
    }

    private AgentLoader$() {
        MODULE$ = this;
    }
}

