/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.http;

import akka.Done;
import akka.NotUsed;
import akka.http.javadsl.model.ResponseEntity;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.stream.Attributes;
import akka.stream.BidiShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.util.ByteString;
import com.typesafe.config.Config;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import kamon.Kamon$;
import kamon.instrumentation.akka.http.AkkaHttpInstrumentation$;
import kamon.instrumentation.akka.http.LastAutomaticOperationNameEdit$;
import kamon.instrumentation.akka.http.ServerFlowWrapper;
import kamon.instrumentation.akka.http.ServerFlowWrapper$;
import kamon.instrumentation.akka.http.ServerFlowWrapper$$anon$1$;
import kamon.instrumentation.akka.http.ServerFlowWrapper$$anon$1$$anon$2$$anon$5$;
import kamon.instrumentation.http.HttpServerInstrumentation;
import kamon.instrumentation.http.HttpServerInstrumentation$;
import kamon.trace.Span;
import kamon.util.CallingThreadExecutionContext$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ServerFlowWrapper$ {
    public static final ServerFlowWrapper$ MODULE$;
    private final TrieMap<Object, HttpServerInstrumentation> kamon$instrumentation$akka$http$ServerFlowWrapper$$_serverInstrumentations;
    private final TrieMap<Object, String> _defaultOperationNames;
    private final ServerFlowWrapper.Settings _defaultSettings;
    private volatile ServerFlowWrapper.Settings _wrapperSettings;

    static {
        new ServerFlowWrapper$();
    }

    public TrieMap<Object, HttpServerInstrumentation> kamon$instrumentation$akka$http$ServerFlowWrapper$$_serverInstrumentations() {
        return this.kamon$instrumentation$akka$http$ServerFlowWrapper$$_serverInstrumentations;
    }

    private TrieMap<Object, String> _defaultOperationNames() {
        return this._defaultOperationNames;
    }

    private ServerFlowWrapper.Settings _defaultSettings() {
        return this._defaultSettings;
    }

    private ServerFlowWrapper.Settings _wrapperSettings() {
        return this._wrapperSettings;
    }

    private void _wrapperSettings_$eq(ServerFlowWrapper.Settings x$1) {
        this._wrapperSettings = x$1;
    }

    public Flow<HttpRequest, HttpResponse, NotUsed> apply(Flow<HttpRequest, HttpResponse, NotUsed> flow, String string, int port) {
        return BidiFlow$.MODULE$.fromGraph(this.wrapStage(this._wrapperSettings(), string, port)).join(flow);
    }

    public GraphStage<BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse>> wrapStage(ServerFlowWrapper.Settings settings, String string, int port) {
        return new GraphStage<BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse>>(settings, string, port){
            private final Config httpServerConfig;
            private final HttpServerInstrumentation httpServerInstrumentation;
            private final Inlet<HttpRequest> requestIn;
            private final Outlet<HttpRequest> requestOut;
            private final Inlet<HttpResponse> responseIn;
            private final Outlet<HttpResponse> responseOut;
            private final BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse> shape;

            public Config httpServerConfig() {
                return this.httpServerConfig;
            }

            public HttpServerInstrumentation httpServerInstrumentation() {
                return this.httpServerInstrumentation;
            }

            public Inlet<HttpRequest> requestIn() {
                return this.requestIn;
            }

            public Outlet<HttpRequest> requestOut() {
                return this.requestOut;
            }

            public Inlet<HttpResponse> responseIn() {
                return this.responseIn;
            }

            public Outlet<HttpResponse> responseOut() {
                return this.responseOut;
            }

            public BidiShape<HttpRequest, HttpRequest, HttpResponse, HttpResponse> shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new GraphStageLogic(this){
                    private final Queue<HttpServerInstrumentation.RequestHandler> kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests;
                    private final Instant _createdAt;
                    private int kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests;
                    private final /* synthetic */ anon.1 $outer;

                    public Queue<HttpServerInstrumentation.RequestHandler> kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests() {
                        return this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests;
                    }

                    private Instant _createdAt() {
                        return this._createdAt;
                    }

                    public int kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests() {
                        return this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests;
                    }

                    public void kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests_$eq(int x$1) {
                        this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests = x$1;
                    }

                    public void preStart() {
                        this.$outer.httpServerInstrumentation().connectionOpened();
                    }

                    public void postStop() {
                        Duration connectionLifetime = Duration.between(this._createdAt(), Kamon$.MODULE$.clock().instant());
                        this.$outer.httpServerInstrumentation().connectionClosed(connectionLifetime, this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests());
                    }

                    public /* synthetic */ anon.1 kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests = (Queue)Queue$.MODULE$.empty();
                        this._createdAt = Kamon$.MODULE$.clock().instant();
                        this.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests = 0;
                        this.setHandler($outer.requestIn(), new InHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onUpstreamFailure(Throwable ex) throws Exception {
                                InHandler.class.onUpstreamFailure((InHandler)this, (Throwable)ex);
                            }

                            public void onPush() {
                                HttpRequest request = (HttpRequest)this.$outer.grab(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                                HttpServerInstrumentation.RequestHandler requestHandler = this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().createHandler(AkkaHttpInstrumentation$.MODULE$.toRequest(request), true).requestReceived();
                                String defaultOperationName2 = this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().settings().defaultOperationName();
                                Span requestSpan = requestHandler.span();
                                String string = requestSpan.operationName();
                                String string2 = defaultOperationName2;
                                boolean allowAutomaticChanges = !(string != null ? !string.equals(string2) : string2 != null);
                                this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpServerInstrumentation.RequestHandler[]{requestHandler}));
                                Kamon$.MODULE$.storeContext(requestHandler.context().withEntry(LastAutomaticOperationNameEdit$.MODULE$.Key(), (Object)Option$.MODULE$.apply((Object)LastAutomaticOperationNameEdit$.MODULE$.apply(requestSpan.operationName(), allowAutomaticChanges))));
                                this.$outer.push(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestOut(), request);
                            }

                            public void onUpstreamFinish() {
                                this.$outer.complete(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestOut());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                InHandler.class.$init$((InHandler)this);
                            }
                        });
                        this.setHandler($outer.requestOut(), new OutHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onPull() {
                                this.$outer.pull(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                            }

                            public void onDownstreamFinish() {
                                this.$outer.cancel(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().requestIn());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                OutHandler.class.$init$((OutHandler)this);
                            }
                        });
                        this.setHandler($outer.responseIn(), new InHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onUpstreamFailure(Throwable ex) throws Exception {
                                InHandler.class.onUpstreamFailure((InHandler)this, (Throwable)ex);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public void onPush() {
                                response = (HttpResponse)this.$outer.grab(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                                requestHandler = (HttpServerInstrumentation.RequestHandler)this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_pendingRequests().dequeue();
                                requestSpan = requestHandler.span();
                                responseWithContext = requestHandler.buildResponse(AkkaHttpInstrumentation$.MODULE$.toResponseBuilder(response), requestHandler.context());
                                if (response.status().intValue() != 404) ** GOTO lbl-1000
                                v0 = requestSpan.operationName();
                                var5_5 = this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().settings().defaultOperationName();
                                if (!(v0 != null ? v0.equals(var5_5) == false : var5_5 != null)) {
                                    v1 = requestSpan.name(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().httpServerInstrumentation().settings().unhandledOperationName()).takeSamplingDecision();
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v1 = BoxedUnit.UNIT;
                                }
                                if (responseWithContext.entity().isKnownEmpty()) {
                                    requestHandler.responseSent(0L);
                                    v2 = responseWithContext.entity();
                                } else {
                                    requestSpan.mark("http.response.ready");
                                    var7_6 = responseWithContext.entity();
                                    if (var7_6 instanceof HttpEntity.Strict) {
                                        var8_7 = (HttpEntity.Strict)var7_6;
                                        bs = var8_7.data();
                                        requestHandler.responseSent(bs.size());
                                        var10_9 = var8_7;
                                    } else if (var7_6 instanceof HttpEntity.Default) {
                                        var11_10 = (HttpEntity.Default)var7_6;
                                        requestHandler.responseSent(var11_10.contentLength());
                                        var10_9 = var11_10;
                                    } else {
                                        responseSizeCounter = new AtomicLong(0L);
                                        var10_9 = responseWithContext.entity().transformDataBytes(((Flow)Flow$.MODULE$.apply().watchTermination(Keep$.MODULE$.right()).wireTap((Function1)new Serializable(this, responseSizeCounter){
                                            public static final long serialVersionUID = 0L;
                                            private final AtomicLong responseSizeCounter$1;

                                            public final void apply(ByteString bs) {
                                                this.responseSizeCounter$1.addAndGet(bs.size());
                                            }
                                            {
                                                this.responseSizeCounter$1 = responseSizeCounter$1;
                                            }
                                        })).mapMaterializedValue((Function1)new Serializable(this, requestHandler, requestSpan, responseSizeCounter){
                                            public static final long serialVersionUID = 0L;
                                            public final HttpServerInstrumentation.RequestHandler requestHandler$1;
                                            public final Span requestSpan$1;
                                            public final AtomicLong responseSizeCounter$1;

                                            public final Future<Done> apply(Future<Done> f) {
                                                return f.andThen((PartialFunction)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anon$1$$anon$2$$anon$5$$anonfun$2 $outer;

                                                    public final <A1 extends Try<Done>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                                        Object object;
                                                        A1 A1 = x1;
                                                        if (A1 instanceof Success) {
                                                            this.$outer.requestHandler$1.responseSent(this.$outer.responseSizeCounter$1.get());
                                                            object = BoxedUnit.UNIT;
                                                        } else if (A1 instanceof Failure) {
                                                            Failure failure = (Failure)A1;
                                                            Throwable e = failure.exception();
                                                            this.$outer.requestSpan$1.fail("Response entity stream failed", e);
                                                            this.$outer.requestHandler$1.responseSent(this.$outer.responseSizeCounter$1.get());
                                                            object = BoxedUnit.UNIT;
                                                        } else {
                                                            object = function1.apply(x1);
                                                        }
                                                        return (B1)object;
                                                    }

                                                    public final boolean isDefinedAt(Try<Done> x1) {
                                                        Try<Done> try_ = x1;
                                                        boolean bl = try_ instanceof Success ? true : try_ instanceof Failure;
                                                        return bl;
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                }, (ExecutionContext)CallingThreadExecutionContext$.MODULE$);
                                            }
                                            {
                                                this.requestHandler$1 = requestHandler$1;
                                                this.requestSpan$1 = requestSpan$1;
                                                this.responseSizeCounter$1 = responseSizeCounter$1;
                                            }
                                        }));
                                    }
                                    v2 = var10_9;
                                }
                                entity = v2;
                                this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests_$eq(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$_completedRequests() + 1);
                                this.$outer.push(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().responseOut(), responseWithContext.withEntity((ResponseEntity)entity));
                            }

                            public void onUpstreamFinish() {
                                this.$outer.completeStage();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                InHandler.class.$init$((InHandler)this);
                            }
                        });
                        this.setHandler($outer.responseOut(), new OutHandler(this){
                            private final /* synthetic */ anon$1$$anon$2 $outer;

                            public void onPull() {
                                this.$outer.pull(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                            }

                            public void onDownstreamFinish() {
                                this.$outer.cancel(this.$outer.kamon$instrumentation$akka$http$ServerFlowWrapper$$anon$$anon$$$outer().responseIn());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                OutHandler.class.$init$((OutHandler)this);
                            }
                        });
                    }
                };
            }
            {
                this.httpServerConfig = Kamon$.MODULE$.config().getConfig(settings$1.configPath());
                this.httpServerInstrumentation = HttpServerInstrumentation$.MODULE$.from(this.httpServerConfig(), settings$1.component(), interface$1, port$1);
                this.requestIn = Inlet$.MODULE$.create("request.in");
                this.requestOut = Outlet$.MODULE$.create("request.out");
                this.responseIn = Inlet$.MODULE$.create("response.in");
                this.responseOut = Outlet$.MODULE$.create("response.out");
                this.shape = new BidiShape(this.requestIn(), this.requestOut(), this.responseIn(), this.responseOut());
            }
        };
    }

    public void changeSettings(String component, String configPath) {
        this._wrapperSettings_$eq(new ServerFlowWrapper.Settings(component, configPath));
    }

    public void resetSettings() {
        this._wrapperSettings_$eq(this._defaultSettings());
    }

    public String defaultOperationName(int listenPort) {
        return (String)this._defaultOperationNames().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)listenPort), (Function0)new Serializable(listenPort){
            public static final long serialVersionUID = 0L;
            private final int listenPort$1;

            public final String apply() {
                return (String)ServerFlowWrapper$.MODULE$.kamon$instrumentation$akka$http$ServerFlowWrapper$$_serverInstrumentations().get((Object)BoxesRunTime.boxToInteger((int)this.listenPort$1)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(HttpServerInstrumentation x$1) {
                        return x$1.settings().defaultOperationName();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "http.server.request";
                    }
                });
            }
            {
                this.listenPort$1 = listenPort$1;
            }
        });
    }

    private ServerFlowWrapper$() {
        MODULE$ = this;
        this.kamon$instrumentation$akka$http$ServerFlowWrapper$$_serverInstrumentations = TrieMap$.MODULE$.empty();
        this._defaultOperationNames = TrieMap$.MODULE$.empty();
        this._defaultSettings = new ServerFlowWrapper.Settings("akka.http.server", "kamon.instrumentation.akka.http.server");
        this._wrapperSettings = this._defaultSettings();
    }
}

