/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.instrumentations;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import kamon.Kamon$;
import kamon.instrumentation.akka.AkkaInstrumentation;
import kamon.instrumentation.akka.AkkaInstrumentation$;
import kamon.instrumentation.akka.AkkaMetrics;
import kamon.instrumentation.akka.AkkaMetrics$;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo$;
import kamon.instrumentation.akka.instrumentations.ActorMonitor;
import kamon.instrumentation.akka.instrumentations.HasGroupPath;
import kamon.util.Filter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;

public final class ActorMonitor$ {
    public static final ActorMonitor$ MODULE$;

    static {
        new ActorMonitor$();
    }

    public ActorMonitor from(Object actorCell, ActorRef ref, ActorRef parent, ActorSystem system) {
        ActorMonitor actorMonitor;
        ActorCellInfo cell = ActorCellInfo$.MODULE$.from(actorCell, ref, parent, system);
        AkkaInstrumentation.Settings settings = AkkaInstrumentation$.MODULE$.settings();
        boolean isTraced = Kamon$.MODULE$.filter(AkkaInstrumentation$.MODULE$.TraceActorFilterName()).accept(cell.path());
        boolean startsTrace = settings.safeActorStartTraceFilter().accept(cell.path());
        boolean participatesInTracing = (isTraced || startsTrace) && !cell.isStreamImplementationActor();
        String autoGroupingPath = this.resolveAutoGroupingPath(cell.actorOrRouterClass(), ref, parent, system.name());
        if (cell.isRouter()) {
            actorMonitor = new ActorMonitor.ContextPropagationOnly(cell, participatesInTracing, false);
        } else {
            Seq<String> configuredMatchingGroups;
            boolean isTracked;
            Filter trackedFilter = cell.isRouter() || cell.isRoutee() ? Kamon$.MODULE$.filter(AkkaInstrumentation$.MODULE$.TrackRouterFilterName()) : settings.safeActorTrackFilter();
            boolean bl = isTracked = !cell.isRootSupervisor() && trackedFilter.accept(cell.path());
            Object object = cell.isRootSupervisor() ? Nil$.MODULE$ : ((configuredMatchingGroups = AkkaInstrumentation$.MODULE$.matchingActorGroups(cell.path())).isEmpty() && !isTracked && settings.autoGrouping() && !cell.isRouter() && !cell.isRoutee() && !ActorCellInfo$.MODULE$.isTyped(cell.actorOrRouterClass()) ? (!trackedFilter.excludes(cell.path()) && Kamon$.MODULE$.filter(AkkaInstrumentation$.MODULE$.TrackAutoGroupFilterName()).accept(autoGroupingPath) ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AkkaMetrics.ActorGroupInstruments[]{AkkaMetrics$.MODULE$.forGroup(autoGroupingPath, system.name())})) : List$.MODULE$.empty()) : (Seq)configuredMatchingGroups.map((Function1)new Serializable(cell){
                public static final long serialVersionUID = 0L;
                private final ActorCellInfo cell$1;

                public final AkkaMetrics.ActorGroupInstruments apply(String groupName) {
                    return AkkaMetrics$.MODULE$.forGroup(groupName, this.cell$1.systemName());
                }
                {
                    this.cell$1 = cell$1;
                }
            }, Seq$.MODULE$.canBuildFrom()));
            Nil$ trackingGroups = object;
            actorMonitor = cell.isRoutee() && isTracked ? this.createRouteeMonitor(cell, (Seq<AkkaMetrics.ActorGroupInstruments>)trackingGroups) : this.createRegularActorMonitor(cell, isTracked, participatesInTracing, (Seq<AkkaMetrics.ActorGroupInstruments>)trackingGroups);
        }
        ActorMonitor.ContextPropagationOnly monitor = actorMonitor;
        return this.traceWrap$1(monitor, cell, startsTrace, participatesInTracing);
    }

    private ActorMonitor createRegularActorMonitor(ActorCellInfo cellInfo, boolean isTracked, boolean participatesInTracing, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics) {
        ActorMonitor actorMonitor;
        if (!isTracked && groupMetrics.isEmpty()) {
            actorMonitor = new ActorMonitor.ContextPropagationOnly(cellInfo, participatesInTracing, true);
        } else {
            None$ actorMetrics = isTracked ? new Some((Object)AkkaMetrics$.MODULE$.forActor(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorOrRouterClass())) : None$.MODULE$;
            actorMonitor = new ActorMonitor.TrackedActor((Option<AkkaMetrics.ActorInstruments>)actorMetrics, groupMetrics, cellInfo);
        }
        return actorMonitor;
    }

    private ActorMonitor createRouteeMonitor(ActorCellInfo cellInfo, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics) {
        AkkaMetrics.RouterInstruments routerMetrics = AkkaMetrics$.MODULE$.forRouter(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorOrRouterClass(), (String)cellInfo.routeeClass().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Class<?> className) {
                return ActorCellInfo$.MODULE$.isTyped(className);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Class<?> x$1) {
                return x$1.getName();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Unknown";
            }
        }));
        return new ActorMonitor.TrackedRoutee(routerMetrics, groupMetrics, cellInfo);
    }

    private String resolveAutoGroupingPath(Class<?> actorClass, ActorRef ref, ActorRef parent, String systemName) {
        String string;
        String parentPath;
        String name2 = ref.path().name();
        int elementCount = ref.path().elements().size();
        String string2 = parentPath = parent instanceof HasGroupPath ? ((HasGroupPath)parent).groupPath() : "";
        if (elementCount == 1) {
            String string3 = name2;
            String string4 = "/";
            string = !(string3 != null ? !string3.equals(string4) : string4 != null) ? "" : new StringBuilder().append((Object)systemName).append((Object)"/").append((Object)name2).toString();
        } else {
            string = ActorCellInfo$.MODULE$.simpleClassName(actorClass);
        }
        String refGroupName = string;
        String refGroupPath = parentPath.isEmpty() ? refGroupName : new StringBuilder().append((Object)parentPath).append((Object)"/").append((Object)refGroupName).toString();
        ((HasGroupPath)ref).setGroupPath(refGroupPath);
        return refGroupPath;
    }

    private final ActorMonitor traceWrap$1(ActorMonitor monitor, ActorCellInfo cell$1, boolean startsTrace$1, boolean participatesInTracing$1) {
        return participatesInTracing$1 ? new ActorMonitor.TracedMonitor(cell$1, startsTrace$1, monitor) : monitor;
    }

    private ActorMonitor$() {
        MODULE$ = this;
    }
}

