/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.cassandra.driver;

import com.datastax.driver.core.AbstractSession;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.QueryOperations$;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;
import kamon.Kamon$;
import kamon.instrumentation.cassandra.CassandraInstrumentation$;
import kamon.instrumentation.cassandra.driver.InstrumentedSession$;
import kamon.trace.Span;
import kamon.trace.Span$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001-\u00111#\u00138tiJ,X.\u001a8uK\u0012\u001cVm]:j_:T!a\u0001\u0003\u0002\r\u0011\u0014\u0018N^3s\u0015\t)a!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011q\u0001C\u0001\u0010S:\u001cHO];nK:$\u0018\r^5p]*\t\u0011\"A\u0003lC6|gn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0016\u001b\u0005q!BA\b\u0011\u0003\u0011\u0019wN]3\u000b\u0005\r\t\"B\u0001\n\u0014\u0003!!\u0017\r^1ti\u0006D(\"\u0001\u000b\u0002\u0007\r|W.\u0003\u0002\u0017\u001d\ty\u0011IY:ue\u0006\u001cGoU3tg&|g\u000e\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001a\u0003))h\u000eZ3sYfLgn\u001a\t\u0003\u001biI!a\u0007\b\u0003\u000fM+7o]5p]\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\"aH\u0011\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000baa\u0002\u0019A\r\t\u000f\r\u0002!\u0019!C\u0005I\u0005AQ\r_3dkR|'/F\u0001&!\t1s&D\u0001(\u0015\tA\u0013&\u0001\u0006d_:\u001cWO\u001d:f]RT!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0003Y5\naaY8n[>t'B\u0001\u0018\u0014\u0003\u00199wn\\4mK&\u0011\u0001g\n\u0002\u0019\u0019&\u001cH/\u001a8j]\u001e,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007B\u0002\u001a\u0001A\u0003%Q%A\u0005fq\u0016\u001cW\u000f^8sA!)A\u0007\u0001C!k\u0005\tr-\u001a;M_\u001e<W\rZ&fsN\u0004\u0018mY3\u0015\u0003Y\u0002\"aN\u001f\u000f\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yeBQ!\u0011\u0001\u0005B\t\u000bA!\u001b8jiR\t\u0011\u0004C\u0003E\u0001\u0011\u0005S)A\u0005j]&$\u0018i]=oGR\ta\tE\u0002'\u000ffI!\u0001S\u0014\u0003!1K7\u000f^3oC\ndWMR;ukJ,\u0007\"\u0002&\u0001\t\u0003Z\u0015\u0001\u00049sKB\f'/Z!ts:\u001cGc\u0001'Q%B\u0019aeR'\u0011\u00055q\u0015BA(\u000f\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0005\u0006#&\u0003\rAN\u0001\u0006cV,'/\u001f\u0005\u0006'&\u0003\r\u0001V\u0001\u000eGV\u001cHo\\7QCfdw.\u00193\u0011\tUKfgW\u0007\u0002-*\u0011!f\u0016\u0006\u00021\u0006!!.\u0019<b\u0013\tQfKA\u0002NCB\u0004\"\u0001X0\u000e\u0003uS!AX,\u0002\u00079Lw.\u0003\u0002a;\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b\t\u0004A\u0011B2\u0002\u001f\t,\u0018\u000e\u001c3DY&,g\u000e^*qC:$\"\u0001\u001a6\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dD\u0011!\u0002;sC\u000e,\u0017BA5g\u0005\u0011\u0019\u0006/\u00198\t\u000b-\f\u0007\u0019\u00017\u0002\u0013M$\u0018\r^3nK:$\bCA\u0007n\u0013\tqgBA\u0005Ti\u0006$X-\\3oi\")\u0001\u000f\u0001C!c\u0006aQ\r_3dkR,\u0017i]=oGR\u0011!/\u001e\t\u0003\u001bML!\u0001\u001e\b\u0003\u001fI+7/\u001e7u'\u0016$h)\u001e;ve\u0016DQa[8A\u00021DQa\u001e\u0001\u0005\na\faD]3d_J$7\t\\5f]R\fV/\u001a:z\u000bb,7-\u001e;j_:LeNZ8\u0015\u0007edh\u0010\u0005\u00029u&\u001110\u000f\u0002\u0005+:LG\u000fC\u0003~m\u0002\u0007A-\u0001\u0006dY&,g\u000e^*qC:Daa <A\u0002\u0005\u0005\u0011A\u0002:fgVdG\u000fE\u0002\u000e\u0003\u0007I1!!\u0002\u000f\u0005%\u0011Vm];miN+G\u000fC\u0004\u0002\n\u0001!\t%a\u0003\u0002\u0015\rdwn]3Bgft7\r\u0006\u0002\u0002\u000eA\u0019Q\"a\u0004\n\u0007\u0005EaBA\u0006DY>\u001cXMR;ukJ,\u0007bBA\u000b\u0001\u0011\u0005\u0013qC\u0001\tSN\u001cEn\\:fIR\u0011\u0011\u0011\u0004\t\u0004q\u0005m\u0011bAA\u000fs\t9!i\\8mK\u0006t\u0007bBA\u0011\u0001\u0011\u0005\u00131E\u0001\u000bO\u0016$8\t\\;ti\u0016\u0014HCAA\u0013!\ri\u0011qE\u0005\u0004\u0003Sq!aB\"mkN$XM\u001d\u0005\b\u0003[\u0001A\u0011IA\u0018\u0003!9W\r^*uCR,GCAA\u0019!\u0011\t\u0019$!\u000f\u000f\u00075\t)$C\u0002\u000289\tqaU3tg&|g.\u0003\u0003\u0002<\u0005u\"!B*uCR,'bAA\u001c\u001d!9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0013\u0001D3yiJ\f7\r^)vKJLHc\u0001\u001c\u0002F!11.a\u0010A\u00021Dq!!\u0013\u0001\t\u0013\tY%\u0001\u000bfqR\u0014\u0018m\u0019;Ti\u0006$X-\\3oiRK\b/\u001a\u000b\u0005\u0003\u001b\n\u0019\u0006\u0005\u00039\u0003\u001f2\u0014bAA)s\t1q\n\u001d;j_:Da!UA$\u0001\u00041\u0004bBA,\u0001\u0011%\u0011\u0011L\u0001\u0016k:\u001c\u0018MZ3FqR\u0014\u0018m\u0019;Fq\u0016\u001cW\u000f^8s)\r)\u00131\f\u0005\b\u0003;\n)\u00061\u0001\u001a\u0003\u001d\u0019Xm]:j_:<q!!\u0019\u0003\u0011\u0003\t\u0019'A\nJ]N$(/^7f]R,GmU3tg&|g\u000eE\u0002!\u0003K2a!\u0001\u0002\t\u0002\u0005\u001d4\u0003BA3\u0003S\u00022\u0001OA6\u0013\r\ti'\u000f\u0002\u0007\u0003:L(+\u001a4\t\u000fu\t)\u0007\"\u0001\u0002rQ\u0011\u00111\r\u0005\u000b\u0003k\n)G1A\u0005\u0002\u0005]\u0014\u0001\u0006#nYN#\u0018\r^3nK:$\bK]3gSb,7/\u0006\u0002\u0002zA1\u00111PAC\u0003\u0013k!!! \u000b\t\u0005}\u0014\u0011Q\u0001\nS6lW\u000f^1cY\u0016T1!a!:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\u000biHA\u0002TKR\u0004B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f;\u0016\u0001\u00027b]\u001eL1APAG\u0011%\t)*!\u001a!\u0002\u0013\tI(A\u000bE[2\u001cF/\u0019;f[\u0016tG\u000f\u0015:fM&DXm\u001d\u0011")
public class InstrumentedSession
extends AbstractSession {
    public final Session kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying;
    private final ListeningExecutorService executor;

    public static Set<String> DmlStatementPrefixes() {
        return InstrumentedSession$.MODULE$.DmlStatementPrefixes();
    }

    private ListeningExecutorService executor() {
        return this.executor;
    }

    public String getLoggedKeyspace() {
        return this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying.getLoggedKeyspace();
    }

    public Session init() {
        return new InstrumentedSession(this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying.init());
    }

    public ListenableFuture<Session> initAsync() {
        return Futures.transform((ListenableFuture)this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying.initAsync(), (Function)new Function<Session, Session>(this){

            public Session apply(Session session) {
                return new InstrumentedSession(session);
            }
        }, (Executor)this.executor());
    }

    public ListenableFuture<PreparedStatement> prepareAsync(String query, Map<String, ByteBuffer> customPayload) {
        SimpleStatement statement = new SimpleStatement(query);
        statement.setOutgoingPayload(customPayload);
        return this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying.prepareAsync((RegularStatement)statement);
    }

    private Span buildClientSpan(Statement statement) {
        Span.Empty$ empty$;
        if (CassandraInstrumentation$.MODULE$.settings().enableTracing()) {
            String query = this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$extractQuery(statement);
            Option<String> statementKind = this.extractStatementType(query);
            Span clientSpan = Kamon$.MODULE$.clientSpanBuilder(QueryOperations$.MODULE$.QueryOperationName(), "cassandra.driver").tagMetrics("cassandra.query.kind", (String)statementKind.getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "other";
                }
            })).tag("db.statement", query).tag("db.type", "cassandra").start();
            Option$.MODULE$.apply((Object)statement.getKeyspace()).foreach((Function1)new Serializable(this, clientSpan){
                public static final long serialVersionUID = 0L;
                private final Span clientSpan$1;

                public final Span apply(String ks) {
                    return this.clientSpan$1.tag("db.instance", ks);
                }
                {
                    this.clientSpan$1 = clientSpan$1;
                }
            });
            empty$ = clientSpan;
        } else {
            empty$ = Span.Empty$.MODULE$;
        }
        return empty$;
    }

    /*
     * WARNING - void declaration
     */
    public ResultSetFuture executeAsync(Statement statement) {
        Span clientSpan = this.buildClientSpan(statement);
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, statement, clientSpan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InstrumentedSession $outer;
            public final Statement statement$1;
            private final Span clientSpan$2;

            public final ResultSetFuture apply() {
                return (ResultSetFuture)Kamon$.MODULE$.runWithContext(Kamon$.MODULE$.currentContext().withEntry(Span$.MODULE$.Key(), (Object)this.clientSpan$2), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final ResultSetFuture apply() {
                        return this.$outer.kamon$instrumentation$cassandra$driver$InstrumentedSession$$anonfun$$$outer().kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying.executeAsync(this.$outer.statement$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ InstrumentedSession kamon$instrumentation$cassandra$driver$InstrumentedSession$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.statement$1 = statement$1;
                this.clientSpan$2 = clientSpan$2;
            }
        });
        if (try_ instanceof Success) {
            void var3_7;
            ResultSetFuture resultSetFuture;
            ResultSetFuture resultSetFuture2;
            Success success = (Success)try_;
            ResultSetFuture future = resultSetFuture2 = (resultSetFuture = (ResultSetFuture)success.value());
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ResultSet>(this, clientSpan){
                private final /* synthetic */ InstrumentedSession $outer;
                private final Span clientSpan$2;

                public void onSuccess(ResultSet result) {
                    this.$outer.kamon$instrumentation$cassandra$driver$InstrumentedSession$$recordClientQueryExecutionInfo(this.clientSpan$2, result);
                    this.clientSpan$2.finish();
                }

                public void onFailure(Throwable cause) {
                    this.clientSpan$2.fail(cause.getMessage(), cause).finish();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientSpan$2 = clientSpan$2;
                }
            }, (Executor)MoreExecutors.directExecutor());
            return var3_7;
        }
        if (try_ instanceof Failure) {
            void var2_2;
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            var2_2.fail(cause.getMessage(), cause);
            var2_2.finish();
            throw cause;
        }
        throw new MatchError((Object)try_);
    }

    public void kamon$instrumentation$cassandra$driver$InstrumentedSession$$recordClientQueryExecutionInfo(Span clientSpan, ResultSet result) {
        ExecutionInfo info = result.getExecutionInfo();
        boolean hasMore = !result.isFullyFetched();
        QueryTrace trace = info.getQueryTrace();
        Object object = trace == null ? BoxedUnit.UNIT : clientSpan.tag("cassandra.driver.rs.trace-id", trace.getTraceId().toString());
        ConsistencyLevel consistencyLevel = info.getAchievedConsistencyLevel();
        Object object2 = consistencyLevel == null ? BoxedUnit.UNIT : clientSpan.tag("cassandra.driver.rs.consistency-level", consistencyLevel.name());
        clientSpan.tag("cassandra.driver.rs.fetch-size", (long)info.getStatement().getFetchSize()).tag("cassandra.driver.rs.fetched", (long)result.getAvailableWithoutFetching()).tag("cassandra.driver.rs.has-more", hasMore);
    }

    public CloseFuture closeAsync() {
        return this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying.closeAsync();
    }

    public boolean isClosed() {
        return this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying.isClosed();
    }

    public Cluster getCluster() {
        return this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying.getCluster();
    }

    public Session.State getState() {
        return this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying.getState();
    }

    public String kamon$instrumentation$cassandra$driver$InstrumentedSession$$extractQuery(Statement statement) {
        String string;
        Statement statement2 = statement;
        if (statement2 instanceof BoundStatement) {
            BoundStatement boundStatement = (BoundStatement)statement2;
            string = boundStatement.preparedStatement().getQueryString();
        } else if (statement2 instanceof RegularStatement) {
            RegularStatement regularStatement = (RegularStatement)statement2;
            string = regularStatement.getQueryString();
        } else if (statement2 instanceof BatchStatement) {
            BatchStatement batchStatement = (BatchStatement)statement2;
            string = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(batchStatement.getStatements()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InstrumentedSession $outer;

                public final String apply(Statement statement) {
                    return this.$outer.kamon$instrumentation$cassandra$driver$InstrumentedSession$$extractQuery(statement);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        } else {
            string = "unsupported-statement-type";
        }
        return string;
    }

    private Option<String> extractStatementType(String query) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final String query$1;

            public final String apply() {
                return this.query$1.substring(0, this.query$1.indexOf(" ")).toLowerCase();
            }
            {
                this.query$1 = query$1;
            }
        }).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String elem) {
                return InstrumentedSession$.MODULE$.DmlStatementPrefixes().contains((Object)elem);
            }
        }).toOption();
    }

    private ListeningExecutorService unsafeExtractExecutor(Session session) {
        Method executorMethod = Class.forName("com.datastax.driver.core.SessionManager").getDeclaredMethod("executor", new Class[0]);
        executorMethod.setAccessible(true);
        return (ListeningExecutorService)executorMethod.invoke((Object)session, new Object[0]);
    }

    public InstrumentedSession(Session underlying) {
        this.kamon$instrumentation$cassandra$driver$InstrumentedSession$$underlying = underlying;
        this.executor = this.unsafeExtractExecutor(underlying);
    }
}

