/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.cassandra.metrics;

import kamon.instrumentation.cassandra.CassandraInstrumentation;
import kamon.instrumentation.cassandra.CassandraInstrumentation$;
import kamon.instrumentation.cassandra.CassandraInstrumentation$Tags$;
import kamon.instrumentation.cassandra.NodeConnectionPoolMetrics;
import kamon.instrumentation.cassandra.SessionMetrics;
import kamon.instrumentation.trace.SpanTagger$;
import kamon.trace.Span;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001-\u00111BT8eK6{g.\u001b;pe*\u00111\u0001B\u0001\b[\u0016$(/[2t\u0015\t)a!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011q\u0001C\u0001\u0010S:\u001cHO];nK:$\u0018\r^5p]*\t\u0011\"A\u0003lC6|gn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u0011qw\u000eZ3\u0011\u0005U\tcB\u0001\f \u001d\t9bD\u0004\u0002\u0019;9\u0011\u0011\u0004H\u0007\u00025)\u00111DC\u0001\u0007yI|w\u000e\u001e \n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011B\u0001\u0011\u0005\u0003a\u0019\u0015m]:b]\u0012\u0014\u0018-\u00138tiJ,X.\u001a8uCRLwN\\\u0005\u0003E\r\u0012AAT8eK*\u0011\u0001\u0005\u0002\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dJ\u0003C\u0001\u0015\u0001\u001b\u0005\u0011\u0001\"B\n%\u0001\u0004!\u0002bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\u000fg\u0016\u001c8/[8o\u001b\u0016$(/[2t+\u0005i\u0003C\u0001\u00182\u001d\t1r&\u0003\u00021\t\u0005q1+Z:tS>tW*\u001a;sS\u000e\u001c\u0018B\u0001\u001a4\u0005I\u0019Vm]:j_:Len\u001d;sk6,g\u000e^:\u000b\u0005A\"\u0001BB\u001b\u0001A\u0003%Q&A\btKN\u001c\u0018n\u001c8NKR\u0014\u0018nY:!\u0011\u001d9\u0004A1A\u0005\u0002a\n1\u0002]8pY6+GO]5dgV\t\u0011\b\u0005\u0002;{9\u0011acO\u0005\u0003y\u0011\t\u0011DT8eK\u000e{gN\\3di&|g\u000eU8pY6+GO]5dg&\u0011ah\u0010\u0002\u001e\u001d>$WmQ8o]\u0016\u001cG/[8o!>|G.\u00138tiJ,X.\u001a8ug*\u0011A\b\u0002\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001d\u0002\u0019A|w\u000e\\'fiJL7m\u001d\u0011\t\u000b\r\u0003A\u0011\u0001#\u0002\u001b\u0005\u0004\b\u000f\\=O_\u0012,G+Y4t)\t)\u0005\n\u0005\u0002\u000e\r&\u0011qI\u0004\u0002\u0005+:LG\u000fC\u0003J\u0005\u0002\u0007!*\u0001\u0003ta\u0006t\u0007CA&O\u001b\u0005a%BA'\t\u0003\u0015!(/Y2f\u0013\tyEJ\u0001\u0003Ta\u0006t\u0007\"B)\u0001\t\u0003\u0011\u0016A\u00059p_2lU\r\u001e:jGN,e.\u00192mK\u0012,\u0012a\u0015\t\u0003\u001bQK!!\u0016\b\u0003\u000f\t{w\u000e\\3b]\")q\u000b\u0001C\u00011\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8t\u001fB,g.\u001a3\u0015\u0005\u0015K\u0006\"\u0002.W\u0001\u0004Y\u0016!B2pk:$\bCA\u0007]\u0013\tifBA\u0002J]RDQa\u0018\u0001\u0005\u0002\u0001\f\u0001cY8o]\u0016\u001cG/[8o\u00072|7/\u001a3\u0015\u0003\u0015CQA\u0019\u0001\u0005\u0002\u0001\f1b\u00197jK:$XI\u001d:pe\")A\r\u0001C\u0001A\u0006Y1/\u001a:wKJ,%O]8s\u0011\u00151\u0007\u0001\"\u0001a\u0003\u0015\u0011X\r\u001e:z\u0011\u0015A\u0007\u0001\"\u0001a\u0003\u001d!\u0018.\\3pkRDQA\u001b\u0001\u0005\u0002\u0001\fAbY1oG\u0016dG.\u0019;j_:DQ\u0001\u001c\u0001\u0005\u0002\u0001\fAc\u001d9fGVd\u0017\r^5wK\u0016CXmY;uS>t\u0007\"\u00028\u0001\t\u0003\u0001\u0017\u0001E3yK\u000e,H/[8o'R\f'\u000f^3e\u0011\u0015\u0001\b\u0001\"\u0001a\u0003E)\u00070Z2vi&|gnQ8na2,G/\u001a\u0005\u0006e\u0002!\ta]\u0001\u0015e\u0016\u001cwN\u001d3J]\u001ac\u0017n\u001a5u'\u0006l\u0007\u000f\\3\u0015\u0005\u0015#\b\"B;r\u0001\u00041\u0018!\u0002<bYV,\u0007CA\u0007x\u0013\tAhB\u0001\u0003M_:<\u0007\"\u0002>\u0001\t\u0003\u0001\u0017!E2p]:,7\r^5p]R\u0013\u0018m\u001d5fI\")A\u0010\u0001C\u0001{\u0006a!/Z2pe\u0012\u0014uN\u001d:poR\u0011QI \u0005\u0006\u007fn\u0004\rA^\u0001\u0006]\u0006twn\u001d\u0005\u0007\u0003\u0007\u0001A\u0011\u00011\u0002\u000f\rdW-\u00198va\u0002")
public class NodeMonitor {
    private final CassandraInstrumentation.Node node;
    private final SessionMetrics.SessionInstruments sessionMetrics;
    private final NodeConnectionPoolMetrics.NodeConnectionPoolInstruments poolMetrics;

    public SessionMetrics.SessionInstruments sessionMetrics() {
        return this.sessionMetrics;
    }

    public NodeConnectionPoolMetrics.NodeConnectionPoolInstruments poolMetrics() {
        return this.poolMetrics;
    }

    public void applyNodeTags(Span span) {
        SpanTagger$.MODULE$.tag(span, CassandraInstrumentation$Tags$.MODULE$.DC(), this.node.dc(), CassandraInstrumentation$.MODULE$.settings().dcTagMode());
        SpanTagger$.MODULE$.tag(span, CassandraInstrumentation$Tags$.MODULE$.Rack(), this.node.rack(), CassandraInstrumentation$.MODULE$.settings().rackTagMode());
        SpanTagger$.MODULE$.tag(span, CassandraInstrumentation$Tags$.MODULE$.Node(), this.node.address(), CassandraInstrumentation$.MODULE$.settings().nodeTagMode());
    }

    public boolean poolMetricsEnabled() {
        return this.poolMetrics() != null;
    }

    public void connectionsOpened(int count) {
        this.sessionMetrics().openConnections().increment((long)count);
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().openConnections().increment((long)count);
        }
    }

    public void connectionClosed() {
        this.sessionMetrics().openConnections().decrement();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().openConnections().decrement();
        }
    }

    public void clientError() {
        this.sessionMetrics().clientErrors().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().clientErrors().increment();
        }
    }

    public void serverError() {
        this.sessionMetrics().serverErrors().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().serverErrors().increment();
        }
    }

    public void retry() {
        this.sessionMetrics().retries().increment();
    }

    public void timeout() {
        this.sessionMetrics().timeouts().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().timeouts().increment();
        }
    }

    public void cancellation() {
        this.sessionMetrics().canceled().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().canceled().increment();
        }
    }

    public void speculativeExecution() {
        this.sessionMetrics().speculations().increment();
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().triggeredSpeculations().increment();
        }
    }

    public void executionStarted() {
        this.sessionMetrics().inFlightRequests().increment();
    }

    public void executionComplete() {
        this.sessionMetrics().inFlightRequests().decrement();
    }

    public void recordInFlightSample(long value) {
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().inFlight().record(value);
        }
    }

    public void connectionTrashed() {
        this.sessionMetrics().trashedConnections().increment();
    }

    public void recordBorrow(long nanos) {
        this.sessionMetrics().borrow().record(nanos);
        if (this.poolMetricsEnabled()) {
            this.poolMetrics().borrow().record(nanos);
        }
    }

    public void cleanup() {
        if (this.poolMetrics() != null) {
            this.poolMetrics().remove();
        }
    }

    public NodeMonitor(CassandraInstrumentation.Node node) {
        this.node = node;
        this.sessionMetrics = new SessionMetrics.SessionInstruments();
        this.poolMetrics = CassandraInstrumentation$.MODULE$.settings().trackNodeConnectionPoolMetrics() ? new NodeConnectionPoolMetrics.NodeConnectionPoolInstruments(node) : null;
    }
}

