/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.executor;

import com.typesafe.config.Config;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import kamon.Kamon$;
import kamon.instrumentation.executor.ExecutorInstrumentation;
import kamon.instrumentation.executor.ExecutorInstrumentation$ForkJoinPoolTelemetryReader$;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.util.Try$;

public final class ExecutorInstrumentation$ {
    public static final ExecutorInstrumentation$ MODULE$;
    private final Logger _logger;
    private volatile Duration kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval;
    private final ExecutorInstrumentation.Settings DefaultSettings;
    private final ExecutorInstrumentation.Settings NoExtraSettings;
    private final Field _executionContextExecutorField;

    static {
        new ExecutorInstrumentation$();
    }

    private Logger _logger() {
        return this._logger;
    }

    public Duration kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval() {
        return this.kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval;
    }

    public void kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval_$eq(Duration x$1) {
        this.kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval = x$1;
    }

    public ExecutorService instrument(ExecutorService executor, String name2) {
        return this.instrument(executor, name2, TagSet$.MODULE$.Empty(), this.DefaultSettings());
    }

    public ExecutorInstrumentation.InstrumentedExecutionContext instrumentExecutionContext(ExecutionContext executionContext, String name2) {
        return this.instrumentExecutionContext(executionContext, name2, TagSet$.MODULE$.Empty(), name2, this.DefaultSettings());
    }

    public ScheduledExecutorService instrumentScheduledExecutor(ScheduledExecutorService executor, String name2) {
        return this.instrumentScheduledExecutor(executor, name2, TagSet$.MODULE$.Empty(), name2);
    }

    public ExecutorService instrument(ExecutorService executor, String name2, ExecutorInstrumentation.Settings settings) {
        return this.instrument(executor, name2, TagSet$.MODULE$.Empty(), settings);
    }

    public ExecutorInstrumentation.InstrumentedExecutionContext instrumentExecutionContext(ExecutionContext executionContext, String name2, ExecutorInstrumentation.Settings settings) {
        return this.instrumentExecutionContext(executionContext, name2, TagSet$.MODULE$.Empty(), name2, settings);
    }

    public ExecutorService instrument(ExecutorService executor, String name2, TagSet extraTags) {
        return this.instrument(executor, name2, extraTags, this.DefaultSettings());
    }

    public ExecutorInstrumentation.InstrumentedExecutionContext instrumentExecutionContext(ExecutionContext executionContext, String name2, TagSet extraTags) {
        return this.instrumentExecutionContext(executionContext, name2, extraTags, name2, this.DefaultSettings());
    }

    public ExecutorService instrument(ExecutorService executor, String name2, TagSet extraTags, ExecutorInstrumentation.Settings settings) {
        return this.instrument(executor, name2, extraTags, name2, settings);
    }

    public ExecutorService instrument(ExecutorService executor, String name2, TagSet extraTags, String scheduledActionName, ExecutorInstrumentation.Settings settings) {
        ExecutorService executorService;
        ExecutorService executorService2 = executor;
        if (executorService2 instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService2;
            executorService = new ExecutorInstrumentation.InstrumentedThreadPool(threadPoolExecutor, name2, extraTags, scheduledActionName, settings);
        } else if (executorService2 instanceof ForkJoinPool) {
            ForkJoinPool forkJoinPool = (ForkJoinPool)executorService2;
            executorService = new ExecutorInstrumentation.InstrumentedForkJoinPool(forkJoinPool, ExecutorInstrumentation$ForkJoinPoolTelemetryReader$.MODULE$.forJava(forkJoinPool), name2, extraTags, scheduledActionName, settings);
        } else if (executorService2 instanceof scala.concurrent.forkjoin.ForkJoinPool) {
            scala.concurrent.forkjoin.ForkJoinPool forkJoinPool = (scala.concurrent.forkjoin.ForkJoinPool)executorService2;
            executorService = new ExecutorInstrumentation.InstrumentedForkJoinPool((ExecutorService)forkJoinPool, ExecutorInstrumentation$ForkJoinPoolTelemetryReader$.MODULE$.forScala(forkJoinPool), name2, extraTags, scheduledActionName, settings);
        } else {
            this._logger().warn("Cannot instrument unknown executor [{}]", new Object[]{executorService2});
            executorService = executor;
        }
        return executorService;
    }

    public ScheduledExecutorService instrumentScheduledExecutor(ScheduledExecutorService executor, String name2, TagSet extraTags) {
        return this.instrumentScheduledExecutor(executor, name2, extraTags, name2);
    }

    public ScheduledExecutorService instrumentScheduledExecutor(ScheduledExecutorService executor, String name2, TagSet extraTags, String scheduledActionName) {
        ScheduledExecutorService scheduledExecutorService;
        ScheduledExecutorService scheduledExecutorService2 = executor;
        if (scheduledExecutorService2 instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService2;
            scheduledExecutorService = new ExecutorInstrumentation.InstrumentedScheduledThreadPoolExecutor(scheduledThreadPoolExecutor, name2, extraTags.withTag("scheduled", Predef$.MODULE$.boolean2Boolean(true)), scheduledActionName);
        } else {
            this._logger().warn("Cannot instrument unknown executor [{}]", new Object[]{scheduledExecutorService2});
            scheduledExecutorService = executor;
        }
        return scheduledExecutorService;
    }

    public ExecutorInstrumentation.InstrumentedExecutionContext instrumentExecutionContext(ExecutionContext executionContext, String name2, TagSet extraTags, String scheduledActionName, ExecutorInstrumentation.Settings settings) {
        Option underlyingExecutor = this.unwrapExecutionContext(executionContext).map((Function1)new Serializable(name2, extraTags, scheduledActionName, settings){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final TagSet extraTags$1;
            private final String scheduledActionName$1;
            private final ExecutorInstrumentation.Settings settings$1;

            public final ExecutorService apply(ExecutorService executor) {
                return ExecutorInstrumentation$.MODULE$.instrument(executor, this.name$1, this.extraTags$1, this.scheduledActionName$1, this.settings$1);
            }
            {
                this.name$1 = name$1;
                this.extraTags$1 = extraTags$1;
                this.scheduledActionName$1 = scheduledActionName$1;
                this.settings$1 = settings$1;
            }
        });
        return new ExecutorInstrumentation.InstrumentedExecutionContext(executionContext, (Option<ExecutorService>)underlyingExecutor);
    }

    public ExecutorService instrument(ExecutorService executor, ExecutorInstrumentation.ForkJoinPoolTelemetryReader telemetryReader, String name2, TagSet extraTags, String scheduledActionName, ExecutorInstrumentation.Settings settings) {
        return new ExecutorInstrumentation.InstrumentedForkJoinPool(executor, telemetryReader, name2, extraTags, scheduledActionName, settings);
    }

    public ExecutorInstrumentation.Settings DefaultSettings() {
        return this.DefaultSettings;
    }

    public ExecutorInstrumentation.Settings NoExtraSettings() {
        return this.NoExtraSettings;
    }

    private Field _executionContextExecutorField() {
        return this._executionContextExecutorField;
    }

    private Option<ExecutorService> unwrapExecutionContext(ExecutionContext executionContext) {
        Some some;
        try {
            some = new Some((Object)((ExecutorService)this._executionContextExecutorField().get(executionContext)));
        }
        catch (Throwable throwable) {
            this._logger().warn("Cannot unwrap unsupported ExecutionContext [{}]", new Object[]{executionContext});
            some = None$.MODULE$;
        }
        return some;
    }

    public Duration kamon$instrumentation$executor$ExecutorInstrumentation$$readSampleInterval(Config config) {
        return (Duration)Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply() {
                return Kamon$.MODULE$.config().getDuration("kamon.instrumentation.executor.sample-interval");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply() {
                return Duration.ofSeconds(10L);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private ExecutorInstrumentation$() {
        void var1_1;
        MODULE$ = this;
        this._logger = LoggerFactory.getLogger((String)"kamon.instrumentation.executors.ExecutorsInstrumentation");
        this.kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval = this.kamon$instrumentation$executor$ExecutorInstrumentation$$readSampleInterval(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Config newConfig) {
                ExecutorInstrumentation$.MODULE$.kamon$instrumentation$executor$ExecutorInstrumentation$$_sampleInterval_$eq(ExecutorInstrumentation$.MODULE$.kamon$instrumentation$executor$ExecutorInstrumentation$$readSampleInterval(newConfig));
            }
        });
        this.DefaultSettings = new ExecutorInstrumentation.Settings(true, false);
        this.NoExtraSettings = new ExecutorInstrumentation.Settings(false, false);
        Field field = Class.forName("scala.concurrent.impl.ExecutionContextImpl").getDeclaredField("executor");
        field.setAccessible(true);
        this._executionContextExecutorField = var1_1;
    }
}

