/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import com.zaxxer.hikari.HikariConfig;
import kamon.instrumentation.jdbc.ConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.DatabaseTags;
import kamon.instrumentation.jdbc.HasConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.JdbcMetrics;
import kamon.instrumentation.jdbc.JdbcMetrics$;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.util.Try$;

public final class HikariPoolConstructorAdvice$ {
    public static final HikariPoolConstructorAdvice$ MODULE$;

    static {
        new HikariPoolConstructorAdvice$();
    }

    @Advice.OnMethodExit
    public void exit(@Advice.This HasConnectionPoolTelemetry hikariPool, @Advice.Argument(value=0) HikariConfig config) {
        String url = config.getJdbcUrl();
        String vendor = (String)Try$.MODULE$.apply((Function0)new Serializable(url){
            public static final long serialVersionUID = 0L;
            private final String url$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(this.url$1)).split(':')[1];
            }
            {
                this.url$1 = url$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unknown";
            }
        });
        TagSet metricTags = TagSet$.MODULE$.builder().add("jdbc.pool.vendor", "hikari").add("jdbc.pool.name", config.getPoolName()).add("db.vendor", vendor).build();
        TagSet spanTags = TagSet$.MODULE$.builder().add("db.url", url).build();
        JdbcMetrics.ConnectionPoolInstruments poolInstruments2 = JdbcMetrics$.MODULE$.poolInstruments(metricTags);
        hikariPool.connectionPoolTelemetry().set(new ConnectionPoolTelemetry(poolInstruments2, new DatabaseTags(metricTags, spanTags)));
    }

    private HikariPoolConstructorAdvice$() {
        MODULE$ = this;
    }
}

