/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import com.typesafe.config.Config;
import kamon.ClassLoading$;
import kamon.Kamon$;
import kamon.instrumentation.jdbc.JdbcInstrumentation;
import kamon.instrumentation.jdbc.utils.LoggingSupport;
import kamon.instrumentation.jdbc.utils.LoggingSupport$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

public final class JdbcInstrumentation$
implements LoggingSupport {
    public static final JdbcInstrumentation$ MODULE$;
    private volatile JdbcInstrumentation.Settings kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings;
    private final Logger logger;

    static {
        new JdbcInstrumentation$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void kamon$instrumentation$jdbc$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void logInfo(Function0<String> msg) {
        LoggingSupport$class.logInfo(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        LoggingSupport$class.logWarn(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        LoggingSupport$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Function0<Throwable> exc) {
        LoggingSupport$class.logError(this, msg, exc);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        LoggingSupport$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        LoggingSupport$class.logTrace(this, msg);
    }

    public JdbcInstrumentation.Settings kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings() {
        return this.kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings;
    }

    public void kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings_$eq(JdbcInstrumentation.Settings x$1) {
        this.kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings = x$1;
    }

    public void onStatementFinish(String statement, long elapsedTimeNanos) {
        if (elapsedTimeNanos >= this.kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings().slowStatementThresholdNanos()) {
            this.kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings().slowStatementProcessors().foreach((Function1)new Serializable(statement, elapsedTimeNanos){
                public static final long serialVersionUID = 0L;
                private final String statement$1;
                private final long elapsedTimeNanos$1;

                public final void apply(JdbcInstrumentation.SlowStatementProcessor x$1) {
                    x$1.process(this.statement$1, this.elapsedTimeNanos$1, JdbcInstrumentation$.MODULE$.kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings().slowStatementThresholdNanos());
                }
                {
                    this.statement$1 = statement$1;
                    this.elapsedTimeNanos$1 = elapsedTimeNanos$1;
                }
            });
        }
    }

    public void onStatementFailure(String statement, Throwable error) {
        this.kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings().failedStatementProcessors().foreach((Function1)new Serializable(statement, error){
            public static final long serialVersionUID = 0L;
            private final String statement$2;
            private final Throwable error$1;

            public final void apply(JdbcInstrumentation.FailedStatementProcessor x$2) {
                x$2.process(this.statement$2, this.error$1);
            }
            {
                this.statement$2 = statement$2;
                this.error$1 = error$1;
            }
        });
    }

    public JdbcInstrumentation.Settings kamon$instrumentation$jdbc$JdbcInstrumentation$$readSettings(Config config) {
        Config jdbcConfig = config.getConfig("kamon.instrumentation.jdbc");
        List slowStatementProcessors = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jdbcConfig.getStringList("statements.slow.processors")).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JdbcInstrumentation.SlowStatementProcessor apply(String fqcn) {
                return (JdbcInstrumentation.SlowStatementProcessor)ClassLoading$.MODULE$.createInstance(fqcn, ClassTag$.MODULE$.apply(JdbcInstrumentation.SlowStatementProcessor.class));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        List failedStatementProcessors = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jdbcConfig.getStringList("statements.failed.processors")).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JdbcInstrumentation.FailedStatementProcessor apply(String fqcn) {
                return (JdbcInstrumentation.FailedStatementProcessor)ClassLoading$.MODULE$.createInstance(fqcn, ClassTag$.MODULE$.apply(JdbcInstrumentation.FailedStatementProcessor.class));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        return new JdbcInstrumentation.Settings(jdbcConfig.getDuration("statements.slow.threshold").toNanos(), (List<JdbcInstrumentation.SlowStatementProcessor>)slowStatementProcessors, (List<JdbcInstrumentation.FailedStatementProcessor>)failedStatementProcessors);
    }

    private JdbcInstrumentation$() {
        MODULE$ = this;
        LoggingSupport$class.$init$(this);
        this.kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings = this.kamon$instrumentation$jdbc$JdbcInstrumentation$$readSettings(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Config newConfig) {
                JdbcInstrumentation$.MODULE$.kamon$instrumentation$jdbc$JdbcInstrumentation$$_settings_$eq(JdbcInstrumentation$.MODULE$.kamon$instrumentation$jdbc$JdbcInstrumentation$$readSettings(newConfig));
            }
        });
    }
}

