/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import com.typesafe.config.Config;
import java.sql.PreparedStatement;
import java.time.Instant;
import kamon.Kamon$;
import kamon.instrumentation.jdbc.ConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.DatabaseTags;
import kamon.instrumentation.jdbc.HasConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.HasDatabaseTags;
import kamon.instrumentation.jdbc.JdbcMetrics$;
import kamon.instrumentation.jdbc.StatementMonitor;
import kamon.instrumentation.jdbc.utils.LoggingSupport;
import kamon.instrumentation.jdbc.utils.LoggingSupport$class;
import kamon.instrumentation.jdbc.utils.SqlVisitor;
import kamon.metric.RangeSampler;
import kamon.tag.Lookups$;
import kamon.tag.Tag;
import kamon.tag.TagSet$;
import kamon.trace.SpanBuilder;
import kanela.agent.bootstrap.stack.CallStackDepth;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class StatementMonitor$
implements LoggingSupport {
    public static final StatementMonitor$ MODULE$;
    private volatile boolean parseSqlOperationName;
    private volatile boolean addStatementSQL;
    private volatile boolean addPreparedStatementSQL;
    private final Logger logger;

    static {
        new StatementMonitor$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void kamon$instrumentation$jdbc$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void logInfo(Function0<String> msg) {
        LoggingSupport$class.logInfo(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        LoggingSupport$class.logWarn(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        LoggingSupport$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Function0<Throwable> exc) {
        LoggingSupport$class.logError(this, msg, exc);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        LoggingSupport$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        LoggingSupport$class.logTrace(this, msg);
    }

    private boolean parseSqlOperationName() {
        return this.parseSqlOperationName;
    }

    private void parseSqlOperationName_$eq(boolean x$1) {
        this.parseSqlOperationName = x$1;
    }

    private boolean addStatementSQL() {
        return this.addStatementSQL;
    }

    private void addStatementSQL_$eq(boolean x$1) {
        this.addStatementSQL = x$1;
    }

    private boolean addPreparedStatementSQL() {
        return this.addPreparedStatementSQL;
    }

    private void addPreparedStatementSQL_$eq(boolean x$1) {
        this.addPreparedStatementSQL = x$1;
    }

    public void kamon$instrumentation$jdbc$StatementMonitor$$updateSettings(Config config) {
        Config jdbcInstrumentationConfig = config.getConfig("kamon.instrumentation.jdbc");
        this.parseSqlOperationName_$eq(jdbcInstrumentationConfig.getBoolean("parse-sql-for-operation-name"));
        String string = jdbcInstrumentationConfig.getString("add-db-statement-as-span-tag");
        if ("always".equals(string)) {
            this.addStatementSQL_$eq(true);
            this.addPreparedStatementSQL_$eq(true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("prepared".equals(string)) {
            this.addStatementSQL_$eq(false);
            this.addPreparedStatementSQL_$eq(true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("never".equals(string)) {
            this.addStatementSQL_$eq(false);
            this.addPreparedStatementSQL_$eq(false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logger().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized value [", "] for the [add-db-statement-as-span-tag] setting. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to [always]"})).s((Seq)Nil$.MODULE$)).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<StatementMonitor.Invocation> start(Object statement, String sql, String statementType) {
        String string;
        Tuple2 tuple2;
        Tuple2 tuple22;
        HasConnectionPoolTelemetry hasConnectionPoolTelemetry;
        None$ none$;
        if (CallStackDepth.incrementFor((Object)statement) != 0) {
            none$ = None$.MODULE$;
            return none$;
        }
        Instant startTimestamp = Kamon$.MODULE$.clock().instant();
        Object object = statement;
        if (object instanceof HasConnectionPoolTelemetry && (hasConnectionPoolTelemetry = (HasConnectionPoolTelemetry)object).connectionPoolTelemetry() != null && hasConnectionPoolTelemetry.connectionPoolTelemetry().get() != null) {
            ConnectionPoolTelemetry poolTelemetry = hasConnectionPoolTelemetry.connectionPoolTelemetry().get();
            tuple22 = new Tuple2((Object)poolTelemetry.instruments().inFlightStatements(), (Object)poolTelemetry.databaseTags());
        } else {
            HasDatabaseTags hasDatabaseTags;
            tuple22 = object instanceof HasDatabaseTags && (hasDatabaseTags = (HasDatabaseTags)object).databaseTags() != null ? new Tuple2(JdbcMetrics$.MODULE$.InFlightStatements().withTags(hasDatabaseTags.databaseTags().metricTags()), (Object)hasDatabaseTags.databaseTags()) : new Tuple2((Object)JdbcMetrics$.MODULE$.InFlightStatements().withoutTags(), (Object)new DatabaseTags(TagSet$.MODULE$.Empty(), TagSet$.MODULE$.Empty()));
        }
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) throw new MatchError((Object)tuple23);
        RangeSampler inFlightRangeSampler2 = (RangeSampler)tuple23._1();
        DatabaseTags databaseTags2 = (DatabaseTags)tuple23._2();
        if (inFlightRangeSampler2 == null) throw new MatchError((Object)tuple23);
        RangeSampler rangeSampler = inFlightRangeSampler2;
        if (databaseTags2 == null) throw new MatchError((Object)tuple23);
        DatabaseTags databaseTags3 = databaseTags2;
        Tuple2 tuple24 = tuple2 = new Tuple2((Object)rangeSampler, (Object)databaseTags3);
        RangeSampler inFlightRangeSampler = (RangeSampler)tuple24._1();
        DatabaseTags databaseTags = (DatabaseTags)tuple24._2();
        if (this.parseSqlOperationName()) {
            try {
                Statement statement2 = CCJSqlParserUtil.parse(sql);
                SqlVisitor statementVisitor = new SqlVisitor(statementType);
                statement2.accept(statementVisitor);
                string = statementVisitor.operation();
            }
            catch (Exception exception) {
                if (this.logger().isInfoEnabled()) {
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not parse sql to get operation name: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sql})), (Throwable)exception);
                }
                string = statementType;
            }
        } else {
            string = statementType;
        }
        String spanName = string;
        SpanBuilder clientSpan = Kamon$.MODULE$.clientSpanBuilder(spanName, "jdbc");
        Object object2 = this.addStatementSQL() || statement instanceof PreparedStatement && this.addPreparedStatementSQL() ? clientSpan.tag("db.statement", sql) : BoxedUnit.UNIT;
        databaseTags.spanTags().iterator().foreach((Function1)new Serializable(databaseTags, clientSpan){
            public static final long serialVersionUID = 0L;
            private final DatabaseTags databaseTags$1;
            private final SpanBuilder clientSpan$1;

            public final SpanBuilder apply(Tag t) {
                return this.clientSpan$1.tag(t.key(), (String)this.databaseTags$1.spanTags().get(Lookups$.MODULE$.coerce(t.key())));
            }
            {
                this.databaseTags$1 = databaseTags$1;
                this.clientSpan$1 = clientSpan$1;
            }
        });
        databaseTags.metricTags().iterator().foreach((Function1)new Serializable(databaseTags, clientSpan){
            public static final long serialVersionUID = 0L;
            private final DatabaseTags databaseTags$1;
            private final SpanBuilder clientSpan$1;

            public final SpanBuilder apply(Tag t) {
                return this.clientSpan$1.tagMetrics(t.key(), (String)this.databaseTags$1.metricTags().get(Lookups$.MODULE$.coerce(t.key())));
            }
            {
                this.databaseTags$1 = databaseTags$1;
                this.clientSpan$1 = clientSpan$1;
            }
        });
        inFlightRangeSampler.increment();
        none$ = new Some((Object)new StatementMonitor.Invocation(statement, clientSpan.start(startTimestamp), sql, startTimestamp, inFlightRangeSampler));
        return none$;
    }

    private StatementMonitor$() {
        MODULE$ = this;
        LoggingSupport$class.$init$(this);
        this.parseSqlOperationName = false;
        this.addStatementSQL = true;
        this.addPreparedStatementSQL = true;
        Kamon$.MODULE$.onReconfigure((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Config c) {
                StatementMonitor$.MODULE$.kamon$instrumentation$jdbc$StatementMonitor$$updateSettings(c);
            }
        });
        this.kamon$instrumentation$jdbc$StatementMonitor$$updateSettings(Kamon$.MODULE$.config());
    }
}

